/*
 * Decompiled with CFR 0.152.
 */
package pkgcommon;

import java.lang.module.ResolvedModule;
import java.util.List;
import java.util.stream.Collectors;

public final class LayerPrinter {
    public static void printRuntimeInfos(ModuleLayer moduleLayer, Object object) throws Exception {
        System.out.println("Infos for Layer and Module which contain " + object);
        String string = moduleLayer.getClass().getName() + "@" + Integer.toHexString(moduleLayer.hashCode());
        System.out.println("Layer (" + string + (moduleLayer.equals(ModuleLayer.boot()) ? "), boot layer" : "), not boot layer"));
        System.out.print("Layer's parents: ");
        List<ModuleLayer> list = moduleLayer.parents();
        if (list.isEmpty() || list.size() == 1 && list.contains(ModuleLayer.empty())) {
            System.out.println("none, as this is the boot layer");
        } else if (list.size() == 1 && list.get(0) == ModuleLayer.boot()) {
            System.out.println("Parent is boot layer");
        } else {
            for (ModuleLayer moduleLayer2 : list) {
                System.out.println(moduleLayer2.getClass().getName() + "@" + Integer.toHexString(moduleLayer2.hashCode()));
            }
        }
        System.out.println("Layer's list of modules:");
        System.out.println(object.getClass().getModule().getLayer().modules().stream().map(Module::getName).sorted().collect(Collectors.joining(", ")));
        System.out.println("Layer's configuration with its list of resolved modules:");
        System.out.println(object.getClass().getModule().getLayer().configuration().modules().stream().map(ResolvedModule::name).sorted().collect(Collectors.joining(", ")));
    }
}

