/*
 * Decompiled with CFR 0.152.
 */
package pkglayer;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import pkglayer.AbstractLayerRef;
import pkglayer.LayerGroup;

public class LayerHierarchy {
    static final Map<String, AbstractLayerRef> mapName2AbstractLayerRef = new HashMap<String, AbstractLayerRef>();
    static final Map<ModuleLayer, AbstractLayerRef> mapLayer2AbstractLayerRef = new HashMap<ModuleLayer, AbstractLayerRef>();
    public static final String BOOT = "boot";
    public static final String ROOT = "root";
    public static LayerGroup root = new LayerGroup(null, "boot", "root", 0, ModuleLayer.boot());

    public static String getLayerName(ModuleLayer moduleLayer) {
        return LayerHierarchy.mapLayer2AbstractLayerRef.get((Object)moduleLayer).name;
    }

    public static String getLayerLevel(ModuleLayer moduleLayer) {
        return LayerHierarchy.mapLayer2AbstractLayerRef.get((Object)moduleLayer).level;
    }

    public static void printLayerHierarchy(AbstractLayerRef abstractLayerRef) {
        Object object;
        System.out.println("Layer  '" + abstractLayerRef.name + "'on level '" + abstractLayerRef.level + "' (" + abstractLayerRef.getLayer().toString() + ")");
        LayerGroup layerGroup = abstractLayerRef.parent;
        if (layerGroup != null) {
            object = abstractLayerRef.getLayer().parents();
            Iterator<Object> iterator = object.iterator();
            while (iterator.hasNext()) {
                ModuleLayer object2 = iterator.next();
                System.out.println("Parent '" + layerGroup.name + "'on level '" + layerGroup.level + "' (" + object2.toString() + ")");
            }
        }
        if (abstractLayerRef.getLayer().modules().isEmpty()) {
            System.out.println("Contains no modules.");
        } else {
            System.out.println("Contains these modules:");
            abstractLayerRef.getLayer().modules().stream().sorted(Comparator.comparing(Module::getName)).forEach(module -> System.out.println("    " + module));
        }
        if (abstractLayerRef instanceof LayerGroup) {
            object = (LayerGroup)abstractLayerRef;
            for (AbstractLayerRef abstractLayerRef2 : ((LayerGroup)object).getAllChildren()) {
                LayerHierarchy.printLayerHierarchy(abstractLayerRef2);
            }
        }
    }
}

