/*
 * Decompiled with CFR 0.152.
 */
package pkgcommon;

import java.lang.module.ResolvedModule;
import java.util.List;
import java.util.stream.Collectors;

public final class LayerPrinter {
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_RED = "\u001b[31m";

    public static void printRuntimeInfos(ModuleLayer moduleLayer) throws Exception {
        System.out.println("Infos for Layer and Module:");
        System.out.println("Layer (" + LayerPrinter.printId(moduleLayer) + (moduleLayer.equals(ModuleLayer.boot()) ? "), boot layer" : "), not boot layer"));
        System.out.print("Layer's parents: ");
        List<ModuleLayer> list = moduleLayer.parents();
        if (list.isEmpty() || list.size() == 1 && list.contains(ModuleLayer.empty())) {
            System.out.println("none, as this is the boot layer");
        } else if (list.size() == 1 && list.get(0) == ModuleLayer.boot()) {
            System.out.println("Parent is boot layer");
        } else {
            for (ModuleLayer moduleLayer2 : list) {
                System.out.println(moduleLayer2.getClass().getName() + "@" + Integer.toHexString(moduleLayer2.hashCode()));
            }
        }
        System.out.println("Layer's configuration including read dependencies:");
        System.out.println(moduleLayer.configuration().modules().stream().filter(resolvedModule -> !LayerPrinter.isJdkModule(resolvedModule)).map(resolvedModule -> String.format("%s%s%s -> [%s]", ANSI_RED, LayerPrinter.printModuleNameAndConfiguration(resolvedModule), ANSI_RESET, LayerPrinter.printRequires(resolvedModule, true))).sorted().collect(Collectors.joining(", ")));
    }

    public static String printRequires(ResolvedModule resolvedModule, boolean bl) {
        return resolvedModule.reads().stream().filter(resolvedModule2 -> !bl || !LayerPrinter.isJdkModule(resolvedModule)).map(LayerPrinter::printModuleNameAndConfiguration).sorted().collect(Collectors.joining(", "));
    }

    public static boolean isJdkModule(ResolvedModule resolvedModule) {
        return resolvedModule.name().startsWith("jdk.");
    }

    public static boolean isJavaModule(ResolvedModule resolvedModule) {
        return resolvedModule.name().startsWith("java.");
    }

    public static String printModuleNameAndConfiguration(ResolvedModule resolvedModule) {
        return String.format("%s (%s)", resolvedModule.reference().descriptor().toNameAndVersion(), LayerPrinter.printId(resolvedModule.configuration()));
    }

    public static String printId(Object object) {
        return object.getClass().getSimpleName() + "@" + Integer.toHexString(object.hashCode());
    }
}

