/*
 * Decompiled with CFR 0.152.
 */
package pkgmain;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import pkglayer.AbstractLayerRef;
import pkglayer.LayerGroup;
import pkglayer.LayerRef;

public class LayerBuilder {
    private String layers_jsonFileName = null;
    private static final String jsonLAYERS = "layers";
    private static final String jsonNAME = "name";
    private static final String jsonLEVEL = "level";
    private static final String jsonLAYER_LIST = "layerList";

    LayerBuilder(String string) {
        this.layers_jsonFileName = string;
    }

    AbstractLayerRef parseLayerJsonFile(LayerGroup layerGroup) throws IOException {
        File file = new File(this.layers_jsonFileName).getAbsoluteFile().getCanonicalFile();
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            JsonReader jsonReader = Json.createReader((InputStream)fileInputStream);
            JsonObject jsonObject = jsonReader.readObject().getJsonObject(jsonLAYERS);
            AbstractLayerRef abstractLayerRef = this.buildLayerHierarchyFromJsonFile(jsonObject, layerGroup);
            return abstractLayerRef;
        }
    }

    private AbstractLayerRef buildLayerHierarchyFromJsonFile(JsonObject jsonObject, LayerGroup layerGroup) {
        String string = jsonObject.getJsonString(jsonNAME).getString();
        String string2 = jsonObject.getJsonString(jsonLEVEL).getString();
        LayerGroup layerGroup2 = new LayerGroup(layerGroup, string, string2, 0);
        if (jsonObject.containsKey((Object)jsonLAYER_LIST)) {
            JsonArray jsonArray = jsonObject.getJsonArray(jsonLAYER_LIST);
            for (int i = 0; i < jsonArray.size(); ++i) {
                this.buildLayerHierarchyFromJsonFile(jsonArray.getJsonObject(i), layerGroup2, 1);
            }
        }
        return layerGroup2;
    }

    private AbstractLayerRef buildLayerHierarchyFromJsonFile(JsonObject jsonObject, LayerGroup layerGroup, int n) {
        String string = jsonObject.getJsonString(jsonNAME).getString();
        String string2 = jsonObject.getJsonString(jsonLEVEL).getString();
        if (jsonObject.containsKey((Object)jsonLAYER_LIST)) {
            LayerGroup layerGroup2 = new LayerGroup(layerGroup, string, string2, n);
            layerGroup.addChildLayer((AbstractLayerRef)layerGroup2);
            JsonArray jsonArray = jsonObject.getJsonArray(jsonLAYER_LIST);
            for (int i = 0; i < jsonArray.size(); ++i) {
                this.buildLayerHierarchyFromJsonFile(jsonArray.getJsonObject(i), layerGroup2, n + 1);
            }
        } else {
            LayerRef layerRef = new LayerRef(layerGroup, string, string2);
            layerGroup.addChildLayer((AbstractLayerRef)layerRef);
        }
        return layerGroup;
    }

    void createJigsawLayers(LayerGroup layerGroup, ModuleLayer moduleLayer, String string) {
        Path path = Paths.get(string, new String[0]).toAbsolutePath().normalize();
        ModuleFinder moduleFinder = ModuleFinder.of(path);
        Set<ModuleReference> set = moduleFinder.findAll();
        if (set.isEmpty()) {
            throw new RuntimeException("No modules found in " + path.toString() + ". Terminating ...");
        }
        for (AbstractLayerRef abstractLayerRef : layerGroup.getAllChildren()) {
            this.createJigsawLayers(abstractLayerRef, moduleLayer, moduleFinder, set);
        }
    }

    private void createJigsawLayers(AbstractLayerRef abstractLayerRef, ModuleLayer moduleLayer, ModuleFinder moduleFinder, Set<ModuleReference> set) {
        this.createJigsawLayerAndAddModules(abstractLayerRef, moduleLayer, moduleFinder, set);
        if (abstractLayerRef instanceof LayerGroup) {
            LayerGroup layerGroup = (LayerGroup)abstractLayerRef;
            for (AbstractLayerRef abstractLayerRef2 : layerGroup.getAllChildren()) {
                this.createJigsawLayers(abstractLayerRef2, layerGroup.getLayer(), moduleFinder, set);
            }
        }
    }

    private void createJigsawLayerAndAddModules(AbstractLayerRef abstractLayerRef, ModuleLayer moduleLayer, ModuleFinder moduleFinder, Set<ModuleReference> set) {
        HashSet<String> hashSet = new HashSet<String>();
        String string3 = "_" + abstractLayerRef.level;
        set.stream().map(moduleReference -> moduleReference.descriptor().name()).filter(string2 -> string2.contains(string3)).forEach(string -> hashSet.add((String)string));
        Configuration configuration = moduleLayer.configuration().resolve(ModuleFinder.of(new Path[0]), moduleFinder, hashSet);
        ModuleLayer moduleLayer2 = moduleLayer.defineModulesWithOneLoader(configuration, ClassLoader.getSystemClassLoader());
        abstractLayerRef.setLayer(moduleLayer2);
    }
}

