<p align="left">
  <svg width="150" class="icon-4Ds2f" preserveAspectRatio="none" viewBox="0 0 70 34"><path d="M2.9,0.5 C4,0.5 5,1.4 5,2.6 C5,3.8 4.1,4.7 2.9,4.7 C1.8,4.7 0.8,3.8 0.8,2.6 C0.8,1.4 1.8,0.5 2.9,0.5 Z M1.3,6.3 L4.4,6.3 L4.4,20.5 L1.3,20.5 L1.3,6.3 Z M21,20.8 L17.9,19 C17,19.9 15.6,20.6 13.7,20.6 C9.5,20.6 6.6,17.8 6.6,13.3 C6.6,8.9 9.4,6 13.7,6 C15.5,6 17,6.7 17.9,7.6 L17.9,0.4 L21,0.1 L21,20.8 Z M13.8,9.2 C11.3,9.2 9.7,11 9.7,13.5 C9.7,15.9 11.4,17.8 13.8,17.8 C16.3,17.8 17.9,16 17.9,13.5 C18,11 16.3,9.2 13.8,9.2 Z M26.3,14.5 C26.6,16.3 28.3,17.7 30.3,17.7 C31.8,17.7 32.9,17.2 33.5,16.3 L37.2,16.3 C36.2,18.9 33.5,20.6 30.2,20.6 C26.1,20.6 22.9,17.4 22.9,13.3 C22.9,9.3 26.1,6 30.1,6 C34.1,6 37.3,9.2 37.3,13.3 C37.3,13.7 37.3,14 37.2,14.4 L26.3,14.4 L26.3,14.5 Z M26.4,11.7 L34,11.7 C33.5,10.2 32,9 30.2,9 C28.4,9 26.9,10.2 26.4,11.7 Z M53.6,6.3 L53.6,20.8 L50.4,19 C49.8,19.8 48.2,20.6 46.3,20.6 C42.2,20.6 39.1,17.6 39.1,13.3 C39.1,9 42.2,6 46.3,6 C48.2,6 49.8,6.9 50.4,7.6 L50.4,6.1 L53.6,6.1 L53.6,6.3 Z M46.4,9.2 C44,9.2 42.2,11.1 42.2,13.5 C42.2,15.8 44,17.8 46.4,17.8 C48.7,17.8 50.5,15.9 50.5,13.5 C50.5,11.1 48.7,9.2 46.4,9.2 Z M56.3,6 L59.1,7.9 C59.8,7 61.3,6.1 63.3,6.1 C66.8,6.1 68.8,8.2 68.8,11.9 L68.8,20.4 L65.7,20.4 L65.7,12.6 C65.7,10.1 64.6,9 62.6,9 C60.5,9 59.5,10.5 59.5,12.6 L59.5,20.4 L56.4,20.4 L56.4,6 L56.3,6 Z M2.294,28.12 C2.819,28.12 3.224,28.22 3.506,28.42 C3.788,28.62 3.93,28.918 3.93,29.313 C3.93,29.53 3.891,29.713 3.814,29.867 C3.73774751,30.0190873 3.62205179,30.1479067 3.479,30.24 C3.31606303,30.3416512 3.13567501,30.4121788 2.947,30.448 C2.7137889,30.4934384 2.4765861,30.5152155 2.239,30.513 L1.824,30.513 L1.824,31.9 L1.3,31.9 L1.3,28.212 C1.447,28.176 1.612,28.152 1.794,28.14 C1.976,28.128 2.142,28.12 2.294,28.12 Z M2.337,28.58 C2.113,28.58 1.943,28.585 1.824,28.596 L1.824,30.064 L2.218,30.064 C2.398,30.064 2.56,30.053 2.704,30.029 C2.848,30.006 2.969,29.967 3.069,29.91 C3.16556532,29.856555 3.24497632,29.7767973 3.298,29.68 C3.35616703,29.5652539 3.38404893,29.4375479 3.379,29.309 C3.38407074,29.1845673 3.35502347,29.0611164 3.295,28.952 C3.23986384,28.8593898 3.16209659,28.7823108 3.069,28.728 C2.96612219,28.6696755 2.85371431,28.6300619 2.737,28.611 C2.60480639,28.5890826 2.47099678,28.5783778 2.337,28.579 L2.337,28.58 Z M5.22,29.022 C5.422,29.022 5.592,29.049 5.73,29.101 C5.868,29.153 5.98,29.227 6.065,29.322 C6.15,29.417 6.21,29.53 6.246,29.662 C6.282,29.794 6.3,29.938 6.3,30.097 L6.3,31.852 L6.12,31.882 C5.92806911,31.909523 5.73530284,31.9308674 5.542,31.946 C5.42955571,31.9550185 5.31680493,31.9596886 5.204,31.96 C5.046,31.96 4.9,31.943 4.767,31.911 C4.64269317,31.8828246 4.52513331,31.8305003 4.421,31.757 C4.32242741,31.6856695 4.24418146,31.5898441 4.194,31.479 C4.13729219,31.3478338 4.10998635,31.2058434 4.114,31.063 C4.114,30.908 4.144,30.775 4.208,30.664 C4.272,30.553 4.356,30.462 4.464,30.394 C4.572,30.325 4.698,30.275 4.842,30.242 C5.04222691,30.1985065 5.247808,30.1850258 5.452,30.202 C5.507,30.207 5.558,30.215 5.606,30.224 C5.655,30.232 5.697,30.241 5.733,30.248 C5.769,30.255 5.795,30.261 5.809,30.265 L5.809,30.124 C5.809,30.041 5.8,29.959 5.782,29.878 C5.764,29.797 5.732,29.726 5.685,29.662 C5.638,29.6 5.574,29.549 5.493,29.511 C5.412,29.473 5.307,29.454 5.177,29.454 C5.011,29.454 4.867,29.466 4.742,29.489 C4.617,29.512 4.526,29.537 4.464,29.562 L4.405,29.146 C4.50960307,29.1062354 4.61825305,29.0780668 4.729,29.062 C4.88,29.036 5.044,29.022 5.22,29.022 Z M5.263,31.539 C5.382,31.539 5.487,31.536 5.579,31.53 C5.671,31.525 5.748,31.516 5.809,31.501 L5.809,30.664 C5.75277113,30.6405176 5.69352798,30.6250336 5.633,30.618 C5.45602576,30.5919062 5.27625624,30.5908962 5.099,30.615 C5.01813103,30.6247418 4.93941426,30.6477149 4.866,30.683 C4.796,30.717 4.738,30.763 4.691,30.823 C4.644,30.883 4.621,30.961 4.621,31.058 C4.621,31.238 4.678,31.363 4.794,31.434 C4.91,31.505 5.066,31.539 5.264,31.539 L5.263,31.539 Z M8.033,29.033 C8.13836101,29.033434 8.24346292,29.0434756 8.347,29.063 C8.401,29.071 8.45,29.081 8.496,29.09 C8.5298515,29.0956618 8.56326616,29.1036813 8.596,29.114 L8.509,29.552 C8.33202583,29.4921598 8.14571175,29.4647208 7.959,29.471 C7.864,29.471 7.772,29.481 7.68,29.5 C7.588,29.519 7.528,29.533 7.5,29.541 L7.5,31.901 L6.997,31.901 L6.997,29.211 C7.116,29.168 7.263,29.128 7.44,29.09 C7.616,29.052 7.814,29.033 8.034,29.033 L8.033,29.033 Z M9.416,29.093 L10.48,29.093 L10.48,29.513 L9.416,29.513 L9.416,30.81 C9.416,30.95 9.426,31.066 9.448,31.158 C9.47,31.25 9.503,31.321 9.546,31.374 C9.589,31.426 9.643,31.463 9.708,31.484 C9.773,31.505 9.848,31.517 9.935,31.517 C10.085,31.517 10.207,31.5 10.299,31.466 L10.491,31.393 L10.588,31.809 C10.538,31.834 10.449,31.865 10.323,31.903 C10.182457,31.9425133 10.036982,31.9617079 9.891,31.96 C9.73050851,31.9650251 9.57047486,31.9402742 9.419,31.887 C9.3007143,31.8430685 9.19688585,31.7672737 9.119,31.668 C9.03926977,31.5623078 8.98456283,31.4399011 8.959,31.31 C8.92688713,31.1470052 8.91180607,30.9811136 8.914,30.815 L8.914,28.31 L9.416,28.223 L9.416,29.093 Z M14.573,30.496 C14.573,30.72 14.541,30.921 14.476,31.102 C14.411,31.282 14.32,31.436 14.203,31.565 C14.086,31.695 13.946,31.795 13.784,31.865 C13.622,31.935 13.446,31.971 13.255,31.971 C13.065,31.971 12.888,31.936 12.726,31.865 C12.5665205,31.7965655 12.4238758,31.6941889 12.308,31.565 C12.1876598,31.4299592 12.0949162,31.2726688 12.035,31.102 C11.9677853,30.9071495 11.9349631,30.7020954 11.938,30.496 C11.938,30.276 11.97,30.076 12.035,29.895 C12.1,29.714 12.191,29.557 12.308,29.427 C12.424,29.297 12.564,29.197 12.726,29.127 C12.888,29.057 13.065,29.022 13.256,29.022 C13.446,29.022 13.622,29.058 13.784,29.128 C13.946,29.198 14.086,29.298 14.203,29.427 C14.32,29.557 14.411,29.713 14.476,29.895 C14.541,30.077 14.573,30.276 14.573,30.496 Z M14.049,30.496 C14.049,30.18 13.978,29.929 13.836,29.743 C13.694,29.557 13.5,29.465 13.256,29.465 C13.028383,29.4563978 12.8111102,29.5603596 12.675,29.743 C12.532,29.929 12.462,30.18 12.462,30.496 C12.462,30.813 12.532,31.064 12.675,31.25 C12.8108975,31.432241 13.0278401,31.5358498 13.255,31.527 C13.5,31.527 13.694,31.436 13.835,31.25 C13.976,31.064 14.049,30.813 14.049,30.496 Z M16.241,27.71 C16.389,27.71 16.516,27.72 16.621,27.742 C16.728,27.764 16.803,27.784 16.846,27.802 L16.754,28.233 C16.711,28.212 16.65,28.191 16.57,28.172 C16.49,28.153 16.394,28.142 16.279,28.142 C16.045,28.142 15.881,28.206 15.788,28.334 C15.694,28.462 15.648,28.634 15.648,28.85 L15.648,29.093 L16.728,29.093 L16.728,29.513 L15.648,29.513 L15.648,31.9 L15.145,31.9 L15.145,28.839 C15.145,28.479 15.233,28.2 15.41,28.004 C15.586,27.809 15.863,27.71 16.241,27.71 Z M20.787,31.999 C20.444,31.999 20.136,31.946 19.863,31.841 C19.5993018,31.7413799 19.3621491,31.5822514 19.17,31.376 C18.9743846,31.1593782 18.8262154,30.9042546 18.735,30.627 C18.633,30.332 18.583,29.993 18.583,29.61 C18.583,29.227 18.641,28.889 18.758,28.594 C18.8646547,28.3138524 19.0276867,28.058583 19.237,27.844 C19.439,27.64 19.677,27.485 19.949,27.379 C20.2289068,27.2720476 20.5263666,27.2184574 20.826,27.221 C21.016,27.221 21.188,27.235 21.342,27.264 C21.496,27.293 21.629,27.324 21.744,27.359 C21.859,27.394 21.954,27.433 22.028,27.472 C22.104,27.512 22.156,27.54 22.186,27.558 L21.942,28.238 C21.609224,28.0535506 21.2344645,27.9581385 20.854,27.961 C20.6642102,27.9584704 20.4757309,27.9927703 20.299,28.062 C20.127,28.131 19.979,28.233 19.853,28.369 C19.7207373,28.5185341 19.6209647,28.6939022 19.56,28.884 C19.49,29.091 19.454,29.331 19.454,29.604 C19.454,29.846 19.482,30.067 19.537,30.271 C19.591,30.473 19.677,30.647 19.791,30.795 C19.905,30.943 20.051,31.057 20.226,31.138 C20.402,31.22 20.613,31.26 20.86,31.26 C21.2581025,31.2713213 21.6527233,31.1829785 22.008,31.003 L22.233,31.683 C22.18,31.718 22.108,31.753 22.018,31.788 C21.6254736,31.9383775 21.2071997,32.0100719 20.787,31.999 Z M23.907,28.362 C24.173,28.362 24.394,28.396 24.575,28.462 C24.755,28.527 24.899,28.62 25.008,28.739 C25.115,28.857 25.192,29.002 25.238,29.171 C25.284,29.341 25.308,29.526 25.308,29.729 L25.308,31.821 C25.184,31.848 24.998,31.88 24.75,31.917 C24.502,31.954 24.22,31.973 23.908,31.973 C23.702,31.973 23.512,31.953 23.341,31.914 C23.1836638,31.8803653 23.0347063,31.8154089 22.903,31.723 C22.781,31.633 22.687,31.52 22.618,31.379 C22.549,31.238 22.516,31.064 22.516,30.857 C22.5105063,30.6830795 22.5504901,30.5107356 22.632,30.357 C22.7068806,30.221063 22.8144547,30.1059278 22.945,30.022 C23.077,29.937 23.23,29.875 23.403,29.838 C23.6731476,29.7811795 23.9506119,29.7676776 24.225,29.798 C24.322,29.81 24.425,29.828 24.535,29.854 L24.535,29.723 C24.535,29.63 24.525,29.542 24.503,29.458 C24.4591174,29.2873364 24.3342971,29.1490624 24.169,29.088 C24.0598294,29.0499029 23.9445669,29.0322745 23.829,29.036 C23.6588299,29.034656 23.4888626,29.0480392 23.321,29.076 C23.193228,29.0956654 23.067417,29.126449 22.945,29.168 L22.845,28.521 C22.947,28.486 23.095,28.451 23.288,28.416 C23.481,28.381 23.688,28.362 23.908,28.362 L23.907,28.362 Z M23.974,31.34 C24.22,31.34 24.408,31.326 24.534,31.3 L24.534,30.415 C24.3814498,30.3739339 24.2239693,30.3540806 24.066,30.356 C23.978,30.356 23.889,30.362 23.799,30.376 C23.7143819,30.386998 23.6320332,30.4112977 23.555,30.448 C23.4848615,30.4814323 23.4248268,30.5328413 23.381,30.597 C23.3353704,30.6685447 23.3123697,30.7521838 23.315,30.837 C23.315,31.027 23.374,31.158 23.493,31.23 C23.611,31.303 23.773,31.34 23.974,31.34 Z M29.228,30.178 C29.228,30.441 29.194,30.684 29.126,30.903 C29.057,31.124 28.96,31.313 28.832,31.472 C28.704,31.631 28.545,31.752 28.353,31.841 C28.161,31.93 27.945,31.973 27.703,31.973 C27.4293253,31.9762549 27.1592769,31.9102049 26.918,31.781 L26.918,33.121 L26.118,33.121 L26.118,28.561 C26.282,28.517 26.482,28.475 26.719,28.436 C26.958,28.396 27.209,28.376 27.472,28.376 C27.745,28.376 27.989,28.418 28.205,28.501 C28.6280597,28.6614602 28.9580976,29.0013882 29.106,29.429 C29.187,29.651 29.228,29.9 29.228,30.178 Z M28.41,30.191 C28.41,29.835 28.329,29.558 28.169,29.359 C28.008,29.161 27.749,29.063 27.393,29.063 C27.318,29.063 27.24,29.065 27.159,29.073 C27.077,29.079 26.997,29.093 26.918,29.115 L26.918,31.089 C26.988,31.137 27.082,31.182 27.198,31.224 C27.315,31.266 27.439,31.286 27.571,31.286 C27.862,31.286 28.074,31.187 28.208,30.989 C28.342,30.792 28.41,30.525 28.41,30.191 Z M32.739,31.551 C32.739,32.101 32.599,32.503 32.32,32.759 C32.04,33.014 31.613,33.142 31.036,33.142 C30.6410362,33.1427552 30.2486922,33.0778714 29.875,32.95 L30.02,32.27 C30.156,32.327 30.311,32.373 30.485,32.408 C30.659,32.443 30.847,32.461 31.049,32.461 C31.371,32.461 31.599,32.396 31.736,32.264 C31.872,32.132 31.94,31.936 31.94,31.676 L31.94,31.544 C31.8389648,31.5921226 31.7343105,31.6322456 31.627,31.664 C31.4818811,31.704706 31.3317116,31.7245714 31.181,31.723 C30.961,31.723 30.761,31.688 30.578,31.616 C30.4005176,31.54891 30.2402771,31.4429941 30.109,31.306 C29.9727411,31.1590284 29.8691369,30.9848779 29.805,30.795 C29.7287343,30.5662106 29.691877,30.3261307 29.696,30.085 C29.696,29.835 29.735,29.604 29.812,29.393 C29.9562788,28.9805453 30.2765718,28.6536559 30.686,28.501 C30.897,28.418 31.137,28.376 31.406,28.376 C31.666,28.376 31.912,28.396 32.146,28.436 C32.379,28.475 32.576,28.516 32.739,28.561 L32.739,31.551 Z M30.514,30.085 C30.514,30.424 30.589,30.672 30.736,30.828 C30.883,30.984 31.074,31.063 31.306,31.063 C31.5299909,31.0633469 31.7496078,31.0009951 31.94,30.883 L31.94,29.096 C31.7668563,29.0587558 31.5900926,29.0409788 31.413,29.043 C31.122,29.043 30.9,29.139 30.746,29.33 C30.592,29.521 30.514,29.773 30.514,30.085 Z M33.399,30.191 C33.399,29.888 33.445,29.621 33.535,29.393 C33.625,29.165 33.745,28.973 33.895,28.821 C34.1897177,28.5278076 34.5882842,28.3628463 35.004,28.362 C35.478,28.362 35.849,28.511 36.114,28.805 C36.382,29.1 36.514,29.54 36.514,30.125 C36.5134981,30.2241104 36.5094956,30.3231722 36.502,30.422 L34.224,30.422 C34.247,30.699 34.344,30.914 34.518,31.065 C34.692,31.218 34.944,31.293 35.274,31.293 C35.5849715,31.2952618 35.8936191,31.2392982 36.184,31.128 L36.291,31.781 C36.2323739,31.8093272 36.1714984,31.8327409 36.109,31.851 C36.021976,31.8779583 35.9335025,31.8999932 35.844,31.917 C35.6237632,31.9639152 35.399178,31.9873793 35.174,31.987 C34.904079,31.992446 34.6356018,31.9462856 34.383,31.851 C33.9602897,31.6890699 33.6364288,31.3404671 33.506,30.907 C33.4326445,30.675505 33.3965278,30.4338268 33.399,30.191 Z M35.716,29.835 C35.716,29.725 35.701,29.62 35.67,29.521 C35.64,29.421 35.594,29.336 35.535,29.264 C35.476,29.192 35.403,29.134 35.317,29.092 C35.220352,29.0481835 35.1150906,29.0266528 35.009,29.029 C34.7952808,29.0258423 34.5912062,29.1178041 34.452,29.28 C34.3874242,29.3561094 34.3369648,29.4431434 34.303,29.537 C34.2680065,29.6333509 34.2438575,29.7333008 34.231,29.835 L35.716,29.835 Z M39.161,30.085 C39.161,29.725 39.116,29.464 39.026,29.304 C38.936,29.143 38.767,29.063 38.521,29.063 C38.433,29.063 38.337,29.069 38.231,29.082 C38.1514962,29.0917338 38.0721528,29.1027352 37.993,29.115 L37.993,31.9 L37.194,31.9 L37.194,28.56 C37.348,28.517 37.549,28.475 37.799,28.436 C38.047,28.396 38.31,28.376 38.587,28.376 C38.825,28.376 39.019,28.407 39.172,28.469 C39.322,28.53 39.449,28.611 39.55,28.713 C39.6853658,28.6208689 39.8318675,28.546274 39.986,28.491 C40.079,28.458 40.176,28.431 40.28,28.409 C40.383,28.387 40.488,28.376 40.593,28.376 C40.862,28.376 41.083,28.415 41.257,28.491 C41.4199876,28.5597778 41.5613188,28.6713914 41.666,28.814 C41.766,28.954 41.833,29.121 41.871,29.316 C41.908,29.513 41.926,29.726 41.926,29.96 L41.926,31.9 L41.128,31.9 L41.128,30.085 C41.128,29.725 41.084,29.464 40.996,29.304 C40.908,29.143 40.739,29.062 40.488,29.062 C40.2683483,29.0660935 40.0539792,29.1300584 39.868,29.247 C39.903,29.357 39.926,29.474 39.94,29.597 C39.9535535,29.728562 39.9602292,29.8607419 39.96,29.993 L39.96,31.9 L39.16,31.9 L39.16,30.085 L39.161,30.085 Z M43.63,27.438 C43.63,27.588 43.58,27.707 43.484,27.795 C43.388,27.883 43.274,27.927 43.141,27.927 C43.0117378,27.9294238 42.8864689,27.8821796 42.791,27.795 C42.6924091,27.7031894 42.6393505,27.5725554 42.646,27.438 C42.646,27.285 42.694,27.164 42.791,27.076 C42.8863693,26.9885455 43.0116192,26.9409506 43.141,26.943 C43.273,26.943 43.387,26.988 43.484,27.076 C43.581,27.164 43.63,27.286 43.63,27.438 Z M43.544,31.9 L42.744,31.9 L42.744,28.448 L43.544,28.448 L43.544,31.9 Z M44.394,28.56 C44.8574949,28.4380804 45.3347382,28.3762404 45.814,28.376 C46.095,28.376 46.331,28.415 46.52,28.491 C46.709,28.568 46.86,28.677 46.972,28.814 C47.084,28.954 47.164,29.121 47.21,29.316 C47.256,29.513 47.279,29.726 47.279,29.96 L47.279,31.9 L46.48,31.9 L46.48,30.085 C46.48,29.9 46.468,29.743 46.444,29.613 C46.42,29.483 46.381,29.378 46.324,29.297 C46.2696037,29.2156387 46.1913558,29.1531103 46.1,29.118 C45.9894119,29.0784068 45.8724173,29.0597555 45.755,29.063 C45.648724,29.0632497 45.5425497,29.0695935 45.437,29.082 C45.327,29.096 45.246,29.106 45.193,29.115 L45.193,31.9 L44.394,31.9 L44.394,28.56 Z M48.982,27.438 C48.982,27.588 48.933,27.707 48.837,27.795 C48.741,27.883 48.626,27.927 48.494,27.927 C48.3647378,27.9294238 48.2394689,27.8821796 48.144,27.795 C48.0454091,27.7031894 47.9923505,27.5725554 47.999,27.438 C47.999,27.285 48.047,27.164 48.143,27.076 C48.2383693,26.9885455 48.3636192,26.9409506 48.493,26.943 C48.626,26.943 48.74,26.988 48.837,27.076 C48.934,27.164 48.982,27.286 48.982,27.438 Z M48.896,31.9 L48.097,31.9 L48.097,28.448 L48.897,28.448 L48.897,31.9 L48.896,31.9 Z M51.16,27.326 L51.992,27.326 L51.992,31.9 L51.16,31.9 L51.16,27.326 Z M52.882,28.561 C53.036,28.517 53.236,28.475 53.482,28.436 C53.729,28.396 54.002,28.376 54.3,28.376 C54.583,28.376 54.818,28.415 55.008,28.491 C55.196,28.568 55.348,28.677 55.46,28.814 C55.571,28.954 55.651,29.121 55.697,29.316 C55.743,29.513 55.767,29.726 55.767,29.96 L55.767,31.9 L54.967,31.9 L54.967,30.085 C54.967,29.9 54.956,29.743 54.931,29.613 C54.906,29.483 54.868,29.378 54.812,29.297 C54.7576037,29.2156387 54.6793558,29.1531103 54.588,29.118 C54.4770971,29.0782839 54.3597518,29.0596307 54.242,29.063 C54.135724,29.0632497 54.0295497,29.0695935 53.924,29.082 C53.815,29.096 53.734,29.106 53.68,29.115 L53.68,31.9 L52.882,31.9 L52.882,28.56 L52.882,28.561 Z M57.375,31.901 C57.1285703,31.3896408 56.9020668,30.8689161 56.696,30.34 C56.4528547,29.7205475 56.2415783,29.0890545 56.063,28.448 L56.915,28.448 C56.963,28.643 57.019,28.851 57.084,29.072 C57.2098585,29.5155268 57.3533052,29.9538732 57.514,30.386 C57.591,30.595 57.663,30.783 57.729,30.95 C57.9674484,30.3324093 58.182271,29.7059546 58.373,29.072 C58.438,28.851 58.496,28.642 58.545,28.448 L59.37,28.448 C59.18,29.122 58.968,29.752 58.737,30.34 C58.5304437,30.8685366 58.303609,31.3889223 58.057,31.9 L57.375,31.9 L57.375,31.901 Z M59.521,30.191 C59.521,29.888 59.567,29.621 59.657,29.393 C59.747,29.165 59.867,28.973 60.017,28.821 C60.3119012,28.5280831 60.7103491,28.3631709 61.126,28.362 C61.6,28.362 61.971,28.511 62.237,28.805 C62.504,29.1 62.637,29.54 62.637,30.125 C62.6361653,30.2241222 62.6318293,30.323184 62.624,30.422 L60.346,30.422 C60.369,30.699 60.466,30.914 60.64,31.065 C60.814,31.218 61.066,31.293 61.396,31.293 C61.7069715,31.2952618 62.0156191,31.2392982 62.306,31.128 L62.413,31.781 C62.3543739,31.8093272 62.2934984,31.8327409 62.231,31.851 C62.143976,31.8779583 62.0555025,31.8999932 61.966,31.917 C61.7457632,31.9639152 61.521178,31.9873793 61.296,31.987 C61.026079,31.992446 60.7576018,31.9462856 60.505,31.851 C60.0822897,31.6890699 59.7584288,31.3404671 59.628,30.907 C59.5546445,30.675505 59.5185278,30.4338268 59.521,30.191 Z M61.839,29.835 C61.839,29.725 61.823,29.62 61.792,29.521 C61.762,29.421 61.716,29.336 61.657,29.264 C61.598,29.192 61.525,29.134 61.439,29.092 C61.3426577,29.0483303 61.2377547,29.0268029 61.132,29.029 C60.9179329,29.0255436 60.7134312,29.1175328 60.574,29.28 C60.5094242,29.3561094 60.4589648,29.4431434 60.425,29.537 C60.3900065,29.6333509 60.3658575,29.7333008 60.353,29.835 L61.839,29.835 Z M63.316,28.561 C63.513411,28.5077511 63.7137484,28.4660141 63.916,28.436 C64.164,28.396 64.436,28.376 64.735,28.376 C65.017,28.376 65.253,28.415 65.442,28.491 C65.631,28.568 65.782,28.677 65.894,28.814 C66.006,28.954 66.086,29.121 66.132,29.316 C66.177,29.513 66.201,29.726 66.201,29.96 L66.201,31.9 L65.402,31.9 L65.402,30.085 C65.402,29.9 65.39,29.743 65.366,29.613 C65.342,29.483 65.302,29.378 65.246,29.297 C65.1916037,29.2156387 65.1133558,29.1531103 65.022,29.118 C64.9110971,29.0782839 64.7937518,29.0596307 64.676,29.063 C64.5700576,29.0632879 64.4642183,29.0696316 64.359,29.082 C64.249,29.096 64.168,29.106 64.115,29.115 L64.115,31.9 L63.316,31.9 L63.316,28.56 L63.316,28.561 Z M66.973,27.538 L67.773,27.406 L67.773,28.448 L69,28.448 L69,29.115 L67.772,29.115 L67.772,30.521 C67.772,30.798 67.816,30.996 67.904,31.115 C67.992,31.233 68.141,31.293 68.352,31.293 C68.498,31.293 68.627,31.277 68.739,31.247 C68.851,31.216 68.94,31.187 69.006,31.161 L69.138,31.795 C69.046,31.834 68.924,31.875 68.775,31.917 C68.626,31.959 68.449,31.979 68.247,31.979 C68.001,31.979 67.795,31.946 67.63,31.881 C67.4754952,31.8225618 67.339692,31.7233874 67.237,31.594 C67.1359786,31.4590365 67.0662909,31.303264 67.033,31.138 C66.9906976,30.9374812 66.9705766,30.7329181 66.973,30.528 L66.973,27.538 Z"></path></svg>
</p>

| Branch   |      Status                                                                                                                                |
|----------|:------------------------------------------------------------------------------------------------------------------------------------------:|
| master | [![Build Status](https://travis-ci.org/tal-tech/sonar-swift.svg?branch=master)](https://travis-ci.org/tal-tech/sonar-swift)  |
| develop| [![Build Status](https://travis-ci.org/tal-tech/sonar-swift.svg?branch=develop)](https://travis-ci.org/tal-tech/sonar-swift) |

SonarQube Plugin for Swift
================================

This is an open source initiative for Apple Swift language support in SonarQube.
The structure of the plugin is based on the [sonar-objective-c](https://github.com/octo-technology/sonar-objective-c) plugin.

<p align="center">
  <img src="screenshot.png" alt="Example iOS SonarQube dashboard" width="100%"/>
</p>

In SonarQube under Quality Profiles the used Linter can be specified by selecting either the SwiftLint Profile or the Tailor Profile as Default profile for Swift Projects:
<p align="center">

  <img src="SwitchProfiles.png" alt="Set preferred profile (SwiftLint or Tailor) to default in SonarQube." width="100%"/>
</p>

### Features

| Feature 		| Supported	| MacOS	      | Unix        |
|---------------|-----------|:-----------:|:-----------:|
| Complexity	|YES		|Uses [Lizard](https://github.com/terryyin/lizard)| Uses [Lizard](https://github.com/terryyin/lizard)|
| Design		|NO			|			  |             |
| Documentation	|YES		|			  |             |
| Duplications	|YES		|			  |             |
| Issues		|YES		| Uses [SwiftLint](https://github.com/realm/SwiftLint) and/or [Tailor](https://github.com/sleekbyte/tailor) for Swift. [OCLint](http://oclint-docs.readthedocs.io/en/stable/) and [Faux Pas](http://fauxpasapp.com/) for Objective-C| Uses [Tailor](https://github.com/sleekbyte/tailor)|
| Size			|YES		|			  |             |
| Tests			|YES		| Uses xcodebuild + xcpretty [xcpretty](https://github.com/supermarin/xcpretty)	| Not Supported |
| Code coverage	|YES	    | Uses [slather](https://github.com/venmo/slather)			| Not Supported|

### Faux Pas support

[Faux Pas](http://fauxpasapp.com/) is a wonderful tool to analyse iOS or Mac applications Objective-C source code, however it is not free. A 30 trial version is available [here](http://fauxpasapp.com/try/).

The plugin runs fine even if Faux Pas is not installed (Faux Pas analysis will be skipped).


### Download

Checkout the [Releases](https://github.com/Backelite/sonar-swift/releases) page.

The full release history is also available in [CHANGELOG.md](./CHANGELOG.md).

### Launching an analysis
If you use [fastlane](https://fastlane.tools), please read [our fastlane integration doc](docs/sonarqube-fastlane.md).
Otherwise, run the ```run-sonar-swift.sh``` script from your Xcode project root folder

### Prerequisites

- a Mac with Xcode 7 or +
- [SonarQube](https://docs.sonarqube.org/display/SONAR/Setup+and+Upgrade) and [SonarQube Scanner](https://docs.sonarqube.org/display/SCAN/Analyzing+with+SonarQube+Scanner)
- [xcpretty](https://github.com/supermarin/xcpretty) (see instructions below)
- [SwiftLint](https://github.com/realm/SwiftLint) ([HomeBrew](http://brew.sh) installed and ```brew install swiftlint```). Version 0.3.0 or above.
- [Tailor](https://github.com/sleekbyte/tailor) ([HomeBrew](http://brew.sh) installed and ```brew install tailor```). Version 0.11.1 or above.
- [slather](https://github.com/SlatherOrg/slather) (```gem install slather```). Version 2.1.0 or above (2.4 since Xcode 8.3).
- [lizard](https://github.com/terryyin/lizard) ([PIP](https://pip.pypa.io/en/stable/installing/) installed and ```sudo pip install lizard```)
- [OCLint](http://oclint-docs.readthedocs.io/en/stable/) installed. Version 0.11.0 recommended (0.13.0 since Xcode 9).
- [Faux Pas](http://fauxpasapp.com/) command line tools installed (optional)

### Installation of xcpretty with JUnit reports fix

At the time, xcpretty needs to be fixed to work with SonarQube.

To install the fixed version, follow those steps :

	git clone https://github.com/Backelite/xcpretty.git
	cd xcpretty
	git checkout fix/duration_of_failed_tests_workaround
	gem build xcpretty.gemspec
	sudo gem install --both xcpretty-0.2.2.gem

### Installation (once for all your Swift projects)
- Download the plugin binary into the $SONARQUBE_HOME/extensions/plugins directory
- Copy [run-sonar-swift.sh](https://raw.githubusercontent.com/Backelite/sonar-swift/master/sonar-swift-plugin/src/main/shell/run-sonar-swift.sh) somewhere in your PATH
- Restart the SonarQube server.

### Configuration (once per project)
- Copy [sonar-project.properties](https://raw.githubusercontent.com/Backelite/sonar-swift/master/sonar-project.properties) in your Xcode project root folder (along your .xcodeproj file)
- Edit the ```sonar-project.properties``` file to match your Xcode iOS/MacOS project

**The good news is that you don't have to modify your Xcode project to enable SonarQube!**. Ok, there might be one needed modification if you don't have a specific scheme for your test target, but that's all.

### Update (once per plugin update)
- Install the lastest plugin version
- Copy ```run-sonar-swift.sh``` somewhere in your PATH

If you still have *run-sonar-swift.sh* file in each of your project (not recommended), you will need to update all those files.

### Contributing

Thank you for your interest in the project! Contributions are welcome and appreciated.

Make sure to read these guides before getting started:

- [Code of Conduct](./CODE_OF_CONDUCT.md)
- [Contribution Guidelines](./CONTRIBUTING.md)

### License

SonarQube Plugin for Swift is released under the GNU LGPL v3 license. See the [LICENSE](./LICENSE.md) file for more info.
