# OpenAI Projects

13 projects using ChatGPT API, Whisper, Embeddings, and DALL-E with Python.

| #   | Project                                                                           | Description                                                                                   |
| --- | --------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------- |
| 01  | [**Color Palette Generator**](01-color-palette-generator)                         | A visual tool to generate color palettes using OpenAI Completion API with Python.             |
| 02  | [**GPT-4 Chatbot**](02-gpt-4-chatbot)                                             | A simple command line chatbot with GPT-4.                                                     |
| 03  | [**Automatic Code Reviewer**](03-automatic-code-reviewer)                         | A simple command-line-based code reviewer.                                                    |
| 04  | [**GPT-4 AI Spotify Playlist Generator**](04-gpt-4-ai-spotify-playlist-generator) | A playlist generator for Spotify with OpenAI's GPT-4.                                         |
| 05  | [**Movie Recommendation System**](05-movie-recommendation-system)                 | An embedding-powered movie recommendation algorithm using Nomic Atlas.                        |
| 06  | [**Q&A Bot**](06-qa-bot)                                                          | A dynamic Q&A Bot using GPT-4.                                                                |
| 07  | [**Sentiment Analysis Project**](07-sentiment-analysis-project)                   | A tool to analyze the sentiment of Reddit comments using GPT-4.                               |
| 08  | [**Book Summarizer Project**](08-book-summarizer-project)                         | A tool to summarize books of any size into a couple of paragraphs.                            |
| 09  | [**Choose Your Own Adventure App**](09-choose-your-own-adventure)                 | A gamebook app with DALL-E, Stable Diffusion, and GPT-4.                                      |
| 10  | [**Whisper Transcription Tool**](10-whisper-transcription-tool)                   | A tool to convert spoken audio into accurate transcriptions and translations, using Whisper.  |
| 11  | [**Auto-GPT Bots**](11-auto-gpt-bots)                                             | Two AI assistants to scrape emails and teach code with Auto-GPT.                              |
| 12  | [**LangChain Bots**](12-langchain-bots)                                           | Two automated AI tools to generate emails and search Wikipedia with LangChain.                |
| 13  | [**Multilingual RAG Search**](13-multilingual-rag-search)                         | A multilingual search tool based on Wikipedia data, utilizing the RAG approach to prompt GPT. |

## Get Inspired

Check out our [**collection of articles**](https://www.onbusinessplan.com/) for those beginning their Generative AI journey. Find tips, tricks, and motivational content to keep you engaged and motivated throughout your learning process.

## Share Your Insights

We want to hear from you! Help us tailor our content to better meet your needs by participating in our brief survey. Your feedback is invaluable in guiding us to create the most relevant and useful resources for developers and freelancers. [**Take the survey here**](https://forms.gle/sSWJ4uAcTdFJu6W76).

## Setup

You need to create a virtual env and install the packages listed in `requirements.txt`. You can then run Jupyter Notebooks in VS Code.

Follow these steps: [How to Work with Python Virtual Environments, Jupyter Notebooks and VS Code](https://python.plainenglish.io/how-to-work-with-python-virtual-environments-jupyter-notebooks-and-vs-code-536fac3d93a1).

You need to create a `.env` file with your `OPENAI_API_KEY`.

## Playground

[Check the playground](00-playground/) to understand the basics.

## Acknowledgments

These projects are based on three courses:

- [Mastering OpenAI Python APIs: Unleash the Power of GPT4](https://www.udemy.com/course/mastering-openai/) by Colt Steele (2023).
- [The Ultimate Guide To ChatGPT & Midjourney](https://www.udemy.com/course/the-ultimate-guide-to-chatgpt-midjourney-prompt-engineering-openai-gpt/) by Colt Steele (2023).
- [ChatGPT - The Complete Guide to ChatGPT & OpenAI APIs](https://www.udemy.com/course/chatgpt-bard-bing-complete-guide-to-chatgpt-openai-apis/) by Maximilian Schwarzmüller (2023).

We are also relying on three short courses:

- [Vector Databases: from Embeddings to Applications](https://www.deeplearning.ai/short-courses/vector-databases-embeddings-applications/) by Sebastian Witalec (2023).
- [LangChain for LLM Application Development](https://www.deeplearning.ai/short-courses/langchain-for-llm-application-development/) by Harrison Chase and Andrew Ng (2023).
- [LangChain: Chat with Your Data](https://www.deeplearning.ai/short-courses/langchain-chat-with-your-data/) by Harrison Chase (2023).

## Show Your Support

If you find these projects helpful or interesting, please consider starring the repository. It's a simple gesture that helps to boost the visibility of the project and show appreciation for the effort put into creating it. Additionally, if you'd like to support my work further, you can [**become a sponsor**](https://github.com/sponsors/solygambas). Your support is greatly appreciated. Thank you!
