# Multilingual RAG Search

A multilingual search tool based on Wikipedia data, utilizing the RAG approach to prompt GPT.

## Setup

You need to create a virtual env and install the packages listed in `requirements.txt`.

Follow these steps: [How to Work with Python Virtual Environments, Jupyter Notebooks and VS Code](https://python.plainenglish.io/how-to-work-with-python-virtual-environments-jupyter-notebooks-and-vs-code-536fac3d93a1).

You need to create a `.env` file with your `OPENAI_API_KEY`.

## Features

- obtaining vector representations of data.
- searching for similar vectors.
- looking for approximate nearest neighbors.
- utilizing vector databases.
- understanding sparse, dense, and hybrid search.
- creating a multilingual search tool.

Based on [Vector Databases: from Embeddings to Applications](https://www.deeplearning.ai/short-courses/vector-databases-embeddings-applications/) by Sebastian Witalec (2023).
