package zvalid

import (
	"testing"

	"github.com/sohaha/zlsgo"
)

func TestRuleIs(t *testing.T) {
	var err error
	tt := zlsgo.NewTest(t)

	err = New().Verifi("true", "值").IsBool().Error()
	tt.NoError(err)
	err = New().Verifi("1true").IsBool().Error()
	tt.Equal(true, err != nil)
	// 空值会直接跳过验证的
	err = New().Verifi("").IsBool().Error()
	tt.NoError(err)

	err = New().Verifi("abc").IsLetter().Error()
	tt.NoError(err)
	err = New().Verifi("a1").IsLetter().Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("").IsLetter().Error()
	tt.NoError(err)

	err = New().Verifi("a").IsLower().Error()
	tt.NoError(err)
	err = New().Verifi("1").IsLower().Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("").IsLower().Error()
	tt.NoError(err)

	err = New().Verifi("A").IsUpper().Error()
	tt.NoError(err)
	err = New().Verifi("1").IsUpper().Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("").IsUpper().Error()
	tt.NoError(err)

	err = New().Verifi("1").IsNumber().Error()
	tt.NoError(err)
	err = New().Verifi("-1").IsNumber().Error()
	tt.NoError(err)
	err = New().Verifi("-1.11").IsNumber().Error()
	tt.NoError(err)
	err = New().Verifi("a1").IsNumber().Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("").IsNumber().Error()
	tt.NoError(err)

	err = New().Verifi("1").IsInteger().Error()
	tt.NoError(err)
	err = New().Verifi("-1").IsInteger().Error()
	tt.NoError(err)
	err = New().Verifi("-1.11").IsInteger().Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("a1").IsInteger().Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("").IsInteger().Error()
	tt.NoError(err)

	err = New().Verifi("a1").IsLowerOrDigit().Error()
	tt.NoError(err)
	err = New().Verifi("A1").IsLowerOrDigit().Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("").IsLowerOrDigit().Error()
	tt.NoError(err)

	err = New().Verifi("A1").IsUpperOrDigit().Error()
	tt.NoError(err)
	err = New().Verifi("a1").IsUpperOrDigit().Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("").IsUpperOrDigit().Error()
	tt.NoError(err)

	err = New().Verifi("Abc1").IsLetterOrDigit().Error()
	tt.NoError(err)
	err = New().Verifi("A1.").IsLetterOrDigit().Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("").IsLetterOrDigit().Error()
	tt.NoError(err)

	err = New().Verifi("是我呀").IsChinese().Error()
	tt.NoError(err)
	err = New().Verifi("A1.").IsChinese().Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("").IsChinese().Error()
	tt.NoError(err)

	err = New().Verifi("13800138000", "手机号码").IsMobile().Error()
	tt.NoError(err)
	err = New().Verifi("A1.").IsMobile().Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("").IsMobile().Error()
	tt.NoError(err)

	err = New().Verifi("seekwe@gmail.com").IsMail().Error()
	tt.NoError(err)
	err = New().Verifi("A1.gmail.com").IsMail().Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("A1.@com").IsMail().Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("A1.@").IsMail().Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("").IsMail().Error()
	tt.NoError(err)

	err = New().Verifi("https://docs.73zls.com/zls-go/#").IsURL().Error()
	tt.NoError(err)
	err = New().Verifi("A1.gmail.com").IsURL().Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("").IsURL().Error()
	tt.NoError(err)

	err = New().Verifi("112.74.213.83", "ip").IsIP().Error()
	tt.NoError(err)
	err = New().Verifi("1271.1").IsIP().Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("").IsIP().Error()
	tt.NoError(err)

	err = New().Verifi(`{"name":"zlsgo"}`, "json").IsJSON().Error()
	tt.NoError(err)
	err = New().Verifi("test").IsJSON().Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("").IsJSON().Error()
	tt.NoError(err)

	err = New().Verifi(`11010119900307379X`).IsChineseIDNumber().Error()
	tt.NoError(err)
	err = New().Verifi("test").IsChineseIDNumber().Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("11010119900307379A").IsChineseIDNumber().Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("").IsChineseIDNumber().Error()
	tt.NoError(err)

	err = New().Verifi(`12345`).MinLength(3).Error()
	tt.NoError(err)
	err = New().Verifi("12").MinLength(3).Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("").MinLength(3).Error()
	tt.NoError(err)

	err = New().Verifi(`是我啊啊`).MinUTF8Length(3).Error()
	tt.NoError(err)
	err = New().Verifi("是").MinUTF8Length(3).Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("").MinUTF8Length(3).Error()
	tt.NoError(err)

	err = New().Verifi(`123`).MaxLength(3).Error()
	tt.NoError(err)
	err = New().Verifi("12345").MaxLength(1).Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("").MaxLength(3).Error()
	tt.NoError(err)

	err = New().Verifi(`是`).MaxUTF8Length(3).Error()
	tt.NoError(err)
	err = New().Verifi("是我啊啊").MaxUTF8Length(3).Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("").MaxUTF8Length(3).Error()
	tt.NoError(err)

	err = New().Verifi(`4`).MinInt(3).Error()
	tt.NoError(err)
	err = New().Verifi("2").MinInt(3).Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("a0").MinInt(3).Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("").MinInt(3).Error()
	tt.NoError(err)

	err = New().Verifi(`3`).MaxInt(3).Error()
	tt.NoError(err)
	err = New().Verifi("4").MaxInt(3).Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("a4").MaxInt(3).Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("").MaxInt(3).Error()
	tt.NoError(err)

	err = New().Verifi(`3.2`).MinFloat(3.1).Error()
	tt.NoError(err)
	err = New().Verifi("2.9").MinFloat(3).Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("a2.9").MinFloat(3).Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("").MinFloat(3).Error()
	tt.NoError(err)

	err = New().Verifi(`3.1`).MaxFloat(3.1).Error()
	tt.NoError(err)
	err = New().Verifi("3.9").MaxFloat(3).Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("a2.9").MaxFloat(3).Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("").MaxFloat(3).Error()
	tt.NoError(err)

	err = New().Verifi(`1`).EnumString([]string{"1"}).Error()
	tt.NoError(err)
	err = New().Verifi("2").EnumString([]string{"1"}).Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("").EnumString([]string{"1"}).Error()
	tt.NoError(err)

	err = New().Verifi(`1`).EnumInt([]int{1}).Error()
	tt.NoError(err)
	err = New().Verifi("2").EnumInt([]int{1}).Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("a2").EnumInt([]int{1}).Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("").EnumInt([]int{1}).Error()
	tt.NoError(err)

	err = New().Verifi(`1`).EnumFloat64([]float64{1.0}).Error()
	tt.NoError(err)
	err = New().Verifi("2").EnumFloat64([]float64{1}).Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("a2").EnumFloat64([]float64{1}).Error()
	tt.Equal(true, err != nil)
	err = New().Verifi("").EnumFloat64([]float64{1}).Error()
	tt.NoError(err)

	err = New().Verifi("12345").Regex("\\d+").Error()
	tt.NoError(err)
	err = New().Verifi("w12345").Regex("w1\\d345").Error()
	tt.NoError(err)
}
