Welcome to the DIWA Documentation
=================================

## What is DIWA?
DIWA is a Deliberately Insecure Web Application, which was built for educational purpose.
Use DIWA to try out common Web Application Security Flaws like
- [SQL Injection](https://www.owasp.org/index.php/SQL_Injection)
- [XSS (Cross-Site-Scripting)](https://www.owasp.org/index.php/Cross-site_Scripting_(XSS))
- [CSRF (Cross-Site-Request-Forgery)](https://www.owasp.org/index.php/Cross-Site_Request_Forgery_(CSRF))
- [Session Hijacking](https://www.owasp.org/index.php/Session_hijacking_attack)
- [Session Fixation](https://www.owasp.org/index.php/Session_fixation)
- [Content Spoofing](https://www.owasp.org/index.php/Content_Spoofing)
- [Missing Function Level Access Control](https://www.owasp.org/index.php/Top_10_2013-A7-Missing_Function_Level_Access_Control)
- [Path Traversal](https://www.owasp.org/index.php/Path_Traversal)
- [Sensitive Data Exposure](https://www.owasp.org/index.php/Top_10_2013-A6-Sensitive_Data_Exposure)
- [Brute Force Attacks](https://www.owasp.org/index.php/Brute_force_attack)
- and more ...

Since DIWA has a lot of security holes that allow an attacker to compromise a webspace / webserver make sure it is only
accessible for yourself or the persons you want to use it.

## How to contribute?
Feel free to fork DIWA or open [pull requests](https://github.com/snsttr/diwa/pulls) on github.

## Where can I report Issues?
Please use our github Project to [report Issues](https://github.com/snsttr/diwa/issues/).

## License
See [LICENSE.md](../LICENSE.md)