from snorkel.map import BaseMapper, LambdaMapper, Mapper, lambda_mapper

"""Base classes for transformation functions.

A transformation function (TF) represents an atomic transformation
to a data point in a data augmentation pipeline. Common examples in
image processing include small image rotations or crops. Snorkel
models data augmentation as a sequence of TFs generated by a policy.
"""

# Used for type checking only
# Note: subclassing as below trips up mypy
BaseTransformationFunction = BaseMapper


class TransformationFunction(Mapper):
    """Base class for TFs.

    See ``snorkel.map.core.Mapper`` for details.
    """

    pass


class LambdaTransformationFunction(LambdaMapper):
    """Convenience class for definining TFs from functions.

    See ``snorkel.map.core.LambdaMapper`` for details.
    """

    pass


class transformation_function(lambda_mapper):
    """Decorate functions to create TFs.

    See ``snorkel.map.core.lambda_mapper`` for details.

    Example
    -------
    >>> @transformation_function()
    ... def square(x):
    ...     x.num = x.num ** 2
    ...     return x
    >>> from types import SimpleNamespace
    >>> square(SimpleNamespace(num=2))
    namespace(num=4)
    """

    pass
