# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]
### [Breaking Changes]
### [Added]
### [Changed]
### [Deprecated]
### [Removed]


##  [0.10.0] - 2023-02-27
### [Breaking Changes]

* PR #1729: Add support for Python 3.11 and remove support for all other minor versions

### [Contributors]

Thanks to @bhancock8, @kamelCased, @MLobo1997, and @rsmith49 for contributions!


## [0.9.9] - 2022-07-28
### [Added]

* PR #1690: Bump numpy version for Mac M1 compat
* PR #1696: Fix linting
* PR #1694: Fix test loss
* PR #1693: Update black version to fix build
* PR #1671: Fix flaky test
* PR #1688: Fix branch filtering for complex tests
* PR #1686: Switch to CircleCI badge
* PR #1685: Migrating travis -> circle 

### [Contributors]

Thanks to @rsmith49, @zexuan-zhou, @humzaiqbal, @fpoms, @crawlingcub, and @henryre for contributions!


## [0.9.8] - 2021-09-23
### [Added]

* PR #1649: Add progress bar for label model training

### [Changed]

* PR #1645: Upgrade networkx requirement to support networkx>=2.5
* PR #1663: Upgrade tensorboard requirement to support tensorboard>=2.0
* PR #1652: Fix issue with logging display during label model training
* PR #1677: Bump version upper bound of networkx to 2.7

### [Contributors]

Thanks to @anerirana, @thatch, @sfilipi, @hardianlawi, @asottile and @marekmodry for contributions!

## [0.9.7] - 2021-03-03
### [Breaking Changes]

* PR #1633, #1628: Update requirements for `numpy` (>=1.16.5,<1.20.0), `pandas` (>=1.0.0,<2.0.0), and `scikit-learn` (>=0.20.2,<0.25.0)

### [Added]

* PR #1628: Add unit test coverage for Python 3.8
* PR #1616: Accept prec_init as array or list in `LabelModel`
* PR #1602: Add get_label_instances to analysis module

### [Contributors]

Thanks to @DavidKoleczek and @antonis19 for contributions!

## [0.9.6] - 2020-08-08
### [Added]

* PR #1572: Allow specification of `memoize_key` in preprocessors
* PR #1597: Improved error messages for MultitaskClassifier
* PR #1592: Improved LabelModel documentation

### [Contributors]

Thanks to @Wirg, @TrigonaMinima, and @dchichkov for recent contributions!

## [0.9.5] - 2020-04-06
### [Breaking Changes]

* PR #1565: Upgrade pytorch requirement to support torch>=1.2.0

## [0.9.4] - 2020-04-05
### [Breaking Changes]

* PR #1535: Refactor baseline model imports in snorkel.labeling.model
    * Now, from `from snorkel.labeling import MajorityLabelVoter, LabelModel`
    can be expressed `from snorkel.labeling.model import MajorityLabelVoter, LabelModel`

### [Added]

* PR #1533: Allow option to save optimizer state in Trainer
* PR #1523: Add GPU option for spaCy preprocessor

### [Changed]

* PR #1540: Fix squeeze bug in `to_int_label_array` function
* PR #1520: Fix error bucket documentation in snorkel.analysis.error_analysis

### [Contributors]

Thanks to @rjurney, @ptrcklv for recent contributions!

## [0.9.3] - 2019-11-11

### [Changed]

* PR #1502: Faster symmetry breaking in LabelModel using Munkres algorithm


## [0.9.2] - 2019-10-22

### [Breaking Changes]

* PR #1481: removed fault tolerant mode for labeling functions

### [Added]

* PR #1481: fault tolerant mode for appliers

### [Changed]

* PR #1450, 1467: ignore abstains in scoring, except coverage
* PR #1463: serialize all attributes of label model
* PR #1466: fix label model GPU training option
* PR #1477, #1492: pin dependency versions

### [Removed]

* PR #1454: `set_seed` utility removed

### [Contributors]

Thanks to @HiromuHota, @ferhatelmas, and @garaud for their recent contributions!


## [0.9.1] - 2019-09-05

### [Breaking Changes]

* PR #1453: `SlicingClassifier` renamed to `SliceAwareClassifier`

### [Added]

* PR #1451: add heuristic for breaking symmetry in multiple label model optima case
* PR #1442: integration test for `MultitaskClassifier`

### [Changed]

* PR #1444: fix label model weight clamping behavior
* PR #1445: fix JSON log writer
* PR #1447: fix correct/incorrect count bug in `LFAnalysis`
* PR #1428, 1449: catch invalid label model inputs
* PR #1441: make inputs to `Scorer.score` optional


## [0.9.0] - 2019-08-15
Version 0.9.0 is a complete redesign of the Snorkel library.
There's too much added, changed, and removed to list in this entry.
For more information on the release,
[check out the project homepage](https://snorkel.org).
From here forward, we'll keep a detailed changelog.
