// File: application.js.js
// Generated by CoffeeScript 1.10.0
(function() {
  $(document).ready(function() {
    var batch_actions_selector;
    $(document).on('focus', '.datepicker:not(.hasDatepicker)', function() {
      var defaults, options;
      defaults = {
        dateFormat: 'yy-mm-dd'
      };
      options = $(this).data('datepicker-options');
      return $(this).datepicker($.extend(defaults, options));
    });
    $('.clear_filters_btn').click(function() {
      var params, regex;
      params = window.location.search.split('&');
      regex = /^(q\[|q%5B|q%5b|page|commit)/;
      return window.location.search = "";
    });
    $('.filter_form').submit(function() {
      return $(this).find(':input').filter(function() {
        return this.value === '';
      }).prop('disabled', true);
    });
    $('.filter_form_field.select_and_search select').change(function() {
      return $(this).siblings('input').prop({
        name: "q[" + this.value + "]"
      });
    });
    if ((batch_actions_selector = $('.table_tools .batch_actions_selector')).length) {
      return batch_actions_selector.next().css({
        width: "calc(100% - 10px - " + (batch_actions_selector.outerWidth()) + "px)",
        'float': 'right'
      });
    }
  });

}).call(this);


// File: base.js.js
// Generated by CoffeeScript 1.10.0
(function() {
  window.ActiveAdmin = {};

}).call(this);


// File: batch_actions.js.js
// Generated by CoffeeScript 1.10.0
(function() {
  $(document).on('ready page:load', function() {
    $('#batch_actions_selector li a').click(function(e) {
      var message, r;
      e.stopPropagation();
      e.preventDefault();
      console.log('clicked it');
      if (message = $(this).data('confirm')) {
        r = window.confirm(message);
        if (r === true) {
          return $(this).trigger('confirm:complete', $(this).data('inputs'));
        }
      } else {
        return $(this).trigger('confirm:complete');
      }
    });
    $('#batch_actions_selector li a').on('confirm:complete', function(e, inputs) {
      var val;
      if (val = JSON.stringify(inputs)) {
        $('#batch_action_inputs').val(val);
      } else {
        $('#batch_action_inputs').attr('disabled', 'disabled');
      }
      $('#batch_action').val($(this).data('action'));
      return $('#collection_selection').submit();
    });
    if ($("#batch_actions_selector").length && $(":checkbox.toggle_all").length) {
      if ($(".paginated_collection").find("table.index_table").length) {
        $(".paginated_collection table").tableCheckboxToggler();
      } else {
        $(".paginated_collection").checkboxToggler();
      }
      return $(".paginated_collection").find(":checkbox").bind("change", function() {
        if ($(".paginated_collection").find(":checkbox").filter(":checked").length > 0) {
          return $("#batch_actions_selector").aaDropdownMenu("enable");
        } else {
          return $("#batch_actions_selector").aaDropdownMenu("disable");
        }
      });
    }
  });

}).call(this);


// File: checkbox-toggler.js.js
// Generated by CoffeeScript 1.10.0
(function() {
  ActiveAdmin.CheckboxToggler = (function() {
    function CheckboxToggler(options, container) {
      var defaults;
      this.options = options;
      this.container = container;
      defaults = {};
      this.options = $.extend(defaults, this.options);
      this._init();
      this._bind();
    }

    CheckboxToggler.prototype._init = function() {
      if (!this.container) {
        throw new Error('Container element not found');
      } else {
        this.$container = $(this.container);
      }
      if (!this.$container.find('.toggle_all').length) {
        throw new Error('"toggle all" checkbox not found');
      } else {
        this.toggle_all_checkbox = this.$container.find('.toggle_all');
      }
      return this.checkboxes = this.$container.find(':checkbox').not(this.toggle_all_checkbox);
    };

    CheckboxToggler.prototype._bind = function() {
      this.checkboxes.change((function(_this) {
        return function(e) {
          return _this._didChangeCheckbox(e.target);
        };
      })(this));
      return this.toggle_all_checkbox.change((function(_this) {
        return function() {
          return _this._didChangeToggleAllCheckbox();
        };
      })(this));
    };

    CheckboxToggler.prototype._didChangeCheckbox = function(checkbox) {
      switch (this.checkboxes.filter(':checked').length) {
        case this.checkboxes.length - 1:
          return this.toggle_all_checkbox.prop({
            checked: null
          });
        case this.checkboxes.length:
          return this.toggle_all_checkbox.prop({
            checked: true
          });
      }
    };

    CheckboxToggler.prototype._didChangeToggleAllCheckbox = function() {
      var setting;
      setting = this.toggle_all_checkbox.prop('checked') ? true : null;
      return this.checkboxes.each((function(_this) {
        return function(index, el) {
          $(el).prop({
            checked: setting
          });
          return _this._didChangeCheckbox(el);
        };
      })(this));
    };

    return CheckboxToggler;

  })();

  $.widget.bridge('checkboxToggler', ActiveAdmin.CheckboxToggler);

}).call(this);


// File: dropdown-menu.js.js
// Generated by CoffeeScript 1.10.0
(function() {
  ActiveAdmin.DropdownMenu = (function() {
    function DropdownMenu(options, element) {
      var defaults;
      this.options = options;
      this.element = element;
      this.$element = $(this.element);
      defaults = {
        fadeInDuration: 20,
        fadeOutDuration: 100,
        onClickActionItemCallback: null
      };
      this.options = $.extend(defaults, this.options);
      this.isOpen = false;
      this.$menuButton = this.$element.find('.dropdown_menu_button');
      this.$menuList = this.$element.find('.dropdown_menu_list_wrapper');
      this._buildMenuList();
      this._bind();
    }

    DropdownMenu.prototype.open = function() {
      this.isOpen = true;
      this.$menuList.fadeIn(this.options.fadeInDuration);
      this._position();
      return this;
    };

    DropdownMenu.prototype.close = function() {
      this.isOpen = false;
      this.$menuList.fadeOut(this.options.fadeOutDuration);
      return this;
    };

    DropdownMenu.prototype.destroy = function() {
      this.$element.unbind();
      this.$element = null;
      return this;
    };

    DropdownMenu.prototype.isDisabled = function() {
      return this.$menuButton.hasClass('disabled');
    };

    DropdownMenu.prototype.disable = function() {
      return this.$menuButton.addClass('disabled');
    };

    DropdownMenu.prototype.enable = function() {
      return this.$menuButton.removeClass('disabled');
    };

    DropdownMenu.prototype.option = function(key, value) {
      if ($.isPlainObject(key)) {
        return this.options = $.extend(true, this.options, key);
      } else if (key != null) {
        return this.options[key];
      } else {
        return this.options[key] = value;
      }
    };

    DropdownMenu.prototype._buildMenuList = function() {
      this.$nipple = $('<div class="dropdown_menu_nipple"></div>');
      this.$menuList.prepend(this.$nipple);
      return this.$menuList.hide();
    };

    DropdownMenu.prototype._bind = function() {
      $('body').click((function(_this) {
        return function() {
          if (_this.isOpen) {
            return _this.close();
          }
        };
      })(this));
      return this.$menuButton.click((function(_this) {
        return function() {
          if (!_this.isDisabled()) {
            if (_this.isOpen) {
              _this.close();
            } else {
              _this.open();
            }
          }
          return false;
        };
      })(this));
    };

    DropdownMenu.prototype._position = function() {
      var button_center, button_left, button_right, centered_menu_left, centered_menu_right, menu_center, nipple_center, window_right;
      this.$menuList.css('top', this.$menuButton.position().top + this.$menuButton.outerHeight() + 10);
      button_left = this.$menuButton.position().left;
      button_center = this.$menuButton.outerWidth() / 2;
      button_right = button_left + button_center * 2;
      menu_center = this.$menuList.outerWidth() / 2;
      nipple_center = this.$nipple.outerWidth() / 2;
      window_right = $(window).width();
      centered_menu_left = button_left + button_center - menu_center;
      centered_menu_right = button_left + button_center + menu_center;
      if (centered_menu_left < 0) {
        this.$menuList.css('left', button_left);
        return this.$nipple.css('left', button_center - nipple_center);
      } else if (centered_menu_right > window_right) {
        this.$menuList.css('right', window_right - button_right);
        return this.$nipple.css('right', button_center - nipple_center);
      } else {
        this.$menuList.css('left', centered_menu_left);
        return this.$nipple.css('left', menu_center - nipple_center);
      }
    };

    return DropdownMenu;

  })();

  $.widget.bridge('aaDropdownMenu', ActiveAdmin.DropdownMenu);

  $(document).on('ready page:load', function() {
    return $('.dropdown_menu').aaDropdownMenu();
  });

}).call(this);


// File: flash.js.js
// Generated by CoffeeScript 1.10.0
(function() {
  var Flash;

  ActiveAdmin.flash = Flash = (function() {
    Flash.error = function(message, close_after) {
      return new this(message, "error", close_after);
    };

    Flash.notice = function(message, close_after) {
      return new this(message, "notice", close_after);
    };

    Flash.prototype.reference = function() {
      return this.reference;
    };

    function Flash(message1, type1, close_after) {
      this.message = message1;
      this.type = type1 != null ? type1 : "notice";
      this.reference = jQuery("<div>").addClass("flash flash_" + type).text(message);
      jQuery(".flashes").append(this.reference);
      if (close_after != null) {
        this.close_after(close_after);
      }
    }

    Flash.prototype.close_after = function(close_after) {
      return setTimeout((function(_this) {
        return function() {
          return _this.close();
        };
      })(this), close_after * 1000);
    };

    Flash.prototype.close = function() {
      return this.reference.remove();
    };

    return Flash;

  })();

}).call(this);


// File: has_many.js.js
// Generated by CoffeeScript 1.10.0
(function() {
  var init_sortable, recompute_positions;

  $(function() {
    $(document).on('click', 'a.button.has_many_remove', function(e) {
      var parent, to_remove;
      e.preventDefault();
      parent = $(this).closest('.has_many_container');
      to_remove = $(this).closest('fieldset');
      recompute_positions(parent);
      parent.trigger('has_many_remove:before', [to_remove, parent]);
      to_remove.remove();
      return parent.trigger('has_many_remove:after', [to_remove, parent]);
    });
    $(document).on('click', 'a.button.has_many_add', function(e) {
      var before_add, fieldset, html, index, parent, regex;
      e.preventDefault();
      parent = $(this).closest('.has_many_container');
      parent.trigger(before_add = $.Event('has_many_add:before'), [parent]);
      if (!before_add.isDefaultPrevented()) {
        index = parent.data('has_many_index') || parent.children('fieldset').length - 1;
        parent.data({
          has_many_index: ++index
        });
        regex = new RegExp($(this).data('placeholder'), 'g');
        html = $(this).data('html').replace(regex, index);
        fieldset = $(html).insertBefore(this);
        recompute_positions(parent);
        return parent.trigger('has_many_add:after', [fieldset, parent]);
      }
    });
    $(document).on('change', '.has_many_container[data-sortable] :input[name$="[_destroy]"]', function() {
      return recompute_positions($(this).closest('.has_many'));
    });
    init_sortable();
    return $(document).on('has_many_add:after', '.has_many_container', init_sortable);
  });

  init_sortable = function() {
    var elems;
    elems = $('.has_many_container[data-sortable]:not(.ui-sortable)');
    elems.sortable({
      items: '> fieldset',
      handle: '> ol > .handle',
      stop: recompute_positions
    });
    return elems.each(recompute_positions);
  };

  recompute_positions = function(parent) {
    var input_name, position;
    parent = parent instanceof jQuery ? parent : $(this);
    input_name = parent.data('sortable');
    position = parseInt(parent.data('sortable-start') || 0, 10);
    return parent.children('fieldset').each(function() {
      var destroy_input, sortable_input;
      destroy_input = $(this).find("> ol > .input > :input[name$='[_destroy]']");
      sortable_input = $(this).find("> ol > .input > :input[name$='[" + input_name + "]']");
      if (sortable_input.length) {
        return sortable_input.val(destroy_input.is(':checked') ? '' : position++);
      }
    });
  };

}).call(this);


// File: modal_dialog.js.js
// Generated by CoffeeScript 1.10.0
(function() {
  ActiveAdmin.modal_dialog = function(message, inputs, callback) {
    var elem, html, klass, name, opts, ref, ref1, type, v, wrapper;
    html = "<form id=\"dialog_confirm\" title=\"" + message + "\"><ul>";
    for (name in inputs) {
      type = inputs[name];
      if (/^(datepicker|checkbox|text)$/.test(type)) {
        wrapper = 'input';
      } else if (type === 'textarea') {
        wrapper = 'textarea';
      } else if ($.isArray(type)) {
        ref = ['select', 'option', type, ''], wrapper = ref[0], elem = ref[1], opts = ref[2], type = ref[3];
      } else {
        throw new Error("Unsupported input type: {" + name + ": " + type + "}");
      }
      klass = type === 'datepicker' ? type : '';
      html += ("<li>\n<label>" + (name.charAt(0).toUpperCase() + name.slice(1)) + "</label>\n<" + wrapper + " name=\"" + name + "\" class=\"" + klass + "\" type=\"" + type + "\">") + (opts ? ((function() {
        var i, len, results;
        results = [];
        for (i = 0, len = opts.length; i < len; i++) {
          v = opts[i];
          if ($.isArray(v)) {
            results.push("<" + elem + " value=" + v[1] + ">" + v[0] + "</" + elem + ">");
          } else {
            results.push("<" + elem + ">" + v + "</" + elem + ">");
          }
        }
        return results;
      })()).join('') : '') + ("</" + wrapper + ">") + "</li>";
      ref1 = [], wrapper = ref1[0], elem = ref1[1], opts = ref1[2], type = ref1[3], klass = ref1[4];
    }
    html += "</ul></form>";
    return $(html).appendTo('body').dialog({
      modal: true,
      dialogClass: 'active_admin_dialog',
      buttons: {
        OK: function() {
          callback($(this).serializeObject());
          return $(this).dialog('close');
        },
        Cancel: function() {
          return $(this).dialog('close').remove();
        }
      }
    });
  };

}).call(this);


// File: per_page.js.js
// Generated by CoffeeScript 1.10.0
(function() {
  ActiveAdmin.PerPage = (function() {
    function PerPage(options, element) {
      this.options = options;
      this.element = element;
      this.$element = $(this.element);
      this._init();
      this._bind();
    }

    PerPage.prototype._init = function() {
      return this.$params = this._queryParams();
    };

    PerPage.prototype._bind = function() {
      return this.$element.change((function(_this) {
        return function() {
          _this.$params['per_page'] = _this.$element.val();
          delete _this.$params['page'];
          return location.search = $.param(_this.$params);
        };
      })(this));
    };

    PerPage.prototype._queryParams = function() {
      var m, params, query, re;
      query = window.location.search.substring(1);
      params = {};
      re = /([^&=]+)=([^&]*)/g;
      while (m = re.exec(query)) {
        params[decodeURIComponent(m[1])] = decodeURIComponent(m[2]);
      }
      return params;
    };

    return PerPage;

  })();

  $.widget.bridge('perPage', ActiveAdmin.PerPage);

  $(function() {
    return $('.pagination_per_page select').perPage();
  });

}).call(this);


// File: popover.js.js
// Generated by CoffeeScript 1.10.0
(function() {
  ActiveAdmin.Popover = (function() {
    function Popover(options1, element) {
      var defaults;
      this.options = options1;
      this.element = element;
      this.$element = $(this.element);
      defaults = {
        fadeInDuration: 20,
        fadeOutDuration: 100,
        autoOpen: true,
        pageWrapperElement: "#wrapper",
        onClickActionItemCallback: null
      };
      this.options = $.extend(defaults, options);
      this.isOpen = false;
      if (!(this.$popover = $(this.$element.attr('href'))).length) {
        this.$popover = this.$element.next('.popover');
      }
      this._buildPopover();
      this._bind();
    }

    Popover.prototype.open = function() {
      this.isOpen = true;
      this.$popover.fadeIn(this.options.fadeInDuration);
      this._positionPopover();
      this._positionNipple();
      return this;
    };

    Popover.prototype.close = function() {
      this.isOpen = false;
      this.$popover.fadeOut(this.options.fadeOutDuration);
      return this;
    };

    Popover.prototype.destroy = function() {
      this.$element.removeData('popover');
      this.$element.unbind();
      this.$element = null;
      return this;
    };

    Popover.prototype._buildPopover = function() {
      this.$nipple = $('<div class="popover_nipple"></div>');
      this.$popover.prepend(this.$nipple);
      this.$popover.hide();
      return this.$popover.addClass('popover');
    };

    Popover.prototype._bind = function() {
      $(this.options.pageWrapperElement).click((function(_this) {
        return function() {
          if (_this.isOpen) {
            return _this.close();
          }
        };
      })(this));
      if (this.options.autoOpen) {
        return this.$element.click((function(_this) {
          return function(e) {
            e.stopPropagation();
            if (_this.isOpen) {
              return _this.close();
            } else {
              return _this.open();
            }
          };
        })(this));
      }
    };

    Popover.prototype._positionPopover = function() {
      var button_center, popover_center;
      button_center = this.$element.offset().left + this.$element.outerWidth() / 2;
      popover_center = this.$popover.outerWidth() / 2;
      return this.$popover.css('left', button_center - popover_center);
    };

    Popover.prototype._positionNipple = function() {
      this.$popover.css('top', this.$element.offset().top + this.$element.outerHeight() + 10);
      return this.$nipple.css('left', this.$popover.outerWidth() / 2 - this.$nipple.outerWidth() / 2);
    };

    return Popover;

  })();

  $.widget.bridge('popover', ActiveAdmin.Popover);

}).call(this);


// File: table-checkbox-toggler.js.js
// Generated by CoffeeScript 1.10.0
(function() {
  var extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  ActiveAdmin.TableCheckboxToggler = (function(superClass) {
    extend(TableCheckboxToggler, superClass);

    function TableCheckboxToggler() {
      return TableCheckboxToggler.__super__.constructor.apply(this, arguments);
    }

    TableCheckboxToggler.prototype._init = function() {
      return TableCheckboxToggler.__super__._init.apply(this, arguments);
    };

    TableCheckboxToggler.prototype._bind = function() {
      TableCheckboxToggler.__super__._bind.apply(this, arguments);
      return this.$container.find('tbody td').click((function(_this) {
        return function(e) {
          if (e.target.type !== 'checkbox') {
            return _this._didClickCell(e.target);
          }
        };
      })(this));
    };

    TableCheckboxToggler.prototype._didChangeCheckbox = function(checkbox) {
      var $row;
      TableCheckboxToggler.__super__._didChangeCheckbox.apply(this, arguments);
      $row = $(checkbox).parents('tr');
      if (checkbox.checked) {
        return $row.addClass('selected');
      } else {
        return $row.removeClass('selected');
      }
    };

    TableCheckboxToggler.prototype._didClickCell = function(cell) {
      return $(cell).parent('tr').find(':checkbox').click();
    };

    return TableCheckboxToggler;

  })(ActiveAdmin.CheckboxToggler);

  $.widget.bridge('tableCheckboxToggler', ActiveAdmin.TableCheckboxToggler);

}).call(this);


// File: sortable_associations.js
$(document).ready(function() {
  // Fix sortable helper
  var fixHelper = function(e, ui) {
    ui.children().each(function() {
        $(this).width($(this).width());
    });
    return ui;
  };

  $('table.sortable').ready(function(){
    var td_count = $(this).find('tbody tr:first-child td').length
    $('table.sortable tbody').sortable(
      {
        handle: '.handle',
        helper: fixHelper,
        placeholder: 'ui-sortable-placeholder',
        update: function(event, ui) {
          //$("#progress").show();
          var positions = [];
          $.each($('table.sortable tbody tr'), function(position, obj){
            var reg = /(\w+_?)+_(\d+)/;
            var parts = reg.exec($(obj).prop('id'));
            if (parts) {
              positions = positions.concat({'id': parts[2], 'position': position});
            }
          });
          $.ajax({
            url: $(ui.item).closest("table.sortable").data("sortable-link"),
            type: 'POST',
            beforeSend: function(xhr) {
              var csrf_token = $('meta[name=csrf-token]').attr('content');
              xhr.setRequestHeader('x-csrf-token', csrf_token);
            },
            dataType: 'script',
            data: {positions: positions},
            success: function(data){
              //$("#progress").hide();
            }
          });
        },
        start: function (event, ui) {
          // Set correct height for placehoder (from dragged tr)
          ui.placeholder.height(ui.item.height());
          // Fix placeholder content to make it correct width
          ui.placeholder.html("<td colspan='"+(td_count)+"'></td>");
        },
        stop: function (event, ui) {
          // Fix odd/even classes after reorder
          $("table.sortable tr:even").removeClass("odd even").addClass("even");
          $("table.sortable tr:odd").removeClass("odd even").addClass("odd");
        }

      });
  });

});