import type {Translations} from '../../server/chat';

export const translations: Translations = {
	strings: {
		"Hello! The global staff team would be happy to help you, but you need to explain what's going on first.": "Olá! A staff global está feliz em poder te ajudar, mas precisamos que você explique o problema primeiro.",
		"Please post the information I requested above so a global staff member can come to help.": "Por favor, poste a informação requisitada para que um membro da staff global possa vir te ajudar.",
		"Thank you for the information, global staff will be here shortly. Please stay in the room.": "Obrigado pela informação, um membro da staff global estará aqui em instantes. Por favor espere na sala.",
		"You are banned from creating tickets": "Você está proibido de criar pedidos de ajuda.",
		", because you have the same IP as ${ticket.banned}.": ", porque você tem o mesmo IP de ${ticket.banned}.",
		"Request help from global staff": "Peça ajuda a staff global",
		"Please <button name=\"login\" class=\"button\">Log In</button> to request help.": "Por favor <button name=\"login\" class=\"button\">faça login</button> para pedir ajuda.",
		"Request Help": "Peça Ajuda",
		"You already have a Help ticket.": "Você já tem um pedido de ajuda aberto.",
		"Back": "Voltar",
		"What's going on?": "O que está acontecendo?",
		"Global staff cannot make Help requests. This form is only for reference.": "A Staff Global não pode abrir pedidos de ajuda. Esse formulário é apenas para referência.",
		"Abuse of Help requests can result in punishments.": "Abusar de pedidos de ajuda pode resultar em punições.",
		"What do you want to report someone for?": "Qual o motivo do seu report?",
		"If someone is harassing you in private messages (PMs), click the button below and a global staff member will take a look. If you are being harassed in a chatroom, please ask a room staff member to handle it. If it's a minor issue, consider using <code>/ignore [username]</code> instead.": "Se alguém está te incomodando em mensagens privadas (PMs), clique no botão abaixo para que um membro da staff global dê uma olhada. Se você está sendo importunado em uma sala de chat, peça ajuda a algum membro da staff da sala. Se é algum problema pequeno, considere usar o comando <code>/ignore [nickname]</code>.",
		"If someone is harassing you in a battle, click the button below and a global staff member will take a look. If you are being harassed in a chatroom, please ask a room staff member to handle it. If it's a minor issue, consider using <code>/ignore [username]</code> instead.": "Se alguém está te incomodando em uma batalha, clique no botão abaixo para que um membro da staff global dê uma olhada. Se você está sendo importunado em uma sala de chat, peça ajuda a algum membro da staff da sala. Se é algum problema pequeno, considere usar o comando <code>/ignore [nickname]</code>.",
		"Please save a replay of the battle if it has ended, or provide a link to the battle if it is still ongoing.": "Por favor salve o replay da batalha se ela ja tiver acabado, ou providencie o link para a batalha se ela ainda estiver acontecendo.",
		"If a user has an inappropriate name, click the button below and a global staff member will take a look.": "Se um usuário estiver usando um nome inapropriado, clique no botão abaixo para que um membro da staff global dê uma olhada.",
		"If a user has inappropriate Pokemon nicknames, click the button below and a global staff member will take a look.": "Se um usuário estiver usando nomes inapropriados em seus Pokémon, clique no botão abaixo para que um membro da staff global dê uma olhada.",
		"What would you like to appeal?": "Que tipo de apelo você gostaria de fazer?",
		"Permalocks are usually for repeated incidents of poor behavior over an extended period of time, and rarely for a single severe infraction. Please keep this in mind when appealing a permalock.": "Permalocks são utilizados no caso de incidência continua de comportamento ruim durante um período extendido de tempo, e esporadicamente em casos de uma infração severa. Por favor tenha isso em mente quando fizer um apelo a um permalock.",
		"Please visit the <a href=\"https://www.smogon.com/forums/threads/discipline-appeal-rules.3583479/\">Discipline Appeals</a> page to appeal your permalock.": "Por favor visite a página <a href=\"https://www.smogon.com/forums/threads/discipline-appeal-rules.3583479/\">Discipline Appeals</a> para fazer um apelo ao seu permalock.",
		"If you want to appeal your lock or namelock, click the button below and a global staff member will be with you shortly.": "Se você deseja realizar um apelo a respeito de seu lock ou namelock, clique no botão abaixo e um membro da staff global estará aqui em breve.",
		"If you are locked or namelocked under a name you don't recognize, click the button below to call a global staff member so we can check.": "Se você recebeu um lock ou namelock em algum nome que você não reconhece, clique no botão abaixo para que um membro da staff global possa checar o ocorrido.",
		"We automatically lock proxies and VPNs to prevent evasion of punishments and other attacks on our server. To get unlocked, you need to disable your proxy or VPN.": "Nós realizamos lock automático de proxies e VPNs para prevenir a evasão de punições e outros tipos de ataques ao nosso servidor. Para ser unlocked, você precisa desabilitar o seu proxy ou VPN.",
		"Do you have an autoconfirmed account? An account is autoconfirmed when it has won at least one rated battle and has been registered for one week or longer.": "Você possui uma conta verificada? Uma conta é verificada quando ela é registrada há pelo menos uma semana e tem pelo menos uma vitória em batalhas na ladder.",
		"Login to your autoconfirmed account by using the <code>/nick</code> command in any chatroom, and the semilock will automatically be removed. Afterwards, you can use the <code>/nick</code> command to switch back to your current username without being semilocked again.": "Faça o login na sua conta verificada usando o commando <code>/nick</code> em qualquer chatroom, e o seu semilock será removido automaticamente. Após isso, você pode usar novamente o commando <code>/nick</code> para voltar a sua conta atual sem estar semilocked.",
		"If the semilock does not go away, you can try asking a global staff member for help. Click the button below to call a global staff member.": "Se o semilock persistir, você pode pedir ajuda a um membro da staff global. Clique no botão abaixo para chamar um membro da staff global.",
		"If you don't have an autoconfirmed account, you will need to contact a global staff member to appeal your semilock. Click the button below to call a global staff member.": "Se você não possui uma conta verificada, você terá que entrar em contato com um membro da staff global para fazer um apelo ao semilock. Clique no botão abaixo para chamar um membro da staff global.",
		"Please PM the staff member who punished you. If you don't know who punished you, ask another room staff member; they will redirect you to the correct user. If you are banned or blacklisted from the room, use <code>/roomauth [name of room]</code> to get a list of room staff members. Bold names are online.": "Por favor, envie uma mensagem privada (PM) para o membro da staff que realizou a punição em você. Se você não sabe quem foi, pergunte a um membro da staff e você será direcionado ao usuário correto. Se você foi banido ou blacklisted de uma sala, use o comando <code>/roomauth [nome da sala]</code> para obter a lista de staff da sala. Nomes em negrito estão online.",
		"Do not PM staff if you are locked (signified by the symbol <code>‽</code> in front of your username). Locks are a different type of punishment; to appeal a lock, make a help ticket by clicking the Back button and then selecting the most relevant option.": "Não mande mensagens privadas (PMs) para membros da staff se você está locked (evidenciado pelo símbolo <code>‽</code> em frente ao seu nome de usuário). Locks são tipos únicos de punição; para apelar a um lock, faça um pedido de ajuda clicando no botão Voltar e selecionando a opção mais relevante para o caso.",
		"Maybe one of these options will be helpful?": "Talvez uma dessas opções sejá útil?",
		"If you lost your password, click the button below to request a password reset. We will need to clarify a few pieces of information before resetting the account. Please note that password resets are low priority and may take a while; we recommend using a new account while waiting.": "Se você perdeu sua senha, clique no botão abaixo para requisitar um reset de sua senha. Precisaremos verificar algumas informações primeiro antes de resetar sua conta. Por favor tenha em mente que resets de senha tem baixa prioridade e podem levar algum tempo; recomendamos que use uma nova conta enquanto espera.",
		"Request a password reset": "Requisitar um reset de sua senha",
		"If you are a room driver or up in a public room, and you need help watching the chat, one or more global staff members would be happy to assist you!": "Se você é room driver ou acima em uma room pública e precisa de ajuda para cuidar do chat, um ou mais membros da staff global ficariam felizes em poder te ajudar!",
		"If your issue is not handled above, click the button below to talk to a global staff member. Please be ready to explain the situation.": "Se o seu problema não foi resolvido acima, clique no botão abaixo para falar com um membro da staff global. Por favor esteja pronto para explicar a situação.",
		"Malformed help request.": "Pedido de ajuda mal feito.",
		"PM Harassment": "Importunação por PM",
		"Battle Harassment": "Importunação em batalhas",
		"Inappropriate Username": "Nome de usuário inapropriado",
		"Inappropriate Pokemon Nicknames": "Apelidos inapropriados em Pokémon",
		"Appeal": "Apelo",
		"IP-Appeal": "Apelo de IP",
		"ISP-Appeal": "Apelo de ISP",
		"Public Room Assistance Request": "Pedido de assistência a sala pública",
		"Other": "Outros",
		"I want to report someone": "Quero reportar um usuário",
		"Someone is harassing me in PMs": "Alguém está me importunando em PMs",
		"Someone is harassing me in a battle": "Alguém está me importunando em batalha",
		"Someone is using an offensive username": "Alguém está usando um nome ofensivo",
		"Someone is using offensive Pokemon nicknames": "Alguém está usando apelidos ofensivos em seus Pokémon",
		"I want to appeal a punishment": "Quero apelar uma punição",
		"I want to appeal my permalock": "Quero apelar meu permalock",
		"I want to appeal my lock": "Quero apelar meu lock",
		"I'm locked because I have the same IP as someone I don't recognize": "Estou locked porque tenho o mesmo IP de alguém que não reconheço",
		"I can't talk in chat because of my ISP": "Não consigo falar no chat por conta do meu ISP",
		"I'm locked because of a proxy or VPN": "Estou locked por conta de proxy ou VPN",
		"Yes, I have an autoconfirmed account": "Sim, possuo uma conta verificada",
		"No, I don't have an autoconfirmed account": "Não, não possuo uma conta verificada",
		"I want to appeal a mute/roomban/blacklist": "Quero apelar um mute/roomban/blacklist",
		"Something else": "Outra coisa",
		"I lost my password": "Perdi minha senha",
		"I need global staff to help watch a public room": "Preciso da ajuda de um membro da staff global em uma sala pública",
		"Report harassment in a private message (PM)": "Reportar importunação em mensagem privada",
		"Report harassment in a battle": "Reportar importunação em batalha",
		"Report an inappropriate username": "Reportar um nome inapropriado",
		"Report inappropriate Pokemon nicknames": "Reportar apelidos inapropriados em Pokémon",
		"Appeal your lock": "Faça um apelo de seu lock",
		"Appeal IP lock": "Faça um apelo de seu lock de IP",
		"Appeal ISP lock": "Faça um apelo de seu lock de ISP",
		"Call a Global Staff member to help": "Chame um membro da staff global para ajudar",
		"Call a Global Staff member": "Chame um membro da staff global",
		"Are you sure you want to submit a ticket for ${type}?": "Tem certeza que você quer enviar um pedido de ajuda para ${type}?",
		"Yes, contact global staff": "Sim, contatar a staff global",
		"No, cancel": "Não, cancelar",
		"Help Ticket Stats": "Status de pedidos de ajuda",
		"Help tickets": "Pedidos de ajuda",
		"Status": "Status",
		"Creator": "Criador",
		"Ticket Type": "Tipo de pedido",
		"Language": "Linguagem",
		"Claimed by": "Atendido por",
		"Action": "Ação",
		"And ${keys.length - count} more tickets.": "E $${keys.length - count} outros pedidos",
		"View all tickets": "Ver todos os pedidos",
		"Closed": "Encerrado",
		"Inactive": "Inativo",
		"Claimed": "Atendido",
		"Unclaimed": "Não atendido",
		"Claim": "Atender",
		"View": "Ver",
		"Log": "Log",
		"Banned by": "Banido por",
		"Username": "Nome de Usuário",
		"Expires": "Expira",
		"Logs": "Logs",
		"And ${banKeys.length - count} more ticket bans.": "E ${banKeys.length - count} outros banimentos de pedidos de ajuda.",
		"Ticket List": "Lista de pedidos de ajuda",
		"Banned": "Banido",
		"Ticket Stats": "Estatísticas de pedidos de ajuda",
		"No ticket stats found.": "Nenhum estatística de pedido de ajuda encontrada.",
		"Previous Month": "Mês anterior",
		"Staff Stats": "Estatísticas da Staff",
		"Next Month": "Mês seguinte",
		"Resolved": "Resvolvido",
		"Unresolved": "Não resolvido",
		"Dead": "Morto",
		"Type": "Tipo",
		"Total Tickets": "Total de pedidos de ajuda",
		"Average Total Time": "Média de tempo total",
		"Average Initial Wait": "Média de espera inicial",
		"Average Total Wait": "Média de espera total",
		"Resolutions": "Resoluções",
		"Positive Result": "Resultado positivo",
		"Staff ID": "ID do membro da staff",
		"Number of Tickets": "Número de pedidos de ajuda",
		"Average Time Per Ticket": "Média de tempo por pedido de ajuda",
		"This command cannot be broadcast in battles.": "Este comando não pode ser exibido publicamente em batalhas.",
		"Report someone": "Reporte alguém.",
		"Appeal a punishment": "Faça um apelo",
		"Request help": "Peça ajuda",
		"You need to choose a username before doing this. [TN: 'this' refers to opening a help ticket]": "Você precisa escolher um nome de usuário antes de fazer isso.",
		"Global staff can't make tickets. They can only use the form for reference.": "A staff global não pode abrir pedidos de ajuda. Esse formulário é apenas para referência.",
		"You already have an open ticket; please wait for global staff to respond.": "Você já tem um pedido de ajuda aberto; por favor espere a staff global responder.",
		"Due to high load, you are limited to creating ${maxTickets} tickets every hour.": "Devido à alta demanda, você só pode criar ${maxTickets} pedidos de ajuda por hora.",
		"Hi! Who was harassing you in private messages?": "Oi! Quem estava te importunando em mensagens privadas?",
		"Hi! Who was harassing you, and in which battle did it happen? Please post a link to the battle or a replay of the battle.": "Oi! Quem estava te importunando, e em que batalha aconteceu? Por favor, poste o link ou replay da batalha em questão.",
		"Hi! Tell us the username that is inappropriate.": "Oi! Diga-nos qual o nome de usuário que é inapropriado.",
		"Hi! Which user has Pokemon with inappropriate nicknames, and in which battle? Please post a link to the battle or a replay of the battle.": "Oi! Qual usuário tem Pokémon com apelidos inapropriados, e em que batalha? Por favor poste um link ou replay da batalha em questão.",
		"Hi! Can you please explain why you feel your punishment is undeserved?": "Oi! Você pode, por favor, explicar por que você acha que foi punido injustamente?",
		"Hi! How are you connecting to Showdown right now? At home, at school, on a phone using mobile data, or some other way?": "Oi! Como você está conectado ao Showdown agora mesmo? Em casa, na escola, usando dados móveis em um celular ou de alguma outra forma?",
		"Hi! Which room(s) do you need us to help you watch?": "Oi! Qual(is) sala(s) você quer nossa ajuda para observar?",
		"Hi! What seems to be the problem? Tell us about any people involved,\n and if this happened in a specific place on the site.": "Oi! Qual parece ser o problema? Conte-nos sobre quaisquer pessoas envolvidas, \n e se aconteceu em um local específico do site.",
		"Hi! Please click the button below to give global staff permission to check PMs.": "Oi! Por favor, clique no botão abaixo para permitir que a staff global verifique suas mensagens privadas.",
		" Or if ${reportTarget} is not the user you want to report, please tell us the name of the user who you want to report.": " Ou se ${reportTarget} não for o usuário que você quer reportar, conte-nos o nome do usuário que você quer reportar.",
		"Help Ticket": "Pedido de Ajuda",
		"Issue": "Problema",
		"A Global Staff member will be with you shortly.": "Um membro da staff global estará com você brevemente.",
		"${inputUsername} does not have an open ticket.": "${inputUsername} não tem um pedido de ajuda aberto.",
		"You closed ${ticket.creator}'s ticket.": "Você encerrou o pedido de ajuda de ${ticket.creator}.",
		"The reason is too long. It cannot exceed 300 characters.": "O motivo é muito longo. Não é possível exceder 300 caracteres.",
		"User '${targetUsername}' not found.": "Usuário '${targetUsername}' não encontrado.",
		"${targetUser ? targetUser.name : target} is not ticket banned.": "${targetUser ? targetUser.name : target} não está banido de pedidos de ajuda.",
		"${targetUser ? targetUser.name : target}'s ticket ban is already expired.": "O banimento de pedidos de ajuda de ${targetUser ? targetUser.name : target} já expirou.",
		"You are already ignoring help ticket notifications. Use /helpticket unignore to receive notifications again.": "Você já está ignorando notificações de pedidos de ajuda. Use /helptickets unignore para receber notificações novamente.",
		"You are now ignoring help ticket notifications.": "Agora você está ignorando notificações de pedidos de ajuda.",
		"You are not ignoring help ticket notifications. Use /helpticket ignore to stop receiving notifications.": "Você não está ignorando notificações de pedidos de ajuda. Use /helptickets ignore para deixar de receber notificações.",
		"You will now receive help ticket notifications.": "Agora você receberá notificações de pedidos de ajuda.",
		"${target} does not have a ticket.": "${target} não tem um pedido de ajuda.",
		"You deleted ${target}'s ticket.": "Você deletou o pedido de ajuda de ${target}.",

		"Hi! All global staff members are busy right now and we apologize for the delay. ": "Olá! Todos os membros da administração estão ocupados no momento e nós pedimos desculpas pela demora.",
		"Please make sure you have given us the permission to check the PMs between you and the user you reported. You can also provide any relevant context; for example, a replay of a battle with the person you're reporting.": "Por favor, certifique-se de que você forneceu a permissão para verificar as PMs (Mensagens Privadas) entre você e o usuário reportado. Você também pode providenciar algo relevante para o caso; por exemplo, um replay da batalha na qual está a pessoa reportada.",
		'Please save the replay of the battle and provide a link to it in this chat, so we can see the harassment even if the battle expires. You can save the replay by clicking on the "Upload and share replay" button once the battle has ended.': 'Por favor, salve o replay da batalha e envie o link neste chat para que possamos ver o assédio, mesmo se a batalha tiver sido expirada. Você pode salvar o replay clicando no botão "Carregar e compartilhar replay" assim que a batalha terminar.',
		"Make sure you have provided the correct username, and if its meaning or why it is offensive is not obvious, please explain why it should not be allowed.": "Certifique-se de ter fornecido o nome de usuário correto e, se seu significado for ofensivo e não for óbvio, explique por que não deve ser permitido.",
		'Please save the replay of the battle and provide a link to it in this chat, so we can see the nicknames even if the battle expires. You can save the replay by clicking on the "Upload and share replay" button once the battle has ended.': 'Por favor, salve o replay da batalha e envie o link neste chat para que possamos ver os nomes dos usuários, mesmo se a batalha tiver sido expirada. Você pode salvar o replay clicando no botão "Carregar e compartilhar replay" assim que a batalha terminar.',
		"Please clearly explain why you should be unlocked and we will review it as soon as possible.": "Por favor, explique claramente por que você deve ser desbloqueado e nós o revisaremos o mais rápido possível.",
		"Please give us all relevant information on how you are connecting to Pokémon Showdown (if it is through mobile data, at home, a school or work network, etc), and we will review your case as soon as possible.": "Por favor, forneça todas as informações relevantes sobre como você está se conectando ao Pokémon Showdown (se for por meio de dados móveis, em casa, em uma rede escolar ou de trabalho etc.), e analisaremos seu caso o mais rápido possível.",
		"Please tell us which room you need assistance with and a global staff member will join your room as soon as possible.": "Por favor, diga-nos em qual sala você precisa de ajuda e um membro da administração vai até você o mais rápido possível.",
		"If your issue pertains to battle mechanics or is a question about Pokémon Showdown, you can ask in the <<help>> chatroom.": "Se o seu problema estiver relacionado à mecânica de batalha ou for uma pergunta sobre Pokémon Showdown, você pode perguntar na sala de bate-papo <<help>>.",
	},
};
