import type {Translations} from '../../server/chat';

export const translations: Translations = {
	strings: {
		"This command can only be used in the Trivia room.": "",
		"There is no game in progress.": "",
		"a cap of ${this.getCap()} points": "",
		"no score cap": "",
		"The currently running game is not Trivia, it's ${game.title}.": "",
		"Random (${ALL_CATEGORIES[questions[0].category]})": "",
		"You have already signed up for this game.": "",
		"You were kicked from the game and thus cannot join it again.": "",
		"You were kicked from the game and cannot join until the next game.": "",
		"This game does not allow latejoins.": "",
		"Enough players have returned to continue the game!": "",
		"The game will continue with the next question.": "",
		"Not enough players are participating to continue the game!": "",
		"Until there are ${MINIMUM_PLAYERS} players participating and present, the game will be paused.": "",
		"Signups for a new trivia game have begun!": "",
		"Signups for a new unranked trivia game have begun!": "",
		"Mode: ${this.game.mode} | Category: ${this.game.category} | Score cap: ${this.getCap() || \"Infinite\"}<br />": "",
		"Sign up for the Trivia game!": "",
		" (You can also type <code>/trivia join</code> to sign up manually.)": "",
		"Mode: ${this.game.mode} | Category: ${this.game.category} | Score cap: ${this.getCap() || \"Infinite\"}": "",
		"User ${tarUser.name} has already been kicked from the game.": "",
		"User ${tarUser.name} is not a player in the game.": "",
		"You are not a player in the current game.": "",
		"The game has already been started.": "",
		"The game will begin in ${START_TIMEOUT / 1000} seconds...": "",
		"The trivia game is already paused.": "",
		"You cannot pause the trivia game during a question.": "",
		"The Trivia game has been paused.": "",
		"The trivia game is not paused.": "",
		"The Trivia game has been resumed.": "",
		"No questions are left!": "",
		"The game has reached a stalemate": "",
		"Question${this.game.length === 'infinite' ? ": "",
		"Category: ${ALL_CATEGORIES[question.category]}": "",
		"The answering period has ended!": "",
		"You gained ${player.points} and answered ": "",
		"You answered": "",
		"${player.correctAnswers} questions correctly.": "",
		"${p1.name} won the game with a final score of <strong>${p1.player.points}</strong>": "",
		", and": "",
		"${initialPart}their leaderboard score has increased by <strong>${prizes[0]}</strong> points!": "",
		"${initialPart}their leaderboard score has increased by <strong>${prizes[0]}</strong> points! ": "",
		"${p2.name} was a runner-up and their leaderboard score has increased by <strong>${prizes[1]}</strong> points!": "",
		"${p2.name} and ${p3.name} were runners-up. ": "",
		"Their leaderboard score has increased by ${prizes[0]}, ${prizes[1]}, and ${prizes[2]}, respectively!": "",
		"User ${mapper(winner)} won the game of ": "",
		"unranked ": "",
		"ranked ": "",
		"${this.game.mode} mode trivia under the ${this.game.category} category with ": "",
		"with ${winner.player.points} points and ": "",
		"${winner.player.correctAnswers} correct answers": "",
		" Second place: ${mapper(winner)} (${winner.player.points} points)": "",
		", third place: ${mapper(winner)} (${winner.player.points} points)": "",
		"The game was forcibly ended by ${user.name}.": "",
		"You are not a player in the current trivia game.": "",
		"The trivia game is paused.": "",
		"There is no question to answer.": "",
		"You have already attempted to answer the current question.": "",
		"Correct: ${players}": "",
		"Answer(s): ${this.curAnswers.join(', ')}": "",
		"They gained <strong>5</strong> points!": "",
		"The top 5 players are: ${this.formatPlayerList({max: 5})}": "",
		"Correct: no one...": "",
		"Answers: ${this.curAnswers.join(', ')}": "",
		"Correct": "",
		"No one answered correctly...": "",
		"Each of them gained <strong>${points}</strong> point(s)!": "",
		"They gained <strong>${points}</strong> point(s)!": "",
		"Nobody gained any points.": "",
		"There is already a game of ${room.game.title} in progress.": "",
		"\"${mode}\" is an invalid mode.": "",
		"\"${category}\" is an invalid category.": "",
		"\"${length}\" is an invalid game length.": "",
		"There are not enough questions in the randomly chosen category to finish a trivia game.": "",
		"There are not enough questions in the trivia database to finish a trivia game.": "",
		"There are not enough questions under the category \"${ALL_CATEGORIES[category]}\" to finish a trivia game.": "",
		"You are now signed up for this game!": "",
		"The user \"${targetUsername}\" does not exist.": "",
		"You have left the current game of Trivia.": "",
		"No valid answer was entered.": "",
		"You have selected \"${answer}\" as your answer.": "",
		"Only Room Owners and higher can force a Trivia game to end with winners in a non-infinite length.": "",
		"${user.name} ended the game of Trivia!": "",
		"User ${target} does not exist.": "",
		"There is a paused trivia game": "",
		"There is a trivia game in progress": "",
		"and it is in its ${game.phase} phase.": "",
		"Mode: ${game.game.mode} | Category: ${game.game.category} | Score cap: ${game.getCap() || \"Infinite\"}": "",
		"Current score: ${player.points} | Correct Answers: ${player.correctAnswers}": "",
		"User ${tarUser.name} is not a player in the current trivia game.": "",
		"Players: ${game.formatPlayerList({max: null, requirePoints: false})}": "",
		"This command can only be used in Question Workshop.": "",
		"Invalid arguments specified in \"${param}\". View /trivia help for more information.": "",
		"${param[0].trim()}' is not a valid category. View /trivia help for more information.": "",
		"You cannot submit questions in the '${ALL_CATEGORIES[category]}' category": "",
		"${param[1].trim()}' is not a valid question.": "",
		"Question \"${param[1].trim()}\" is too long! It must remain under ${MAX_QUESTION_LENGTH} characters.": "",
		"Question \"${question}\" is already in the trivia database.": "",
		"No valid answers were specified for question '${param[1].trim()}'.": "",
		"Some of the answers entered for question '${param[1].trim()}' were too long!": "",
		"They must remain under ${MAX_ANSWER_LENGTH} characters.": "",
		"No questions await review.": "",
		"Category": "",
		"Question": "",
		"Answer(s)": "",
		"Submitted By": "",
		"${target}' is not a valid set of submission index numbers.": "",
		"View /trivia review and /trivia help for more information.": "",
		"${target}' is an invalid argument. View /trivia help questions for more information.": "",
		"${target}' is not a valid argument. View /trivia help questions for more information.": "",
		"${user.name} removed question '${target}' from the question database.": "",
		"Question '${target}' was not found in the question database.": "",
		"${param[1].trim()}' is already in the category '${param[0].trim()}'.": "",
		"${user.name} changed question category to '${param[0]}' for '${param[1].trim()}' ": "",
		"from the question database.": "",
		"No questions have been submitted yet.": "",
		"Question Count": "",
		"Total": "",
		"${target}' is not a valid category. View /help trivia for more information.": "",
		"There are no questions in the ${ALL_CATEGORIES[target]} category.": "",
		"There are <strong>${list.length}</strong> questions in the ${cat} category.": "",
		"No valid search arguments entered.": "",
		"No valid search category was entered. Valid categories: submissions, subs, questions, qs": "",
		"No valid search query as entered.": "",
		"No results found under the ${type} list.": "",
		"There are <strong>${results.length}</strong> matches for your query:=": "",
		"This command can only be used in Trivia.": "",
		"User '${name}' has not played any trivia games yet.": "",
		"all time:": "",
		"User: <strong>${name}</strong>": "",
		"Leaderboard score: ${row(0)}": "",
		"Total game points: ${row(1)}": "",
		"Total correct answers: ${row(2)}": "",
		"No trivia games have been played yet.": "",
		"Rank": "",
		"User": "",
		"Leaderboard score": "",
		"Total game points": "",
		"Total correct answers": "",
		"This command can only be used in Question Workshop": "",
		"${user.name} removed all questions of category '${category}'.": "",
		"You cannot clear the category '${ALL_CATEGORIES[category]}'.": "",
		"${category}' is an invalid category.": "",
		"There is no game history.": "",
		"${game.mode} mode, ${game.length} length Trivia game in the ${game.category} category": "",
		"hosted by ${game.creator}": "",
		"Infinite": "",
		"Signups for a new Mastermind game have begun!": "",
		"The currently running game is not Mastermind, it's ${game.title}.": "",
		"The top <strong>${this.numFinalists}</strong> players will advance to the finals!": "",
		"Type <code>/mastermind join</code> to sign up for the game.": "",
		"There is already a round of Mastermind in progress.": "",
		"That user is not signed up for Mastermind!": "",
		"The user \"${playerID}\" has already played their round of Mastermind.": "",
		"You cannot start the game of Mastermind until there are more players than finals slots.": "",
		"The round of Mastermind has ended!": "",
		"${player} earned ${points} points!": "",
		"You cannot start finals until the user '${player}' has played a round.": "",
		"There are no questions in the Trivia database.": "",
		"No one scored any points, so it's a tie!": "",
		"${winnerName} won the game of Mastermind with ${winner.player.points} points!": "",
		"${secondPlace} and ${thirdPlace} were runners-up with ${second.player.points} and ${third.player.points} points, respectively.": "",
		"${secondPlace} was a runner up with ${second.player.points} points.": "",
		"The game of Mastermind was forcibly ended by ${user.name}.": "",
		"A Mastermind round in the ${this.game.category} category for ${player} is starting!": "",
		"The Mastermind finals are starting!": "",
		"You cannot pass in the finals.": "",
		"You must specify a number that is at least 2 for finalists.": "",
		"${category} is not a valid category.": "",
		"You must specify a round length of at least 1 second.": "",
		"There are no questions in the ${categoryName} category.": "",
		"You must specify a length of at least 1 second.": "",
		"No round of Mastermind is currently being played.": "",
		"You are not a player in the current round of Mastermind.": "",
		"There is a Mastermind game in progress, and it is in its ${game.phase} phase.": "",
		"Players": "",
		"Kicking ${user.name} would leave this game of Mastermind without enough players to reach ${this.numFinalists} finalists.": "",
	},
};
