import type {Translations} from '../../server/chat';

export const translations: Translations = {
	strings: {
		"Hello! The global staff team would be happy to help you, but you need to explain what's going on first.": "Hallo! Het globale personeel zou je graag willen helpen, maar je moet wel eerst uitleggen wat er aan de hand is.",
		"Please post the information I requested above so a global staff member can come to help.": "Deel de informatie die ik hierboven heb opgevraagd, zodat een globaal personeelslid kan komen helpen",
		"Thank you for the information, global staff will be here shortly. Please stay in the room.": "Bedankt voor de informatie, een globaal personeelslid zal hier binnenkort komen. Blijf alsjeblieft in de kamer.",
		"You are banned from creating tickets": "Je bent verbannen van het maken van help tickets",
		", because you have the same IP as ${ticket.banned}.": ", omdat je hetzelfde IP hebt als $(ticket.banned}.",
		"Request help from global staff": "Vraag hulp van globaal personeel",
		'Please <button name="login" class="button">Log In</button> to request help.': '<button name="login" class="button">Log alsjeblieft in</button> om hulp te vragen.',
		"Request Help": "Vraag Hulp",
		"You already have a Help ticket.": "Je hebt al een Help Ticket.",
		"Back": "Terug",
		"What's going on?": "Wat is er aan de hand?",
		"Global staff cannot make Help requests. This form is only for reference.": "Globale personeelsleden kunnen geen Hulpverzoeken maken. Dit formulier is enkel bestemd als referentie",
		"Abuse of Help requests can result in punishments.": "Misbruik van Hulpverzoeken kan resulteren in bestraffing.",
		"What do you want to report someone for?": "Waar wil je iemand voor rapporteren?",
		"If someone is harassing you in private messages (PMs), click the button below and a global staff member will take a look. If you are being harassed in a chatroom, please ask a room staff member to handle it. If it's a minor issue, consider using <code>/ignore [username]</code> instead.": "Als iemand je lastigvalt in privé berichten (PM), klik dan de knop hieronder en een globaal personeelslid zal een kijkje nemen. Als je lastiggevallen word in een chatkamer, vraag dan alsjeblieft het kamer personeel om het af te handelen. Als het een klein probleem is, overweeg dan om <code>/ignore [gebruikersnaam]</code> te gebruiken.",
		"If someone is harassing you in a battle, click the button below and a global staff member will take a look. If you are being harassed in a chatroom, please ask a room staff member to handle it. If it's a minor issue, consider using <code>/ignore [username]</code> instead.": "Als iemand je lastigvalt in een gevecht, klik dan de knop hieronder en een globaal personeelslid zal een kijkje nemen. Als je lastiggevallen word in een chatkamer, vraag dan alsjeblieft het kamer personeel om het af te handelen. Als het een klein probleem is, overweeg <code>/ignore [gebruikersnaam]</code> te gebruiken.",
		"Please save a replay of the battle if it has ended, or provide a link to the battle if it is still ongoing.": "Sla alsjeblieft de replay van het gevecht op als het gevecht voorbij is, of verstrek een link van het gevecht als deze nog gaande is.",
		"If a user has an inappropriate name, click the button below and a global staff member will take a look.": "Als een gebruiker een ongepaste naam heeft, klik dan op de knop hieronder en een globaal personeelslid zal een kijkje nemen.",
		"If a user has inappropriate Pokemon nicknames, click the button below and a global staff member will take a look.": "Als een gebruiker ongepaste Pokemon bijnamen heeft, klik dan op de knop hieronder en een globaal personeelslid zal een kijkje nemen.",
		"What would you like to appeal?": "Waar wil je bezwaar tegen indienen?",
		"Permalocks are usually for repeated incidents of poor behavior over an extended period of time, and rarely for a single severe infraction. Please keep this in mind when appealing a permalock.": "Permalocks zijn meestal voor herhaalde incidenten van slecht gedrag over een langere periode, en zelden voor een enkele zware overtreding. Houd hier rekening mee bij het in bezwaar gaan tegen een permalock.",
		'Please visit the <a href="https://www.smogon.com/forums/threads/discipline-appeal-rules.3583479/">Discipline Appeals</a> page to appeal your permalock.': 'Bezoek alsjeblieft de <a href="https://www.smogon.com/forums/threads/discipline-appeal-rules.3583479/">Discipline Bezwaren</a> pagina om in bezwaar te gaan tegen jouw permalock.',
		"If you want to appeal your lock or namelock, click the button below and a global staff member will be with you shortly.": "Als je in bezwaar wil gaan tegen je lock of naamlock, click dan op de knop hieronder en een globaal personeelslid zijn snel bij je zijn.",
		"If you are locked or namelocked under a name you don't recognize, click the button below to call a global staff member so we can check.": "Als je bent gelocked of genaamlocked onder een naam die je niet bekent voor komt, klik dan op knop hieronder om een globaal personeelslid op te roepen zodat we het kunnen uitzoeken.",
		"We automatically lock proxies and VPNs to prevent evasion of punishments and other attacks on our server. To get unlocked, you need to disable your proxy or VPN.": "We locken proxies en VPNs automatisch om te voorkomen dat bestraffingen kunnen worden ontdoken en andere aanvallen op onze server tegen te gaan. Om te worden unlocked, moet je, je proxy of VPN uitschakelen.",
		"Do you have an autoconfirmed account? An account is autoconfirmed when it has won at least one rated battle and has been registered for one week or longer.": "Heb je een account dat autoconfirmed is? Een account is autoconfirmed wanneer het op zijn minst één rated gevecht heeft gewonnen en één week of langer is geregistreerd.",
		"Login to your autoconfirmed account by using the <code>/nick</code> command in any chatroom, and the semilock will automatically be removed. Afterwords, you can use the <code>/nick</code> command to switch back to your current username without being semilocked again.": "Log in op je autoconfirmed account doormiddel van <code>/nick</code> in een chatkamer, en de semilock zal automatisch worden verwijderd. Daarna kan je het commando <code>/nick</code> gebruiken om terug naar je huidige gebruikersnaam te gaan zonder opnieuw gesemilocked te worden.",
		"If the semilock does not go away, you can try asking a global staff member for help. Click the button below to call a global staff member.": "Als de semilock niet verdwijnt, kan je proberen een globaal personeelslid om hulp te vragen. Klik op de knop hieronder om een globaal personeelslid op te roepen.",
		"If you don't have an autoconfirmed account, you will need to contact a global staff member to appeal your semilock. Click the button below to call a global staff member.": "Als je geen autoconfirmed account bezit, zal je een globaal personeelslid moeten contacteren om tegen je semilock in bezwaar te gaan. Klik op de knop hieronder om een globaal personeelslid op te roepen.",
		"Please PM the staff member who punished you. If you don't know who punished you, ask another room staff member; they will redirect you to the correct user. If you are banned or blacklisted from the room, use <code>/roomauth [name of room]</code> to get a list of room staff members. Bold names are online.": "PM alsjeblieft het personeelslid die jou bestraft heeft. Als je niet weet wie jou bestraft heeft, vraag dan een ander personeelslid; die zullen je naar de juiste gebruiker verwijzen. Als je bent verbannen of bent geblacklist van de kamer, gebruik dan <code>/roomauth [naam van de kamer]</code> om een lijst te zien van alle personeelsleden van de kamer. Dikgedrukte namen zijn online.",
		"Do not PM staff if you are locked (signified by the symbol <code>‽</code> in front of your username). Locks are a different type of punishment; to appeal a lock, make a help ticket by clicking the Back button and then selecting the most relevant option.": "PM geen personeelslid als je bent gelocked (aangeduid door het teken <code>‽</code> vóór je gebruikersnaam). Locks zijn een ander soort bestraffing; om tegen een lock in bezwaar te gaan, maak dan een help ticket door op de Terug knop te klikken en de meest accurate optie te kiezen.",
		"Maybe one of these options will be helpful?": "Misschien is één van deze opties nuttig?",
		"If you lost your password, click the button below to request a password reset. We will need to clarify a few pieces of information before resetting the account. Please note that password resets are low priority and may take a while; we recommend using a new account while waiting.": "Als je, je wachtwoord bent vergeten, klik dan op de knop hieronder om een wachtwoord reset aan te vragen. We zullen enkele gegevens moeten vaststellen voordat we het account kunnen resetten. Houd er rekening mee dat wachtwoord resets een lage prioriteit hebben en dus een tijdje kunnen duren; we raden je aan een nieuw account te gebruiken terwijl je wacht.",
		"Request a password reset": "Vraag een wachtwoord reset aan",
		"If you are a room driver or up in a public room, and you need help watching the chat, one or more global staff members would be happy to assist you!": "Als je een kamer driver of hoger bent in een publieke kamer, en je hebt hulp nodig met de chat in de gaten houden, één of meerdere personeelsleden zullen je graag assisteren!",
		"If your issue is not handled above, click the button below to talk to a global staff member. Please be ready to explain the situation.": "Als je probleem niet hierboven is vermeld, klik dan de knop hieronder om met een globaal personeelslid te praten. Wees gereed om de situatie uit te leggen.",
		"Malformed help request.": "Incorrecte hulpaanvraag.",
		"PM Harassment": "PM Intimidatie",
		"Battle Harassment": "Gevecht Intimidatie",
		"Inappropriate Username": "Ongepaste Gebruikersnaam",
		"Inappropriate Pokemon Nicknames": "Ongepaste Pokemon Bijnamen",
		"Appeal": "Ga in bezwaar",
		"IP-Appeal": "IP-Bezwaar",
		"ISP-Appeal": "ISP-Bezwaar",
		"Public Room Assistance Request": "Publieke Kamer Assistentie Aanvraag",
		"Other": "Anders",
		"I want to report someone": "Ik wil iemand rapporteren",
		"Someone is harassing me in PMs": "Iemand valt mij lastig in PMs",
		"Someone is harassing me in a battle": "Iemand valt mij lastig in een gevecht",
		"Someone is using an offensive username": "Iemand gebruikt een beledigende gebruikersnaam",
		"Someone is using offensive Pokemon nicknames": "Iemand gebruikt beledigende Pokemon bijnamen",
		"I want to appeal a punishment": "Ik wil in bezwaar gaan tegen een bestraffing",
		"I want to appeal my permalock": "Ik wil in bezwaar gaan tegen mijn permalock",
		"I want to appeal my lock": "Ik wil in bezwaar gaan tegen mijn lock",
		"I'm locked because I have the same IP as someone I don't recognize": "Ik ben gelocked omdat ik hetzelfde IP heb als iemand die ik niet herken.",
		"I can't talk in chat because of my ISP": "Ik kan niet in chats praten vanwege mijn ISP",
		"I'm locked because of a proxy or VPN": "Ik ben gelocked vanwege een proxy of VPN",
		"Yes, I have an autoconfirmed account": "Ja, ik heb een autoconfirmed account",
		"No, I don't have an autoconfirmed account": "Nee, ik heb geen autoconfirmed account",
		"I want to appeal a mute/roomban/blacklist": "",
		"Something else": "Iets anders",
		"I lost my password": "Ik ben mijn wachtwoord vergeten",
		"I need global staff to help watch a public room": "Ik heb een globaal personeelslid nodig om een publieke kamer in de gaten te houden",
		"Report harassment in a private message (PM)": "Rapporteer intimidatie in een privé bericht (PM)",
		"Report harassment in a battle": "Rapporteer intimidatie in een gevecht",
		"Report an inappropriate username": "Rapporteer een ongepaste gebruikersnaam",
		"Report inappropriate Pokemon nicknames": "Rapporteer ongepaste Pokemon bijnamen",
		"Appeal your lock": "Ga in bezwaar tegen je lock",
		"Appeal IP lock": "Ga in bezwaar tegen een IP lock",
		"Appeal ISP lock": "Ga in bezwaar tegen en ISP lock",
		"Call a Global Staff member to help": "Roep een global personeelslid op voor hulp",
		"Call a Global Staff member": "Roep een globaal personeelslid",
		"Are you sure you want to submit a ticket for ${type}?": "Weet je zeker dat je een ticket wil indienen voor ${type}?",
		"Yes, contact global staff": "Ja, contacteer een global personeelslid",
		"No, cancel": "Nee, annuleren",
		"Help Ticket Stats": "Hulp Ticket Statistieken",
		"Help tickets": "Hulp tickets",
		"Status": "Status",
		"Creator": "Maker",
		"Ticket Type": "Ticket Soort",
		"Language": "",
		"Claimed by": "Geclaimed door",
		"Action": "Actie",
		"And ${keys.length - count} more tickets.": "En ${keys.length - count} more tickets.",
		"View all tickets": "Bekijk alle tickets",
		"Closed": "Gesloten",
		"Inactive": "Inactief",
		"Claimed": "Geclaimd",
		"Unclaimed": "Ongeclaimd",
		"Claim": "Claim",
		"View": "Bekijk",
		"Log": "Log",
		"Banned by": "Verbannen door",
		"Username": "Gebruikersnaam",
		"Expires": "Verloopt",
		"Logs": "Logs",
		"And ${banKeys.length - count} more ticket bans.": "",
		"Ticket List": "Ticket Lijst",
		"Banned": "Verbannen",
		"Ticket Stats": "Ticket Statistieken",
		"No ticket stats found.": "Geen ticket statistieken gevonden.",
		"Previous Month": "Vorige Maand",
		"Staff Stats": "Personeel Statistieken",
		"Next Month": "Volgende Maand",
		"Resolved": "Opgelost",
		"Unresolved": "Onopgelost",
		"Dead": "Dood",
		"Type": "Soort",
		"Total Tickets": "Totaal Aantal Tickets",
		"Average Total Time": "Gemiddelde Totale Tijd",
		"Average Initial Wait": "Gemiddelde Aanvankelijke Wachttijd",
		"Average Total Wait": "Gemiddelde Totale Wachttijd",
		"Resolutions": "Oplossingen",
		"Positive Result": "Positief Resultaat",
		"Staff ID": "Personeel ID",
		"Number of Tickets": "Aantal Tickets",
		"Average Time Per Ticket": "Gemiddelde Tijd Per Ticket",
		"This command cannot be broadcast in battles.": "Dit commando kan niet worden omgeroepen in gevechten.",
		"Report someone": "Rapporteer iemand",
		"Appeal a punishment": "",
		"Request help": "Vraag hulp",
		"You need to choose a username before doing this. [TN: 'this' refers to opening a help ticket]": "Je moet een gebruikersnaam kiezen voordat je dit doet.",
		"Global staff can't make tickets. They can only use the form for reference.": "Globale personeelsleden kunnen geen tickets maken. Ze kunnen enkel dit formulier als referentie gebruiken.",
		"You already have an open ticket; please wait for global staff to respond.": "Je hebt al een openstaande ticket, wacht alsjeblieft tot een global personeelslid reageert.",
		"Due to high load, you are limited to creating ${maxTickets} tickets every hour.": "Door overvloed ben je gelimiteerd tot het maken van ${maxTickets} per uur.",
		"Hi! Who was harassing you in private messages?": "Hoi! Wie viel jou lastig in prive berichten?",
		"Hi! Who was harassing you, and in which battle did it happen? Please post a link to the battle or a replay of the battle.": "Hoi! Wie viel jou lastig, en ik welk gevecht gebeurde dat? Deel alsjeblieft de link van het gevecht of de replay van het gevecht.",
		"Hi! Tell us the username that is inappropriate.": "Hoi! Vertel ons de naam die ongepast is.",
		"Hi! Which user has Pokemon with inappropriate nicknames, and in which battle? Please post a link to the battle or a replay of the battle.": "Hoi! Welke gebruiker heeft ongepaste Pokemon bijnamen, en in welk gevecht? Deel alsjeblieft de link van het gevecht of de replay van het gevecht.",
		"Hi! Can you please explain why you feel your punishment is undeserved?": "Hoi! Kan je alsjeblieft uitleggen waarom jij denkt dat je bestraffing niet verdient is?",
		"Hi! How are you connecting to Showdown right now? At home, at school, on a phone using mobile data, or some other way?": "Hoi! Hoe ben je nu met Showdown verbonden? Thuis, op school, via telefoon met mobiele data, of op een andere manier?",
		"Hi! Which room(s) do you need us to help you watch?": "Hoi! Welke kamer(s) wil je dat wij in de gaten houden?",
		"Hi! What seems to be the problem? Tell us about any people involved,\n and if this happened in a specific place on the site.": "Hoi! Wat is het probleem? Vertel ons over welke personen zijn betrokken,\n en of dit plaats vond in een specieke plek op de website.",
		"Hi! Please click the button below to give global staff permission to check PMs.": "Hoi! Klik alsjeblieft op de knop hieronder om globale personeelsleden toestemmingen to geven om PMs in te zien.",
		" Or if ${reportTarget} is not the user you want to report, please tell us the name of the user who you want to report.": "Of als ${reportTarget} niet de gebruiker is die je wilde rapporteren, zeg ons dan alsjeblieft de naam van de gebruiker die je wel wilde rapporteren.",
		"Help Ticket": "Hulp Ticket",
		"Issue": "Probleem",
		"A Global Staff member will be with you shortly.": "Een Globaal Personeelslid zal snel bij je zijn.",
		"${inputUsername} does not have an open ticket.": "${inputUsername} heeft geen openstaande ticket.",
		"You closed ${ticket.creator}'s ticket.": "Je hebt ${ticket.creator}'s gesloten.",
		"The reason is too long. It cannot exceed 300 characters.": "De reden is te lang. Het mag niet de 300 karakters limiet overschreiden.",
		"User '${this.targetUsername}' not found.": "Gebruiker '${this.targetUsername}' is niet gevonden.",
		"${targetUser ? targetUser.name : target} is not ticket banned.": "${targetUser ? targetUser.name : target} is niet verbannen van tickets.",
		"${targetUser ? targetUser.name : target}'s ticket ban is already expired.": "${targetUser ? targetUser.name : target} ticket verbanning is al verlopen.",
		"You are already ignoring help ticket notifications. Use /helpticket unignore to receive notifications again.": "Je negeert hulp ticket notificaties al. Gebruik /helpticket unignore om wederom notificaties te ontvangen.",
		"You are now ignoring help ticket notifications.": "Je negeert nu hulp ticket notificaties.",
		"You are not ignoring help ticket notifications. Use /helpticket ignore to stop receiving notifications.": "Je negeert hulp ticket notificaties niet. Gebruik /helpticket ignore om te voorkomen dat je notificaties ontvangt.",
		"You will now receive help ticket notifications.": "Je zal nu wederom help ticket notificaties ontvangen.",
		"${target} does not have a ticket.": "${target} heeft geen ticket",
		"You deleted ${target}'s ticket.": "Je hebt ${target}'s ticket verwijderd.",

		"Hi! All global staff members are busy right now and we apologize for the delay. ": "",
		"Please make sure you have given us the permission to check the PMs between you and the user you reported. You can also provide any relevant context; for example, a replay of a battle with the person you're reporting.": "",
		'Please save the replay of the battle and provide a link to it in this chat, so we can see the harassment even if the battle expires. You can save the replay by clicking on the "Upload and share replay" button once the battle has ended.': "",
		"Make sure you have provided the correct username, and if its meaning or why it is offensive is not obvious, please explain why it should not be allowed.": "",
		'Please save the replay of the battle and provide a link to it in this chat, so we can see the nicknames even if the battle expires. You can save the replay by clicking on the "Upload and share replay" button once the battle has ended.': "",
		"Please clearly explain why you should be unlocked and we will review it as soon as possible.": "",
		"Please give us all relevant information on how you are connecting to Pokémon Showdown (if it is through mobile data, at home, a school or work network, etc), and we will review your case as soon as possible.": "",
		"Please tell us which room you need assistance with and a global staff member will join your room as soon as possible.": "",
		"If your issue pertains to battle mechanics or is a question about Pokémon Showdown, you can ask in the <<help>> chatroom.": "",
	},
};
