export const ItemsText: {[id: IDEntry]: ItemText} = {
	abilityshield: {
		name: "Ability Shield",
		shortDesc: "Holder's Ability cannot be changed, suppressed, or ignored by any effect.",

		block: "  [POKEMON]'s Ability is protected by the effects of its Ability Shield!",
	},
	abomasite: {
		name: "Abomasite",
		shortDesc: "If held by an Abomasnow, this item allows it to Mega Evolve in battle.",
	},
	absolite: {
		name: "Absolite",
		shortDesc: "If held by an Absol, this item allows it to Mega Evolve in battle.",
	},
	absorbbulb: {
		name: "Absorb Bulb",
		shortDesc: "Raises holder's Sp. Atk by 1 stage if hit by a Water-type attack. Single use.",
	},
	adamantcrystal: {
		name: "Adamant Crystal",
		shortDesc: "If held by a Dialga, its Steel- and Dragon-type attacks have 1.2x power.",
	},
	adamantorb: {
		name: "Adamant Orb",
		shortDesc: "If held by a Dialga, its Steel- and Dragon-type attacks have 1.2x power.",
	},
	adrenalineorb: {
		name: "Adrenaline Orb",
		shortDesc: "Raises holder's Speed by 1 stage if it gets affected by Intimidate. Single use.",
	},
	aerodactylite: {
		name: "Aerodactylite",
		shortDesc: "If held by an Aerodactyl, this item allows it to Mega Evolve in battle.",
	},
	aggronite: {
		name: "Aggronite",
		shortDesc: "If held by an Aggron, this item allows it to Mega Evolve in battle.",
	},
	aguavberry: {
		name: "Aguav Berry",
		shortDesc: "Restores 1/3 max HP at 1/4 max HP or less; confuses if -SpD Nature. Single use.",
		gen7: {
			shortDesc: "Restores 1/2 max HP at 1/4 max HP or less; confuses if -SpD Nature. Single use.",
		},
		gen6: {
			shortDesc: "Restores 1/8 max HP at 1/2 max HP or less; confuses if -SpD Nature. Single use.",
		},
	},
	airballoon: {
		name: "Air Balloon",
		shortDesc: "Holder is immune to Ground-type attacks. Pops when holder is hit.",

		start: "  [POKEMON] floats in the air with its Air Balloon!",
		end: "  [POKEMON]'s Air Balloon popped!",
	},
	alakazite: {
		name: "Alakazite",
		shortDesc: "If held by an Alakazam, this item allows it to Mega Evolve in battle.",
	},
	aloraichiumz: {
		name: "Aloraichium Z",
		shortDesc: "If held by an Alolan Raichu with Thunderbolt, it can use Stoked Sparksurfer.",
	},
	altarianite: {
		name: "Altarianite",
		shortDesc: "If held by an Altaria, this item allows it to Mega Evolve in battle.",
	},
	ampharosite: {
		name: "Ampharosite",
		shortDesc: "If held by an Ampharos, this item allows it to Mega Evolve in battle.",
	},
	apicotberry: {
		name: "Apicot Berry",
		shortDesc: "Raises holder's Sp. Def by 1 stage when at 1/4 max HP or less. Single use.",
	},
	armorfossil: {
		name: "Armor Fossil",
		shortDesc: "Can be revived into Shieldon.",
	},
	aspearberry: {
		name: "Aspear Berry",
		shortDesc: "Holder is cured if it is frozen. Single use.",
	},
	assaultvest: {
		name: "Assault Vest",
		shortDesc: "Holder's Sp. Def is 1.5x, but it can only select damaging moves.",
	},
	audinite: {
		name: "Audinite",
		shortDesc: "If held by an Audino, this item allows it to Mega Evolve in battle.",
	},
	auspiciousarmor: {
		name: "Auspicious Armor",
		shortDesc: "Evolves Charcadet into Armarouge when used.",
	},
	babiriberry: {
		name: "Babiri Berry",
		shortDesc: "Halves damage taken from a supereffective Steel-type attack. Single use.",
	},
	banettite: {
		name: "Banettite",
		shortDesc: "If held by a Banette, this item allows it to Mega Evolve in battle.",
	},
	beastball: {
		name: "Beast Ball",
		shortDesc: "A special Poke Ball designed to catch Ultra Beasts.",
	},
	beedrillite: {
		name: "Beedrillite",
		shortDesc: "If held by a Beedrill, this item allows it to Mega Evolve in battle.",
	},
	belueberry: {
		name: "Belue Berry",
		shortDesc: "Cannot be eaten by the holder. No effect when eaten with Bug Bite or Pluck.",
	},
	berryjuice: {
		name: "Berry Juice",
		shortDesc: "Restores 20 HP when at 1/2 max HP or less. Single use.",
	},
	berrysweet: {
		name: "Berry Sweet",
		shortDesc: "Evolves Milcery into Alcremie when held and spun around.",
	},
	bignugget: {
		name: "Big Nugget",
		shortDesc: "A big nugget of pure gold that gives off a lustrous gleam.",
	},
	bigroot: {
		name: "Big Root",
		shortDesc: "Holder gains 1.3x HP from draining/Aqua Ring/Ingrain/Leech Seed/Strength Sap.",
		gen6: {
			shortDesc: "Holder gains 1.3x HP from draining moves, Aqua Ring, Ingrain, and Leech Seed.",
		},
	},
	bindingband: {
		name: "Binding Band",
		shortDesc: "Holder's partial-trapping moves deal 1/6 max HP per turn instead of 1/8.",
	},
	blackbelt: {
		name: "Black Belt",
		shortDesc: "Holder's Fighting-type attacks have 1.2x power.",
		gen3: {
			shortDesc: "Holder's Fighting-type attacks have 1.1x power.",
		},
	},
	blacksludge: {
		name: "Black Sludge",
		shortDesc: "Each turn, if holder is a Poison type, restores 1/16 max HP; loses 1/8 if not.",

		heal: "  [POKEMON] restored a little HP using its Black Sludge!",
	},
	blackglasses: {
		name: "Black Glasses",
		shortDesc: "Holder's Dark-type attacks have 1.2x power.",
		gen3: {
			shortDesc: "Holder's Dark-type attacks have 1.1x power.",
		},
	},
	blastoisinite: {
		name: "Blastoisinite",
		shortDesc: "If held by a Blastoise, this item allows it to Mega Evolve in battle.",
	},
	blazikenite: {
		name: "Blazikenite",
		shortDesc: "If held by a Blaziken, this item allows it to Mega Evolve in battle.",
	},
	blueorb: {
		name: "Blue Orb",
		shortDesc: "If held by a Kyogre, this item triggers its Primal Reversion in battle.",
	},
	blukberry: {
		name: "Bluk Berry",
		shortDesc: "Cannot be eaten by the holder. No effect when eaten with Bug Bite or Pluck.",
	},
	blunderpolicy: {
		name: "Blunder Policy",
		shortDesc: "If the holder misses due to accuracy, its Speed is raised by 2 stages. Single use.",
	},
	boosterenergy: {
		name: "Booster Energy",
		shortDesc: "Activates the Protosynthesis or Quark Drive Abilities. Single use.",
	},
	bottlecap: {
		name: "Bottle Cap",
		shortDesc: "Used for Hyper Training. One of a Pokemon's stats is calculated with an IV of 31.",
	},
	brightpowder: {
		name: "Bright Powder",
		shortDesc: "The accuracy of attacks against the holder is 0.9x.",
		gen2: {
			shortDesc: "An attack against the holder has its accuracy out of 255 lowered by 20.",
		},
	},
	buggem: {
		name: "Bug Gem",
		shortDesc: "Holder's first successful Bug-type attack will have 1.3x power. Single use.",
		gen5: {
			shortDesc: "Holder's first successful Bug-type attack will have 1.5x power. Single use.",
		},
	},
	bugmemory: {
		name: "Bug Memory",
		shortDesc: "Holder's Multi-Attack is Bug type.",
	},
	buginiumz: {
		name: "Buginium Z",
		shortDesc: "If holder has a Bug move, this item allows it to use a Bug Z-Move.",
	},
	burndrive: {
		name: "Burn Drive",
		shortDesc: "Holder's Techno Blast is Fire type.",
	},
	cameruptite: {
		name: "Cameruptite",
		shortDesc: "If held by a Camerupt, this item allows it to Mega Evolve in battle.",
	},
	cellbattery: {
		name: "Cell Battery",
		shortDesc: "Raises holder's Attack by 1 if hit by an Electric-type attack. Single use.",
	},
	charcoal: {
		name: "Charcoal",
		shortDesc: "Holder's Fire-type attacks have 1.2x power.",
		gen3: {
			shortDesc: "Holder's Fire-type attacks have 1.1x power.",
		},
	},
	charizarditex: {
		name: "Charizardite X",
		shortDesc: "If held by a Charizard, this item allows it to Mega Evolve in battle.",
	},
	charizarditey: {
		name: "Charizardite Y",
		shortDesc: "If held by a Charizard, this item allows it to Mega Evolve in battle.",
	},
	chartiberry: {
		name: "Charti Berry",
		shortDesc: "Halves damage taken from a supereffective Rock-type attack. Single use.",
	},
	cheriberry: {
		name: "Cheri Berry",
		shortDesc: "Holder cures itself if it is paralyzed. Single use.",
	},
	cherishball: {
		name: "Cherish Ball",
		shortDesc: "A rare Poke Ball that has been crafted to commemorate an occasion.",
	},
	chestoberry: {
		name: "Chesto Berry",
		shortDesc: "Holder wakes up if it is asleep. Single use.",
	},
	chilanberry: {
		name: "Chilan Berry",
		shortDesc: "Halves damage taken from a Normal-type attack. Single use.",
	},
	chilldrive: {
		name: "Chill Drive",
		shortDesc: "Holder's Techno Blast is Ice type.",
	},
	chippedpot: {
		name: "Chipped Pot",
		shortDesc: "Evolves Sinistea-Antique into Polteageist-Antique when used.",
	},
	choiceband: {
		name: "Choice Band",
		shortDesc: "Holder's Attack is 1.5x, but it can only select the first move it executes.",
	},
	choicescarf: {
		name: "Choice Scarf",
		shortDesc: "Holder's Speed is 1.5x, but it can only select the first move it executes.",
	},
	choicespecs: {
		name: "Choice Specs",
		shortDesc: "Holder's Sp. Atk is 1.5x, but it can only select the first move it executes.",
	},
	chopleberry: {
		name: "Chople Berry",
		shortDesc: "Halves damage taken from a supereffective Fighting-type attack. Single use.",
	},
	clawfossil: {
		name: "Claw Fossil",
		shortDesc: "Can be revived into Anorith.",
	},
	clearamulet: {
		name: "Clear Amulet",
		shortDesc: "Prevents other Pokemon from lowering the holder's stat stages.",

		block: "  The effects of [POKEMON]'s Clear Amulet prevent its stats from being lowered!",
	},
	cloversweet: {
		name: "Clover Sweet",
		shortDesc: "Evolves Milcery into Alcremie when held and spun around.",
	},
	cobaberry: {
		name: "Coba Berry",
		shortDesc: "Halves damage taken from a supereffective Flying-type attack. Single use.",
	},
	colburberry: {
		name: "Colbur Berry",
		shortDesc: "Halves damage taken from a supereffective Dark-type attack. Single use.",
	},
	cornerstonemask: {
		name: "Cornerstone Mask",
		shortDesc: "Ogerpon-Cornerstone: 1.2x power attacks; Terastallize to gain Embody Aspect.",
	},
	cornnberry: {
		name: "Cornn Berry",
		shortDesc: "Cannot be eaten by the holder. No effect when eaten with Bug Bite or Pluck.",
	},
	coverfossil: {
		name: "Cover Fossil",
		shortDesc: "Can be revived into Tirtouga.",
	},
	covertcloak: {
		name: "Covert Cloak",
		shortDesc: "Holder is not affected by the secondary effect of another Pokemon's attack.",
	},
	crackedpot: {
		name: "Cracked Pot",
		shortDesc: "Evolves Sinistea into Polteageist when used.",
	},
	custapberry: {
		name: "Custap Berry",
		shortDesc: "Holder moves first in its priority bracket when at 1/4 max HP or less. Single use.",

		activate: "  [POKEMON] can act faster than normal, thanks to its Custap Berry!",
	},
	damprock: {
		name: "Damp Rock",
		shortDesc: "Holder's use of Rain Dance lasts 8 turns instead of 5.",
	},
	darkgem: {
		name: "Dark Gem",
		shortDesc: "Holder's first successful Dark-type attack will have 1.3x power. Single use.",
		gen5: {
			shortDesc: "Holder's first successful Dark-type attack will have 1.5x power. Single use.",
		},
	},
	darkmemory: {
		name: "Dark Memory",
		shortDesc: "Holder's Multi-Attack is Dark type.",
	},
	darkiniumz: {
		name: "Darkinium Z",
		shortDesc: "If holder has a Dark move, this item allows it to use a Dark Z-Move.",
	},
	dawnstone: {
		name: "Dawn Stone",
		desc: "Evolves male Kirlia into Gallade and female Snorunt into Froslass when used.",
		shortDesc: "Evolves certain species of Pokemon when used.",
	},
	decidiumz: {
		name: "Decidium Z",
		shortDesc: "If held by a Decidueye with Spirit Shackle, it can use Sinister Arrow Raid.",
	},
	deepseascale: {
		name: "Deep Sea Scale",
		desc: "If held by a Clamperl, its Sp. Def is doubled. Evolves Clamperl into Gorebyss when traded.",
		shortDesc: "If held by a Clamperl, its Sp. Def is doubled.",
	},
	deepseatooth: {
		name: "Deep Sea Tooth",
		desc: "If held by a Clamperl, its Sp. Atk is doubled. Evolves Clamperl into Huntail when traded.",
		shortDesc: "If held by a Clamperl, its Sp. Atk is doubled.",
	},
	destinyknot: {
		name: "Destiny Knot",
		shortDesc: "If holder becomes infatuated, the other Pokemon also becomes infatuated.",
	},
	diancite: {
		name: "Diancite",
		shortDesc: "If held by a Diancie, this item allows it to Mega Evolve in battle.",
	},
	diveball: {
		name: "Dive Ball",
		shortDesc: "A Poke Ball that works especially well on Pokemon that live underwater.",
	},
	domefossil: {
		name: "Dome Fossil",
		shortDesc: "Can be revived into Kabuto.",
	},
	dousedrive: {
		name: "Douse Drive",
		shortDesc: "Holder's Techno Blast is Water type.",
	},
	dracoplate: {
		name: "Draco Plate",
		shortDesc: "Holder's Dragon-type attacks have 1.2x power. Judgment is Dragon type.",
	},
	dragonfang: {
		name: "Dragon Fang",
		shortDesc: "Holder's Dragon-type attacks have 1.2x power.",
		gen3: {
			shortDesc: "Holder's Dragon-type attacks have 1.1x power.",
		},
		gen2: {
			shortDesc: "No competitive use.",
		},
	},
	dragongem: {
		name: "Dragon Gem",
		shortDesc: "Holder's first successful Dragon-type attack will have 1.3x power. Single use.",
		gen5: {
			shortDesc: "Holder's first successful Dragon-type attack will have 1.5x power. Single use.",
		},
	},
	dragonmemory: {
		name: "Dragon Memory",
		shortDesc: "Holder's Multi-Attack is Dragon type.",
	},
	dragonscale: {
		name: "Dragon Scale",
		shortDesc: "Evolves Seadra into Kingdra when traded.",
		gen2: {
			shortDesc: "Holder's Dragon-type attacks have 1.1x power. Evolves Seadra (trade).",
		},
	},
	dragoniumz: {
		name: "Dragonium Z",
		shortDesc: "If holder has a Dragon move, this item allows it to use a Dragon Z-Move.",
	},
	dreadplate: {
		name: "Dread Plate",
		shortDesc: "Holder's Dark-type attacks have 1.2x power. Judgment is Dark type.",
	},
	dreamball: {
		name: "Dream Ball",
		shortDesc: "A Poke Ball that makes it easier to catch wild Pokémon while they're asleep.",
		gen7: {
			shortDesc: "A special Poke Ball that appears out of nowhere in a bag at the Entree Forest.",
		},
	},
	dubiousdisc: {
		name: "Dubious Disc",
		shortDesc: "Evolves Porygon2 into Porygon-Z when traded.",
	},
	durinberry: {
		name: "Durin Berry",
		shortDesc: "Cannot be eaten by the holder. No effect when eaten with Bug Bite or Pluck.",
	},
	duskball: {
		name: "Dusk Ball",
		shortDesc: "A Poke Ball that makes it easier to catch wild Pokemon at night or in caves.",
	},
	duskstone: {
		name: "Dusk Stone",
		desc: "Evolves Murkrow into Honchkrow, Misdreavus into Mismagius, Lampent into Chandelure, and Doublade into Aegislash when used.",
		shortDesc: "Evolves certain species of Pokemon when used.",
	},
	earthplate: {
		name: "Earth Plate",
		shortDesc: "Holder's Ground-type attacks have 1.2x power. Judgment is Ground type.",
	},
	eeviumz: {
		name: "Eevium Z",
		shortDesc: "If held by an Eevee with Last Resort, it can use Extreme Evoboost.",
	},
	ejectbutton: {
		name: "Eject Button",
		shortDesc: "If holder survives a hit, it immediately switches out to a chosen ally. Single use.",

		end: "  [POKEMON] is switched out with the Eject Button!",
	},
	ejectpack: {
		name: "Eject Pack",
		shortDesc: "If the holder's stat stages are lowered, it switches to a chosen ally. Single use.",

		end: "  [POKEMON] is switched out by the Eject Pack!",
	},
	electirizer: {
		name: "Electirizer",
		shortDesc: "Evolves Electabuzz into Electivire when traded.",
	},
	electricgem: {
		name: "Electric Gem",
		shortDesc: "Holder's first successful Electric-type attack will have 1.3x power. Single use.",
		gen5: {
			shortDesc: "Holder's first successful Electric-type attack will have 1.5x power. Single use.",
		},
	},
	electricmemory: {
		name: "Electric Memory",
		shortDesc: "Holder's Multi-Attack is Electric type.",
	},
	electricseed: {
		name: "Electric Seed",
		shortDesc: "If the terrain is Electric Terrain, raises holder's Defense by 1 stage. Single use.",
	},
	electriumz: {
		name: "Electrium Z",
		shortDesc: "If holder has an Electric move, this item allows it to use an Electric Z-Move.",
	},
	enigmaberry: {
		name: "Enigma Berry",
		shortDesc: "Restores 1/4 max HP after holder is hit by a supereffective move. Single use.",
		gen3: {
			shortDesc: "No competitive use.",
		},
	},
	eviolite: {
		name: "Eviolite",
		shortDesc: "If holder's species can evolve, its Defense and Sp. Def are 1.5x.",
	},
	expertbelt: {
		name: "Expert Belt",
		shortDesc: "Holder's attacks that are super effective against the target do 1.2x damage.",
	},
	fairiumz: {
		name: "Fairium Z",
		shortDesc: "If holder has a Fairy move, this item allows it to use a Fairy Z-Move.",
	},
	fairyfeather: {
		name: "Fairy Feather",
		shortDesc: "Holder's Fairy-type attacks have 1.2x power.",
	},
	fairygem: {
		name: "Fairy Gem",
		shortDesc: "Holder's first successful Fairy-type attack will have 1.3x power. Single use.",
	},
	fairymemory: {
		name: "Fairy Memory",
		shortDesc: "Holder's Multi-Attack is Fairy type.",
	},
	fastball: {
		name: "Fast Ball",
		shortDesc: "A Poke Ball that makes it easier to catch Pokemon which are quick to run away.",
	},
	fightinggem: {
		name: "Fighting Gem",
		shortDesc: "Holder's first successful Fighting-type attack will have 1.3x power. Single use.",
		gen5: {
			shortDesc: "Holder's first successful Fighting-type attack will have 1.5x power. Single use.",
		},
	},
	fightingmemory: {
		name: "Fighting Memory",
		shortDesc: "Holder's Multi-Attack is Fighting type.",
	},
	fightiniumz: {
		name: "Fightinium Z",
		shortDesc: "If holder has a Fighting move, this item allows it to use a Fighting Z-Move.",
	},
	figyberry: {
		name: "Figy Berry",
		shortDesc: "Restores 1/3 max HP at 1/4 max HP or less; confuses if -Atk Nature. Single use.",
		gen7: {
			shortDesc: "Restores 1/2 max HP at 1/4 max HP or less; confuses if -Atk Nature. Single use.",
		},
		gen6: {
			shortDesc: "Restores 1/8 max HP at 1/2 max HP or less; confuses if -Atk Nature. Single use.",
		},
	},
	firegem: {
		name: "Fire Gem",
		shortDesc: "Holder's first successful Fire-type attack will have 1.3x power. Single use.",
		gen5: {
			shortDesc: "Holder's first successful Fire-type attack will have 1.5x power. Single use.",
		},
	},
	firememory: {
		name: "Fire Memory",
		shortDesc: "Holder's Multi-Attack is Fire type.",
	},
	firestone: {
		name: "Fire Stone",
		desc: "Evolves Vulpix into Ninetales, Growlithe into Arcanine, Eevee into Flareon, and Pansear into Simisear when used.",
		shortDesc: "Evolves certain species of Pokemon when used.",
	},
	firiumz: {
		name: "Firium Z",
		shortDesc: "If holder has a Fire move, this item allows it to use a Fire Z-Move.",
	},
	fistplate: {
		name: "Fist Plate",
		shortDesc: "Holder's Fighting-type attacks have 1.2x power. Judgment is Fighting type.",
	},
	flameorb: {
		name: "Flame Orb",
		shortDesc: "At the end of every turn, this item attempts to burn the holder.",
	},
	flameplate: {
		name: "Flame Plate",
		shortDesc: "Holder's Fire-type attacks have 1.2x power. Judgment is Fire type.",
	},
	floatstone: {
		name: "Float Stone",
		shortDesc: "Holder's weight is halved.",
	},
	flowersweet: {
		name: "Flower Sweet",
		shortDesc: "Evolves Milcery into Alcremie when held and spun around.",
	},
	flyinggem: {
		name: "Flying Gem",
		shortDesc: "Holder's first successful Flying-type attack will have 1.3x power. Single use.",
		gen5: {
			shortDesc: "Holder's first successful Flying-type attack will have 1.5x power. Single use.",
		},
	},
	flyingmemory: {
		name: "Flying Memory",
		shortDesc: "Holder's Multi-Attack is Flying type.",
	},
	flyiniumz: {
		name: "Flyinium Z",
		shortDesc: "If holder has a Flying move, this item allows it to use a Flying Z-Move.",
	},
	focusband: {
		name: "Focus Band",
		shortDesc: "Holder has a 10% chance to survive an attack that would KO it with 1 HP.",
		gen2: {
			shortDesc: "Holder has a ~11.7% chance to survive an attack that would KO it with 1 HP.",
		},

		activate: "  [POKEMON] hung on using its Focus Band!",
	},
	focussash: {
		name: "Focus Sash",
		shortDesc: "If holder's HP is full, will survive an attack that would KO it with 1 HP. Single use.",
		gen4: {
			shortDesc: "If holder's HP is full, survives all hits of one attack with at least 1 HP. Single use.",
		},

		end: "  [POKEMON] hung on using its Focus Sash!",
	},
	fossilizedbird: {
		name: "Fossilized Bird",
		shortDesc: "Can revive into Dracozolt with Fossilized Drake or Arctozolt with Fossilized Dino.",
	},
	fossilizeddino: {
		name: "Fossilized Dino",
		shortDesc: "Can revive into Arctovish with Fossilized Fish or Arctozolt with Fossilized Bird.",
	},
	fossilizeddrake: {
		name: "Fossilized Drake",
		shortDesc: "Can revive into Dracozolt with Fossilized Bird or Dracovish with Fossilized Fish.",
	},
	fossilizedfish: {
		name: "Fossilized Fish",
		shortDesc: "Can revive into Dracovish with Fossilized Drake or Arctovish with Fossilized Dino.",
	},
	friendball: {
		name: "Friend Ball",
		shortDesc: "A Poke Ball that makes caught Pokemon more friendly.",
	},
	fullincense: {
		name: "Full Incense",
		shortDesc: "Holder moves last in its priority bracket.",
	},
	galaricacuff: {
		name: "Galarica Cuff",
		shortDesc: "Evolves Galarian Slowpoke into Galarian Slowbro when used.",
	},
	galaricawreath: {
		name: "Galarica Wreath",
		shortDesc: "Evolves Galarian Slowpoke into Galarian Slowking when used.",
	},
	galladite: {
		name: "Galladite",
		shortDesc: "If held by a Gallade, this item allows it to Mega Evolve in battle.",
	},
	ganlonberry: {
		name: "Ganlon Berry",
		shortDesc: "Raises holder's Defense by 1 stage when at 1/4 max HP or less. Single use.",
	},
	garchompite: {
		name: "Garchompite",
		shortDesc: "If held by a Garchomp, this item allows it to Mega Evolve in battle.",
	},
	gardevoirite: {
		name: "Gardevoirite",
		shortDesc: "If held by a Gardevoir, this item allows it to Mega Evolve in battle.",
	},
	gengarite: {
		name: "Gengarite",
		shortDesc: "If held by a Gengar, this item allows it to Mega Evolve in battle.",
	},
	ghostgem: {
		name: "Ghost Gem",
		shortDesc: "Holder's first successful Ghost-type attack will have 1.3x power. Single use.",
		gen5: {
			shortDesc: "Holder's first successful Ghost-type attack will have 1.5x power. Single use.",
		},
	},
	ghostmemory: {
		name: "Ghost Memory",
		shortDesc: "Holder's Multi-Attack is Ghost type.",
	},
	ghostiumz: {
		name: "Ghostium Z",
		shortDesc: "If holder has a Ghost move, this item allows it to use a Ghost Z-Move.",
	},
	glalitite: {
		name: "Glalitite",
		shortDesc: "If held by a Glalie, this item allows it to Mega Evolve in battle.",
	},
	goldbottlecap: {
		name: "Gold Bottle Cap",
		shortDesc: "Used for Hyper Training. All of a Pokemon's stats are calculated with an IV of 31.",
	},
	grassgem: {
		name: "Grass Gem",
		shortDesc: "Holder's first successful Grass-type attack will have 1.3x power. Single use.",
		gen5: {
			shortDesc: "Holder's first successful Grass-type attack will have 1.5x power. Single use.",
		},
	},
	grassmemory: {
		name: "Grass Memory",
		shortDesc: "Holder's Multi-Attack is Grass type.",
	},
	grassiumz: {
		name: "Grassium Z",
		shortDesc: "If holder has a Grass move, this item allows it to use a Grass Z-Move.",
	},
	grassyseed: {
		name: "Grassy Seed",
		shortDesc: "If the terrain is Grassy Terrain, raises holder's Defense by 1 stage. Single use.",
	},
	greatball: {
		name: "Great Ball",
		shortDesc: "A high-performance Ball that provides a higher catch rate than a Poke Ball.",
	},
	grepaberry: {
		name: "Grepa Berry",
		shortDesc: "Cannot be eaten by the holder. No effect when eaten with Bug Bite or Pluck.",
	},
	gripclaw: {
		name: "Grip Claw",
		shortDesc: "Holder's partial-trapping moves always last 7 turns.",
	},
	griseouscore: {
		name: "Griseous Core",
		shortDesc: "If held by a Giratina, its Ghost- and Dragon-type attacks have 1.2x power.",
	},
	griseousorb: {
		name: "Griseous Orb",
		shortDesc: "If held by a Giratina, its Ghost- and Dragon-type attacks have 1.2x power.",
		gen4: {
			shortDesc: "Can only be held by Giratina. Its Ghost- & Dragon-type attacks have 1.2x power.",
		},
	},
	groundgem: {
		name: "Ground Gem",
		shortDesc: "Holder's first successful Ground-type attack will have 1.3x power. Single use.",
		gen5: {
			shortDesc: "Holder's first successful Ground-type attack will have 1.5x power. Single use.",
		},
	},
	groundmemory: {
		name: "Ground Memory",
		shortDesc: "Holder's Multi-Attack is Ground type.",
	},
	groundiumz: {
		name: "Groundium Z",
		shortDesc: "If holder has a Ground move, this item allows it to use a Ground Z-Move.",
	},
	gyaradosite: {
		name: "Gyaradosite",
		shortDesc: "If held by a Gyarados, this item allows it to Mega Evolve in battle.",
	},
	habanberry: {
		name: "Haban Berry",
		shortDesc: "Halves damage taken from a supereffective Dragon-type attack. Single use.",
	},
	hardstone: {
		name: "Hard Stone",
		shortDesc: "Holder's Rock-type attacks have 1.2x power.",
		gen3: {
			shortDesc: "Holder's Rock-type attacks have 1.1x power.",
		},
	},
	healball: {
		name: "Heal Ball",
		shortDesc: "A remedial Poke Ball that restores the caught Pokemon's HP and status problem.",
	},
	hearthflamemask: {
		name: "Hearthflame Mask",
		shortDesc: "Ogerpon-Hearthflame: 1.2x power attacks; Terastallize to gain Embody Aspect.",
	},
	heatrock: {
		name: "Heat Rock",
		shortDesc: "Holder's use of Sunny Day lasts 8 turns instead of 5.",
	},
	heavyball: {
		name: "Heavy Ball",
		shortDesc: "A Poke Ball for catching very heavy Pokemon.",
	},
	heavydutyboots: {
		name: "Heavy-Duty Boots",
		shortDesc: "When switching in, the holder is unaffected by hazards on its side of the field.",
	},
	helixfossil: {
		name: "Helix Fossil",
		shortDesc: "Can be revived into Omanyte.",
	},
	heracronite: {
		name: "Heracronite",
		shortDesc: "If held by a Heracross, this item allows it to Mega Evolve in battle.",
	},
	hondewberry: {
		name: "Hondew Berry",
		shortDesc: "Cannot be eaten by the holder. No effect when eaten with Bug Bite or Pluck.",
	},
	houndoominite: {
		name: "Houndoominite",
		shortDesc: "If held by a Houndoom, this item allows it to Mega Evolve in battle.",
	},
	iapapaberry: {
		name: "Iapapa Berry",
		shortDesc: "Restores 1/3 max HP at 1/4 max HP or less; confuses if -Def Nature. Single use.",
		gen7: {
			shortDesc: "Restores 1/2 max HP at 1/4 max HP or less; confuses if -Def Nature. Single use.",
		},
		gen6: {
			shortDesc: "Restores 1/8 max HP at 1/2 max HP or less; confuses if -Def Nature. Single use.",
		},
	},
	icegem: {
		name: "Ice Gem",
		shortDesc: "Holder's first successful Ice-type attack will have 1.3x power. Single use.",
		gen5: {
			shortDesc: "Holder's first successful Ice-type attack will have 1.5x power. Single use.",
		},
	},
	icememory: {
		name: "Ice Memory",
		shortDesc: "Holder's Multi-Attack is Ice type.",
	},
	icestone: {
		name: "Ice Stone",
		desc: "Evolves Alolan Sandshrew into Alolan Sandslash, Alolan Vulpix into Alolan Ninetales, Eevee into Glaceon, and Galarian Darumaka into Galarian Darmanitan when used.",
		shortDesc: "Evolves certain species of Pokemon when used.",
		gen7: {
			desc: "Evolves Alolan Sandshrew into Alolan Sandslash and Alolan Vulpix into Alolan Ninetales when used.",
		},
	},
	icicleplate: {
		name: "Icicle Plate",
		shortDesc: "Holder's Ice-type attacks have 1.2x power. Judgment is Ice type.",
	},
	iciumz: {
		name: "Icium Z",
		shortDesc: "If holder has an Ice move, this item allows it to use an Ice Z-Move.",
	},
	icyrock: {
		name: "Icy Rock",
		shortDesc: "Holder's use of Snowscape lasts 8 turns instead of 5.",
		gen8: {
			shortDesc: "Holder's use of Hail lasts 8 turns instead of 5.",
		},
	},
	inciniumz: {
		name: "Incinium Z",
		shortDesc: "If held by an Incineroar with Darkest Lariat, it can use Malicious Moonsault.",
	},
	insectplate: {
		name: "Insect Plate",
		shortDesc: "Holder's Bug-type attacks have 1.2x power. Judgment is Bug type.",
	},
	ironball: {
		name: "Iron Ball",
		shortDesc: "Holder is grounded, Speed halved. If Flying type, takes neutral Ground damage.",
		gen4: {
			shortDesc: "Holder's Speed is halved and it becomes grounded.",
		},
	},
	ironplate: {
		name: "Iron Plate",
		shortDesc: "Holder's Steel-type attacks have 1.2x power. Judgment is Steel type.",
	},
	jabocaberry: {
		name: "Jaboca Berry",
		shortDesc: "If holder is hit by a physical move, attacker loses 1/8 of its max HP. Single use.",
	},
	jawfossil: {
		name: "Jaw Fossil",
		shortDesc: "Can be revived into Tyrunt.",
	},
	kasibberry: {
		name: "Kasib Berry",
		shortDesc: "Halves damage taken from a supereffective Ghost-type attack. Single use.",
	},
	kebiaberry: {
		name: "Kebia Berry",
		shortDesc: "Halves damage taken from a supereffective Poison-type attack. Single use.",
	},
	keeberry: {
		name: "Kee Berry",
		shortDesc: "Raises holder's Defense by 1 stage after it is hit by a physical attack. Single use.",
	},
	kelpsyberry: {
		name: "Kelpsy Berry",
		shortDesc: "Cannot be eaten by the holder. No effect when eaten with Bug Bite or Pluck.",
	},
	kangaskhanite: {
		name: "Kangaskhanite",
		shortDesc: "If held by a Kangaskhan, this item allows it to Mega Evolve in battle.",
	},
	kingsrock: {
		name: "King's Rock",
		desc: "Holder's attacks without a chance to make the target flinch gain a 10% chance to make the target flinch. Evolves Poliwhirl into Politoed and Slowpoke into Slowking when traded.",
		shortDesc: "Holder's attacks without a chance to flinch gain a 10% chance to flinch.",
	},
	kommoniumz: {
		name: "Kommonium Z",
		shortDesc: "If held by a Kommo-o with Clanging Scales, it can use Clangorous Soulblaze.",
	},
	laggingtail: {
		name: "Lagging Tail",
		shortDesc: "Holder moves last in its priority bracket.",
	},
	lansatberry: {
		name: "Lansat Berry",
		shortDesc: "Holder gains the Focus Energy effect when at 1/4 max HP or less. Single use.",
	},
	latiasite: {
		name: "Latiasite",
		shortDesc: "If held by a Latias, this item allows it to Mega Evolve in battle.",
	},
	latiosite: {
		name: "Latiosite",
		shortDesc: "If held by a Latios, this item allows it to Mega Evolve in battle.",
	},
	laxincense: {
		name: "Lax Incense",
		shortDesc: "The accuracy of attacks against the holder is 0.9x.",
		gen3: {
			shortDesc: "The accuracy of attacks against the holder is 0.95x.",
		},
	},
	leafstone: {
		name: "Leaf Stone",
		desc: "Evolves Gloom into Vileplume, Weepinbell into Victreebel, Exeggcute into Exeggutor or Alolan Exeggutor, Eevee into Leafeon, Nuzleaf into Shiftry, and Pansage into Simisage when used.",
		shortDesc: "Evolves certain species of Pokemon when used.",
		gen7: {
			desc: "Evolves Gloom into Vileplume, Weepinbell into Victreebel, Exeggcute into Exeggutor or Alolan Exeggutor, Nuzleaf into Shiftry, and Pansage into Simisage when used.",
		},
	},
	leek: {
		name: "Leek",
		shortDesc: "If held by a Farfetch’d or Sirfetch’d, its critical hit ratio is raised by 2 stages.",
	},
	leftovers: {
		name: "Leftovers",
		shortDesc: "At the end of every turn, holder restores 1/16 of its max HP.",

		heal: "  [POKEMON] restored a little HP using its Leftovers!",
	},
	leppaberry: {
		name: "Leppa Berry",
		shortDesc: "Restores 10 PP to the first of the holder's moves to reach 0 PP. Single use.",

		activate: "  [POKEMON] restored PP to its move [MOVE] using its Leppa Berry!",
	},
	levelball: {
		name: "Level Ball",
		shortDesc: "A Poke Ball for catching Pokemon that are a lower level than your own.",
	},
	liechiberry: {
		name: "Liechi Berry",
		shortDesc: "Raises holder's Attack by 1 stage when at 1/4 max HP or less. Single use.",
	},
	lifeorb: {
		name: "Life Orb",
		shortDesc: "Holder's attacks do 1.3x damage, and it loses 1/10 its max HP after the attack.",

		damage: "  [POKEMON] lost some of its HP!",
	},
	lightball: {
		name: "Light Ball",
		shortDesc: "If held by a Pikachu, its Attack and Sp. Atk are doubled.",
		gen4: {
			shortDesc: "If held by a Pikachu, its attacks have their power doubled.",
		},
		gen3: {
			shortDesc: "If held by a Pikachu, its Special Attack is doubled.",
		},
	},
	lightclay: {
		name: "Light Clay",
		shortDesc: "Holder's use of Aurora Veil, Light Screen, or Reflect lasts 8 turns instead of 5.",
		gen6: {
			shortDesc: "Holder's use of Light Screen or Reflect lasts 8 turns instead of 5.",
		},
	},
	loadeddice: {
		name: "Loaded Dice",
		desc: "The holder's moves that normally hit 2 to 5 times instead hit 4 or 5 times. If the first hit is successful, the holder's use of Triple Kick or Triple Axel hits 3 times, and Population Bomb hits 4 to 10 times, at random.",
		shortDesc: "Holder's moves that hit 2-5 times hit 4-5 times; Population Bomb hits 4-10 times.",
	},
	lopunnite: {
		name: "Lopunnite",
		shortDesc: "If held by a Lopunny, this item allows it to Mega Evolve in battle.",
	},
	loveball: {
		name: "Love Ball",
		shortDesc: "Poke Ball for catching Pokemon that are the opposite gender of your Pokemon.",
	},
	lovesweet: {
		name: "Love Sweet",
		shortDesc: "Evolves Milcery into Alcremie when held and spun around.",
	},
	lucarionite: {
		name: "Lucarionite",
		shortDesc: "If held by a Lucario, this item allows it to Mega Evolve in battle.",
	},
	luckypunch: {
		name: "Lucky Punch",
		shortDesc: "If held by a Chansey, its critical hit ratio is raised by 2 stages.",
		gen2: {
			shortDesc: "If held by a Chansey, its critical hit ratio is always at stage 2. (25% crit rate)",
		},
	},
	lumberry: {
		name: "Lum Berry",
		shortDesc: "Holder cures itself if it has a non-volatile status or is confused. Single use.",
	},
	luminousmoss: {
		name: "Luminous Moss",
		shortDesc: "Raises holder's Sp. Def by 1 stage if hit by a Water-type attack. Single use.",
	},
	lunaliumz: {
		name: "Lunalium Z",
		shortDesc: "Lunala or Dawn Wings Necrozma with Moongeist Beam can use a special Z-Move.",
	},
	lureball: {
		name: "Lure Ball",
		shortDesc: "A Poke Ball for catching Pokemon hooked by a Rod when fishing.",
	},
	lustrousglobe: {
		name: "Lustrous Globe",
		shortDesc: "If held by a Palkia, its Water- and Dragon-type attacks have 1.2x power.",
	},
	lustrousorb: {
		name: "Lustrous Orb",
		shortDesc: "If held by a Palkia, its Water- and Dragon-type attacks have 1.2x power.",
	},
	luxuryball: {
		name: "Luxury Ball",
		shortDesc: "A comfortable Poke Ball that makes a caught wild Pokemon quickly grow friendly.",
	},
	lycaniumz: {
		name: "Lycanium Z",
		shortDesc: "If held by a Lycanroc forme with Stone Edge, it can use Splintered Stormshards.",
	},
	machobrace: {
		name: "Macho Brace",
		shortDesc: "Holder's Speed is halved. The Klutz Ability does not ignore this effect.",
	},
	magmarizer: {
		name: "Magmarizer",
		shortDesc: "Evolves Magmar into Magmortar when traded.",
	},
	magnet: {
		name: "Magnet",
		shortDesc: "Holder's Electric-type attacks have 1.2x power.",
		gen3: {
			shortDesc: "Holder's Electric-type attacks have 1.1x power.",
		},
	},
	magoberry: {
		name: "Mago Berry",
		shortDesc: "Restores 1/3 max HP at 1/4 max HP or less; confuses if -Spe Nature. Single use.",
		gen7: {
			shortDesc: "Restores 1/2 max HP at 1/4 max HP or less; confuses if -Spe Nature. Single use.",
		},
		gen6: {
			shortDesc: "Restores 1/8 max HP at 1/2 max HP or less; confuses if -Spe Nature. Single use.",
		},
	},
	magostberry: {
		name: "Magost Berry",
		shortDesc: "Cannot be eaten by the holder. No effect when eaten with Bug Bite or Pluck.",
	},
	mail: {
		name: "Mail",
		shortDesc: "Cannot be given to or taken from a Pokemon, except by Covet/Knock Off/Thief.",
	},
	maliciousarmor: {
		name: "Malicious Armor",
		shortDesc: "Evolves Charcadet into Ceruledge when used.",
	},
	manectite: {
		name: "Manectite",
		shortDesc: "If held by a Manectric, this item allows it to Mega Evolve in battle.",
	},
	marangaberry: {
		name: "Maranga Berry",
		shortDesc: "Raises holder's Sp. Def by 1 stage after it is hit by a special attack. Single use.",
	},
	marshadiumz: {
		name: "Marshadium Z",
		shortDesc: "If held by Marshadow with Spectral Thief, it can use Soul-Stealing 7-Star Strike.",
	},
	masterball: {
		name: "Master Ball",
		shortDesc: "The best Ball with the ultimate performance. It will catch any wild Pokemon.",
	},
	masterpieceteacup: {
		name: "Masterpiece Teacup",
		shortDesc: "Evolves Poltchageist-Artisan into Sinistcha-Masterpiece when used.",
	},
	mawilite: {
		name: "Mawilite",
		shortDesc: "If held by a Mawile, this item allows it to Mega Evolve in battle.",
	},
	meadowplate: {
		name: "Meadow Plate",
		shortDesc: "Holder's Grass-type attacks have 1.2x power. Judgment is Grass type.",
	},
	medichamite: {
		name: "Medichamite",
		shortDesc: "If held by a Medicham, this item allows it to Mega Evolve in battle.",
	},
	mentalherb: {
		name: "Mental Herb",
		shortDesc: "Cures holder of Attract, Disable, Encore, Heal Block, Taunt, Torment. Single use.",
		gen4: {
			shortDesc: "Holder is cured if it is infatuated. Single use.",
		},
	},
	metagrossite: {
		name: "Metagrossite",
		shortDesc: "If held by a Metagross, this item allows it to Mega Evolve in battle.",
	},
	metalalloy: {
		name: "Metal Alloy",
		shortDesc: "Evolves Duraludon into Archaludon when used.",
	},
	metalcoat: {
		name: "Metal Coat",
		desc: "Holder's Steel-type attacks have 1.2x power. Evolves Onix into Steelix and Scyther into Scizor when traded.",
		shortDesc: "Holder's Steel-type attacks have 1.2x power.",
		gen3: {
			desc: "Holder's Steel-type attacks have 1.1x power. Evolves Onix into Steelix and Scyther into Scizor when traded.",
			shortDesc: "Holder's Steel-type attacks have 1.1x power.",
		},
	},
	metalpowder: {
		name: "Metal Powder",
		shortDesc: "If held by a Ditto that hasn't Transformed, its Defense is doubled.",
		gen2: {
			shortDesc: "If held by a Ditto, its Defense and Sp. Def are 1.5x, even while Transformed.",
		},
	},
	metronome: {
		name: "Metronome",
		shortDesc: "Damage of moves used on consecutive turns is increased. Max 2x after 5 turns.",
		gen4: {
			shortDesc: "Damage of moves used on consecutive turns is increased. Max 2x after 10 turns.",
		},
	},
	mewniumz: {
		name: "Mewnium Z",
		shortDesc: "If held by a Mew with Psychic, it can use Genesis Supernova.",
	},
	mewtwonitex: {
		name: "Mewtwonite X",
		shortDesc: "If held by a Mewtwo, this item allows it to Mega Evolve in battle.",
	},
	mewtwonitey: {
		name: "Mewtwonite Y",
		shortDesc: "If held by a Mewtwo, this item allows it to Mega Evolve in battle.",
	},
	micleberry: {
		name: "Micle Berry",
		shortDesc: "Holder's next move has 1.2x accuracy when at 1/4 max HP or less. Single use.",
	},
	mimikiumz: {
		name: "Mimikium Z",
		shortDesc: "If held by a Mimikyu with Play Rough, it can use Let's Snuggle Forever.",
	},
	mindplate: {
		name: "Mind Plate",
		shortDesc: "Holder's Psychic-type attacks have 1.2x power. Judgment is Psychic type.",
	},
	miracleseed: {
		name: "Miracle Seed",
		shortDesc: "Holder's Grass-type attacks have 1.2x power.",
		gen3: {
			shortDesc: "Holder's Grass-type attacks have 1.1x power.",
		},
	},
	mirrorherb: {
		name: "Mirror Herb",
		shortDesc: "When an opposing Pokemon raises a stat stage, the holder copies it. Single use.",

		activate: "  [POKEMON] used its Mirror Herb to mirror its opponent's stat changes!",
	},
	mistyseed: {
		name: "Misty Seed",
		shortDesc: "If the terrain is Misty Terrain, raises holder's Sp. Def by 1 stage. Single use.",
	},
	moonball: {
		name: "Moon Ball",
		shortDesc: "A Poke Ball for catching Pokemon that evolve using the Moon Stone.",
	},
	moonstone: {
		name: "Moon Stone",
		desc: "Evolves Nidorina into Nidoqueen, Nidorino into Nidoking, Clefairy into Clefable, Jigglypuff into Wigglytuff, Skitty into Delcatty, and Munna into Musharna when used.",
		shortDesc: "Evolves certain species of Pokemon when used.",
	},
	muscleband: {
		name: "Muscle Band",
		shortDesc: "Holder's physical attacks have 1.1x power.",
	},
	mysticwater: {
		name: "Mystic Water",
		shortDesc: "Holder's Water-type attacks have 1.2x power.",
		gen3: {
			shortDesc: "Holder's Water-type attacks have 1.1x power.",
		},
	},
	nanabberry: {
		name: "Nanab Berry",
		shortDesc: "Cannot be eaten by the holder. No effect when eaten with Bug Bite or Pluck.",
	},
	nestball: {
		name: "Nest Ball",
		shortDesc: "A Poke Ball that works especially well on weaker Pokemon in the wild.",
	},
	netball: {
		name: "Net Ball",
		shortDesc: "A Poke Ball that works especially well on Water- and Bug-type Pokemon.",
	},
	nevermeltice: {
		name: "Never-Melt Ice",
		shortDesc: "Holder's Ice-type attacks have 1.2x power.",
		gen3: {
			shortDesc: "Holder's Ice-type attacks have 1.1x power.",
		},
	},
	nomelberry: {
		name: "Nomel Berry",
		shortDesc: "Cannot be eaten by the holder. No effect when eaten with Bug Bite or Pluck.",
	},
	normalgem: {
		name: "Normal Gem",
		shortDesc: "Holder's first successful Normal-type attack will have 1.3x power. Single use.",
		gen5: {
			shortDesc: "Holder's first successful Normal-type attack will have 1.5x power. Single use.",
		},
	},
	normaliumz: {
		name: "Normalium Z",
		shortDesc: "If holder has a Normal move, this item allows it to use a Normal Z-Move.",
	},
	occaberry: {
		name: "Occa Berry",
		shortDesc: "Halves damage taken from a supereffective Fire-type attack. Single use.",
	},
	oddincense: {
		name: "Odd Incense",
		shortDesc: "Holder's Psychic-type attacks have 1.2x power.",
	},
	oldamber: {
		name: "Old Amber",
		shortDesc: "Can be revived into Aerodactyl.",
	},
	oranberry: {
		name: "Oran Berry",
		shortDesc: "Restores 10 HP when at 1/2 max HP or less. Single use.",
	},
	ovalstone: {
		name: "Oval Stone",
		shortDesc: "Evolves Happiny into Chansey when held and leveled up during the day.",
	},
	pamtreberry: {
		name: "Pamtre Berry",
		shortDesc: "Cannot be eaten by the holder. No effect when eaten with Bug Bite or Pluck.",
	},
	parkball: {
		name: "Park Ball",
		shortDesc: "A special Poke Ball for the Pal Park.",
	},
	passhoberry: {
		name: "Passho Berry",
		shortDesc: "Halves damage taken from a supereffective Water-type attack. Single use.",
	},
	payapaberry: {
		name: "Payapa Berry",
		shortDesc: "Halves damage taken from a supereffective Psychic-type attack. Single use.",
	},
	pechaberry: {
		name: "Pecha Berry",
		shortDesc: "Holder is cured if it is poisoned. Single use.",
	},
	persimberry: {
		name: "Persim Berry",
		shortDesc: "Holder is cured if it is confused. Single use.",
	},
	petayaberry: {
		name: "Petaya Berry",
		shortDesc: "Raises holder's Sp. Atk by 1 stage when at 1/4 max HP or less. Single use.",
	},
	pidgeotite: {
		name: "Pidgeotite",
		shortDesc: "If held by a Pidgeot, this item allows it to Mega Evolve in battle.",
	},
	pikaniumz: {
		name: "Pikanium Z",
		shortDesc: "If held by a Pikachu with Volt Tackle, it can use Catastropika.",
	},
	pikashuniumz: {
		name: "Pikashunium Z",
		shortDesc: "If held by cap Pikachu with Thunderbolt, it can use 10,000,000 Volt Thunderbolt.",
	},
	pinapberry: {
		name: "Pinap Berry",
		shortDesc: "Cannot be eaten by the holder. No effect when eaten with Bug Bite or Pluck.",
	},
	pinsirite: {
		name: "Pinsirite",
		shortDesc: "If held by a Pinsir, this item allows it to Mega Evolve in battle.",
	},
	pixieplate: {
		name: "Pixie Plate",
		shortDesc: "Holder's Fairy-type attacks have 1.2x power. Judgment is Fairy type.",
	},
	plumefossil: {
		name: "Plume Fossil",
		shortDesc: "Can be revived into Archen.",
	},
	poisonbarb: {
		name: "Poison Barb",
		shortDesc: "Holder's Poison-type attacks have 1.2x power.",
		gen3: {
			shortDesc: "Holder's Poison-type attacks have 1.1x power.",
		},
	},
	poisongem: {
		name: "Poison Gem",
		shortDesc: "Holder's first successful Poison-type attack will have 1.3x power. Single use.",
		gen5: {
			shortDesc: "Holder's first successful Poison-type attack will have 1.5x power. Single use.",
		},
	},
	poisonmemory: {
		name: "Poison Memory",
		shortDesc: "Holder's Multi-Attack is Poison type.",
	},
	poisoniumz: {
		name: "Poisonium Z",
		shortDesc: "If holder has a Poison move, this item allows it to use a Poison Z-Move.",
	},
	pokeball: {
		name: "Poke Ball",
		shortDesc: "A device for catching wild Pokemon. It is designed as a capsule system.",
	},
	pomegberry: {
		name: "Pomeg Berry",
		shortDesc: "Cannot be eaten by the holder. No effect when eaten with Bug Bite or Pluck.",
	},
	poweranklet: {
		name: "Power Anklet",
		shortDesc: "Holder's Speed is halved. The Klutz Ability does not ignore this effect.",
	},
	powerband: {
		name: "Power Band",
		shortDesc: "Holder's Speed is halved. The Klutz Ability does not ignore this effect.",
	},
	powerbelt: {
		name: "Power Belt",
		shortDesc: "Holder's Speed is halved. The Klutz Ability does not ignore this effect.",
	},
	powerbracer: {
		name: "Power Bracer",
		shortDesc: "Holder's Speed is halved. The Klutz Ability does not ignore this effect.",
	},
	powerherb: {
		name: "Power Herb",
		shortDesc: "Holder's two-turn moves complete in one turn (except Sky Drop). Single use.",

		end: "  [POKEMON] became fully charged due to its Power Herb!",
	},
	powerlens: {
		name: "Power Lens",
		shortDesc: "Holder's Speed is halved. The Klutz Ability does not ignore this effect.",
	},
	powerweight: {
		name: "Power Weight",
		shortDesc: "Holder's Speed is halved. The Klutz Ability does not ignore this effect.",
	},
	premierball: {
		name: "Premier Ball",
		shortDesc: "A rare Poke Ball that has been crafted to commemorate an event.",
	},
	primariumz: {
		name: "Primarium Z",
		shortDesc: "If held by a Primarina with Sparkling Aria, it can use Oceanic Operetta.",
	},
	prismscale: {
		name: "Prism Scale",
		shortDesc: "Evolves Feebas into Milotic when traded.",
	},
	protectivepads: {
		name: "Protective Pads",
		shortDesc: "Holder's moves are protected from adverse contact effects, except Pickpocket.",

		block: "  [POKEMON] protected itself with its Protective Pads!",
	},
	protector: {
		name: "Protector",
		shortDesc: "Evolves Rhydon into Rhyperior when traded.",
	},
	psychicgem: {
		name: "Psychic Gem",
		shortDesc: "Holder's first successful Psychic-type attack will have 1.3x power. Single use.",
		gen5: {
			shortDesc: "Holder's first successful Psychic-type attack will have 1.5x power. Single use.",
		},
	},
	psychicmemory: {
		name: "Psychic Memory",
		shortDesc: "Holder's Multi-Attack is Psychic type.",
	},
	psychicseed: {
		name: "Psychic Seed",
		shortDesc: "If the terrain is Psychic Terrain, raises holder's Sp. Def by 1 stage. Single use.",
	},
	psychiumz: {
		name: "Psychium Z",
		shortDesc: "If holder has a Psychic move, this item allows it to use a Psychic Z-Move.",
	},
	punchingglove: {
		name: "Punching Glove",
		shortDesc: "Holder's punch-based attacks have 1.1x power and do not make contact.",
	},
	qualotberry: {
		name: "Qualot Berry",
		shortDesc: "Cannot be eaten by the holder. No effect when eaten with Bug Bite or Pluck.",
	},
	quickball: {
		name: "Quick Ball",
		shortDesc: "A Poke Ball that provides a better catch rate at the start of a wild encounter.",
	},
	quickclaw: {
		name: "Quick Claw",
		shortDesc: "Each turn, holder has a 20% chance to move first in its priority bracket.",
		gen2: {
			shortDesc: "Each turn, holder has a ~23.4% chance to move first in its priority bracket.",
		},

		activate: "  [POKEMON] can act faster than normal, thanks to its Quick Claw!",
	},
	quickpowder: {
		name: "Quick Powder",
		shortDesc: "If held by a Ditto that hasn't Transformed, its Speed is doubled.",
	},
	rabutaberry: {
		name: "Rabuta Berry",
		shortDesc: "Cannot be eaten by the holder. No effect when eaten with Bug Bite or Pluck.",
	},
	rarebone: {
		name: "Rare Bone",
		shortDesc: "No competitive use other than when used with Fling.",
	},
	rawstberry: {
		name: "Rawst Berry",
		shortDesc: "Holder is cured if it is burned. Single use.",
	},
	razorclaw: {
		name: "Razor Claw",
		desc: "Holder's critical hit ratio is raised by 1 stage. Evolves Sneasel into Weavile when held and leveled up during the night.",
		shortDesc: "Holder's critical hit ratio is raised by 1 stage.",
	},
	razorfang: {
		name: "Razor Fang",
		desc: "Holder's attacks without a chance to make the target flinch gain a 10% chance to make the target flinch. Evolves Gligar into Gliscor when held and leveled up during the night.",
		shortDesc: "Holder's attacks without a chance to flinch gain a 10% chance to flinch.",
	},
	razzberry: {
		name: "Razz Berry",
		shortDesc: "Cannot be eaten by the holder. No effect when eaten with Bug Bite or Pluck.",
	},
	reapercloth: {
		name: "Reaper Cloth",
		shortDesc: "Evolves Dusclops into Dusknoir when traded.",
	},
	redcard: {
		name: "Red Card",
		shortDesc: "If holder survives a hit, attacker is forced to switch to a random ally. Single use.",

		end: "  [POKEMON] held up its Red Card against [TARGET]!",
	},
	redorb: {
		name: "Red Orb",
		shortDesc: "If held by a Groudon, this item triggers its Primal Reversion in battle.",
	},
	repeatball: {
		name: "Repeat Ball",
		shortDesc: "A Poke Ball that works well on Pokemon species that were previously caught.",
	},
	ribbonsweet: {
		name: "Ribbon Sweet",
		shortDesc: "Evolves Milcery into Alcremie when held and spun around.",
	},
	rindoberry: {
		name: "Rindo Berry",
		shortDesc: "Halves damage taken from a supereffective Grass-type attack. Single use.",
	},
	ringtarget: {
		name: "Ring Target",
		shortDesc: "The holder's type immunities granted solely by its typing are negated.",
	},
	rockgem: {
		name: "Rock Gem",
		shortDesc: "Holder's first successful Rock-type attack will have 1.3x power. Single use.",
		gen5: {
			shortDesc: "Holder's first successful Rock-type attack will have 1.5x power. Single use.",
		},
	},
	rockincense: {
		name: "Rock Incense",
		shortDesc: "Holder's Rock-type attacks have 1.2x power.",
	},
	rockmemory: {
		name: "Rock Memory",
		shortDesc: "Holder's Multi-Attack is Rock type.",
	},
	rockiumz: {
		name: "Rockium Z",
		shortDesc: "If holder has a Rock move, this item allows it to use a Rock Z-Move.",
	},
	rockyhelmet: {
		name: "Rocky Helmet",
		shortDesc: "If holder is hit by a contact move, the attacker loses 1/6 of its max HP.",

		damage: "  [POKEMON] was hurt by the Rocky Helmet!",
	},
	roomservice: {
		name: "Room Service",
		shortDesc: "If Trick Room is active, the holder's Speed is lowered by 1 stage. Single use.",
	},
	rootfossil: {
		name: "Root Fossil",
		shortDesc: "Can be revived into Lileep.",
	},
	roseincense: {
		name: "Rose Incense",
		shortDesc: "Holder's Grass-type attacks have 1.2x power.",
	},
	roseliberry: {
		name: "Roseli Berry",
		shortDesc: "Halves damage taken from a supereffective Fairy-type attack. Single use.",
	},
	rowapberry: {
		name: "Rowap Berry",
		shortDesc: "If holder is hit by a special move, attacker loses 1/8 of its max HP. Single use.",
	},
	rustedshield: {
		name: "Rusted Shield",
		shortDesc: "If held by a Zamazenta, this item changes its forme to Crowned Shield.",
	},
	rustedsword: {
		name: "Rusted Sword",
		shortDesc: "If held by a Zacian, this item changes its forme to Crowned Sword.",
	},
	sablenite: {
		name: "Sablenite",
		shortDesc: "If held by a Sableye, this item allows it to Mega Evolve in battle.",
	},
	sachet: {
		name: "Sachet",
		shortDesc: "Evolves Spritzee into Aromatisse when traded.",
	},
	safariball: {
		name: "Safari Ball",
		shortDesc: "A special Poke Ball that is used only in the Safari Zone and Great Marsh.",
	},
	safetygoggles: {
		name: "Safety Goggles",
		shortDesc: "Holder is immune to powder moves and damage from Sandstorm or Hail.",

		block: "  [POKEMON] is not affected by [MOVE] thanks to its Safety Goggles!",
	},
	sailfossil: {
		name: "Sail Fossil",
		shortDesc: "Can be revived into Amaura.",
	},
	salacberry: {
		name: "Salac Berry",
		shortDesc: "Raises holder's Speed by 1 stage when at 1/4 max HP or less. Single use.",
	},
	salamencite: {
		name: "Salamencite",
		shortDesc: "If held by a Salamence, this item allows it to Mega Evolve in battle.",
	},
	sceptilite: {
		name: "Sceptilite",
		shortDesc: "If held by a Sceptile, this item allows it to Mega Evolve in battle.",
	},
	scizorite: {
		name: "Scizorite",
		shortDesc: "If held by a Scizor, this item allows it to Mega Evolve in battle.",
	},
	scopelens: {
		name: "Scope Lens",
		shortDesc: "Holder's critical hit ratio is raised by 1 stage.",
	},
	seaincense: {
		name: "Sea Incense",
		shortDesc: "Holder's Water-type attacks have 1.2x power.",
		gen3: {
			shortDesc: "Holder's Water-type attacks have 1.05x power.",
		},
	},
	sharpbeak: {
		name: "Sharp Beak",
		shortDesc: "Holder's Flying-type attacks have 1.2x power.",
		gen3: {
			shortDesc: "Holder's Flying-type attacks have 1.1x power.",
		},
	},
	sharpedonite: {
		name: "Sharpedonite",
		shortDesc: "If held by a Sharpedo, this item allows it to Mega Evolve in battle.",
	},
	shedshell: {
		name: "Shed Shell",
		shortDesc: "Holder cannot be prevented from choosing to switch out by any effect.",
	},
	shellbell: {
		name: "Shell Bell",
		shortDesc: "After an attack, holder gains 1/8 of the damage in HP dealt to other Pokemon.",

		heal: "  [POKEMON] restored a little HP using its Shell Bell!",
	},
	shinystone: {
		name: "Shiny Stone",
		desc: "Evolves Togetic into Togekiss, Roselia into Roserade, Minccino into Cinccino, and Floette into Florges when used.",
		shortDesc: "Evolves certain species of Pokemon when used.",
	},
	shockdrive: {
		name: "Shock Drive",
		shortDesc: "Holder's Techno Blast is Electric type.",
	},
	shucaberry: {
		name: "Shuca Berry",
		shortDesc: "Halves damage taken from a supereffective Ground-type attack. Single use.",
	},
	silkscarf: {
		name: "Silk Scarf",
		shortDesc: "Holder's Normal-type attacks have 1.2x power.",
		gen3: {
			shortDesc: "Holder's Normal-type attacks have 1.1x power.",
		},
	},
	silverpowder: {
		name: "Silver Powder",
		shortDesc: "Holder's Bug-type attacks have 1.2x power.",
		gen3: {
			shortDesc: "Holder's Bug-type attacks have 1.1x power.",
		},
	},
	sitrusberry: {
		name: "Sitrus Berry",
		shortDesc: "Restores 1/4 max HP when at 1/2 max HP or less. Single use.",
		gen3: {
			shortDesc: "Restores 30 HP when at 1/2 max HP or less. Single use.",
		},
	},
	skullfossil: {
		name: "Skull Fossil",
		shortDesc: "Can be revived into Cranidos.",
	},
	skyplate: {
		name: "Sky Plate",
		shortDesc: "Holder's Flying-type attacks have 1.2x power. Judgment is Flying type.",
	},
	slowbronite: {
		name: "Slowbronite",
		shortDesc: "If held by a Slowbro, this item allows it to Mega Evolve in battle.",
	},
	smoothrock: {
		name: "Smooth Rock",
		shortDesc: "Holder's use of Sandstorm lasts 8 turns instead of 5.",
	},
	snorliumz: {
		name: "Snorlium Z",
		shortDesc: "If held by a Snorlax with Giga Impact, it can use Pulverizing Pancake.",
	},
	snowball: {
		name: "Snowball",
		shortDesc: "Raises holder's Attack by 1 if hit by an Ice-type attack. Single use.",
	},
	softsand: {
		name: "Soft Sand",
		shortDesc: "Holder's Ground-type attacks have 1.2x power.",
		gen3: {
			shortDesc: "Holder's Ground-type attacks have 1.1x power.",
		},
	},
	solganiumz: {
		name: "Solganium Z",
		shortDesc: "Solgaleo or Dusk Mane Necrozma with Sunsteel Strike can use a special Z-Move.",
	},
	souldew: {
		name: "Soul Dew",
		shortDesc: "If held by a Latias/Latios, its Dragon- and Psychic-type moves have 1.2x power.",
		gen6: {
			shortDesc: "If held by a Latias or a Latios, its Sp. Atk and Sp. Def are 1.5x.",
		},
	},
	spelltag: {
		name: "Spell Tag",
		shortDesc: "Holder's Ghost-type attacks have 1.2x power.",
		gen3: {
			shortDesc: "Holder's Ghost-type attacks have 1.1x power.",
		},
	},
	spelonberry: {
		name: "Spelon Berry",
		shortDesc: "Cannot be eaten by the holder. No effect when eaten with Bug Bite or Pluck.",
	},
	splashplate: {
		name: "Splash Plate",
		shortDesc: "Holder's Water-type attacks have 1.2x power. Judgment is Water type.",
	},
	spookyplate: {
		name: "Spooky Plate",
		shortDesc: "Holder's Ghost-type attacks have 1.2x power. Judgment is Ghost type.",
	},
	sportball: {
		name: "Sport Ball",
		shortDesc: "A special Poke Ball for the Bug-Catching Contest.",
	},
	starfberry: {
		name: "Starf Berry",
		shortDesc: "Raises a random stat by 2 when at 1/4 max HP or less (not acc/eva). Single use.",
	},
	starsweet: {
		name: "Star Sweet",
		shortDesc: "Evolves Milcery into Alcremie when held and spun around.",
	},
	steelixite: {
		name: "Steelixite",
		shortDesc: "If held by a Steelix, this item allows it to Mega Evolve in battle.",
	},
	steelgem: {
		name: "Steel Gem",
		shortDesc: "Holder's first successful Steel-type attack will have 1.3x power. Single use.",
		gen5: {
			shortDesc: "Holder's first successful Steel-type attack will have 1.5x power. Single use.",
		},
	},
	steelmemory: {
		name: "Steel Memory",
		shortDesc: "Holder's Multi-Attack is Steel type.",
	},
	steeliumz: {
		name: "Steelium Z",
		shortDesc: "If holder has a Steel move, this item allows it to use a Steel Z-Move.",
	},
	stick: {
		name: "Stick",
		shortDesc: "If held by a Farfetch’d, its critical hit ratio is raised by 2 stages.",
		gen2: {
			shortDesc: "If held by a Farfetch’d, its critical hit ratio is always at stage 2. (25% crit rate)",
		},
	},
	stickybarb: {
		name: "Sticky Barb",
		shortDesc: "Each turn, holder loses 1/8 max HP. An attacker making contact can receive it.",
	},
	stoneplate: {
		name: "Stone Plate",
		shortDesc: "Holder's Rock-type attacks have 1.2x power. Judgment is Rock type.",
	},
	strangeball: {
		name: "Strange Ball",
		shortDesc: "Placeholder if caught in Poke Ball not in current game.",
	},
	strawberrysweet: {
		name: "Strawberry Sweet",
		shortDesc: "Evolves Milcery into Alcremie when held and spun around.",
	},
	sunstone: {
		name: "Sun Stone",
		desc: "Evolves Gloom into Bellossom, Sunkern into Sunflora, Cottonee into Whimsicott, Petilil into Lilligant, and Helioptile into Heliolisk when used.",
		shortDesc: "Evolves certain species of Pokemon when used.",
	},
	swampertite: {
		name: "Swampertite",
		shortDesc: "If held by a Swampert, this item allows it to Mega Evolve in battle.",
	},
	sweetapple: {
		name: "Sweet Apple",
		shortDesc: "Evolves Applin into Appletun when used.",
	},
	syrupyapple: {
		name: "Syrupy Apple",
		shortDesc: "Evolves Applin into Dipplin when used.",
	},
	tamatoberry: {
		name: "Tamato Berry",
		shortDesc: "Cannot be eaten by the holder. No effect when eaten with Bug Bite or Pluck.",
	},
	tangaberry: {
		name: "Tanga Berry",
		shortDesc: "Halves damage taken from a supereffective Bug-type attack. Single use.",
	},
	tapuniumz: {
		name: "Tapunium Z",
		shortDesc: "If held by a Tapu with Nature's Madness, it can use Guardian of Alola.",
	},
	tartapple: {
		name: "Tart Apple",
		shortDesc: "Evolves Applin into Flapple when used.",
	},
	terrainextender: {
		name: "Terrain Extender",
		shortDesc: "Holder's use of Electric/Grassy/Misty/Psychic Terrain lasts 8 turns instead of 5.",
	},
	thickclub: {
		name: "Thick Club",
		shortDesc: "If held by a Cubone or a Marowak, its Attack is doubled.",
	},
	throatspray: {
		name: "Throat Spray",
		shortDesc: "Raises holder's Special Attack by 1 stage after it uses a sound move. Single use.",
	},
	thunderstone: {
		name: "Thunder Stone",
		desc: "Evolves Pikachu into Raichu or Alolan Raichu, Eevee into Jolteon, Eelektrik into Eelektross, and Charjabug into Vikavolt when used.",
		shortDesc: "Evolves certain species of Pokemon when used.",
		gen7: {
			desc: "Evolves Pikachu into Raichu or Alolan Raichu, Eevee into Jolteon, and Eelektrik into Eelektross when used.",
		},
	},
	timerball: {
		name: "Timer Ball",
		shortDesc: "A Poke Ball that becomes better the more turns there are in a battle.",
	},
	toxicorb: {
		name: "Toxic Orb",
		shortDesc: "At the end of every turn, this item attempts to badly poison the holder.",
	},
	toxicplate: {
		name: "Toxic Plate",
		shortDesc: "Holder's Poison-type attacks have 1.2x power. Judgment is Poison type.",
	},
	tr00: {
		name: "TR00",
		shortDesc: "Teaches certain Pokemon the move Swords Dance. One use.",
	},
	tr01: {
		name: "TR01",
		shortDesc: "Teaches certain Pokemon the move Body Slam. One use.",
	},
	tr02: {
		name: "TR02",
		shortDesc: "Teaches certain Pokemon the move Flamethrower. One use.",
	},
	tr03: {
		name: "TR03",
		shortDesc: "Teaches certain Pokemon the move Hydro Pump. One use.",
	},
	tr04: {
		name: "TR04",
		shortDesc: "Teaches certain Pokemon the move Surf. One use.",
	},
	tr05: {
		name: "TR05",
		shortDesc: "Teaches certain Pokemon the move Ice Beam. One use.",
	},
	tr06: {
		name: "TR06",
		shortDesc: "Teaches certain Pokemon the move Blizzard. One use.",
	},
	tr07: {
		name: "TR07",
		shortDesc: "Teaches certain Pokemon the move Low Kick. One use.",
	},
	tr08: {
		name: "TR08",
		shortDesc: "Teaches certain Pokemon the move Thunderbolt. One use.",
	},
	tr09: {
		name: "TR09",
		shortDesc: "Teaches certain Pokemon the move Thunder. One use.",
	},
	tr10: {
		name: "TR10",
		shortDesc: "Teaches certain Pokemon the move Earthquake. One use.",
	},
	tr11: {
		name: "TR11",
		shortDesc: "Teaches certain Pokemon the move Psychic. One use.",
	},
	tr12: {
		name: "TR12",
		shortDesc: "Teaches certain Pokemon the move Agility. One use.",
	},
	tr13: {
		name: "TR13",
		shortDesc: "Teaches certain Pokemon the move Focus Energy. One use.",
	},
	tr14: {
		name: "TR14",
		shortDesc: "Teaches certain Pokemon the move Metronome. One use.",
	},
	tr15: {
		name: "TR15",
		shortDesc: "Teaches certain Pokemon the move Fire Blast. One use.",
	},
	tr16: {
		name: "TR16",
		shortDesc: "Teaches certain Pokemon the move Waterfall. One use.",
	},
	tr17: {
		name: "TR17",
		shortDesc: "Teaches certain Pokemon the move Amnesia. One use.",
	},
	tr18: {
		name: "TR18",
		shortDesc: "Teaches certain Pokemon the move Leech Life. One use.",
	},
	tr19: {
		name: "TR19",
		shortDesc: "Teaches certain Pokemon the move Tri Attack. One use.",
	},
	tr20: {
		name: "TR20",
		shortDesc: "Teaches certain Pokemon the move Substitute. One use.",
	},
	tr21: {
		name: "TR21",
		shortDesc: "Teaches certain Pokemon the move Reversal. One use.",
	},
	tr22: {
		name: "TR22",
		shortDesc: "Teaches certain Pokemon the move Sludge Bomb. One use.",
	},
	tr23: {
		name: "TR23",
		shortDesc: "Teaches certain Pokemon the move Spikes. One use.",
	},
	tr24: {
		name: "TR24",
		shortDesc: "Teaches certain Pokemon the move Outrage. One use.",
	},
	tr25: {
		name: "TR25",
		shortDesc: "Teaches certain Pokemon the move Psyshock. One use.",
	},
	tr26: {
		name: "TR26",
		shortDesc: "Teaches certain Pokemon the move Endure. One use.",
	},
	tr27: {
		name: "TR27",
		shortDesc: "Teaches certain Pokemon the move Sleep Talk. One use.",
	},
	tr28: {
		name: "TR28",
		shortDesc: "Teaches certain Pokemon the move Megahorn. One use.",
	},
	tr29: {
		name: "TR29",
		shortDesc: "Teaches certain Pokemon the move Baton Pass. One use.",
	},
	tr30: {
		name: "TR30",
		shortDesc: "Teaches certain Pokemon the move Encore. One use.",
	},
	tr31: {
		name: "TR31",
		shortDesc: "Teaches certain Pokemon the move Iron Tail. One use.",
	},
	tr32: {
		name: "TR32",
		shortDesc: "Teaches certain Pokemon the move Crunch. One use.",
	},
	tr33: {
		name: "TR33",
		shortDesc: "Teaches certain Pokemon the move Shadow Ball. One use.",
	},
	tr34: {
		name: "TR34",
		shortDesc: "Teaches certain Pokemon the move Future Sight. One use.",
	},
	tr35: {
		name: "TR35",
		shortDesc: "Teaches certain Pokemon the move Uproar. One use.",
	},
	tr36: {
		name: "TR36",
		shortDesc: "Teaches certain Pokemon the move Heat Wave. One use.",
	},
	tr37: {
		name: "TR37",
		shortDesc: "Teaches certain Pokemon the move Taunt. One use.",
	},
	tr38: {
		name: "TR38",
		shortDesc: "Teaches certain Pokemon the move Trick. One use.",
	},
	tr39: {
		name: "TR39",
		shortDesc: "Teaches certain Pokemon the move Superpower. One use.",
	},
	tr40: {
		name: "TR40",
		shortDesc: "Teaches certain Pokemon the move Skill Swap. One use.",
	},
	tr41: {
		name: "TR41",
		shortDesc: "Teaches certain Pokemon the move Blaze Kick. One use.",
	},
	tr42: {
		name: "TR42",
		shortDesc: "Teaches certain Pokemon the move Hyper Voice. One use.",
	},
	tr43: {
		name: "TR43",
		shortDesc: "Teaches certain Pokemon the move Overheat. One use.",
	},
	tr44: {
		name: "TR44",
		shortDesc: "Teaches certain Pokemon the move Cosmic Power. One use.",
	},
	tr45: {
		name: "TR45",
		shortDesc: "Teaches certain Pokemon the move Muddy Water. One use.",
	},
	tr46: {
		name: "TR46",
		shortDesc: "Teaches certain Pokemon the move Iron Defense. One use.",
	},
	tr47: {
		name: "TR47",
		shortDesc: "Teaches certain Pokemon the move Dragon Claw. One use.",
	},
	tr48: {
		name: "TR48",
		shortDesc: "Teaches certain Pokemon the move Bulk Up. One use.",
	},
	tr49: {
		name: "TR49",
		shortDesc: "Teaches certain Pokemon the move Calm Mind. One use.",
	},
	tr50: {
		name: "TR50",
		shortDesc: "Teaches certain Pokemon the move Leaf Blade. One use.",
	},
	tr51: {
		name: "TR51",
		shortDesc: "Teaches certain Pokemon the move Dragon Dance. One use.",
	},
	tr52: {
		name: "TR52",
		shortDesc: "Teaches certain Pokemon the move Gyro Ball. One use.",
	},
	tr53: {
		name: "TR53",
		shortDesc: "Teaches certain Pokemon the move Close Combat. One use.",
	},
	tr54: {
		name: "TR54",
		shortDesc: "Teaches certain Pokemon the move Toxic Spikes. One use.",
	},
	tr55: {
		name: "TR55",
		shortDesc: "Teaches certain Pokemon the move Flare Blitz. One use.",
	},
	tr56: {
		name: "TR56",
		shortDesc: "Teaches certain Pokemon the move Aura Sphere. One use.",
	},
	tr57: {
		name: "TR57",
		shortDesc: "Teaches certain Pokemon the move Poison Jab. One use.",
	},
	tr58: {
		name: "TR58",
		shortDesc: "Teaches certain Pokemon the move Dark Pulse. One use.",
	},
	tr59: {
		name: "TR59",
		shortDesc: "Teaches certain Pokemon the move Seed Bomb. One use.",
	},
	tr60: {
		name: "TR60",
		shortDesc: "Teaches certain Pokemon the move X-Scissor. One use.",
	},
	tr61: {
		name: "TR61",
		shortDesc: "Teaches certain Pokemon the move Bug Buzz. One use.",
	},
	tr62: {
		name: "TR62",
		shortDesc: "Teaches certain Pokemon the move Dragon Pulse. One use.",
	},
	tr63: {
		name: "TR63",
		shortDesc: "Teaches certain Pokemon the move Power Gem. One use.",
	},
	tr64: {
		name: "TR64",
		shortDesc: "Teaches certain Pokemon the move Focus Blast. One use.",
	},
	tr65: {
		name: "TR65",
		shortDesc: "Teaches certain Pokemon the move Energy Ball. One use.",
	},
	tr66: {
		name: "TR66",
		shortDesc: "Teaches certain Pokemon the move Brave Bird. One use.",
	},
	tr67: {
		name: "TR67",
		shortDesc: "Teaches certain Pokemon the move Earth Power. One use.",
	},
	tr68: {
		name: "TR68",
		shortDesc: "Teaches certain Pokemon the move Nasty Plot. One use.",
	},
	tr69: {
		name: "TR69",
		shortDesc: "Teaches certain Pokemon the move Zen Headbutt. One use.",
	},
	tr70: {
		name: "TR70",
		shortDesc: "Teaches certain Pokemon the move Flash Cannon. One use.",
	},
	tr71: {
		name: "TR71",
		shortDesc: "Teaches certain Pokemon the move Leaf Storm. One use.",
	},
	tr72: {
		name: "TR72",
		shortDesc: "Teaches certain Pokemon the move Power Whip. One use.",
	},
	tr73: {
		name: "TR73",
		shortDesc: "Teaches certain Pokemon the move Gunk Shot. One use.",
	},
	tr74: {
		name: "TR74",
		shortDesc: "Teaches certain Pokemon the move Iron Head. One use.",
	},
	tr75: {
		name: "TR75",
		shortDesc: "Teaches certain Pokemon the move Stone Edge. One use.",
	},
	tr76: {
		name: "TR76",
		shortDesc: "Teaches certain Pokemon the move Stealth Rock. One use.",
	},
	tr77: {
		name: "TR77",
		shortDesc: "Teaches certain Pokemon the move Grass Knot. One use.",
	},
	tr78: {
		name: "TR78",
		shortDesc: "Teaches certain Pokemon the move Sludge Wave. One use.",
	},
	tr79: {
		name: "TR79",
		shortDesc: "Teaches certain Pokemon the move Heavy Slam. One use.",
	},
	tr80: {
		name: "TR80",
		shortDesc: "Teaches certain Pokemon the move Electro Ball. One use.",
	},
	tr81: {
		name: "TR81",
		shortDesc: "Teaches certain Pokemon the move Foul Play. One use.",
	},
	tr82: {
		name: "TR82",
		shortDesc: "Teaches certain Pokemon the move Stored Power. One use.",
	},
	tr83: {
		name: "TR83",
		shortDesc: "Teaches certain Pokemon the move Ally Switch. One use.",
	},
	tr84: {
		name: "TR84",
		shortDesc: "Teaches certain Pokemon the move Scald. One use.",
	},
	tr85: {
		name: "TR85",
		shortDesc: "Teaches certain Pokemon the move Work Up. One use.",
	},
	tr86: {
		name: "TR86",
		shortDesc: "Teaches certain Pokemon the move Wild Charge. One use.",
	},
	tr87: {
		name: "TR87",
		shortDesc: "Teaches certain Pokemon the move Drill Run. One use.",
	},
	tr88: {
		name: "TR88",
		shortDesc: "Teaches certain Pokemon the move Heat Crash. One use.",
	},
	tr89: {
		name: "TR89",
		shortDesc: "Teaches certain Pokemon the move Hurricane. One use.",
	},
	tr90: {
		name: "TR90",
		shortDesc: "Teaches certain Pokemon the move Play Rough. One use.",
	},
	tr91: {
		name: "TR91",
		shortDesc: "Teaches certain Pokemon the move Venom Drench. One use.",
	},
	tr92: {
		name: "TR92",
		shortDesc: "Teaches certain Pokemon the move Dazzling Gleam. One use.",
	},
	tr93: {
		name: "TR93",
		shortDesc: "Teaches certain Pokemon the move Darkest Lariat. One use.",
	},
	tr94: {
		name: "TR94",
		shortDesc: "Teaches certain Pokemon the move High Horsepower. One use.",
	},
	tr95: {
		name: "TR95",
		shortDesc: "Teaches certain Pokemon the move Throat Chop. One use.",
	},
	tr96: {
		name: "TR96",
		shortDesc: "Teaches certain Pokemon the move Pollen Puff. One use.",
	},
	tr97: {
		name: "TR97",
		shortDesc: "Teaches certain Pokemon the move Psychic Fangs. One use.",
	},
	tr98: {
		name: "TR98",
		shortDesc: "Teaches certain Pokemon the move Liquidation. One use.",
	},
	tr99: {
		name: "TR99",
		shortDesc: "Teaches certain Pokemon the move Body Press. One use.",
	},
	twistedspoon: {
		name: "Twisted Spoon",
		shortDesc: "Holder's Psychic-type attacks have 1.2x power.",
		gen3: {
			shortDesc: "Holder's Psychic-type attacks have 1.1x power.",
		},
	},
	tyranitarite: {
		name: "Tyranitarite",
		shortDesc: "If held by a Tyranitar, this item allows it to Mega Evolve in battle.",
	},
	ultraball: {
		name: "Ultra Ball",
		shortDesc: "An ultra-performance Ball that provides a higher catch rate than a Great Ball.",
	},
	ultranecroziumz: {
		name: "Ultranecrozium Z",
		shortDesc: "Dusk Mane/Dawn Wings Necrozma: Ultra Burst, then Z-Move w/ Photon Geyser.",

		transform: "  Bright light is about to burst out of [POKEMON]!",
		activate: "[POKEMON] regained its true power through Ultra Burst!",
	},
	unremarkableteacup: {
		name: "Unremarkable Teacup",
		shortDesc: "Evolves Poltchageist into Sinistcha when used.",
	},
	upgrade: {
		name: "Up-Grade",
		shortDesc: "Evolves Porygon into Porygon2 when traded.",
	},
	utilityumbrella: {
		name: "Utility Umbrella",
		desc: "The holder ignores rain- and sun-based effects, including those of its Ability unless it is Orichalcum Pulse or Protosynthesis. Damage and accuracy calculations from attacks used by the holder are affected by rain and sun, but not attacks used against the holder.",
		shortDesc: "The holder ignores rain- and sun-based effects.",
		gen8: {
			desc: "The holder ignores rain- and sun-based effects, including those of its Ability. Damage and accuracy calculations from attacks used by the holder are affected by rain and sun, but not attacks used against the holder.",
		},
	},
	venusaurite: {
		name: "Venusaurite",
		shortDesc: "If held by a Venusaur, this item allows it to Mega Evolve in battle.",
	},
	wacanberry: {
		name: "Wacan Berry",
		shortDesc: "Halves damage taken from a supereffective Electric-type attack. Single use.",
	},
	watergem: {
		name: "Water Gem",
		shortDesc: "Holder's first successful Water-type attack will have 1.3x power. Single use.",
		gen5: {
			shortDesc: "Holder's first successful Water-type attack will have 1.5x power. Single use.",
		},
	},
	watermemory: {
		name: "Water Memory",
		shortDesc: "Holder's Multi-Attack is Water type.",
	},
	waterstone: {
		name: "Water Stone",
		desc: "Evolves Poliwhirl into Poliwrath, Shellder into Cloyster, Staryu into Starmie, Eevee into Vaporeon, Lombre into Ludicolo, and Panpour into Simipour when used.",
		shortDesc: "Evolves certain species of Pokemon when used.",
	},
	wateriumz: {
		name: "Waterium Z",
		shortDesc: "If holder has a Water move, this item allows it to use a Water Z-Move.",
	},
	watmelberry: {
		name: "Watmel Berry",
		shortDesc: "Cannot be eaten by the holder. No effect when eaten with Bug Bite or Pluck.",
	},
	waveincense: {
		name: "Wave Incense",
		shortDesc: "Holder's Water-type attacks have 1.2x power.",
	},
	weaknesspolicy: {
		name: "Weakness Policy",
		shortDesc: "If holder is hit super effectively, raises Attack, Sp. Atk by 2 stages. Single use.",
	},
	wellspringmask: {
		name: "Wellspring Mask",
		shortDesc: "Ogerpon-Wellspring: 1.2x power attacks; Terastallize to gain Embody Aspect.",
	},
	wepearberry: {
		name: "Wepear Berry",
		shortDesc: "Cannot be eaten by the holder. No effect when eaten with Bug Bite or Pluck.",
	},
	whippeddream: {
		name: "Whipped Dream",
		shortDesc: "Evolves Swirlix into Slurpuff when traded.",
	},
	whiteherb: {
		name: "White Herb",
		shortDesc: "Restores all lowered stat stages to 0 when one is less than 0. Single use.",

		end: "  [POKEMON] returned its stats to normal using its White Herb!",
	},
	widelens: {
		name: "Wide Lens",
		shortDesc: "The accuracy of attacks by the holder is 1.1x.",
	},
	wikiberry: {
		name: "Wiki Berry",
		shortDesc: "Restores 1/3 max HP at 1/4 max HP or less; confuses if -SpA Nature. Single use.",
		gen7: {
			shortDesc: "Restores 1/2 max HP at 1/4 max HP or less; confuses if -SpA Nature. Single use.",
		},
		gen6: {
			shortDesc: "Restores 1/8 max HP at 1/2 max HP or less; confuses if -SpA Nature. Single use.",
		},
	},
	wiseglasses: {
		name: "Wise Glasses",
		shortDesc: "Holder's special attacks have 1.1x power.",
	},
	yacheberry: {
		name: "Yache Berry",
		shortDesc: "Halves damage taken from a supereffective Ice-type attack. Single use.",
	},
	zapplate: {
		name: "Zap Plate",
		shortDesc: "Holder's Electric-type attacks have 1.2x power. Judgment is Electric type.",
	},
	zoomlens: {
		name: "Zoom Lens",
		shortDesc: "The accuracy of attacks by the holder is 1.2x if it moves after its target.",
	},

	// Gen 2 items

	berserkgene: {
		name: "Berserk Gene",
		shortDesc: "(Gen 2) On switch-in, raises holder's Attack by 2 and confuses it. Single use.",
	},
	berry: {
		name: "Berry",
		shortDesc: "(Gen 2) Restores 10 HP when at 1/2 max HP or less. Single use.",
	},
	bitterberry: {
		name: "Bitter Berry",
		shortDesc: "(Gen 2) Holder is cured if it is confused. Single use.",
	},
	burntberry: {
		name: "Burnt Berry",
		shortDesc: "(Gen 2) Holder is cured if it is frozen. Single use.",
	},
	goldberry: {
		name: "Gold Berry",
		shortDesc: "(Gen 2) Restores 30 HP when at 1/2 max HP or less. Single use.",
	},
	iceberry: {
		name: "Ice Berry",
		shortDesc: "(Gen 2) Holder is cured if it is burned. Single use.",
	},
	mintberry: {
		name: "Mint Berry",
		shortDesc: "(Gen 2) Holder wakes up if it is asleep. Single use.",
	},
	miracleberry: {
		name: "Miracle Berry",
		shortDesc: "(Gen 2) Holder cures itself if it is confused or has a status condition. Single use.",
	},
	mysteryberry: {
		name: "Mystery Berry",
		shortDesc: "(Gen 2) Restores 5 PP to the first of the holder's moves to reach 0 PP. Single use.",

		activate: "  [POKEMON] restored PP to its [MOVE] move using Mystery Berry!",
	},
	pinkbow: {
		name: "Pink Bow",
		shortDesc: "(Gen 2) Holder's Normal-type attacks have 1.1x power.",
	},
	polkadotbow: {
		name: "Polkadot Bow",
		shortDesc: "(Gen 2) Holder's Normal-type attacks have 1.1x power.",
	},
	przcureberry: {
		name: "PRZ Cure Berry",
		shortDesc: "(Gen 2) Holder cures itself if it is paralyzed. Single use.",
	},
	psncureberry: {
		name: "PSN Cure Berry",
		shortDesc: "(Gen 2) Holder is cured if it is poisoned. Single use.",
	},

	// CAP items

	crucibellite: {
		name: "Crucibellite",
		shortDesc: "If held by a Crucibelle, this item allows it to Mega Evolve in battle.",
	},
	vilevial: {
		name: "Vile Vial",
		shortDesc: "If held by a Venomicon, its Poison- and Flying-type attacks have 1.2x power.",
	},
};
