export const Learnsets: import('../../../sim/dex-species').ModdedLearnsetDataTable = {
	missingno: {
		learnset: {
			blizzard: ["1M"],
			bubblebeam: ["1M"],
			cut: ["1M"],
			doubleedge: ["1M"],
			earthquake: ["1M"],
			fissure: ["1M"],
			fly: ["1M"],
			icebeam: ["1M"],
			megakick: ["1M"],
			megapunch: ["1M"],
			psychic: ["1M"],
			rage: ["1M"],
			razorwind: ["1M"],
			rest: ["1M"],
			seismictoss: ["1M"],
			skyattack: ["1L1"],
			submission: ["1M"],
			substitute: ["1M"],
			swordsdance: ["1M"],
			takedown: ["1M"],
			teleport: ["1M"],
			thunder: ["1M"],
			thunderwave: ["1M"],
			toxic: ["1M"],
			triattack: ["1M"],
			watergun: ["1M", "1L1"],
		},
	},
	bulbasaur: {
		learnset: {
			ancientpower: ["2S0"],
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			curse: ["2M"],
			cut: ["2M", "1M"],
			defensecurl: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			furycutter: ["2M"],
			gigadrain: ["2M"],
			growl: ["2L4", "2S0", "1L1"],
			growth: ["2L32", "1L34"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			leechseed: ["2L7", "1L7"],
			lightscreen: ["2E"],
			megadrain: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			petaldance: ["2E"],
			poisonpowder: ["2L15", "1L20"],
			protect: ["2M"],
			rage: ["1M"],
			razorleaf: ["2L20", "1L27"],
			razorwind: ["2E"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			safeguard: ["2E"],
			skullbash: ["2E"],
			sleeppowder: ["2L15", "1L41"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M", "2L46", "1M", "1L48"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			sweetscent: ["2M", "2L25"],
			swordsdance: ["1M"],
			synthesis: ["2L39"],
			tackle: ["2L1", "2S0", "1L1"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
			vinewhip: ["2L10", "1L13"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "growl", "ancientpower"]},
		],
		encounters: [
			{generation: 1, level: 5},
		],
	},
	ivysaur: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			curse: ["2M"],
			cut: ["2M", "1M"],
			defensecurl: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			furycutter: ["2M"],
			gigadrain: ["2M"],
			growl: ["2L4", "2L1", "1L1"],
			growth: ["2L38", "1L38"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			leechseed: ["2L7", "2L1", "1L7", "1L1"],
			megadrain: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			poisonpowder: ["2L15", "1L22"],
			protect: ["2M"],
			rage: ["1M"],
			razorleaf: ["2L22", "1L30"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			sleeppowder: ["2L15", "1L46"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M", "2L56", "1M", "1L54"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			sweetscent: ["2M", "2L29"],
			swordsdance: ["1M"],
			synthesis: ["2L47"],
			tackle: ["2L1", "1L1"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
			vinewhip: ["2L10", "1L13"],
		},
	},
	venusaur: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			curse: ["2M"],
			cut: ["2M", "1M"],
			defensecurl: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			furycutter: ["2M"],
			gigadrain: ["2M"],
			growl: ["2L4", "2L1", "1L1"],
			growth: ["2L41", "1L43"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			leechseed: ["2L7", "2L1", "1L7", "1L1"],
			megadrain: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			poisonpowder: ["2L15", "2S0", "1L22"],
			protect: ["2M"],
			rage: ["1M"],
			razorleaf: ["2L22", "2S0", "1L30"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			roar: ["2M"],
			sleeppowder: ["2L15", "2S0", "1L55"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M", "2L65", "1M", "1L65"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			sweetscent: ["2M", "2L29", "2S0"],
			swordsdance: ["1M"],
			synthesis: ["2L53"],
			tackle: ["2L1", "1L1"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
			vinewhip: ["2L10", "2L1", "1L13", "1L1"],
		},
		eventData: [
			{generation: 2, level: 40, shiny: true, moves: ["poisonpowder", "sleeppowder", "razorleaf", "sweetscent"]},
		],
	},
	charmander: {
		learnset: {
			ancientpower: ["2E"],
			attract: ["2M"],
			beatup: ["2E"],
			bellydrum: ["2E"],
			bide: ["1M"],
			bite: ["2E"],
			bodyslam: ["1M"],
			counter: ["1M"],
			crunch: ["2S0"],
			curse: ["2M"],
			cut: ["2M", "1M"],
			defensecurl: ["2M"],
			dig: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dragonbreath: ["2M"],
			dragonrage: ["2L43", "1M"],
			dynamicpunch: ["2M"],
			ember: ["2L7", "1L9"],
			endure: ["2M"],
			fireblast: ["2M", "1M"],
			firepunch: ["2M"],
			firespin: ["2L49", "1L46"],
			flamethrower: ["2T", "2L31", "1L38"],
			frustration: ["2M"],
			furycutter: ["2M"],
			growl: ["2L1", "2S0", "1L1"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			irontail: ["2M"],
			leer: ["1L15"],
			megakick: ["1M"],
			megapunch: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			outrage: ["2E"],
			protect: ["2M"],
			rage: ["2L19", "1M", "1L22"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rockslide: ["2E"],
			rocksmash: ["2M"],
			scaryface: ["2L25"],
			scratch: ["2L1", "2S0", "1L1"],
			seismictoss: ["1M"],
			skullbash: ["1M"],
			slash: ["2L37", "1L30"],
			sleeptalk: ["2M"],
			smokescreen: ["2L13"],
			snore: ["2M"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			swordsdance: ["1M"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["scratch", "growl", "crunch"]},
		],
		encounters: [
			{generation: 1, level: 5},
		],
	},
	charmeleon: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			counter: ["1M"],
			curse: ["2M"],
			cut: ["2M", "1M"],
			defensecurl: ["2M"],
			dig: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dragonbreath: ["2M"],
			dragonrage: ["2L48", "1M"],
			dynamicpunch: ["2M"],
			ember: ["2L7", "2L1", "1L9", "1L1"],
			endure: ["2M"],
			fireblast: ["2M", "1M"],
			firepunch: ["2M"],
			firespin: ["2L55", "1L56"],
			flamethrower: ["2T", "2L34", "1L42"],
			frustration: ["2M"],
			furycutter: ["2M"],
			growl: ["2L1", "1L1"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			irontail: ["2M"],
			leer: ["1L15"],
			megakick: ["1M"],
			megapunch: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			protect: ["2M"],
			rage: ["2L20", "1M", "1L24"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rocksmash: ["2M"],
			scaryface: ["2L27"],
			scratch: ["2L1", "1L1"],
			seismictoss: ["1M"],
			skullbash: ["1M"],
			slash: ["2L41", "1L33"],
			sleeptalk: ["2M"],
			smokescreen: ["2L13"],
			snore: ["2M"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			swordsdance: ["1M"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
		},
	},
	charizard: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			counter: ["1M"],
			curse: ["2M"],
			cut: ["2M", "1M"],
			defensecurl: ["2M"],
			dig: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dragonbreath: ["2M"],
			dragonrage: ["2L54", "1M"],
			dynamicpunch: ["2M"],
			earthquake: ["2M", "1M"],
			ember: ["2L7", "2L1", "1L9", "1L1"],
			endure: ["2M"],
			fireblast: ["2M", "1M"],
			firepunch: ["2M"],
			firespin: ["2L64", "1L55"],
			fissure: ["1M"],
			flamethrower: ["2T", "2L34", "2S0", "1L46"],
			fly: ["2M", "1M"],
			frustration: ["2M"],
			furycutter: ["2M"],
			growl: ["2L1", "1L1"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			irontail: ["2M"],
			leer: ["1L15", "1L1"],
			megakick: ["1M"],
			megapunch: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			protect: ["2M"],
			rage: ["2L20", "2S0", "1M", "1L24"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			roar: ["2M"],
			rocksmash: ["2M"],
			sandstorm: ["2M"],
			scaryface: ["2L27", "2S0"],
			scratch: ["2L1", "1L1"],
			seismictoss: ["1M"],
			skullbash: ["1M"],
			slash: ["2L44", "1L36"],
			sleeptalk: ["2M"],
			smokescreen: ["2L13", "2L1"],
			snore: ["2M"],
			steelwing: ["2M"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			swordsdance: ["1M"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
			wingattack: ["2L36", "2S0"],
		},
		eventData: [
			{generation: 2, level: 40, shiny: true, moves: ["rage", "scaryface", "flamethrower", "wingattack"]},
		],
	},
	squirtle: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bite: ["2L18", "1L22"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubble: ["2L7", "1L8"],
			bubblebeam: ["1M"],
			confusion: ["2E"],
			counter: ["1M"],
			curse: ["2M"],
			defensecurl: ["2M"],
			dig: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			flail: ["2E"],
			foresight: ["2E"],
			frustration: ["2M"],
			haze: ["2E"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hydropump: ["2L47", "1L42"],
			icebeam: ["2T", "1M"],
			icepunch: ["2M"],
			icywind: ["2M"],
			irontail: ["2M"],
			megakick: ["1M"],
			megapunch: ["1M"],
			mimic: ["1M"],
			mirrorcoat: ["2E"],
			mist: ["2E"],
			mudslap: ["2M"],
			protect: ["2M", "2L28"],
			rage: ["1M"],
			raindance: ["2M", "2L33"],
			rapidspin: ["2L23"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rocksmash: ["2M"],
			rollout: ["2M"],
			seismictoss: ["1M"],
			skullbash: ["2L40", "1M", "1L35"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			tackle: ["2L1", "2S0", "1L1"],
			tailwhip: ["2L4", "2S0", "1L1"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
			waterfall: ["2M"],
			watergun: ["2L13", "1M", "1L15"],
			whirlpool: ["2M"],
			withdraw: ["2L10", "1L28"],
			zapcannon: ["2S0"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "tailwhip", "zapcannon"]},
		],
		encounters: [
			{generation: 1, level: 5},
		],
	},
	wartortle: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bite: ["2L19", "1L24"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubble: ["2L7", "2L1", "1L8", "1L1"],
			bubblebeam: ["1M"],
			counter: ["1M"],
			curse: ["2M"],
			defensecurl: ["2M"],
			dig: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hydropump: ["2L53", "1L47"],
			icebeam: ["2T", "1M"],
			icepunch: ["2M"],
			icywind: ["2M"],
			irontail: ["2M"],
			megakick: ["1M"],
			megapunch: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			protect: ["2M", "2L31"],
			rage: ["1M"],
			raindance: ["2M", "2L37"],
			rapidspin: ["2L25"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rocksmash: ["2M"],
			rollout: ["2M"],
			seismictoss: ["1M"],
			skullbash: ["2L45", "1M", "1L39"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			tackle: ["2L1", "1L1"],
			tailwhip: ["2L4", "2L1", "1L1"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
			waterfall: ["2M"],
			watergun: ["2L13", "1M", "1L15"],
			whirlpool: ["2M"],
			withdraw: ["2L10", "1L31"],
		},
	},
	blastoise: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bite: ["2L19", "2S0", "1L24"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubble: ["2L7", "2L1", "1L8", "1L1"],
			bubblebeam: ["1M"],
			counter: ["1M"],
			curse: ["2M"],
			defensecurl: ["2M"],
			dig: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dynamicpunch: ["2M"],
			earthquake: ["2M", "1M"],
			endure: ["2M"],
			fissure: ["1M"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hydropump: ["2L68", "1L52"],
			hyperbeam: ["2M", "1M"],
			icebeam: ["2T", "1M"],
			icepunch: ["2M"],
			icywind: ["2M"],
			irontail: ["2M"],
			megakick: ["1M"],
			megapunch: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			protect: ["2M", "2L31", "2S0"],
			rage: ["1M"],
			raindance: ["2M", "2L42"],
			rapidspin: ["2L25", "2S0"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			roar: ["2M"],
			rocksmash: ["2M"],
			rollout: ["2M"],
			seismictoss: ["1M"],
			skullbash: ["2L55", "1M", "1L42"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			tackle: ["2L1", "1L1"],
			tailwhip: ["2L4", "2L1", "1L1"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
			waterfall: ["2M"],
			watergun: ["2L13", "2S0", "1M", "1L15", "1L1"],
			whirlpool: ["2M"],
			withdraw: ["2L10", "2L1", "1L31"],
		},
		eventData: [
			{generation: 2, level: 40, shiny: true, moves: ["watergun", "bite", "rapidspin", "protect"]},
		],
	},
	caterpie: {
		learnset: {
			stringshot: ["2L1", "1L1"],
			tackle: ["2L1", "1L1"],
		},
		encounters: [
			{generation: 1, level: 3},
			{generation: 2, level: 3},
		],
	},
	metapod: {
		learnset: {
			harden: ["2L7", "2L1", "1L7", "1L1"],
		},
		encounters: [
			{generation: 1, level: 4},
			{generation: 2, level: 4},
			{generation: 3, level: 4},
		],
	},
	butterfree: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			confusion: ["2L10", "2L1", "1L10", "1L12", "1L1"],
			curse: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			flash: ["2M", "1M"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			gust: ["2L28", "1L28"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			megadrain: ["1M"],
			mimic: ["1M"],
			nightmare: ["2M"],
			poisonpowder: ["2L13", "1L13", "1L15"],
			protect: ["2M"],
			psybeam: ["2L34", "1L34", "1L32"],
			psychic: ["2M", "1M"],
			psywave: ["1M"],
			rage: ["1M"],
			razorwind: ["1M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			safeguard: ["2L40"],
			sleeppowder: ["2L15", "1L15", "1L17"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M", "1M"],
			stunspore: ["2L14", "1L14", "1L16"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			supersonic: ["2L18", "1L18", "1L21"],
			swagger: ["2M"],
			sweetscent: ["2M"],
			swift: ["2M", "1M"],
			takedown: ["1M"],
			teleport: ["1M"],
			toxic: ["2M", "1M"],
			whirlwind: ["2L23", "1M", "1L23", "1L26"],
		},
		encounters: [
			{generation: 2, level: 7},
		],
	},
	weedle: {
		learnset: {
			poisonsting: ["2L1", "1L1"],
			stringshot: ["2L1", "1L1"],
		},
		encounters: [
			{generation: 1, level: 3},
			{generation: 2, level: 3},
		],
	},
	kakuna: {
		learnset: {
			harden: ["2L7", "2L1", "1L1"],
		},
		encounters: [
			{generation: 1, level: 4},
			{generation: 2, level: 4},
		],
	},
	beedrill: {
		learnset: {
			agility: ["2L40", "1L35"],
			attract: ["2M"],
			bide: ["1M"],
			curse: ["2M"],
			cut: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			focusenergy: ["2L15", "1L16"],
			frustration: ["2M"],
			furyattack: ["2L10", "2L1", "1L12", "1L1"],
			furycutter: ["2M"],
			gigadrain: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			megadrain: ["1M"],
			mimic: ["1M"],
			pinmissile: ["2L35", "1L30"],
			protect: ["2M"],
			pursuit: ["2L30"],
			rage: ["2L25", "1M", "1L25"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			snore: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			sweetscent: ["2M"],
			swift: ["2M", "1M"],
			swordsdance: ["1M"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
			twineedle: ["2L20", "1L20"],
		},
		encounters: [
			{generation: 2, level: 7},
		],
	},
	pidgey: {
		learnset: {
			agility: ["2L37", "1L36"],
			attract: ["2M"],
			bide: ["1M"],
			curse: ["2M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			feintattack: ["2E"],
			fly: ["2M", "1M"],
			foresight: ["2E"],
			frustration: ["2M"],
			gust: ["2L9", "1L1"],
			hiddenpower: ["2M"],
			mimic: ["1M"],
			mirrormove: ["2L47", "1L44"],
			mudslap: ["2M"],
			protect: ["2M"],
			pursuit: ["2E"],
			quickattack: ["2L15", "1L12"],
			rage: ["1M"],
			razorwind: ["1M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			sandattack: ["2L5", "1L5"],
			skyattack: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			steelwing: ["2M", "2E"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			tackle: ["2L1"],
			takedown: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
			whirlwind: ["2L21", "1M", "1L19"],
			wingattack: ["2L29", "1L28"],
		},
		encounters: [
			{generation: 1, level: 2},
			{generation: 2, level: 2},
		],
	},
	pidgeotto: {
		learnset: {
			agility: ["2L43", "1L40"],
			attract: ["2M"],
			bide: ["1M"],
			curse: ["2M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			fly: ["2M", "1M"],
			frustration: ["2M"],
			gust: ["2L9", "2L1", "1L1"],
			hiddenpower: ["2M"],
			mimic: ["1M"],
			mirrormove: ["2L55", "1L49"],
			mudslap: ["2M"],
			protect: ["2M"],
			quickattack: ["2L15", "1L12"],
			rage: ["1M"],
			razorwind: ["1M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			sandattack: ["2L5", "2L1", "1L5", "1L1"],
			skyattack: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			steelwing: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			tackle: ["2L1"],
			takedown: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
			whirlwind: ["2L23", "1M", "1L21"],
			wingattack: ["2L33", "1L31"],
		},
		encounters: [
			{generation: 1, level: 9},
			{generation: 2, level: 7},
		],
	},
	pidgeot: {
		learnset: {
			agility: ["2L46", "1L44"],
			attract: ["2M"],
			bide: ["1M"],
			curse: ["2M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			fly: ["2M", "1M"],
			frustration: ["2M"],
			gust: ["2L9", "2L1", "1L1"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			mimic: ["1M"],
			mirrormove: ["2L61", "1L54"],
			mudslap: ["2M"],
			protect: ["2M"],
			quickattack: ["2L15", "2L1", "1L12", "1L1"],
			rage: ["1M"],
			razorwind: ["1M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			sandattack: ["2L5", "2L1", "1L5", "1L1"],
			skyattack: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			steelwing: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			tackle: ["2L1"],
			takedown: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
			whirlwind: ["2L23", "1M", "1L21"],
			wingattack: ["2L33", "1L31"],
		},
	},
	rattata: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bite: ["2E"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubblebeam: ["1M"],
			counter: ["2E"],
			curse: ["2M"],
			defensecurl: ["2M"],
			dig: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			flamewheel: ["2E"],
			focusenergy: ["2L20", "1L23"],
			frustration: ["2M"],
			furyswipes: ["2E"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperfang: ["2L13", "1L14"],
			icywind: ["2M"],
			irontail: ["2M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			protect: ["2M"],
			pursuit: ["2L27"],
			quickattack: ["2L7", "1L7"],
			rage: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			reversal: ["2E"],
			rocksmash: ["2M"],
			screech: ["2E"],
			shadowball: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			superfang: ["2L34", "1L34"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			tackle: ["2L1", "1L1"],
			tailwhip: ["2L1", "1L1"],
			takedown: ["1M"],
			thief: ["2M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["1M"],
			toxic: ["2M", "1M"],
			watergun: ["1M"],
		},
		encounters: [
			{generation: 1, level: 2},
			{generation: 2, level: 2},
		],
	},
	raticate: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubblebeam: ["1M"],
			curse: ["2M"],
			cut: ["2M"],
			defensecurl: ["2M"],
			dig: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			focusenergy: ["1L27"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			hyperfang: ["2L13", "1L14"],
			icebeam: ["2T", "1M"],
			icywind: ["2M"],
			irontail: ["2M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			protect: ["2M"],
			pursuit: ["2L30"],
			quickattack: ["2L7", "2L1", "1L7", "1L1"],
			rage: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			roar: ["2M"],
			rocksmash: ["2M"],
			scaryface: ["2L20"],
			shadowball: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			superfang: ["2L40", "1L41"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			tackle: ["2L1", "1L1"],
			tailwhip: ["2L1", "1L1"],
			takedown: ["1M"],
			thief: ["2M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			toxic: ["2M", "1M"],
			watergun: ["1M"],
		},
		encounters: [
			{generation: 1, level: 15},
			{generation: 2, level: 6},
		],
	},
	spearow: {
		learnset: {
			agility: ["2L43", "1L36"],
			attract: ["2M"],
			bide: ["1M"],
			curse: ["2M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			drillpeck: ["2L37", "1L29"],
			endure: ["2M"],
			feintattack: ["2E"],
			falseswipe: ["2E"],
			fly: ["2M", "1M"],
			frustration: ["2M"],
			furyattack: ["2L13", "1L15"],
			growl: ["2L1", "2S0", "1L1"],
			hiddenpower: ["2M"],
			leer: ["2L7", "1L9"],
			mimic: ["1M"],
			mirrormove: ["2L31", "1L22"],
			mudslap: ["2M"],
			peck: ["2L1", "2S0", "1L1"],
			protect: ["2M"],
			pursuit: ["2L25"],
			quickattack: ["2E"],
			rage: ["1M"],
			razorwind: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			scaryface: ["2E"],
			skyattack: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			sonicboom: ["2S0"],
			steelwing: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			takedown: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
			triattack: ["2E"],
			whirlwind: ["1M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["peck", "growl", "sonicboom"]},
		],
		encounters: [
			{generation: 1, level: 3},
			{generation: 2, level: 2},
		],
	},
	fearow: {
		learnset: {
			agility: ["2L47", "1L43"],
			attract: ["2M"],
			bide: ["1M"],
			curse: ["2M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			drillpeck: ["2L40", "1L34"],
			endure: ["2M"],
			fly: ["2M", "1M"],
			frustration: ["2M"],
			furyattack: ["2L13", "2L1", "1L15", "1S0"],
			growl: ["2L1", "1L1", "1S0"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			leer: ["2L7", "2L1", "1L9", "1L1", "1S0"],
			mimic: ["1M"],
			mirrormove: ["2L32", "1L25"],
			mudslap: ["2M"],
			payday: ["1S0"],
			peck: ["2L1", "1L1"],
			protect: ["2M"],
			pursuit: ["2L26"],
			rage: ["1M"],
			razorwind: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			skyattack: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			steelwing: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			takedown: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
			whirlwind: ["1M"],
		},
		eventData: [
			{generation: 1, level: 20, moves: ["growl", "leer", "furyattack", "payday"], japan: true},
		],
		encounters: [
			{generation: 1, level: 19},
			{generation: 2, level: 7},
		],
	},
	ekans: {
		learnset: {
			acid: ["2L37", "1L38"],
			attract: ["2M"],
			beatup: ["2E"],
			bide: ["1M"],
			bite: ["2L15", "1L17"],
			bodyslam: ["1M"],
			crunch: ["2E"],
			curse: ["2M"],
			dig: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			earthquake: ["2M", "1M"],
			endure: ["2M"],
			fissure: ["1M"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			glare: ["2L23", "1L24"],
			haze: ["2L43"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			leer: ["2L1", "1L1"],
			megadrain: ["1M"],
			mimic: ["1M"],
			poisonsting: ["2L9", "1L10"],
			protect: ["2M"],
			pursuit: ["2E"],
			rage: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rockslide: ["1M"],
			screech: ["2L29", "1L31"],
			skullbash: ["1M"],
			slam: ["2E"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			snore: ["2M"],
			spite: ["2E"],
			strength: ["2M", "1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			takedown: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
			wrap: ["2L1", "1L1"],
		},
	},
	arbok: {
		learnset: {
			acid: ["2L43", "1L47"],
			attract: ["2M"],
			bide: ["1M"],
			bite: ["2L15", "2L1", "1L17"],
			bodyslam: ["1M"],
			curse: ["2M"],
			dig: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			earthquake: ["2M", "1M"],
			endure: ["2M"],
			fissure: ["1M"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			glare: ["2L25", "1L27"],
			haze: ["2L51"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			leer: ["2L1", "1L1"],
			megadrain: ["1M"],
			mimic: ["1M"],
			poisonsting: ["2L9", "2L1", "1L10", "1L1"],
			protect: ["2M"],
			rage: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rockslide: ["1M"],
			screech: ["2L33", "1L36"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			snore: ["2M"],
			strength: ["2M", "1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			takedown: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
			wrap: ["2L1", "1L1"],
		},
		encounters: [
			{generation: 2, level: 10},
		],
	},
	pichu: {
		learnset: {
			attract: ["2M"],
			bide: ["2E"],
			charm: ["2L1", "2S3", "2S2", "2S1", "2S0"],
			curse: ["2M"],
			defensecurl: ["2M"],
			detect: ["2M"],
			dizzypunch: ["2S0"],
			doubleslap: ["2E"],
			doubleteam: ["2M"],
			encore: ["2E"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			irontail: ["2M"],
			mudslap: ["2M"],
			petaldance: ["2S1"],
			present: ["2E"],
			protect: ["2M"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			reversal: ["2E"],
			rollout: ["2M"],
			scaryface: ["2S2"],
			sing: ["2S3"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			swagger: ["2M"],
			sweetkiss: ["2L11"],
			swift: ["2M"],
			tailwhip: ["2L6"],
			thunder: ["2M"],
			thunderbolt: ["2T"],
			thundershock: ["2L1", "2S3", "2S2", "2S1", "2S0"],
			thunderwave: ["2L8"],
			toxic: ["2M"],
			zapcannon: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["thundershock", "charm", "dizzypunch"]},
			{generation: 2, level: 5, shiny: 1, moves: ["thundershock", "charm", "petaldance"]},
			{generation: 2, level: 5, shiny: 1, moves: ["thundershock", "charm", "scaryface"]},
			{generation: 2, level: 5, shiny: 1, moves: ["thundershock", "charm", "sing"]},
		],
	},
	pikachu: {
		learnset: {
			agility: ["2L33", "1L33"],
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			curse: ["2M"],
			defensecurl: ["2M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "2L15", "1M", "1L15"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			flash: ["2M", "1M"],
			fly: ["1S1"],
			frustration: ["2M"],
			growl: ["2L1", "1L1", "1S2"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			irontail: ["2M"],
			lightscreen: ["2L50", "1L50"],
			megakick: ["1M"],
			megapunch: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			payday: ["1M"],
			protect: ["2M"],
			quickattack: ["2L11", "1L11", "1L16"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rollout: ["2M"],
			seismictoss: ["1M"],
			skullbash: ["1M"],
			slam: ["2L20", "1L20"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M"],
			submission: ["1M"],
			substitute: ["1M"],
			surf: ["1T", "1S2", "1S0"],
			swagger: ["2M"],
			swift: ["2M", "1M", "1L26"],
			tailwhip: ["2L6", "1L6"],
			takedown: ["1M"],
			thunder: ["2M", "2L41", "1M", "1L41", "1L43"],
			thunderbolt: ["2T", "2L26", "1M", "1L26"],
			thunderpunch: ["2M"],
			thundershock: ["2L1", "1L1", "1S2"],
			thunderwave: ["2L8", "1M", "1L8", "1L9"],
			toxic: ["2M", "1M"],
			zapcannon: ["2M"],
		},
		eventData: [
			{generation: 1, level: 5, moves: ["surf"]},
			{generation: 1, level: 5, moves: ["fly"], japan: true},
			{generation: 1, level: 5, moves: ["thundershock", "growl", "surf"]},
		],
		encounters: [
			{generation: 1, level: 3},
			{generation: 2, level: 4},
		],
	},
	raichu: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			curse: ["2M"],
			defensecurl: ["2M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			flash: ["2M", "1M"],
			frustration: ["2M"],
			growl: ["1L1"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			irontail: ["2M"],
			megakick: ["1M"],
			megapunch: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			payday: ["1M"],
			protect: ["2M"],
			quickattack: ["2L1"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rollout: ["2M"],
			seismictoss: ["1M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M"],
			submission: ["1M"],
			substitute: ["1M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			tailwhip: ["2L1"],
			takedown: ["1M"],
			thief: ["2M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "2L1", "1M"],
			thunderpunch: ["2M"],
			thundershock: ["2L1", "1L1"],
			thunderwave: ["1M", "1L1"],
			toxic: ["2M", "1M"],
			zapcannon: ["2M"],
		},
	},
	sandshrew: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			counter: ["2E"],
			curse: ["2M"],
			cut: ["2M", "1M"],
			defensecurl: ["2M", "2L6"],
			detect: ["2M"],
			dig: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dynamicpunch: ["2M"],
			earthquake: ["2M", "1M"],
			endure: ["2M"],
			fissure: ["1M"],
			flail: ["2E"],
			frustration: ["2M"],
			furycutter: ["2M"],
			furyswipes: ["2L37", "1L38"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			irontail: ["2M"],
			metalclaw: ["2E"],
			mimic: ["1M"],
			mudslap: ["2M"],
			poisonsting: ["2L17", "1L24"],
			protect: ["2M"],
			rage: ["1M"],
			rapidspin: ["2E"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rockslide: ["1M"],
			rocksmash: ["2M"],
			rollout: ["2M"],
			safeguard: ["2E"],
			sandattack: ["2L11", "1L10"],
			sandstorm: ["2M", "2L45"],
			scratch: ["2L1", "1L1"],
			seismictoss: ["1M"],
			skullbash: ["1M"],
			slash: ["2L23", "1L17"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "2L30", "1M", "1L31"],
			swordsdance: ["1M"],
			takedown: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
		},
		encounters: [
			{generation: 1, level: 6},
		],
	},
	sandslash: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			curse: ["2M"],
			cut: ["2M", "1M"],
			defensecurl: ["2M", "2L6", "2L1"],
			detect: ["2M"],
			dig: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dynamicpunch: ["2M"],
			earthquake: ["2M", "1M"],
			endure: ["2M"],
			fissure: ["1M"],
			frustration: ["2M"],
			furycutter: ["2M"],
			furyswipes: ["2L42", "1L47"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			irontail: ["2M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			poisonsting: ["2L17", "1L27"],
			protect: ["2M"],
			rage: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rockslide: ["1M"],
			rocksmash: ["2M"],
			rollout: ["2M"],
			sandattack: ["2L11", "2L1", "1L10", "1L1"],
			sandstorm: ["2M", "2L52"],
			scratch: ["2L1", "1L1"],
			seismictoss: ["1M"],
			skullbash: ["1M"],
			slash: ["2L24", "1L17"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "2L33", "1M", "1L36"],
			swordsdance: ["1M"],
			takedown: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
		},
		encounters: [
			{generation: 2, level: 10},
		],
	},
	nidoranf: {
		learnset: {
			attract: ["2M"],
			beatup: ["2E"],
			bide: ["1M"],
			bite: ["2L30", "1L30", "1L29"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			charm: ["2E"],
			counter: ["2E"],
			curse: ["2M"],
			defensecurl: ["2M"],
			detect: ["2M"],
			disable: ["2E"],
			doubleedge: ["1M"],
			doublekick: ["2L12", "1L12", "1L43"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			focusenergy: ["2E"],
			frustration: ["2M"],
			furyswipes: ["2L38", "1L38", "1L36"],
			growl: ["2L1", "2S2", "2S1", "2S0", "1L1"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			irontail: ["2M"],
			lovelykiss: ["2S0"],
			mimic: ["1M"],
			moonlight: ["2S1"],
			mudslap: ["2M"],
			poisonsting: ["2L17", "1L17", "1L14"],
			protect: ["2M"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			scratch: ["2L8", "1L8"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			supersonic: ["2E"],
			swagger: ["2M"],
			sweetkiss: ["2S2"],
			tackle: ["2L1", "2S2", "2S1", "2S0", "1L1"],
			tailwhip: ["2L23", "1L23", "1L21"],
			takedown: ["2E", "1M"],
			thief: ["2M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			toxic: ["2M", "1M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["growl", "tackle", "lovelykiss"]},
			{generation: 2, level: 5, shiny: 1, moves: ["growl", "tackle", "moonlight"]},
			{generation: 2, level: 5, shiny: 1, moves: ["growl", "tackle", "sweetkiss"]},
		],
		encounters: [
			{generation: 1, level: 2},
		],
	},
	nidorina: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bite: ["2L36", "1L36", "1L32"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubblebeam: ["1M"],
			curse: ["2M"],
			defensecurl: ["2M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doublekick: ["2L12", "1L12", "1L50"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			frustration: ["2M"],
			furyswipes: ["2L46", "1L46", "1L41"],
			growl: ["2L1", "1L1"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			horndrill: ["1M"],
			icebeam: ["2T", "1M"],
			irontail: ["2M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			poisonsting: ["2L19", "1L19", "1L14"],
			protect: ["2M"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rocksmash: ["2M"],
			scratch: ["2L8", "1L8", "1L1"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			tackle: ["2L1", "1L1"],
			tailwhip: ["2L27", "1L27", "1L23"],
			takedown: ["1M"],
			thief: ["2M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			toxic: ["2M", "1M"],
			watergun: ["1M"],
		},
	},
	nidoqueen: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["2L23", "1M", "1L23", "1L1"],
			bubblebeam: ["1M"],
			counter: ["1M"],
			curse: ["2M"],
			defensecurl: ["2M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doublekick: ["2L1", "1L12"],
			doubleteam: ["2M", "1M"],
			dynamicpunch: ["2M"],
			earthquake: ["2M", "1M"],
			endure: ["2M"],
			fireblast: ["2M", "1M"],
			firepunch: ["2M"],
			fissure: ["1M"],
			flamethrower: ["2T"],
			frustration: ["2M"],
			furycutter: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			horndrill: ["1M"],
			hyperbeam: ["2M", "1M"],
			icebeam: ["2T", "1M"],
			icepunch: ["2M"],
			icywind: ["2M"],
			irontail: ["2M"],
			megakick: ["1M"],
			megapunch: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			payday: ["1M"],
			poisonsting: ["1L14"],
			protect: ["2M"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			roar: ["2M"],
			rockslide: ["1M"],
			rocksmash: ["2M"],
			sandstorm: ["2M"],
			scratch: ["2L1", "1L8", "1L1"],
			seismictoss: ["1M"],
			shadowball: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			tackle: ["2L1", "1L1"],
			tailwhip: ["2L1", "1L1"],
			takedown: ["1M"],
			thief: ["2M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			thunderpunch: ["2M"],
			toxic: ["2M", "1M"],
			watergun: ["1M"],
		},
	},
	nidoranm: {
		learnset: {
			amnesia: ["2E"],
			attract: ["2M"],
			beatup: ["2E"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			confusion: ["2E"],
			counter: ["2E"],
			curse: ["2M"],
			defensecurl: ["2M"],
			detect: ["2M"],
			disable: ["2E"],
			doubleedge: ["1M"],
			doublekick: ["2L12", "1L12", "1L43"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			focusenergy: ["2L23", "1L23", "1L21"],
			frustration: ["2M"],
			furyattack: ["2L30", "1L30", "1L29"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hornattack: ["2L8", "1L8"],
			horndrill: ["2L38", "1M", "1L38", "1L36"],
			irontail: ["2M"],
			leer: ["2L1", "2S2", "2S1", "2S0", "1L1"],
			lovelykiss: ["2S0"],
			mimic: ["1M"],
			morningsun: ["2S1"],
			mudslap: ["2M"],
			poisonsting: ["2L17", "1L17", "1L14"],
			protect: ["2M"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			supersonic: ["2E"],
			swagger: ["2M"],
			sweetkiss: ["2S2"],
			tackle: ["2L1", "2S2", "2S1", "2S0", "1L1"],
			takedown: ["2E", "1M"],
			thief: ["2M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			toxic: ["2M", "1M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["leer", "tackle", "lovelykiss"]},
			{generation: 2, level: 5, shiny: 1, moves: ["leer", "tackle", "morningsun"]},
			{generation: 2, level: 5, shiny: 1, moves: ["leer", "tackle", "sweetkiss"]},
		],
		encounters: [
			{generation: 1, level: 2},
		],
	},
	nidorino: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubblebeam: ["1M"],
			curse: ["2M"],
			defensecurl: ["2M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doublekick: ["2L12", "1L12", "1L50"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			focusenergy: ["2L27", "1L27", "1L23"],
			frustration: ["2M"],
			furyattack: ["2L36", "1L36", "1L32"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hornattack: ["2L8", "1L8", "1L1"],
			horndrill: ["2L46", "1M", "1L46", "1L41"],
			icebeam: ["2T", "1M"],
			irontail: ["2M"],
			leer: ["2L1", "1L1"],
			mimic: ["1M"],
			mudslap: ["2M"],
			poisonsting: ["2L19", "1L19", "1L14"],
			protect: ["2M"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rocksmash: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			tackle: ["2L1", "1L1"],
			takedown: ["1M"],
			thief: ["2M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			toxic: ["2M", "1M"],
			watergun: ["1M"],
		},
	},
	nidoking: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubblebeam: ["1M"],
			counter: ["1M"],
			curse: ["2M"],
			defensecurl: ["2M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doublekick: ["2L1", "1L12"],
			doubleteam: ["2M", "1M"],
			dynamicpunch: ["2M"],
			earthquake: ["2M", "1M"],
			endure: ["2M"],
			fireblast: ["2M", "1M"],
			firepunch: ["2M"],
			fissure: ["1M"],
			flamethrower: ["2T"],
			frustration: ["2M"],
			furycutter: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hornattack: ["2L1", "1L8", "1L1"],
			horndrill: ["1M"],
			hyperbeam: ["2M", "1M"],
			icebeam: ["2T", "1M"],
			icepunch: ["2M"],
			icywind: ["2M"],
			irontail: ["2M"],
			megakick: ["1M"],
			megapunch: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			payday: ["1M"],
			poisonsting: ["2L1", "1L14", "1L1"],
			protect: ["2M"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			roar: ["2M"],
			rockslide: ["1M"],
			rocksmash: ["2M"],
			sandstorm: ["2M"],
			seismictoss: ["1M"],
			shadowball: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			tackle: ["2L1", "1L1"],
			takedown: ["1M"],
			thief: ["2M"],
			thrash: ["2L23", "1L23", "1L1"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			thunderpunch: ["2M"],
			toxic: ["2M", "1M"],
			watergun: ["1M"],
		},
	},
	cleffa: {
		learnset: {
			amnesia: ["2E"],
			attract: ["2M"],
			bellydrum: ["2E"],
			charm: ["2L1", "2S3", "2S2", "2S1", "2S0"],
			curse: ["2M"],
			defensecurl: ["2M"],
			detect: ["2M"],
			dizzypunch: ["2S3"],
			doubleteam: ["2M"],
			dreameater: ["2M"],
			encore: ["2L4", "2S3", "2S2", "2S1", "2S0"],
			endure: ["2M"],
			fireblast: ["2M"],
			flamethrower: ["2T"],
			flash: ["2M"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			icywind: ["2M"],
			irontail: ["2M"],
			metronome: ["2E"],
			mimic: ["2E"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			petaldance: ["2S0"],
			pound: ["2L1", "2S3", "2S2", "2S1", "2S0"],
			present: ["2E"],
			protect: ["2M"],
			psychic: ["2M"],
			psychup: ["2M"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			rollout: ["2M"],
			scaryface: ["2S1"],
			shadowball: ["2M"],
			sing: ["2L8"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M"],
			splash: ["2E"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			sweetkiss: ["2L13"],
			swift: ["2S2"],
			toxic: ["2M"],
			zapcannon: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["pound", "charm", "encore", "petaldance"]},
			{generation: 2, level: 5, shiny: 1, moves: ["pound", "charm", "encore", "scaryface"]},
			{generation: 2, level: 5, shiny: 1, moves: ["pound", "charm", "encore", "swift"]},
			{generation: 2, level: 5, shiny: 1, moves: ["pound", "charm", "encore", "dizzypunch"]},
		],
	},
	clefairy: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubblebeam: ["1M"],
			counter: ["1M"],
			curse: ["2M"],
			defensecurl: ["2M", "2L26", "1L39"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doubleslap: ["2L13", "1L18"],
			doubleteam: ["2M", "1M"],
			dreameater: ["2M"],
			dynamicpunch: ["2M"],
			encore: ["2L4"],
			endure: ["2M"],
			fireblast: ["2M", "1M"],
			firepunch: ["2M"],
			flamethrower: ["2T"],
			flash: ["2M", "1M"],
			frustration: ["2M"],
			growl: ["2L1", "1L1"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			icebeam: ["2T", "1M"],
			icepunch: ["2M"],
			irontail: ["2M"],
			lightscreen: ["2L53", "1L48"],
			megakick: ["1M"],
			megapunch: ["1M"],
			metronome: ["2L34", "1M", "1L31"],
			mimic: ["1M"],
			minimize: ["2L19", "1L24"],
			moonlight: ["2L43"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			pound: ["2L1", "1L1"],
			protect: ["2M"],
			psychic: ["2M", "1M"],
			psychup: ["2M"],
			psywave: ["1M"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rollout: ["2M"],
			seismictoss: ["1M"],
			shadowball: ["2M"],
			sing: ["2L8", "1L13"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M", "1M"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			takedown: ["1M"],
			teleport: ["1M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			thunderpunch: ["2M"],
			thunderwave: ["1M"],
			toxic: ["2M", "1M"],
			triattack: ["1M"],
			watergun: ["1M"],
			zapcannon: ["2M"],
		},
		encounters: [
			{generation: 1, level: 8},
		],
	},
	clefable: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubblebeam: ["1M"],
			counter: ["1M"],
			curse: ["2M"],
			defensecurl: ["2M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doubleslap: ["2L1", "1L1"],
			doubleteam: ["2M", "1M"],
			dreameater: ["2M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			fireblast: ["2M", "1M"],
			firepunch: ["2M"],
			flamethrower: ["2T"],
			flash: ["2M", "1M"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			icebeam: ["2T", "1M"],
			icepunch: ["2M"],
			irontail: ["2M"],
			megakick: ["1M"],
			megapunch: ["1M"],
			metronome: ["2L1", "1M", "1L1"],
			mimic: ["1M"],
			minimize: ["1L1"],
			moonlight: ["2L1"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			protect: ["2M"],
			psychic: ["2M", "1M"],
			psychup: ["2M"],
			psywave: ["1M"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rollout: ["2M"],
			seismictoss: ["1M"],
			shadowball: ["2M"],
			sing: ["2L1", "1L1"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M", "1M"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			takedown: ["1M"],
			teleport: ["1M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			thunderpunch: ["2M"],
			thunderwave: ["1M"],
			toxic: ["2M", "1M"],
			triattack: ["1M"],
			watergun: ["1M"],
			zapcannon: ["2M"],
		},
	},
	vulpix: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			confuseray: ["2L19", "1L28"],
			curse: ["2M"],
			dig: ["2M", "1M"],
			disable: ["2E"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			ember: ["2L1", "1L1"],
			endure: ["2M"],
			feintattack: ["2E"],
			fireblast: ["2M", "1M"],
			firespin: ["2L37", "1L42"],
			flail: ["2E"],
			flamethrower: ["2T", "2L31", "1L35"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hypnosis: ["2E"],
			irontail: ["2M"],
			mimic: ["1M"],
			protect: ["2M"],
			quickattack: ["2L7", "1L16"],
			rage: ["1M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			roar: ["2L13", "1L21"],
			safeguard: ["2L25"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			spite: ["2E"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			tailwhip: ["2L1", "1L1"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
		},
		encounters: [
			{generation: 1, level: 18},
			{generation: 1, level: 15},
		],
	},
	ninetales: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			confuseray: ["2L1"],
			curse: ["2M"],
			dig: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			ember: ["2L1", "1L1"],
			endure: ["2M"],
			fireblast: ["2M", "1M"],
			firespin: ["2L43"],
			flamethrower: ["2T"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			irontail: ["2M"],
			mimic: ["1M"],
			protect: ["2M"],
			quickattack: ["2L1", "1L1"],
			rage: ["1M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			roar: ["2M", "1L1"],
			safeguard: ["2L1"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			tailwhip: ["1L1"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
		},
	},
	igglybuff: {
		learnset: {
			attract: ["2M"],
			charm: ["2L1", "2S3", "2S2", "2S1", "2S0"],
			curse: ["2M"],
			defensecurl: ["2M", "2L4", "2S3", "2S2", "2S1", "2S0"],
			detect: ["2M"],
			dizzypunch: ["2S3"],
			doubleteam: ["2M"],
			dreameater: ["2M"],
			endure: ["2M"],
			feintattack: ["2E"],
			fireblast: ["2M"],
			flamethrower: ["2T"],
			flash: ["2M"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			icywind: ["2M"],
			mimic: ["2S0"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			perishsong: ["2E"],
			petaldance: ["2S1"],
			pound: ["2L9"],
			present: ["2E"],
			protect: ["2M"],
			psychic: ["2M"],
			psychup: ["2M"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			rollout: ["2M"],
			scaryface: ["2S2"],
			shadowball: ["2M"],
			sing: ["2L1", "2S3", "2S2", "2S1", "2S0"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			sweetkiss: ["2L14"],
			toxic: ["2M"],
			zapcannon: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["sing", "charm", "defensecurl", "mimic"]},
			{generation: 2, level: 5, shiny: 1, moves: ["sing", "charm", "defensecurl", "petaldance"]},
			{generation: 2, level: 5, shiny: 1, moves: ["sing", "charm", "defensecurl", "scaryface"]},
			{generation: 2, level: 5, shiny: 1, moves: ["sing", "charm", "defensecurl", "dizzypunch"]},
		],
	},
	jigglypuff: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["2L34", "1M", "1L34"],
			bubblebeam: ["1M"],
			counter: ["1M"],
			curse: ["2M"],
			defensecurl: ["2M", "2L4", "1L19"],
			detect: ["2M"],
			disable: ["2L14", "1L14"],
			doubleedge: ["2L39", "1M", "1L39"],
			doubleslap: ["2L24", "1L24"],
			doubleteam: ["2M", "1M"],
			dreameater: ["2M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			fireblast: ["2M", "1M"],
			firepunch: ["2M"],
			flamethrower: ["2T"],
			flash: ["2M", "1M"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			icebeam: ["2T", "1M"],
			icepunch: ["2M"],
			megakick: ["1M"],
			megapunch: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			pound: ["2L9", "1L9"],
			protect: ["2M"],
			psychic: ["2M", "1M"],
			psychup: ["2M"],
			psywave: ["1M"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "2L29", "1M", "1L29"],
			return: ["2M"],
			rollout: ["2M", "2L19"],
			seismictoss: ["1M"],
			shadowball: ["2M"],
			sing: ["2L1", "1L1"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M", "1M"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			takedown: ["1M"],
			teleport: ["1M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			thunderpunch: ["2M"],
			thunderwave: ["1M"],
			toxic: ["2M", "1M"],
			triattack: ["1M"],
			watergun: ["1M"],
			zapcannon: ["2M"],
		},
		encounters: [
			{generation: 1, level: 3},
			{generation: 2, level: 3},
		],
	},
	wigglytuff: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubblebeam: ["1M"],
			counter: ["1M"],
			curse: ["2M"],
			defensecurl: ["2M", "2L1", "1L1"],
			detect: ["2M"],
			disable: ["2L1", "1L1"],
			doubleedge: ["1M"],
			doubleslap: ["2L1", "1L1"],
			doubleteam: ["2M", "1M"],
			dreameater: ["2M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			fireblast: ["2M", "1M"],
			firepunch: ["2M"],
			flamethrower: ["2T"],
			flash: ["2M", "1M"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			icebeam: ["2T", "1M"],
			icepunch: ["2M"],
			megakick: ["1M"],
			megapunch: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			protect: ["2M"],
			psychic: ["2M", "1M"],
			psychup: ["2M"],
			psywave: ["1M"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rollout: ["2M"],
			seismictoss: ["1M"],
			shadowball: ["2M"],
			sing: ["2L1", "1L1"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M", "1M"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			takedown: ["1M"],
			teleport: ["1M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			thunderpunch: ["2M"],
			thunderwave: ["1M"],
			toxic: ["2M", "1M"],
			triattack: ["1M"],
			watergun: ["1M"],
			zapcannon: ["2M"],
		},
		encounters: [
			{generation: 1, level: 22},
			{generation: 1, level: 3},
		],
	},
	zubat: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bite: ["2L12", "1L15"],
			confuseray: ["2L19", "1L21"],
			curse: ["2M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			feintattack: ["2E"],
			flail: ["2S0"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			gust: ["2E"],
			haze: ["2L46", "1L36"],
			hiddenpower: ["2M"],
			leechlife: ["2L1", "2S0", "1L1"],
			meanlook: ["2L36"],
			megadrain: ["1M"],
			mimic: ["1M"],
			protect: ["2M"],
			pursuit: ["2E"],
			quickattack: ["2E"],
			rage: ["1M"],
			razorwind: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			steelwing: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			supersonic: ["2L6", "1L10"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			takedown: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
			whirlwind: ["2E", "1M"],
			wingattack: ["2L27", "1L28"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["leechlife", "flail"]},
		],
		encounters: [
			{generation: 1, level: 6},
			{generation: 2, level: 2},
		],
	},
	golbat: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bite: ["2L12", "1L15", "1L1"],
			confuseray: ["2L19", "1L21"],
			curse: ["2M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			haze: ["2L55", "1L43"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			leechlife: ["2L1", "1L1"],
			meanlook: ["2L42"],
			megadrain: ["1M"],
			mimic: ["1M"],
			protect: ["2M"],
			rage: ["1M"],
			razorwind: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			screech: ["2L1", "1L1"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			steelwing: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			supersonic: ["2L6", "2L1", "1L10"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			takedown: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
			whirlwind: ["1M"],
			wingattack: ["2L30", "1L32"],
		},
		encounters: [
			{generation: 2, level: 13},
		],
	},
	crobat: {
		learnset: {
			attract: ["2M"],
			bite: ["2L12"],
			confuseray: ["2L19"],
			curse: ["2M"],
			detect: ["2M"],
			doubleteam: ["2M"],
			endure: ["2M"],
			fly: ["2M"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			haze: ["2L55"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			leechlife: ["2L1"],
			meanlook: ["2L42"],
			protect: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			screech: ["2L1"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			steelwing: ["2M"],
			sunnyday: ["2M"],
			supersonic: ["2L6", "2L1"],
			swagger: ["2M"],
			swift: ["2M"],
			thief: ["2M"],
			toxic: ["2M"],
			wingattack: ["2L30"],
		},
	},
	oddish: {
		learnset: {
			absorb: ["2L1", "2S0", "1L1"],
			acid: ["2L23", "1L24"],
			attract: ["2M"],
			bide: ["1M"],
			curse: ["2M"],
			cut: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			flail: ["2E"],
			flash: ["2M"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			hiddenpower: ["2M"],
			leechseed: ["2S0"],
			megadrain: ["1M"],
			mimic: ["1M"],
			moonlight: ["2L32"],
			petaldance: ["2L39", "1L33"],
			poisonpowder: ["2L14", "1L15"],
			protect: ["2M"],
			rage: ["1M"],
			razorleaf: ["2E"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			sleeppowder: ["2L18", "1L19"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M", "1M", "1L46"],
			stunspore: ["2L16", "1L17"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			sweetscent: ["2M", "2L7"],
			swordsdance: ["2E", "1M"],
			synthesis: ["2E"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["absorb", "leechseed"]},
		],
		encounters: [
			{generation: 1, level: 12},
		],
	},
	gloom: {
		learnset: {
			absorb: ["2L1", "1L1"],
			acid: ["2L24", "1L28"],
			attract: ["2M"],
			bide: ["1M"],
			curse: ["2M"],
			cut: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			hiddenpower: ["2M"],
			megadrain: ["1M"],
			mimic: ["1M"],
			moonlight: ["2L35"],
			petaldance: ["2L44", "1L38"],
			poisonpowder: ["2L14", "2L1", "1L15", "1L1"],
			protect: ["2M"],
			rage: ["1M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			sleeppowder: ["2L18", "1L19"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M", "1M", "1L52"],
			stunspore: ["2L16", "1L17", "1L1"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			sweetscent: ["2M", "2L7", "2L1"],
			swordsdance: ["1M"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
		},
		encounters: [
			{generation: 2, level: 14},
		],
	},
	vileplume: {
		learnset: {
			absorb: ["2L1"],
			acid: ["1L1"],
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			curse: ["2M"],
			cut: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			megadrain: ["1M"],
			mimic: ["1M"],
			petaldance: ["2L1", "1L1"],
			poisonpowder: ["1L15"],
			protect: ["2M"],
			rage: ["1M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			sleeppowder: ["1L19", "1L1"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M", "1M"],
			stunspore: ["2L1", "1L17", "1L1"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			sweetscent: ["2M", "2L1"],
			swordsdance: ["1M"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
		},
	},
	paras: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			counter: ["2E"],
			curse: ["2M"],
			cut: ["2M", "1M"],
			dig: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			falseswipe: ["2E"],
			flail: ["2E"],
			flash: ["2M"],
			frustration: ["2M"],
			furycutter: ["2M"],
			gigadrain: ["2M", "2L43"],
			growth: ["2L37", "1L41"],
			hiddenpower: ["2M"],
			leechlife: ["2L19", "1L20"],
			lightscreen: ["2E"],
			megadrain: ["1M"],
			mimic: ["1M"],
			poisonpowder: ["2L13"],
			protect: ["2M"],
			psybeam: ["2E"],
			pursuit: ["2E"],
			rage: ["1M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rocksmash: ["2M"],
			scratch: ["2L1", "2S0", "1L1"],
			screech: ["2E"],
			skullbash: ["1M"],
			slash: ["2L31", "1L34"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M", "1M"],
			spore: ["2L25", "1L27"],
			stunspore: ["2L7", "1L13"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			sweetscent: ["2M", "2E"],
			swordsdance: ["1M"],
			synthesis: ["2S0"],
			takedown: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["scratch", "synthesis"]},
		],
		encounters: [
			{generation: 1, level: 8},
		],
	},
	parasect: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			curse: ["2M"],
			cut: ["2M", "1M"],
			dig: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			furycutter: ["2M"],
			gigadrain: ["2M", "2L55"],
			growth: ["2L46", "1L48"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			leechlife: ["2L19", "1L20", "1L1"],
			megadrain: ["1M"],
			mimic: ["1M"],
			poisonpowder: ["2L13", "2L1"],
			protect: ["2M"],
			rage: ["1M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rocksmash: ["2M"],
			scratch: ["2L1", "1L1"],
			skullbash: ["1M"],
			slash: ["2L37", "1L39"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M", "1M"],
			spore: ["2L28", "1L30"],
			stunspore: ["2L7", "2L1", "1L13", "1L1"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			sweetscent: ["2M"],
			swordsdance: ["1M"],
			takedown: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
		},
		encounters: [
			{generation: 1, level: 13},
			{generation: 2, level: 5},
		],
	},
	venonat: {
		learnset: {
			attract: ["2M"],
			batonpass: ["2E"],
			bide: ["1M"],
			confusion: ["2L17", "1L19"],
			curse: ["2M"],
			disable: ["2L1", "1L1"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			flash: ["1M"],
			foresight: ["2L1"],
			frustration: ["2M"],
			gigadrain: ["2M", "2E"],
			hiddenpower: ["2M"],
			leechlife: ["2L25", "1L27"],
			megadrain: ["1M"],
			mimic: ["1M"],
			poisonpowder: ["2L20", "1L22", "1L24"],
			protect: ["2M"],
			psybeam: ["2L33", "1L35"],
			psychic: ["2M", "2L41", "1M", "1L43"],
			psywave: ["1M"],
			rage: ["1M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			screech: ["2E"],
			sleeppowder: ["2L36", "1L38"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M", "1M"],
			stunspore: ["2L28", "1L30"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			supersonic: ["2L9", "1L11"],
			swagger: ["2M"],
			sweetscent: ["2M"],
			swift: ["2M"],
			tackle: ["2L1", "1L1"],
			takedown: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
		},
		encounters: [
			{generation: 1, level: 13},
		],
	},
	venomoth: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			confusion: ["2L17", "1L1"],
			curse: ["2M"],
			disable: ["2L1", "1L1"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			flash: ["2M", "1M"],
			foresight: ["2L1"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			gust: ["2L31"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			leechlife: ["2L25", "1L27", "1L1"],
			megadrain: ["1M"],
			mimic: ["1M"],
			poisonpowder: ["2L20", "1L22", "1L24", "1L1"],
			protect: ["2M"],
			psybeam: ["2L36", "1L38"],
			psychic: ["2M", "2L52", "1M", "1L50"],
			psywave: ["1M"],
			rage: ["1M"],
			razorwind: ["1M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			sleeppowder: ["2L42", "1L43"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M", "1M"],
			stunspore: ["2L28", "1L30"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			supersonic: ["2L9", "2L1", "1L1"],
			swagger: ["2M"],
			sweetscent: ["2M"],
			swift: ["2M", "1M"],
			tackle: ["2L1", "1L1"],
			takedown: ["1M"],
			teleport: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
			whirlwind: ["1M"],
		},
		encounters: [
			{generation: 1, level: 30},
			{generation: 2, level: 10},
		],
	},
	diglett: {
		learnset: {
			ancientpower: ["2E"],
			attract: ["2M"],
			beatup: ["2E"],
			bide: ["1M"],
			bodyslam: ["1M"],
			curse: ["2M"],
			cut: ["2M", "1M"],
			dig: ["2M", "2L17", "1M", "1L19"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			earthquake: ["2M", "2L41", "1M", "1L40"],
			endure: ["2M"],
			feintattack: ["2E"],
			fissure: ["2L49", "1M"],
			frustration: ["2M"],
			growl: ["2L5", "1L15"],
			hiddenpower: ["2M"],
			magnitude: ["2L9"],
			mimic: ["1M"],
			mudslap: ["2M"],
			protect: ["2M"],
			pursuit: ["2E"],
			rage: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rockslide: ["1M"],
			rocksmash: ["2M"],
			sandattack: ["2L25", "1L24"],
			scratch: ["2L1", "1L1"],
			screech: ["2E"],
			slash: ["2L33", "1L31"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			snore: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			takedown: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
		},
		encounters: [
			{generation: 1, level: 15},
			{generation: 2, level: 2},
		],
	},
	dugtrio: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			curse: ["2M"],
			cut: ["2M", "1M"],
			dig: ["2M", "2L17", "1M", "1L19", "1L1"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			earthquake: ["2M", "2L49", "1M", "1L47"],
			endure: ["2M"],
			fissure: ["2L61", "1M"],
			frustration: ["2M"],
			growl: ["2L5", "2L1", "1L15", "1L1"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			magnitude: ["2L9", "2L1"],
			mimic: ["1M"],
			mudslap: ["2M"],
			protect: ["2M"],
			rage: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rockslide: ["1M"],
			rocksmash: ["2M"],
			sandattack: ["2L25", "1L24"],
			scratch: ["2L1", "1L1"],
			slash: ["2L37", "1L35"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			snore: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			takedown: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
			triattack: ["2L1"],
		},
		encounters: [
			{generation: 1, level: 15},
			{generation: 2, level: 5},
		],
	},
	meowth: {
		learnset: {
			amnesia: ["2E"],
			attract: ["2M"],
			bide: ["1M"],
			bite: ["2L11", "1L12"],
			bodyslam: ["1M"],
			bubblebeam: ["1M"],
			charm: ["2E"],
			curse: ["2M"],
			defensecurl: ["2M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dreameater: ["2M"],
			endure: ["2M"],
			feintattack: ["2L28"],
			frustration: ["2M"],
			furyswipes: ["2L41", "1L33"],
			growl: ["2L1", "1L1"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hypnosis: ["2E"],
			icywind: ["2M"],
			irontail: ["2M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			payday: ["2L20", "1M", "1L17"],
			protect: ["2M"],
			psychup: ["2M"],
			rage: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			scratch: ["2L1", "1L1"],
			screech: ["2L35", "1L24"],
			shadowball: ["2M"],
			skullbash: ["1M"],
			slash: ["2L46", "1L44"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			spite: ["2E"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			takedown: ["1M"],
			thief: ["2M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			toxic: ["2M", "1M"],
			watergun: ["1M"],
			zapcannon: ["2M"],
		},
		encounters: [
			{generation: 1, level: 10},
		],
	},
	persian: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bite: ["2L11", "2L1", "1L12", "1L1"],
			bodyslam: ["1M"],
			bubblebeam: ["1M"],
			curse: ["2M"],
			defensecurl: ["2M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dreameater: ["2M"],
			endure: ["2M"],
			feintattack: ["2L29"],
			frustration: ["2M"],
			furyswipes: ["2L46", "1L37"],
			growl: ["2L1", "1L1"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			icywind: ["2M"],
			irontail: ["2M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			payday: ["2L20", "1M", "1L17"],
			protect: ["2M"],
			psychup: ["2M"],
			rage: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			roar: ["2M"],
			scratch: ["2L1", "1L1"],
			screech: ["2L38", "1L24", "1L1"],
			shadowball: ["2M"],
			skullbash: ["1M"],
			slash: ["2L53", "1L51"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			takedown: ["1M"],
			thief: ["2M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			toxic: ["2M", "1M"],
			watergun: ["1M"],
			zapcannon: ["2M"],
		},
		encounters: [
			{generation: 2, level: 18},
		],
	},
	psyduck: {
		learnset: {
			amnesia: ["1S0"],
			attract: ["2M"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubblebeam: ["1M"],
			confusion: ["2L16", "1L36"],
			counter: ["1M"],
			crosschop: ["2E"],
			curse: ["2M"],
			dig: ["2M", "1M"],
			disable: ["2L10", "1L31"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			flash: ["2M"],
			foresight: ["2E"],
			frustration: ["2M"],
			furyswipes: ["2L40", "1L43"],
			futuresight: ["2E"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hydropump: ["2L50", "1L52"],
			hypnosis: ["2E"],
			icebeam: ["2T", "2E", "1M"],
			icepunch: ["2M"],
			icywind: ["2M"],
			irontail: ["2M"],
			lightscreen: ["2E"],
			megakick: ["1M"],
			megapunch: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			payday: ["1M"],
			petaldance: ["2S1"],
			protect: ["2M"],
			psybeam: ["2E"],
			psychic: ["2E"],
			psychup: ["2M", "2L31"],
			rage: ["1M"],
			raindance: ["2M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rocksmash: ["2M"],
			scratch: ["2L1", "2S2", "2S1", "1L1", "1S0"],
			screech: ["2L23"],
			seismictoss: ["1M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			tailwhip: ["2L5", "2S2", "2S1", "1L28"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
			triattack: ["2S2"],
			waterfall: ["2M"],
			watergun: ["1M"],
			whirlpool: ["2M"],
		},
		eventData: [
			{generation: 1, level: 15, moves: ["scratch", "amnesia"]},
			{generation: 2, level: 5, shiny: 1, moves: ["scratch", "tailwhip", "petaldance"]},
			{generation: 2, level: 5, shiny: 1, moves: ["scratch", "tailwhip", "triattack"]},
		],
		encounters: [
			{generation: 1, level: 15},
		],
	},
	golduck: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubblebeam: ["1M"],
			confusion: ["2L16", "2L1", "1L39"],
			counter: ["1M"],
			curse: ["2M"],
			dig: ["2M", "1M"],
			disable: ["2L10", "2L1", "1L31", "1L1"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			furycutter: ["2M"],
			furyswipes: ["2L44", "1L48"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hydropump: ["2L58", "1L59"],
			hyperbeam: ["2M", "1M"],
			icebeam: ["2T", "1M"],
			icepunch: ["2M"],
			icywind: ["2M"],
			irontail: ["2M"],
			megakick: ["1M"],
			megapunch: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			payday: ["1M"],
			protect: ["2M"],
			psychup: ["2M", "2L31"],
			rage: ["1M"],
			raindance: ["2M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rocksmash: ["2M"],
			scratch: ["2L1", "1L1"],
			screech: ["2L23"],
			seismictoss: ["1M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			tailwhip: ["2L5", "2L1", "1L28", "1L1"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
			waterfall: ["2M"],
			watergun: ["1M"],
			whirlpool: ["2M"],
		},
		encounters: [
			{generation: 1, level: 15},
			{generation: 2, level: 10},
		],
	},
	mankey: {
		learnset: {
			attract: ["2M"],
			beatup: ["2E"],
			bide: ["1M"],
			bodyslam: ["1M"],
			counter: ["2E", "1M"],
			crosschop: ["2L39"],
			curse: ["2M"],
			defensecurl: ["2M"],
			detect: ["2M"],
			dig: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			firepunch: ["2M"],
			focusenergy: ["2L27", "1L27"],
			foresight: ["2E"],
			frustration: ["2M"],
			furyswipes: ["2L21", "1L21"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			icepunch: ["2M"],
			irontail: ["2M"],
			karatechop: ["2L15", "1L15"],
			leer: ["2L1", "1L1"],
			lowkick: ["2L9", "1L9"],
			meditate: ["2E"],
			megakick: ["1M"],
			megapunch: ["1M"],
			metronome: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			payday: ["1M"],
			protect: ["2M"],
			psychup: ["2M"],
			rage: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			reversal: ["2E"],
			rockslide: ["2E", "1M"],
			rocksmash: ["2M"],
			scratch: ["2L1", "1L1"],
			screech: ["2L45", "1L45"],
			seismictoss: ["2L33", "1M", "1L33"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			takedown: ["1M"],
			thief: ["2M"],
			thrash: ["2L51", "1L39"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			thunderpunch: ["2M"],
			toxic: ["2M", "1M"],
		},
		encounters: [
			{generation: 1, level: 3},
		],
	},
	primeape: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			counter: ["1M"],
			crosschop: ["2L45"],
			curse: ["2M"],
			defensecurl: ["2M"],
			detect: ["2M"],
			dig: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			firepunch: ["2M"],
			focusenergy: ["2L27", "1L27"],
			frustration: ["2M"],
			furyswipes: ["2L21", "1L21", "1L1"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			icepunch: ["2M"],
			irontail: ["2M"],
			karatechop: ["2L15", "1L15", "1L1"],
			leer: ["2L1", "1L1"],
			lowkick: ["2L9", "2L1", "1L9", "1L1"],
			megakick: ["1M"],
			megapunch: ["1M"],
			metronome: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			payday: ["1M"],
			protect: ["2M"],
			psychup: ["2M"],
			rage: ["2L28", "2L1", "1M", "1L28"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rockslide: ["1M"],
			rocksmash: ["2M"],
			scratch: ["2L1", "1L1"],
			screech: ["2L54", "1L45"],
			seismictoss: ["2L36", "1M", "1L37"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			takedown: ["1M"],
			thief: ["2M"],
			thrash: ["2L63", "1L46"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			thunderpunch: ["2M"],
			toxic: ["2M", "1M"],
		},
		encounters: [
			{generation: 2, level: 15},
		],
	},
	growlithe: {
		learnset: {
			agility: ["2L42", "1L39"],
			attract: ["2M"],
			bide: ["1M"],
			bite: ["2L1", "1L1"],
			bodyslam: ["2E", "1M"],
			crunch: ["2E"],
			curse: ["2M"],
			dig: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dragonbreath: ["2M"],
			dragonrage: ["1M"],
			ember: ["2L9", "1L18"],
			endure: ["2M"],
			fireblast: ["2M", "1M"],
			firespin: ["2E"],
			flamethrower: ["2T", "2L50", "1L50"],
			flamewheel: ["2L34"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			irontail: ["2M"],
			leer: ["2L18", "1L23"],
			mimic: ["1M"],
			protect: ["2M"],
			rage: ["1M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			roar: ["2M", "2L1", "1L1"],
			rocksmash: ["2M"],
			safeguard: ["2E"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			takedown: ["2L26", "1M", "1L30"],
			thrash: ["2E"],
			toxic: ["2M", "1M"],
		},
		encounters: [
			{generation: 1, level: 15},
		],
	},
	arcanine: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			curse: ["2M"],
			dig: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dragonbreath: ["2M"],
			dragonrage: ["1M"],
			ember: ["1L1"],
			endure: ["2M"],
			extremespeed: ["2L50"],
			fireblast: ["2M", "1M"],
			flamethrower: ["2T"],
			flamewheel: ["2L1"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			irontail: ["2M"],
			leer: ["2L1", "1L1"],
			mimic: ["1M"],
			protect: ["2M"],
			rage: ["1M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			roar: ["2M", "2L1", "1L1"],
			rocksmash: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			takedown: ["2L1", "1M", "1L1"],
			teleport: ["1M"],
			toxic: ["2M", "1M"],
		},
	},
	poliwag: {
		learnset: {
			amnesia: ["1L38"],
			attract: ["2M"],
			bellydrum: ["2L37"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["2L31", "1M", "1L31"],
			bubble: ["2L1", "2S2", "2S1", "2S0", "1L1"],
			bubblebeam: ["2E", "1M"],
			curse: ["2M"],
			defensecurl: ["2M"],
			doubleedge: ["1M"],
			doubleslap: ["2L19", "1L25"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			frustration: ["2M"],
			growth: ["2S0"],
			haze: ["2E"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hydropump: ["2L43", "1L45"],
			hypnosis: ["2L7", "1L16"],
			icebeam: ["2T", "1M"],
			icywind: ["2M"],
			lovelykiss: ["2S1"],
			mimic: ["1M"],
			mindreader: ["2E"],
			mist: ["2E"],
			protect: ["2M"],
			psychic: ["2M", "1M"],
			psywave: ["1M"],
			rage: ["1M"],
			raindance: ["2M", "2L25"],
			rest: ["2M", "1M"],
			return: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			splash: ["2E"],
			substitute: ["1M"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			sweetkiss: ["2S2"],
			takedown: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
			waterfall: ["2M"],
			watergun: ["2L13", "1M", "1L19"],
			whirlpool: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["bubble", "growth"]},
			{generation: 2, level: 5, shiny: 1, moves: ["bubble", "lovelykiss"]},
			{generation: 2, level: 5, shiny: 1, moves: ["bubble", "sweetkiss"]},
		],
		encounters: [
			{generation: 1, level: 5},
			{generation: 2, level: 3},
		],
	},
	poliwhirl: {
		learnset: {
			amnesia: ["1L41"],
			attract: ["2M"],
			bellydrum: ["2L43"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["2L35", "1M", "1L33"],
			bubble: ["2L1", "1L1"],
			bubblebeam: ["1M"],
			counter: ["1M"],
			curse: ["2M"],
			defensecurl: ["2M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doubleslap: ["2L19", "1L26"],
			doubleteam: ["2M", "1M"],
			earthquake: ["2M", "1M"],
			endure: ["2M"],
			fissure: ["1M"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hydropump: ["2L51", "1L49"],
			hypnosis: ["2L7", "2L1", "1L16", "1L1"],
			icebeam: ["2T", "1M"],
			icepunch: ["2M"],
			icywind: ["2M"],
			megakick: ["1M"],
			megapunch: ["1M"],
			metronome: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			protect: ["2M"],
			psychic: ["2M", "1M"],
			psywave: ["1M"],
			rage: ["1M"],
			raindance: ["2M", "2L27"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rocksmash: ["2M"],
			seismictoss: ["1M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			takedown: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
			waterfall: ["2M"],
			watergun: ["2L13", "2L1", "1M", "1L19", "1L1"],
			whirlpool: ["2M"],
		},
		encounters: [
			{generation: 1, level: 15},
			{generation: 2, level: 10},
		],
	},
	poliwrath: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M", "1L1"],
			bubblebeam: ["1M"],
			counter: ["1M"],
			curse: ["2M"],
			defensecurl: ["2M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doubleslap: ["2L1", "1L1"],
			doubleteam: ["2M", "1M"],
			dynamicpunch: ["2M"],
			earthquake: ["2M", "1M"],
			endure: ["2M"],
			fissure: ["1M"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			hypnosis: ["2L1", "1L16", "1L1"],
			icebeam: ["2T", "1M"],
			icepunch: ["2M"],
			icywind: ["2M"],
			megakick: ["1M"],
			megapunch: ["1M"],
			metronome: ["1M"],
			mimic: ["1M"],
			mindreader: ["2L51"],
			mudslap: ["2M"],
			protect: ["2M"],
			psychic: ["2M", "1M"],
			psywave: ["1M"],
			rage: ["1M"],
			raindance: ["2M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rocksmash: ["2M"],
			seismictoss: ["1M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M", "1M"],
			submission: ["2L35", "2L1", "1M"],
			substitute: ["1M"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			takedown: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
			waterfall: ["2M"],
			watergun: ["2L1", "1M", "1L19", "1L1"],
			whirlpool: ["2M"],
		},
	},
	abra: {
		learnset: {
			attract: ["2M"],
			barrier: ["2E"],
			bide: ["1M"],
			bodyslam: ["1M"],
			counter: ["1M"],
			curse: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dreameater: ["2M"],
			dynamicpunch: ["2M"],
			encore: ["2E"],
			endure: ["2M"],
			firepunch: ["2M"],
			flash: ["2M", "1M"],
			foresight: ["2S0"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			icepunch: ["2M"],
			lightscreen: ["2E"],
			megakick: ["1M"],
			megapunch: ["1M"],
			metronome: ["1M"],
			mimic: ["1M"],
			nightmare: ["2M"],
			protect: ["2M"],
			psychic: ["2M", "1M"],
			psychup: ["2M"],
			psywave: ["1M"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			seismictoss: ["1M"],
			shadowball: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			takedown: ["1M"],
			teleport: ["2L1", "2S0", "1M", "1L1"],
			thief: ["2M"],
			thunderpunch: ["2M"],
			thunderwave: ["1M"],
			toxic: ["2M", "1M"],
			triattack: ["1M"],
			zapcannon: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["teleport", "foresight"]},
		],
		encounters: [
			{generation: 1, level: 6},
		],
	},
	kadabra: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			confusion: ["2L16", "2L1", "1L16", "1L1"],
			counter: ["1M"],
			curse: ["2M"],
			dig: ["2M", "1M"],
			disable: ["2L18", "1L20", "1L1"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dreameater: ["2M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			firepunch: ["2M"],
			flash: ["2M", "1M"],
			frustration: ["2M"],
			futuresight: ["2L31"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			icepunch: ["2M"],
			kinesis: ["2L1", "1L1"],
			megakick: ["1M"],
			megapunch: ["1M"],
			metronome: ["1M"],
			mimic: ["1M"],
			nightmare: ["2M"],
			protect: ["2M"],
			psybeam: ["2L21", "1L27"],
			psychic: ["2M", "2L38", "1M", "1L38"],
			psychup: ["2M"],
			psywave: ["1M"],
			rage: ["1M"],
			raindance: ["2M"],
			recover: ["2L26", "1L31"],
			reflect: ["2L45", "1M", "1L42"],
			rest: ["2M", "1M"],
			return: ["2M"],
			seismictoss: ["1M"],
			shadowball: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			takedown: ["1M"],
			teleport: ["2L1", "1M", "1L1"],
			thief: ["2M"],
			thunderpunch: ["2M"],
			thunderwave: ["1M"],
			toxic: ["2M", "1M"],
			triattack: ["1M"],
			zapcannon: ["2M"],
		},
		encounters: [
			{generation: 2, level: 15},
		],
	},
	alakazam: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			confusion: ["2L16", "2L1", "1L16", "1L1"],
			counter: ["1M"],
			curse: ["2M"],
			dig: ["2M", "1M"],
			disable: ["2L18", "1L20", "1L1"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dreameater: ["2M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			firepunch: ["2M"],
			flash: ["2M", "1M"],
			frustration: ["2M"],
			futuresight: ["2L31"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			icepunch: ["2M"],
			kinesis: ["2L1", "1L1"],
			megakick: ["1M"],
			megapunch: ["1M"],
			metronome: ["1M"],
			mimic: ["1M"],
			nightmare: ["2M"],
			protect: ["2M"],
			psybeam: ["2L21", "1L27"],
			psychic: ["2M", "2L38", "1M", "1L38"],
			psychup: ["2M"],
			psywave: ["1M"],
			rage: ["1M"],
			raindance: ["2M"],
			recover: ["2L26", "1L31"],
			reflect: ["2L45", "1M", "1L42"],
			rest: ["2M", "1M"],
			return: ["2M"],
			seismictoss: ["1M"],
			shadowball: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			takedown: ["1M"],
			teleport: ["2L1", "1M", "1L1"],
			thief: ["2M"],
			thunderpunch: ["2M"],
			thunderwave: ["1M"],
			toxic: ["2M", "1M"],
			triattack: ["1M"],
			zapcannon: ["2M"],
		},
	},
	machop: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			counter: ["1M"],
			crosschop: ["2L37"],
			curse: ["2M"],
			detect: ["2M"],
			dig: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dynamicpunch: ["2M"],
			earthquake: ["2M", "1M"],
			encore: ["2E"],
			endure: ["2M"],
			falseswipe: ["2S0"],
			fireblast: ["2M", "1M"],
			firepunch: ["2M"],
			fissure: ["1M"],
			flamethrower: ["2T"],
			focusenergy: ["2L7", "1L32"],
			foresight: ["2L25"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			icepunch: ["2M"],
			karatechop: ["2L13", "1L1"],
			leer: ["2L1", "2S1", "2S0", "1L25"],
			lightscreen: ["2E"],
			lowkick: ["2L1", "2S1", "2S0", "1L20"],
			meditate: ["2E"],
			megakick: ["1M"],
			megapunch: ["1M"],
			metronome: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			protect: ["2M"],
			rage: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rockslide: ["1M"],
			rocksmash: ["2M"],
			rollingkick: ["2E"],
			scaryface: ["2L43"],
			seismictoss: ["2L19", "1M", "1L39"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M", "1M"],
			submission: ["2L49", "1M", "1L46"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			takedown: ["1M"],
			thief: ["2M"],
			thrash: ["2S1"],
			thunderpunch: ["2M"],
			toxic: ["2M", "1M"],
			vitalthrow: ["2L31"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["lowkick", "leer", "falseswipe"]},
			{generation: 2, level: 5, shiny: 1, moves: ["lowkick", "leer", "thrash"]},
		],
		encounters: [
			{generation: 1, level: 15},
		],
	},
	machoke: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			counter: ["1M"],
			crosschop: ["2L43"],
			curse: ["2M"],
			detect: ["2M"],
			dig: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dynamicpunch: ["2M"],
			earthquake: ["2M", "1M"],
			endure: ["2M"],
			fireblast: ["2M", "1M"],
			firepunch: ["2M"],
			fissure: ["1M"],
			flamethrower: ["2T"],
			focusenergy: ["2L8", "2L1", "1L36"],
			foresight: ["2L25"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			icepunch: ["2M"],
			karatechop: ["2L15", "1L1"],
			leer: ["2L1", "1L25", "1L1"],
			lowkick: ["2L1", "1L20", "1L1"],
			megakick: ["1M"],
			megapunch: ["1M"],
			metronome: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			protect: ["2M"],
			rage: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rockslide: ["1M"],
			rocksmash: ["2M"],
			scaryface: ["2L52"],
			seismictoss: ["2L19", "1M", "1L44"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M", "1M"],
			submission: ["2L61", "1M", "1L52"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			takedown: ["1M"],
			thief: ["2M"],
			thunderpunch: ["2M"],
			toxic: ["2M", "1M"],
			vitalthrow: ["2L34"],
		},
		encounters: [
			{generation: 2, level: 14},
		],
	},
	machamp: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			counter: ["1M"],
			crosschop: ["2L43"],
			curse: ["2M"],
			detect: ["2M"],
			dig: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dynamicpunch: ["2M"],
			earthquake: ["2M", "1M"],
			endure: ["2M"],
			fireblast: ["2M", "1M"],
			firepunch: ["2M"],
			fissure: ["1M"],
			flamethrower: ["2T"],
			focusenergy: ["2L8", "2L1", "1L36"],
			foresight: ["2L25"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			icepunch: ["2M"],
			karatechop: ["2L15", "1L1"],
			leer: ["2L1", "1L25", "1L1"],
			lowkick: ["2L1", "1L20", "1L1"],
			megakick: ["1M"],
			megapunch: ["1M"],
			metronome: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			protect: ["2M"],
			rage: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rockslide: ["1M"],
			rocksmash: ["2M"],
			scaryface: ["2L52"],
			seismictoss: ["2L19", "1M", "1L44"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M", "1M"],
			submission: ["2L61", "1M", "1L52"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			takedown: ["1M"],
			thief: ["2M"],
			thunderpunch: ["2M"],
			toxic: ["2M", "1M"],
			vitalthrow: ["2L34"],
		},
		encounters: [
			{generation: 1, level: 16},
			{generation: 2, level: 5},
		],
	},
	bellsprout: {
		learnset: {
			acid: ["2L23", "1L26"],
			attract: ["2M"],
			bide: ["1M"],
			curse: ["2M"],
			cut: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			encore: ["2E"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			growth: ["2L6", "1L1"],
			hiddenpower: ["2M"],
			leechlife: ["2E"],
			lovelykiss: ["2S0"],
			megadrain: ["1M"],
			mimic: ["1M"],
			poisonpowder: ["2L17", "1L15"],
			protect: ["2M"],
			rage: ["1M"],
			razorleaf: ["2L37", "1L33"],
			reflect: ["2E", "1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			slam: ["2L45", "1L42"],
			sleeppowder: ["2L15", "1L18"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M", "1M"],
			stunspore: ["2L19", "1L21"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			sweetkiss: ["2S1"],
			sweetscent: ["2M", "2L30"],
			swordsdance: ["2E", "1M"],
			synthesis: ["2E"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
			vinewhip: ["2L1", "2S1", "2S0", "1L1"],
			wrap: ["2L11", "1L13"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["vinewhip", "lovelykiss"]},
			{generation: 2, level: 5, shiny: 1, moves: ["vinewhip", "sweetkiss"]},
		],
		encounters: [
			{generation: 1, level: 12},
			{generation: 2, level: 3},
		],
	},
	weepinbell: {
		learnset: {
			acid: ["2L24", "1L29"],
			attract: ["2M"],
			bide: ["1M"],
			curse: ["2M"],
			cut: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			growth: ["2L6", "2L1", "1L1"],
			hiddenpower: ["2M"],
			megadrain: ["1M"],
			mimic: ["1M"],
			poisonpowder: ["2L17", "1L15"],
			protect: ["2M"],
			rage: ["1M"],
			razorleaf: ["2L42", "1L38"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			slam: ["2L54", "1L49"],
			sleeppowder: ["2L15", "1L18"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M", "1M"],
			stunspore: ["2L19", "1L23"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			sweetscent: ["2M", "2L33"],
			swordsdance: ["1M"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
			vinewhip: ["2L1", "1L1"],
			wrap: ["2L11", "2L1", "1L13", "1L1"],
		},
		encounters: [
			{generation: 2, level: 12},
		],
	},
	victreebel: {
		learnset: {
			acid: ["1L1"],
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			curse: ["2M"],
			cut: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			megadrain: ["1M"],
			mimic: ["1M"],
			poisonpowder: ["1L15"],
			protect: ["2M"],
			rage: ["1M"],
			razorleaf: ["2L1", "1L1"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			sleeppowder: ["2L1", "1L18", "1L1"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M", "1M"],
			stunspore: ["1L1"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			sweetscent: ["2M", "2L1"],
			swordsdance: ["1M"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
			vinewhip: ["2L1"],
			wrap: ["1L13"],
		},
	},
	tentacool: {
		learnset: {
			acid: ["2L19", "1L1"],
			attract: ["2M"],
			aurorabeam: ["2E"],
			barrier: ["2L36", "1L33"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bubblebeam: ["2L25", "1M"],
			confuseray: ["2S0"],
			constrict: ["2L12", "1L27"],
			curse: ["2M"],
			cut: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			haze: ["2E"],
			hiddenpower: ["2M"],
			hydropump: ["2L49", "1L48"],
			icebeam: ["2T", "1M"],
			icywind: ["2M"],
			megadrain: ["1M"],
			mimic: ["1M"],
			mirrorcoat: ["2E"],
			poisonsting: ["2L1", "2S0", "1L18"],
			protect: ["2M"],
			rage: ["1M"],
			raindance: ["2M"],
			rapidspin: ["2E"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			safeguard: ["2E"],
			screech: ["2L43", "1L40"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			snore: ["2M"],
			substitute: ["1M"],
			supersonic: ["2L6", "1L7"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			swordsdance: ["1M"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
			watergun: ["1M", "1L22"],
			whirlpool: ["2M"],
			wrap: ["2L30", "1L13"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["poisonsting", "confuseray"]},
		],
		encounters: [
			{generation: 1, level: 5},
		],
	},
	tentacruel: {
		learnset: {
			acid: ["2L19", "1L1"],
			attract: ["2M"],
			barrier: ["2L38", "1L35"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bubblebeam: ["2L25", "1M"],
			constrict: ["2L12", "2L1", "1L27"],
			curse: ["2M"],
			cut: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			hiddenpower: ["2M"],
			hydropump: ["2L55", "1L50"],
			hyperbeam: ["2M", "1M"],
			icebeam: ["2T", "1M"],
			icywind: ["2M"],
			megadrain: ["1M"],
			mimic: ["1M"],
			poisonsting: ["2L1", "1L18"],
			protect: ["2M"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			screech: ["2L47", "1L43"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			snore: ["2M"],
			substitute: ["1M"],
			supersonic: ["2L6", "2L1", "1L7", "1L1"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			swordsdance: ["1M"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
			watergun: ["1M", "1L22"],
			whirlpool: ["2M"],
			wrap: ["2L30", "1L13", "1L1"],
		},
		encounters: [
			{generation: 1, level: 20},
			{generation: 2, level: 20},
		],
	},
	geodude: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			counter: ["1M"],
			curse: ["2M"],
			defensecurl: ["2M", "2L6", "1L11"],
			dig: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dynamicpunch: ["2M"],
			earthquake: ["2M", "2L36", "1M", "1L31"],
			endure: ["2M"],
			explosion: ["2L41", "1M", "1L36"],
			fireblast: ["2M", "1M"],
			firepunch: ["2M"],
			fissure: ["1M"],
			flamethrower: ["2T"],
			frustration: ["2M"],
			harden: ["2L26", "1L26"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			magnitude: ["2L16"],
			megapunch: ["2E", "1M"],
			metronome: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			protect: ["2M"],
			rage: ["1M"],
			rapidspin: ["2S0"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rockslide: ["2E", "1M"],
			rocksmash: ["2M"],
			rockthrow: ["2L11", "1L16"],
			rollout: ["2M", "2L31"],
			sandstorm: ["2M"],
			seismictoss: ["1M"],
			selfdestruct: ["2L21", "1M", "1L21"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			tackle: ["2L1", "2S0", "1L1"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "rapidspin"]},
		],
		encounters: [
			{generation: 1, level: 7},
			{generation: 2, level: 2},
		],
	},
	graveler: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			counter: ["1M"],
			curse: ["2M"],
			defensecurl: ["2M", "2L6", "2L1", "1L11", "1L1"],
			dig: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dynamicpunch: ["2M"],
			earthquake: ["2M", "2L41", "1M", "1L36"],
			endure: ["2M"],
			explosion: ["2L48", "1M", "1L43"],
			fireblast: ["2M", "1M"],
			firepunch: ["2M"],
			fissure: ["1M"],
			flamethrower: ["2T"],
			frustration: ["2M"],
			harden: ["2L27", "1L29"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			magnitude: ["2L16"],
			megapunch: ["1M"],
			metronome: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			protect: ["2M"],
			rage: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rockslide: ["1M"],
			rocksmash: ["2M"],
			rockthrow: ["2L11", "2L1", "1L16"],
			rollout: ["2M", "2L34"],
			sandstorm: ["2M"],
			seismictoss: ["1M"],
			selfdestruct: ["2L21", "1M", "1L21"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			tackle: ["2L1", "1L1"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
		},
		encounters: [
			{generation: 2, level: 23},
		],
	},
	golem: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			counter: ["1M"],
			curse: ["2M"],
			defensecurl: ["2M", "2L6", "2L1", "1L11", "1L1"],
			dig: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dynamicpunch: ["2M"],
			earthquake: ["2M", "2L41", "1M", "1L36"],
			endure: ["2M"],
			explosion: ["2L48", "1M", "1L43"],
			fireblast: ["2M", "1M"],
			firepunch: ["2M"],
			fissure: ["1M"],
			flamethrower: ["2T"],
			frustration: ["2M"],
			furycutter: ["2M"],
			harden: ["2L27", "1L29"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			magnitude: ["2L16", "2L1"],
			megakick: ["1M"],
			megapunch: ["1M"],
			metronome: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			protect: ["2M"],
			rage: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			roar: ["2M"],
			rockslide: ["1M"],
			rocksmash: ["2M"],
			rockthrow: ["2L11", "2L1", "1L16"],
			rollout: ["2M", "2L34"],
			sandstorm: ["2M"],
			seismictoss: ["1M"],
			selfdestruct: ["2L21", "1M", "1L21"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			tackle: ["2L1", "1L1"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
		},
		encounters: [
			{generation: 1, level: 16},
		],
	},
	ponyta: {
		learnset: {
			agility: ["2L43", "1L48"],
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			charm: ["2E"],
			curse: ["2M"],
			doubleedge: ["1M"],
			doublekick: ["2E"],
			doubleteam: ["2M", "1M"],
			ember: ["2L13", "1L1"],
			endure: ["2M"],
			fireblast: ["2M", "2L53", "1M"],
			firespin: ["2L26", "1L39"],
			flamethrower: ["2T"],
			flamewheel: ["2E"],
			frustration: ["2M"],
			growl: ["2L4", "2S0", "1L35"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			horndrill: ["1M"],
			hypnosis: ["2E"],
			irontail: ["2M"],
			lowkick: ["2S0"],
			mimic: ["1M"],
			protect: ["2M"],
			quickattack: ["2E"],
			rage: ["1M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			stomp: ["2L19", "1L32"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			tackle: ["2L1", "2S0"],
			tailwhip: ["2L8", "1L30"],
			takedown: ["2L34", "1M", "1L43"],
			thrash: ["2E"],
			toxic: ["2M", "1M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "growl", "lowkick"]},
		],
		encounters: [
			{generation: 1, level: 28},
		],
	},
	rapidash: {
		learnset: {
			agility: ["2L47", "1L55"],
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			curse: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			ember: ["2L13", "2L1", "1L1", "1S0"],
			endure: ["2M"],
			fireblast: ["2M", "2L61", "1M"],
			firespin: ["2L26", "1L39", "1S0"],
			flamethrower: ["2T"],
			frustration: ["2M"],
			furyattack: ["2L40"],
			growl: ["2L4", "2L1", "1L35", "1L1"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			horndrill: ["1M"],
			hyperbeam: ["2M", "1M"],
			irontail: ["2M"],
			mimic: ["1M"],
			payday: ["1S0"],
			protect: ["2M"],
			rage: ["1M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			stomp: ["2L19", "1L32", "1L1", "1S0"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			tackle: ["2L1"],
			tailwhip: ["2L8", "2L1", "1L30", "1L1"],
			takedown: ["2L34", "1M", "1L47"],
			toxic: ["2M", "1M"],
		},
		eventData: [
			{generation: 1, level: 40, moves: ["ember", "firespin", "stomp", "payday"], japan: true},
		],
		encounters: [
			{generation: 2, level: 14, gender: "M"},
		],
	},
	slowpoke: {
		learnset: {
			amnesia: ["2L43", "1L40"],
			attract: ["2M"],
			bellydrum: ["2E"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubblebeam: ["1M"],
			confusion: ["2L20", "1L1"],
			curse: ["2M", "2L1"],
			dig: ["2M", "1M"],
			disable: ["2L29", "1L18"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dreameater: ["2M"],
			earthquake: ["2M", "1M"],
			endure: ["2M"],
			fireblast: ["2M", "1M"],
			fissure: ["1M"],
			flamethrower: ["2T"],
			flash: ["2M", "1M"],
			frustration: ["2M"],
			futuresight: ["2E"],
			growl: ["2L6", "1L27"],
			headbutt: ["2M", "2L34", "1L22"],
			hiddenpower: ["2M"],
			icebeam: ["2T", "1M"],
			icywind: ["2M"],
			irontail: ["2M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			payday: ["1M"],
			protect: ["2M"],
			psychic: ["2M", "2L48", "1M", "1L48"],
			psychup: ["2M"],
			psywave: ["1M"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			safeguard: ["2E"],
			shadowball: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			stomp: ["2E"],
			strength: ["2M", "1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			tackle: ["2L1"],
			takedown: ["1M"],
			teleport: ["1M"],
			thunderwave: ["1M"],
			toxic: ["2M", "1M"],
			triattack: ["1M"],
			watergun: ["2L15", "1M", "1L33"],
			zapcannon: ["2M"],
		},
		encounters: [
			{generation: 1, level: 15},
		],
	},
	slowbro: {
		learnset: {
			amnesia: ["2L46", "1L44"],
			attract: ["2M"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubblebeam: ["1M"],
			confusion: ["2L20", "1L1"],
			counter: ["1M"],
			curse: ["2M", "2L1"],
			dig: ["2M", "1M"],
			disable: ["2L29", "1L18", "1L1"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dreameater: ["2M"],
			dynamicpunch: ["2M"],
			earthquake: ["2M", "1M"],
			endure: ["2M"],
			fireblast: ["2M", "1M"],
			fissure: ["1M"],
			flamethrower: ["2T"],
			flash: ["2M", "1M"],
			frustration: ["2M"],
			furycutter: ["2M"],
			growl: ["2L6", "2L1", "1L27"],
			headbutt: ["2M", "2L34", "1L22", "1L1"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			icebeam: ["2T", "1M"],
			icepunch: ["2M"],
			icywind: ["2M"],
			irontail: ["2M"],
			megakick: ["1M"],
			megapunch: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			payday: ["1M"],
			protect: ["2M"],
			psychic: ["2M", "2L54", "1M", "1L55"],
			psychup: ["2M"],
			psywave: ["1M"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rocksmash: ["2M"],
			seismictoss: ["1M"],
			shadowball: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			tackle: ["2L1"],
			takedown: ["1M"],
			teleport: ["1M"],
			thunderwave: ["1M"],
			toxic: ["2M", "1M"],
			triattack: ["1M"],
			watergun: ["2L15", "2L1", "1M", "1L33"],
			withdraw: ["2L37", "1L37"],
			zapcannon: ["2M"],
		},
		encounters: [
			{generation: 1, level: 15},
			{generation: 1, level: 23},
			{generation: 2, level: 20},
		],
	},
	magnemite: {
		learnset: {
			agility: ["2S0"],
			bide: ["1M"],
			curse: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			flash: ["2M", "1M"],
			frustration: ["2M"],
			hiddenpower: ["2M"],
			lockon: ["2L27"],
			mimic: ["1M"],
			protect: ["2M"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rollout: ["2M"],
			screech: ["2L39", "1L47"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			sonicboom: ["2L16", "1L21"],
			substitute: ["1M"],
			supersonic: ["2L11", "1L29"],
			swagger: ["2M"],
			swift: ["2M", "2L33", "1M", "1L41"],
			tackle: ["2L1", "2S0", "1L1"],
			takedown: ["1M"],
			teleport: ["1M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			thundershock: ["2L6", "1L25"],
			thunderwave: ["2L21", "1M", "1L35"],
			toxic: ["2M", "1M"],
			zapcannon: ["2M", "2L45"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "agility"]},
		],
		encounters: [
			{generation: 1, level: 16},
		],
	},
	magneton: {
		learnset: {
			bide: ["1M"],
			curse: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			flash: ["2M", "1M"],
			frustration: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			lockon: ["2L27"],
			mimic: ["1M"],
			protect: ["2M"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rollout: ["2M"],
			screech: ["2L43", "1L54"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			sonicboom: ["2L16", "2L1", "1L21", "1L1"],
			substitute: ["1M"],
			supersonic: ["2L11", "2L1", "1L29"],
			swagger: ["2M"],
			swift: ["2M", "2L35", "1M", "1L46"],
			tackle: ["2L1", "1L1"],
			takedown: ["1M"],
			teleport: ["1M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			thundershock: ["2L6", "2L1", "1L25", "1L1"],
			thunderwave: ["2L21", "1M", "1L38"],
			toxic: ["2M", "1M"],
			triattack: ["2L35"],
			zapcannon: ["2M", "2L53"],
		},
		encounters: [
			{generation: 2, level: 5},
		],
	},
	farfetchd: {
		learnset: {
			agility: ["2L31", "2S0", "1L31"],
			attract: ["2M"],
			batonpass: ["2S0"],
			bide: ["1M"],
			bodyslam: ["1M"],
			curse: ["2M"],
			cut: ["2M", "1M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			falseswipe: ["2L44"],
			flail: ["2E"],
			fly: ["2M", "1M"],
			foresight: ["2E"],
			frustration: ["2M"],
			furyattack: ["2L19", "1L15"],
			furycutter: ["2S1"],
			gust: ["2E"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			irontail: ["2M"],
			leer: ["2L13", "1L7"],
			mimic: ["1M"],
			mirrormove: ["2E"],
			mudslap: ["2M"],
			peck: ["2L1", "2S1", "1L1"],
			protect: ["2M"],
			psychup: ["2M"],
			quickattack: ["2E"],
			rage: ["1M"],
			razorwind: ["1M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			sandattack: ["2L7", "1L1"],
			skullbash: ["1M"],
			slash: ["2L37", "2S0", "1L39"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			steelwing: ["2M", "2E"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			swordsdance: ["2L25", "2S0", "1M", "1L23"],
			takedown: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
			whirlwind: ["1M"],
		},
		eventData: [
			{generation: 2, level: 5, moves: ["batonpass", "swordsdance", "agility", "slash"]},
			{generation: 2, level: 5, shiny: 1, moves: ["peck", "furycutter"]},
		],
		encounters: [
			{generation: 1, level: 3},
		],
	},
	doduo: {
		learnset: {
			agility: ["2L37", "1L44"],
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			curse: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			drillpeck: ["2L33", "1L30"],
			endure: ["2M"],
			feintattack: ["2E"],
			flail: ["2E"],
			fly: ["2M", "1M"],
			frustration: ["2M"],
			furyattack: ["2L13", "1L24"],
			growl: ["2L1", "2S0", "1L20"],
			haze: ["2E"],
			hiddenpower: ["2M"],
			lowkick: ["2S0"],
			mimic: ["1M"],
			mudslap: ["2M"],
			peck: ["2L1", "2S0", "1L1"],
			protect: ["2M"],
			pursuit: ["2L9"],
			quickattack: ["2E"],
			rage: ["2L25", "1M", "1L36"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			skullbash: ["1M"],
			skyattack: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			steelwing: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			supersonic: ["2E"],
			swagger: ["2M"],
			swift: ["2M"],
			takedown: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
			triattack: ["2L21", "1M", "1L40"],
			whirlwind: ["1M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["peck", "growl", "lowkick"]},
		],
		encounters: [
			{generation: 1, level: 18},
			{generation: 2, level: 4},
		],
	},
	dodrio: {
		learnset: {
			agility: ["2L47", "1L51"],
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			curse: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			drillpeck: ["2L38", "1L30"],
			endure: ["2M"],
			fly: ["2M", "1M"],
			frustration: ["2M"],
			furyattack: ["2L13", "2L1", "1L24", "1L1"],
			growl: ["2L1", "1L20", "1L1"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			peck: ["2L1", "1L1"],
			protect: ["2M"],
			pursuit: ["2L9", "2L1"],
			rage: ["2L25", "1M", "1L39"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			skullbash: ["1M"],
			skyattack: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			steelwing: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M"],
			takedown: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
			triattack: ["2L21", "1M", "1L45"],
			whirlwind: ["1M"],
		},
		encounters: [
			{generation: 1, level: 29},
			{generation: 2, level: 10, gender: "F"},
			{generation: 2, level: 30},
		],
	},
	seel: {
		learnset: {
			attract: ["2M"],
			aurorabeam: ["2L16", "1L35"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubblebeam: ["1M"],
			curse: ["2M"],
			disable: ["2E"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			encore: ["2E"],
			endure: ["2M"],
			flail: ["2S0"],
			frustration: ["2M"],
			growl: ["2L5", "2S0", "1L30"],
			headbutt: ["2M", "2L1", "2S0", "1L1"],
			hiddenpower: ["2M"],
			horndrill: ["1M"],
			icebeam: ["2T", "2L37", "1M", "1L50"],
			icywind: ["2M"],
			lick: ["2E"],
			mimic: ["1M"],
			payday: ["1M"],
			peck: ["2E"],
			perishsong: ["2E"],
			protect: ["2M"],
			rage: ["1M"],
			raindance: ["2M"],
			rest: ["2M", "2L21", "1M", "1L40"],
			return: ["2M"],
			safeguard: ["2L48"],
			skullbash: ["1M"],
			slam: ["2E"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["1M"],
			substitute: ["1M"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			takedown: ["2L32", "1M", "1L45"],
			toxic: ["2M", "1M"],
			waterfall: ["2M"],
			watergun: ["1M"],
			whirlpool: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["headbutt", "growl", "flail"]},
		],
		encounters: [
			{generation: 1, level: 22},
		],
	},
	dewgong: {
		learnset: {
			attract: ["2M"],
			aurorabeam: ["2L16", "2L1", "1L35", "1L1"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubblebeam: ["1M"],
			curse: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			frustration: ["2M"],
			growl: ["2L5", "2L1", "1L30", "1L1"],
			headbutt: ["2M", "2L1", "1L1"],
			hiddenpower: ["2M"],
			horndrill: ["1M"],
			hyperbeam: ["2M", "1M"],
			icebeam: ["2T", "2L43", "1M", "1L56"],
			icywind: ["2M"],
			mimic: ["1M"],
			payday: ["1M"],
			protect: ["2M"],
			rage: ["1M"],
			raindance: ["2M"],
			rest: ["2M", "2L21", "1M", "1L44"],
			return: ["2M"],
			safeguard: ["2L60"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["1M"],
			substitute: ["1M"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			takedown: ["2L32", "1M", "1L50"],
			toxic: ["2M", "1M"],
			waterfall: ["2M"],
			watergun: ["1M"],
			whirlpool: ["2M"],
		},
		encounters: [
			{generation: 1, level: 15},
			{generation: 2, level: 5},
		],
	},
	grimer: {
		learnset: {
			acidarmor: ["2L40", "1L55"],
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			curse: ["2M"],
			disable: ["2L10", "1L1"],
			doubleteam: ["2M", "1M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			explosion: ["1M"],
			fireblast: ["2M", "1M"],
			firepunch: ["2M"],
			flamethrower: ["2T"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			harden: ["2L5", "1L42"],
			haze: ["2E"],
			hiddenpower: ["2M"],
			icepunch: ["2M"],
			lick: ["2E"],
			meanlook: ["2E"],
			megadrain: ["1M"],
			mimic: ["1M"],
			minimize: ["2L23", "1L33"],
			mudslap: ["2M"],
			poisongas: ["2L1", "1L30"],
			pound: ["2L1", "1L1"],
			protect: ["2M"],
			rage: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			screech: ["2L31", "1L48"],
			selfdestruct: ["1M"],
			sleeptalk: ["2M"],
			sludge: ["2L16", "1L37"],
			sludgebomb: ["2M", "2L50"],
			snore: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			thief: ["2M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			thunderpunch: ["2M"],
			toxic: ["2M", "1M"],
			zapcannon: ["2M"],
		},
		encounters: [
			{generation: 1, level: 23},
		],
	},
	muk: {
		learnset: {
			acidarmor: ["2L45", "1L60"],
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			curse: ["2M"],
			disable: ["2L37", "1L1"],
			doubleteam: ["2M", "1M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			explosion: ["1M"],
			fireblast: ["2M", "1M"],
			firepunch: ["2M"],
			flamethrower: ["2T"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			harden: ["2L33", "2L1", "1L45"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			icepunch: ["2M"],
			megadrain: ["1M"],
			mimic: ["1M"],
			minimize: ["2L23", "1L33"],
			mudslap: ["2M"],
			poisongas: ["2L1", "1L30", "1L1"],
			pound: ["2L1", "1L1"],
			protect: ["2M"],
			rage: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			screech: ["2L31", "1L53"],
			selfdestruct: ["1M"],
			sleeptalk: ["2M"],
			sludge: ["2L45", "1L37"],
			sludgebomb: ["2M", "2L60"],
			snore: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			thief: ["2M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			thunderpunch: ["2M"],
			toxic: ["2M", "1M"],
			zapcannon: ["2M"],
		},
		encounters: [
			{generation: 1, level: 25},
			{generation: 1, level: 15, japan: true},
			{generation: 2, level: 5},
		],
	},
	shellder: {
		learnset: {
			attract: ["2M"],
			aurorabeam: ["2L17", "1L30"],
			barrier: ["2E"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bubblebeam: ["2E", "1M"],
			clamp: ["2L41", "1L23"],
			curse: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			explosion: ["1M"],
			frustration: ["2M"],
			hiddenpower: ["2M"],
			icebeam: ["2T", "2L49", "1M", "1L50"],
			icywind: ["2M"],
			leer: ["2L33", "1L39"],
			mimic: ["1M"],
			protect: ["2M", "2L25"],
			rage: ["1M"],
			raindance: ["2M"],
			rapidspin: ["2E"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			screech: ["2E"],
			selfdestruct: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			substitute: ["1M"],
			supersonic: ["2L9", "1L18"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			tackle: ["2L1", "1L1"],
			takedown: ["2E", "1M"],
			teleport: ["1M"],
			toxic: ["2M", "1M"],
			triattack: ["1M"],
			watergun: ["1M"],
			whirlpool: ["2M"],
			withdraw: ["2L1", "1L1"],
		},
		encounters: [
			{generation: 1, level: 10},
		],
	},
	cloyster: {
		learnset: {
			attract: ["2M"],
			aurorabeam: ["2L1", "1L1"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bubblebeam: ["1M"],
			clamp: ["1L1"],
			curse: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			explosion: ["1M"],
			frustration: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			icebeam: ["2T", "1M"],
			icywind: ["2M"],
			mimic: ["1M"],
			protect: ["2M", "2L1"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			selfdestruct: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			spikecannon: ["2L41", "1L50"],
			spikes: ["2L33"],
			substitute: ["1M"],
			supersonic: ["2L1", "1L1"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			takedown: ["1M"],
			teleport: ["1M"],
			toxic: ["2M", "1M"],
			triattack: ["1M"],
			watergun: ["1M"],
			whirlpool: ["2M"],
			withdraw: ["2L1", "1L1"],
		},
	},
	gastly: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			confuseray: ["2L28", "1L1"],
			curse: ["2M", "2L16"],
			destinybond: ["2L36"],
			doubleteam: ["2M", "1M"],
			dreameater: ["2M", "2L33", "1M", "1L35"],
			endure: ["2M"],
			explosion: ["1M"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			haze: ["2E"],
			hiddenpower: ["2M"],
			hypnosis: ["2L1", "1L27"],
			lick: ["2L1", "1L1"],
			meanlook: ["2L13"],
			megadrain: ["1M"],
			mimic: ["1M"],
			nightmare: ["2M"],
			nightshade: ["2L21", "1L1"],
			perishsong: ["2E"],
			protect: ["2M"],
			psychic: ["2M", "1M"],
			psychup: ["2M"],
			psywave: ["2E", "1M"],
			rage: ["1M"],
			raindance: ["2M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			selfdestruct: ["1M"],
			shadowball: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			spite: ["2L8"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			thief: ["2M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			toxic: ["2M", "1M"],
			zapcannon: ["2M"],
		},
		encounters: [
			{generation: 1, level: 18},
		],
	},
	haunter: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			confuseray: ["2L31", "1L1"],
			curse: ["2M", "2L16"],
			destinybond: ["2L48"],
			doubleteam: ["2M", "1M"],
			dreameater: ["2M", "2L39", "1M", "1L38"],
			endure: ["2M"],
			explosion: ["1M"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			hiddenpower: ["2M"],
			hypnosis: ["2L1", "1L29"],
			lick: ["2L1", "1L1"],
			meanlook: ["2L13"],
			megadrain: ["1M"],
			mimic: ["1M"],
			nightmare: ["2M"],
			nightshade: ["2L21", "1L1"],
			protect: ["2M"],
			psychic: ["2M", "1M"],
			psychup: ["2M"],
			psywave: ["1M"],
			rage: ["1M"],
			raindance: ["2M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			selfdestruct: ["1M"],
			shadowball: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			spite: ["2L8", "2L1"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			thief: ["2M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			toxic: ["2M", "1M"],
			zapcannon: ["2M"],
		},
		encounters: [
			{generation: 1, level: 20},
			{generation: 2, level: 15},
		],
	},
	gengar: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			confuseray: ["2L31", "1L1"],
			counter: ["1M"],
			curse: ["2M", "2L16"],
			destinybond: ["2L48"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dreameater: ["2M", "2L39", "1M", "1L38"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			explosion: ["1M"],
			firepunch: ["2M"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			hypnosis: ["2L1", "1L29"],
			icepunch: ["2M"],
			lick: ["2L1", "1L1"],
			meanlook: ["2L13"],
			megadrain: ["1M"],
			megakick: ["1M"],
			megapunch: ["1M"],
			metronome: ["1M"],
			mimic: ["1M"],
			nightmare: ["2M"],
			nightshade: ["2L21", "1L1"],
			protect: ["2M"],
			psychic: ["2M", "1M"],
			psychup: ["2M"],
			psywave: ["1M"],
			rage: ["1M"],
			raindance: ["2M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rocksmash: ["2M"],
			seismictoss: ["1M"],
			selfdestruct: ["1M"],
			shadowball: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			spite: ["2L8", "2L1"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			takedown: ["1M"],
			thief: ["2M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			thunderpunch: ["2M"],
			toxic: ["2M", "1M"],
			zapcannon: ["2M"],
		},
	},
	onix: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bind: ["2L10", "1L15"],
			bodyslam: ["1M"],
			curse: ["2M"],
			dig: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			earthquake: ["2M", "1M"],
			endure: ["2M"],
			explosion: ["1M"],
			fissure: ["1M"],
			flail: ["2E"],
			frustration: ["2M"],
			harden: ["2L23", "1L43"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			irontail: ["2M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			protect: ["2M"],
			rage: ["2L27", "1M", "1L25"],
			rest: ["2M", "1M"],
			return: ["2M"],
			roar: ["2M"],
			rockslide: ["2E", "1M"],
			rocksmash: ["2M"],
			rockthrow: ["2L14", "1L19"],
			sandstorm: ["2M", "2L36"],
			screech: ["2L1", "2S0", "1L1"],
			selfdestruct: ["1M"],
			sharpen: ["2S0"],
			skullbash: ["1M"],
			slam: ["2L40", "1L33"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M", "1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			tackle: ["2L1", "2S0", "1L1"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "screech", "sharpen"]},
		],
		encounters: [
			{generation: 1, level: 13},
		],
	},
	drowzee: {
		learnset: {
			amnesia: ["2S0"],
			attract: ["2M"],
			barrier: ["2E"],
			bide: ["1M"],
			bodyslam: ["1M"],
			confusion: ["2L18", "1L17"],
			counter: ["1M"],
			curse: ["2M"],
			disable: ["2L10", "1L12"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dreameater: ["2M", "1M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			firepunch: ["2M"],
			flash: ["2M", "1M"],
			frustration: ["2M"],
			futuresight: ["2L45"],
			headbutt: ["2M", "2L25", "1L24"],
			hiddenpower: ["2M"],
			hypnosis: ["2L1", "2S0", "1L1"],
			icepunch: ["2M"],
			lightscreen: ["2E"],
			meditate: ["2L36", "1L37"],
			megakick: ["1M"],
			megapunch: ["1M"],
			metronome: ["1M"],
			mimic: ["1M"],
			nightmare: ["2M"],
			poisongas: ["2L31", "1L29"],
			pound: ["2L1", "2S0", "1L1"],
			protect: ["2M"],
			psychic: ["2M", "2L40", "1M", "1L32"],
			psychup: ["2M", "2L43"],
			psywave: ["1M"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			seismictoss: ["1M"],
			shadowball: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			takedown: ["1M"],
			teleport: ["1M"],
			thunderpunch: ["2M"],
			thunderwave: ["1M"],
			toxic: ["2M", "1M"],
			triattack: ["1M"],
			zapcannon: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["pound", "hypnosis", "amnesia"]},
		],
		encounters: [
			{generation: 1, level: 9},
		],
	},
	hypno: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			confusion: ["2L18", "2L1", "1L17", "1L1"],
			counter: ["1M"],
			curse: ["2M"],
			disable: ["2L10", "2L1", "1L12", "1L1"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dreameater: ["2M", "1M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			firepunch: ["2M"],
			flash: ["2M", "1M"],
			frustration: ["2M"],
			futuresight: ["2L60"],
			headbutt: ["2M", "2L25", "1L24"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			hypnosis: ["2L1", "1L1"],
			icepunch: ["2M"],
			meditate: ["2L40", "1L43"],
			megakick: ["1M"],
			megapunch: ["1M"],
			metronome: ["1M"],
			mimic: ["1M"],
			nightmare: ["2M"],
			poisongas: ["2L33", "1L33"],
			pound: ["2L1", "1L1"],
			protect: ["2M"],
			psychic: ["2M", "2L49", "1M", "1L37"],
			psychup: ["2M", "2L55"],
			psywave: ["1M"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			seismictoss: ["1M"],
			shadowball: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			takedown: ["1M"],
			teleport: ["1M"],
			thunderpunch: ["2M"],
			thunderwave: ["1M"],
			toxic: ["2M", "1M"],
			triattack: ["1M"],
			zapcannon: ["2M"],
		},
		encounters: [
			{generation: 2, level: 16},
			{generation: 4, level: 16},
		],
	},
	krabby: {
		learnset: {
			amnesia: ["2E"],
			attract: ["2M"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubble: ["2L1", "2S0", "1L1"],
			bubblebeam: ["1M"],
			crabhammer: ["2L41", "1L35"],
			curse: ["2M"],
			cut: ["2M", "1M"],
			dig: ["2E"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			flail: ["2E"],
			frustration: ["2M"],
			furycutter: ["2M"],
			guillotine: ["2L27", "1L25"],
			harden: ["2L16", "1L40"],
			haze: ["2E"],
			hiddenpower: ["2M"],
			icebeam: ["2T", "1M"],
			icywind: ["2M"],
			leer: ["2L5", "2S0", "1L1"],
			metalclaw: ["2S0"],
			mimic: ["1M"],
			mudslap: ["2M"],
			protect: ["2M", "2L34"],
			rage: ["1M"],
			raindance: ["2M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rocksmash: ["2M"],
			slam: ["2E"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			stomp: ["2L23", "1L30"],
			strength: ["2M", "1M"],
			substitute: ["1M"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			swordsdance: ["1M"],
			takedown: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
			visegrip: ["2L12", "1L20"],
			watergun: ["1M"],
			whirlpool: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["bubble", "leer", "metalclaw"]},
		],
		encounters: [
			{generation: 1, level: 10},
		],
	},
	kingler: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubble: ["2L1", "1L1"],
			bubblebeam: ["1M"],
			crabhammer: ["2L49", "1L42"],
			curse: ["2M"],
			cut: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			frustration: ["2M"],
			furycutter: ["2M"],
			guillotine: ["2L27", "1L25"],
			harden: ["2L16", "1L49"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			icebeam: ["2T", "1M"],
			icywind: ["2M"],
			leer: ["2L5", "2L1", "1L1"],
			mimic: ["1M"],
			mudslap: ["2M"],
			protect: ["2M", "2L38"],
			rage: ["1M"],
			raindance: ["2M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rocksmash: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			stomp: ["2L23", "1L34"],
			strength: ["2M", "1M"],
			substitute: ["1M"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			swordsdance: ["1M"],
			takedown: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
			visegrip: ["2L12", "2L1", "1L20", "1L1"],
			watergun: ["1M"],
			whirlpool: ["2M"],
		},
		encounters: [
			{generation: 1, level: 15},
		],
	},
	voltorb: {
		learnset: {
			agility: ["2S0"],
			bide: ["1M"],
			curse: ["2M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			explosion: ["2L39", "1M", "1L43"],
			flash: ["2M", "1M"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			lightscreen: ["2L33", "1L29"],
			mimic: ["1M"],
			mirrorcoat: ["2L41"],
			protect: ["2M"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rollout: ["2M", "2L29"],
			screech: ["2L9", "1L1"],
			selfdestruct: ["2L23", "1M", "1L22"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			sonicboom: ["2L17", "1L17"],
			substitute: ["1M"],
			swagger: ["2M"],
			swift: ["2M", "2L37", "1M", "1L36"],
			tackle: ["2L1", "2S0", "1L1"],
			takedown: ["1M"],
			teleport: ["1M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			thunderwave: ["1M"],
			toxic: ["2M", "1M"],
			zapcannon: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "agility"]},
		],
		encounters: [
			{generation: 1, level: 14},
			{generation: 1, level: 40},
		],
	},
	electrode: {
		learnset: {
			bide: ["1M"],
			curse: ["2M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			explosion: ["2L44", "1M", "1L50"],
			flash: ["2M", "1M"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			lightscreen: ["2L34", "1L29"],
			mimic: ["1M"],
			mirrorcoat: ["2L48"],
			protect: ["2M"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rollout: ["2M", "2L29"],
			screech: ["2L9", "2L1", "1L1"],
			selfdestruct: ["2L23", "2L1", "1M", "1L22"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			sonicboom: ["2L17", "2L1", "1L17", "1L1"],
			substitute: ["1M"],
			swagger: ["2M"],
			swift: ["2M", "2L40", "1M", "1L40"],
			tackle: ["2L1", "1L1"],
			takedown: ["1M"],
			teleport: ["1M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			thunderwave: ["1M"],
			toxic: ["2M", "1M"],
			zapcannon: ["2M"],
		},
		encounters: [
			{generation: 1, level: 3},
			{generation: 2, level: 23},
		],
	},
	exeggcute: {
		learnset: {
			ancientpower: ["2E"],
			attract: ["2M"],
			barrage: ["2L1", "2S0", "1L1"],
			bide: ["1M"],
			confusion: ["2L19"],
			curse: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dreameater: ["2M"],
			eggbomb: ["1M"],
			endure: ["2M"],
			explosion: ["1M"],
			flash: ["2M"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			hiddenpower: ["2M"],
			hypnosis: ["2L1", "2S0", "1L1"],
			leechseed: ["2L13", "1L28"],
			megadrain: ["2E"],
			mimic: ["1M"],
			moonlight: ["2E"],
			nightmare: ["2M"],
			poisonpowder: ["2L31", "1L37"],
			protect: ["2M"],
			psychic: ["2M", "1M"],
			psychup: ["2M"],
			psywave: ["1M"],
			rage: ["1M"],
			reflect: ["2L7", "2E", "1M", "1L25"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rollout: ["2M"],
			selfdestruct: ["1M"],
			sleeppowder: ["2L37", "1L48"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M", "2L43", "1L42"],
			strength: ["2M"],
			stunspore: ["2L25", "1L32"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			sweetscent: ["2S0"],
			synthesis: ["2E"],
			takedown: ["1M"],
			teleport: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["barrage", "hypnosis", "sweetscent"]},
		],
		encounters: [
			{generation: 1, level: 20},
		],
	},
	exeggutor: {
		learnset: {
			attract: ["2M"],
			barrage: ["2L1", "1L1"],
			bide: ["1M"],
			confusion: ["2L1"],
			curse: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dreameater: ["2M"],
			eggbomb: ["2L31", "1M"],
			endure: ["2M"],
			explosion: ["1M"],
			flash: ["2M"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			hypnosis: ["2L1", "1L1"],
			megadrain: ["1M"],
			mimic: ["1M"],
			nightmare: ["2M"],
			protect: ["2M"],
			psychic: ["2M", "1M"],
			psychup: ["2M"],
			psywave: ["1M"],
			rage: ["1M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rollout: ["2M"],
			selfdestruct: ["1M"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M", "1M"],
			stomp: ["2L19", "1L28"],
			strength: ["2M", "1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			takedown: ["1M"],
			teleport: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
		},
	},
	cubone: {
		learnset: {
			ancientpower: ["2E"],
			attract: ["2M"],
			bellydrum: ["2E"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			boneclub: ["2L9", "1L10", "1L1"],
			bonemerang: ["2L25", "1L43"],
			bonerush: ["2L41"],
			bubblebeam: ["1M"],
			counter: ["1M"],
			curse: ["2M"],
			detect: ["2M"],
			dig: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dynamicpunch: ["2M"],
			earthquake: ["2M", "1M"],
			endure: ["2M"],
			falseswipe: ["2L33"],
			fireblast: ["2M", "1M"],
			firepunch: ["2M"],
			fissure: ["1M"],
			flamethrower: ["2T"],
			focusenergy: ["2L21", "1L31"],
			frustration: ["2M"],
			furyattack: ["2S0"],
			growl: ["2L1", "2S0", "1L1"],
			headbutt: ["2M", "2L13", "1L18"],
			hiddenpower: ["2M"],
			icebeam: ["2T", "1M"],
			icywind: ["2M"],
			irontail: ["2M"],
			leer: ["2L17", "1L25"],
			megakick: ["1M"],
			megapunch: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			perishsong: ["2E"],
			protect: ["2M"],
			rage: ["2L29", "1M", "1L46"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rockslide: ["2E"],
			rocksmash: ["2M"],
			sandstorm: ["2M"],
			screech: ["2E"],
			seismictoss: ["1M"],
			skullbash: ["2E", "1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swordsdance: ["2E"],
			tailwhip: ["2L5", "2S0", "1L13"],
			takedown: ["1M"],
			thief: ["2M"],
			thrash: ["2L37", "1L38"],
			thunderpunch: ["2M"],
			toxic: ["2M", "1M"],
			watergun: ["1M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["growl", "tailwhip", "furyattack"]},
		],
		encounters: [
			{generation: 1, level: 16},
		],
	},
	marowak: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			boneclub: ["2L9", "2L1", "1L10", "1L1"],
			bonemerang: ["2L25", "1L48"],
			bonerush: ["2L53"],
			bubblebeam: ["1M"],
			counter: ["1M"],
			curse: ["2M"],
			detect: ["2M"],
			dig: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dynamicpunch: ["2M"],
			earthquake: ["2M", "1M"],
			endure: ["2M"],
			falseswipe: ["2L39"],
			fireblast: ["2M", "1M"],
			firepunch: ["2M"],
			fissure: ["1M"],
			flamethrower: ["2T"],
			focusenergy: ["2L21", "1L33", "1L1"],
			frustration: ["2M"],
			growl: ["2L1", "1L1"],
			headbutt: ["2M", "2L13", "2L1", "1L18"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			icebeam: ["2T", "1M"],
			icywind: ["2M"],
			irontail: ["2M"],
			leer: ["2L17", "1L25", "1L1"],
			megakick: ["1M"],
			megapunch: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			protect: ["2M"],
			rage: ["2L32", "1M", "1L55"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rocksmash: ["2M"],
			sandstorm: ["2M"],
			seismictoss: ["1M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			tailwhip: ["2L5", "2L1", "1L13", "1L1"],
			takedown: ["1M"],
			thief: ["2M"],
			thrash: ["2L46", "1L41"],
			thunderpunch: ["2M"],
			toxic: ["2M", "1M"],
			watergun: ["1M"],
		},
		encounters: [
			{generation: 1, level: 24},
			{generation: 2, level: 12},
		],
	},
	tyrogue: {
		learnset: {
			attract: ["2M"],
			curse: ["2M"],
			detect: ["2M"],
			dizzypunch: ["2S1"],
			doubleteam: ["2M"],
			endure: ["2M"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			highjumpkick: ["2E"],
			machpunch: ["2E"],
			mindreader: ["2E"],
			mudslap: ["2M"],
			protect: ["2M"],
			rage: ["2S0"],
			rapidspin: ["2E"],
			rest: ["2M"],
			return: ["2M"],
			rocksmash: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M"],
			tackle: ["2L1", "2S1", "2S0"],
			thief: ["2M"],
			toxic: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "rage"]},
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "dizzypunch"]},
		],
	},
	hitmonlee: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			counter: ["1M"],
			curse: ["2M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doublekick: ["2L1", "1L1", "1S0"],
			doubleteam: ["2M", "1M"],
			dynamicpunch: ["2M"],
			endure: ["2M", "2L41"],
			focusenergy: ["2L21", "1L43"],
			foresight: ["2L36"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			highjumpkick: ["2L26", "1L48"],
			jumpkick: ["2L16", "1L38"],
			meditate: ["2L6", "1L1", "1S0"],
			megakick: ["2L46", "1M", "1L53"],
			megapunch: ["1M"],
			metronome: ["1M"],
			mimic: ["1M"],
			mindreader: ["2L31"],
			mudslap: ["2M"],
			protect: ["2M"],
			rage: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			reversal: ["2L51"],
			rocksmash: ["2M"],
			rollingkick: ["2L11", "1L33"],
			seismictoss: ["1M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			takedown: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
		},
		eventData: [
			{generation: 1, level: 20, moves: ["doublekick", "meditate"]},
		],
		encounters: [
			{generation: 1, level: 30},
		],
	},
	hitmonchan: {
		learnset: {
			agility: ["2L7", "1L1", "1S0"],
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			cometpunch: ["2L1", "1L1", "1S0"],
			counter: ["2L50", "1M", "1L53"],
			curse: ["2M"],
			detect: ["2M", "2L44"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			firepunch: ["2M", "2L26", "1L33"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			icepunch: ["2M", "2L26", "1L38"],
			machpunch: ["2L32"],
			megakick: ["1M"],
			megapunch: ["2L38", "1M", "1L48"],
			metronome: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			protect: ["2M"],
			pursuit: ["2L13"],
			rage: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rocksmash: ["2M"],
			seismictoss: ["1M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			takedown: ["1M"],
			thief: ["2M"],
			thunderpunch: ["2M", "2L26", "1L43"],
			toxic: ["2M", "1M"],
		},
		eventData: [
			{generation: 1, level: 20, moves: ["cometpunch", "agility"]},
		],
		encounters: [
			{generation: 1, level: 30},
		],
	},
	hitmontop: {
		learnset: {
			agility: ["2L37"],
			attract: ["2M"],
			counter: ["2L31"],
			curse: ["2M"],
			detect: ["2M", "2L43"],
			dig: ["2M"],
			doubleteam: ["2M"],
			endure: ["2M"],
			focusenergy: ["2L7"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			mudslap: ["2M"],
			protect: ["2M"],
			pursuit: ["2L13"],
			quickattack: ["2L19"],
			rapidspin: ["2L25"],
			rest: ["2M"],
			return: ["2M"],
			rocksmash: ["2M"],
			rollingkick: ["2L1"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M"],
			thief: ["2M"],
			toxic: ["2M"],
			triplekick: ["2L49"],
		},
	},
	lickitung: {
		learnset: {
			attract: ["2M"],
			bellydrum: ["2E"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["2E", "1M"],
			bubblebeam: ["1M"],
			counter: ["1M"],
			curse: ["2M"],
			cut: ["2M", "1M"],
			defensecurl: ["2M", "2L13", "1L23"],
			disable: ["2L31", "1L15"],
			doubleedge: ["1M"],
			doubleslap: ["2S0"],
			doubleteam: ["2M", "1M"],
			dreameater: ["2M"],
			dynamicpunch: ["2M"],
			earthquake: ["2M", "1M"],
			endure: ["2M"],
			fireblast: ["2M", "1M"],
			firepunch: ["2M"],
			fissure: ["1M"],
			flamethrower: ["2T"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			icebeam: ["2T", "1M"],
			icepunch: ["2M"],
			icywind: ["2M"],
			irontail: ["2M"],
			lick: ["2L1", "2S0"],
			magnitude: ["2E"],
			megakick: ["1M"],
			megapunch: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			protect: ["2M"],
			psychup: ["2M"],
			rage: ["1M"],
			raindance: ["2M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rocksmash: ["2M"],
			rollout: ["2M"],
			sandstorm: ["2M"],
			screech: ["2L43", "1L39"],
			seismictoss: ["1M"],
			shadowball: ["2M"],
			skullbash: ["1M"],
			slam: ["2L37", "1L31"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			stomp: ["2L19", "1L7"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			supersonic: ["2L7", "1L1"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			swordsdance: ["1M"],
			takedown: ["1M"],
			thief: ["2M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			thunderpunch: ["2M"],
			toxic: ["2M", "1M"],
			watergun: ["1M"],
			wrap: ["2L25", "1L1"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["lick", "doubleslap"]},
		],
		encounters: [
			{generation: 1, level: 15},
		],
	},
	koffing: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			curse: ["2M"],
			destinybond: ["2L45", "2E"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			explosion: ["2L41", "1M", "1L48"],
			fireblast: ["2M", "1M"],
			flamethrower: ["2T"],
			frustration: ["2M"],
			haze: ["2L33", "1L45"],
			hiddenpower: ["2M"],
			mimic: ["1M"],
			painsplit: ["2E"],
			poisongas: ["2L1"],
			protect: ["2M"],
			psybeam: ["2E"],
			psywave: ["2E"],
			rage: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rollout: ["2M"],
			screech: ["2E"],
			selfdestruct: ["2L17", "1M", "1L40"],
			sleeptalk: ["2M"],
			sludge: ["2L21", "1L32"],
			sludgebomb: ["2M"],
			smog: ["2L9", "1L1"],
			smokescreen: ["2L25", "1L37"],
			snore: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			tackle: ["2L1", "1L1"],
			thief: ["2M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			toxic: ["2M", "1M"],
			zapcannon: ["2M"],
		},
		encounters: [
			{generation: 1, level: 30},
		],
	},
	weezing: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			curse: ["2M"],
			destinybond: ["2L51"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			explosion: ["2L44", "1M", "1L53"],
			fireblast: ["2M", "1M"],
			flamethrower: ["2T"],
			frustration: ["2M"],
			haze: ["2L33", "1L49"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			mimic: ["1M"],
			poisongas: ["2L1"],
			protect: ["2M"],
			rage: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rollout: ["2M"],
			selfdestruct: ["2L17", "2L1", "1M", "1L43"],
			sleeptalk: ["2M"],
			sludge: ["2L21", "1L32", "1L1"],
			sludgebomb: ["2M"],
			smog: ["2L9", "2L1", "1L1"],
			smokescreen: ["2L25", "1L39"],
			snore: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			tackle: ["2L1", "1L1"],
			thief: ["2M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			toxic: ["2M", "1M"],
			zapcannon: ["2M"],
		},
		encounters: [
			{generation: 2, level: 16},
		],
	},
	rhyhorn: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			blizzard: ["2M"],
			bodyslam: ["1M"],
			counter: ["2E"],
			crunch: ["2E"],
			curse: ["2M"],
			dig: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			earthquake: ["2M", "2L55", "1M"],
			endure: ["2M"],
			fireblast: ["2M", "1M"],
			fissure: ["1M"],
			flamethrower: ["2T"],
			frustration: ["2M"],
			furyattack: ["2L19", "1L1", "1L40"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hornattack: ["2L1", "1L1"],
			horndrill: ["2L37", "1M", "1L45"],
			icebeam: ["2T"],
			icywind: ["2M"],
			irontail: ["2M"],
			leer: ["1L50"],
			magnitude: ["2E"],
			mimic: ["1M"],
			mudslap: ["2M"],
			protect: ["2M"],
			pursuit: ["2E"],
			rage: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			reversal: ["2E"],
			roar: ["2M"],
			rockslide: ["2E", "1M"],
			rocksmash: ["2M"],
			rollout: ["2M"],
			sandstorm: ["2M"],
			scaryface: ["2L31"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			stomp: ["2L13", "1L1", "1L30"],
			strength: ["2M", "1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			tailwhip: ["2L1", "1L1", "1L35"],
			takedown: ["2L49", "1M", "1L55"],
			thrash: ["2E"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			toxic: ["2M", "1M"],
			zapcannon: ["2M"],
		},
		encounters: [
			{generation: 1, level: 20},
		],
	},
	rhydon: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubblebeam: ["1M"],
			counter: ["1M"],
			curse: ["2M"],
			dig: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dynamicpunch: ["2M"],
			earthquake: ["2M", "2L65", "1M"],
			endure: ["2M"],
			fireblast: ["2M", "1M"],
			firepunch: ["2M"],
			fissure: ["1M"],
			flamethrower: ["2T"],
			frustration: ["2M"],
			furyattack: ["2L19", "2L1", "1L40", "1L1"],
			furycutter: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hornattack: ["2L1", "1L1"],
			horndrill: ["2L37", "1M", "1L48"],
			hyperbeam: ["2M", "1M"],
			icebeam: ["2T", "1M"],
			icywind: ["2M"],
			irontail: ["2M"],
			leer: ["1L55"],
			megakick: ["1M"],
			megapunch: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			payday: ["1M"],
			protect: ["2M"],
			rage: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			roar: ["2M"],
			rockslide: ["1M"],
			rocksmash: ["2M"],
			rollout: ["2M"],
			sandstorm: ["2M"],
			scaryface: ["2L31"],
			seismictoss: ["1M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			stomp: ["2L13", "2L1", "1L30", "1L1"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			tailwhip: ["2L1", "1L35", "1L1"],
			takedown: ["2L54", "1M", "1L64"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			thunderpunch: ["2M"],
			toxic: ["2M", "1M"],
			watergun: ["1M"],
			zapcannon: ["2M"],
		},
		encounters: [
			{generation: 1, level: 15},
			{generation: 2, level: 10},
		],
	},
	chansey: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubblebeam: ["1M"],
			counter: ["1M"],
			curse: ["2M"],
			defensecurl: ["2M", "2L41", "1L44"],
			doubleedge: ["2L57", "1M", "1L54"],
			doubleslap: ["2L17", "1L12", "1L1"],
			doubleteam: ["2M", "1M"],
			dreameater: ["2M"],
			dynamicpunch: ["2M"],
			eggbomb: ["2L35", "1M"],
			endure: ["2M"],
			fireblast: ["2M", "1M"],
			flamethrower: ["2T"],
			flash: ["2M", "1M"],
			frustration: ["2M"],
			growl: ["2L5", "1L30"],
			headbutt: ["2M"],
			healbell: ["2E"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			icebeam: ["2T", "1M"],
			icywind: ["2M"],
			irontail: ["2M"],
			lightscreen: ["2L49", "1L48"],
			megakick: ["1M"],
			megapunch: ["1M"],
			metronome: ["2E", "1M"],
			mimic: ["1M"],
			minimize: ["2L23", "1L38"],
			mudslap: ["2M"],
			pound: ["2L1", "2S0", "1L1"],
			present: ["2E"],
			protect: ["2M"],
			psychic: ["2M", "1M"],
			psychup: ["2M"],
			psywave: ["1M"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rocksmash: ["2M"],
			rollout: ["2M"],
			sandstorm: ["2M"],
			seismictoss: ["1M"],
			shadowball: ["2M"],
			sing: ["2L29", "1L24"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			softboiled: ["2L13", "1M"],
			solarbeam: ["2M", "1M"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			sweetscent: ["2S0"],
			tailwhip: ["2L9", "1L1"],
			takedown: ["1M"],
			teleport: ["1M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			thunderwave: ["1M"],
			toxic: ["2M", "1M"],
			triattack: ["1M"],
			watergun: ["1M"],
			zapcannon: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["pound", "sweetscent"]},
		],
		encounters: [
			{generation: 1, level: 7},
		],
	},
	blissey: {
		learnset: {
			attract: ["2M"],
			blizzard: ["2M"],
			curse: ["2M"],
			defensecurl: ["2M", "2L33"],
			doubleedge: ["2L47"],
			doubleslap: ["2L13"],
			doubleteam: ["2M"],
			dreameater: ["2M"],
			dynamicpunch: ["2M"],
			eggbomb: ["2L28"],
			endure: ["2M"],
			fireblast: ["2M"],
			flamethrower: ["2T"],
			flash: ["2M"],
			frustration: ["2M"],
			growl: ["2L4"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			icebeam: ["2T"],
			icywind: ["2M"],
			lightscreen: ["2L40"],
			minimize: ["2L18"],
			mudslap: ["2M"],
			pound: ["2L1"],
			protect: ["2M"],
			psychic: ["2M"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			rocksmash: ["2M"],
			rollout: ["2M"],
			sandstorm: ["2M"],
			shadowball: ["2M"],
			sing: ["2L23"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			softboiled: ["2L10"],
			solarbeam: ["2M"],
			strength: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			tailwhip: ["2L7"],
			thunder: ["2M"],
			thunderbolt: ["2T"],
			toxic: ["2M"],
			zapcannon: ["2M"],
		},
	},
	tangela: {
		learnset: {
			absorb: ["2L10", "1L27", "1L29"],
			amnesia: ["2E"],
			attract: ["2M"],
			bide: ["1M"],
			bind: ["2L25", "1L24", "1L1"],
			bodyslam: ["1M"],
			confusion: ["2E"],
			constrict: ["2L1", "2S0", "1L1"],
			curse: ["2M"],
			cut: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			flail: ["2E"],
			flash: ["2M"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			growth: ["2L46", "1L48", "1L49"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			megadrain: ["2L31", "2E", "1M"],
			mimic: ["1M"],
			poisonpowder: ["2L13", "1L32"],
			protect: ["2M"],
			psychup: ["2M"],
			rage: ["1M"],
			reflect: ["2E"],
			rest: ["2M", "1M"],
			return: ["2M"],
			skullbash: ["1M"],
			slam: ["2L40", "1L45"],
			sleeppowder: ["2L4", "2S0", "1L39"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M", "1M"],
			stunspore: ["2L34", "1L36"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			sweetscent: ["2M"],
			swordsdance: ["1M"],
			synthesis: ["2S0"],
			takedown: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
			vinewhip: ["2L19", "1L29"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["constrict", "sleeppowder", "synthesis"]},
		],
		encounters: [
			{generation: 1, level: 13},
		],
	},
	kangaskhan: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bite: ["2L13", "1L26"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubblebeam: ["1M"],
			cometpunch: ["2L1", "2S0", "1L1"],
			counter: ["1M"],
			curse: ["2M"],
			disable: ["2E"],
			dizzypunch: ["2L43", "1L46"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dynamicpunch: ["2M"],
			earthquake: ["2M", "1M"],
			endure: ["2M", "2L37"],
			feintattack: ["2S0"],
			fireblast: ["2M", "1M"],
			firepunch: ["2M"],
			fissure: ["1M"],
			flamethrower: ["2T"],
			focusenergy: ["2E"],
			foresight: ["2E"],
			frustration: ["2M"],
			furycutter: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			icebeam: ["2T", "1M"],
			icepunch: ["2M"],
			icywind: ["2M"],
			irontail: ["2M"],
			leer: ["2L7", "1L41"],
			megakick: ["1M"],
			megapunch: ["2L25", "1M", "1L36"],
			mimic: ["1M"],
			mudslap: ["2M"],
			protect: ["2M"],
			rage: ["2L31", "1M", "1L1"],
			raindance: ["2M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			reversal: ["2L49"],
			roar: ["2M"],
			rockslide: ["1M"],
			rocksmash: ["2M"],
			safeguard: ["2E"],
			sandstorm: ["2M"],
			seismictoss: ["1M"],
			shadowball: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			stomp: ["2E"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			tailwhip: ["2L19", "1L31"],
			takedown: ["1M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			thunderpunch: ["2M"],
			toxic: ["2M", "1M"],
			watergun: ["1M"],
			zapcannon: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["cometpunch", "feintattack"]},
		],
		encounters: [
			{generation: 1, level: 25},
			{generation: 1, level: 15, japan: true},
		],
	},
	horsea: {
		learnset: {
			agility: ["2L36", "1L37"],
			attract: ["2M"],
			aurorabeam: ["2E"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bubble: ["2L1", "2S0", "1L1"],
			bubblebeam: ["1M"],
			curse: ["2M"],
			disable: ["2E"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dragonbreath: ["2M"],
			dragonrage: ["2E"],
			endure: ["2M"],
			flail: ["2E"],
			frustration: ["2M"],
			haze: ["2S0"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hydropump: ["2L43", "1L45"],
			icebeam: ["2T", "1M"],
			icywind: ["2M"],
			leer: ["2L15", "1L24"],
			mimic: ["1M"],
			octazooka: ["2E"],
			protect: ["2M"],
			rage: ["1M"],
			raindance: ["2M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			smokescreen: ["2L8", "1L19"],
			snore: ["2M"],
			splash: ["2E"],
			substitute: ["1M"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
			twister: ["2L29"],
			waterfall: ["2M"],
			watergun: ["2L22", "1M", "1L30"],
			whirlpool: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["bubble", "haze"]},
		],
		encounters: [
			{generation: 1, level: 5},
		],
	},
	seadra: {
		learnset: {
			agility: ["2L40", "1L41"],
			attract: ["2M"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bubble: ["2L1", "1L1"],
			bubblebeam: ["1M"],
			curse: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dragonbreath: ["2M"],
			endure: ["2M"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hydropump: ["2L51", "1L52"],
			hyperbeam: ["2M", "1M"],
			icebeam: ["2T", "1M"],
			icywind: ["2M"],
			leer: ["2L15", "2L1", "1L24"],
			mimic: ["1M"],
			protect: ["2M"],
			rage: ["1M"],
			raindance: ["2M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			smokescreen: ["2L8", "2L1", "1L19", "1L1"],
			snore: ["2M"],
			substitute: ["1M"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
			twister: ["2L29"],
			waterfall: ["2M"],
			watergun: ["2L22", "2L1", "1M", "1L30"],
			whirlpool: ["2M"],
		},
		encounters: [
			{generation: 1, level: 20},
			{generation: 2, level: 20},
		],
	},
	kingdra: {
		learnset: {
			agility: ["2L40"],
			attract: ["2M"],
			blizzard: ["2M"],
			bubble: ["2L1"],
			curse: ["2M"],
			doubleteam: ["2M"],
			dragonbreath: ["2M"],
			endure: ["2M"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hydropump: ["2L51"],
			hyperbeam: ["2M"],
			icebeam: ["2T"],
			icywind: ["2M"],
			leer: ["2L15", "2L1"],
			protect: ["2M"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			sleeptalk: ["2M"],
			smokescreen: ["2L8", "2L1"],
			snore: ["2M"],
			surf: ["2M"],
			swagger: ["2M"],
			swift: ["2M"],
			toxic: ["2M"],
			twister: ["2L29"],
			waterfall: ["2M"],
			watergun: ["2L22", "2L1"],
			whirlpool: ["2M"],
		},
	},
	goldeen: {
		learnset: {
			agility: ["2L52", "1L54"],
			attract: ["2M"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bubblebeam: ["1M"],
			curse: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			flail: ["2L24"],
			frustration: ["2M"],
			furyattack: ["2L29", "1L30"],
			haze: ["2E"],
			hiddenpower: ["2M"],
			hornattack: ["2L15", "1L24"],
			horndrill: ["2L43", "1M", "1L45"],
			hydropump: ["2E"],
			icebeam: ["2T", "1M"],
			icywind: ["2M"],
			mimic: ["1M"],
			peck: ["2L1", "2S0", "1L1"],
			protect: ["2M"],
			psybeam: ["2E"],
			rage: ["1M"],
			raindance: ["2M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			substitute: ["1M"],
			supersonic: ["2L10", "1L19"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			swordsdance: ["2S0"],
			tailwhip: ["2L1", "2S0", "1L1"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
			waterfall: ["2M", "2L38", "1L37"],
			watergun: ["1M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["peck", "tailwhip", "swordsdance"]},
		],
		encounters: [
			{generation: 1, level: 5},
		],
	},
	seaking: {
		learnset: {
			agility: ["2L61", "1L54"],
			attract: ["2M"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bubblebeam: ["1M"],
			curse: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			flail: ["2L24"],
			frustration: ["2M"],
			furyattack: ["2L29", "1L30"],
			hiddenpower: ["2M"],
			hornattack: ["2L15", "1L24"],
			horndrill: ["2L49", "1M", "1L48"],
			hyperbeam: ["2M", "1M"],
			icebeam: ["2T", "1M"],
			icywind: ["2M"],
			mimic: ["1M"],
			peck: ["2L1", "1L1"],
			protect: ["2M"],
			rage: ["1M"],
			raindance: ["2M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			substitute: ["1M"],
			supersonic: ["2L10", "1L19", "1L1"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			tailwhip: ["2L1", "1L1"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
			waterfall: ["2M", "2L41", "1L39"],
			watergun: ["1M"],
		},
		encounters: [
			{generation: 1, level: 23},
			{generation: 2, level: 10},
		],
	},
	staryu: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bubblebeam: ["2L31", "1M"],
			curse: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			flash: ["2M", "1M"],
			frustration: ["2M"],
			harden: ["2L1", "2S0", "1L22"],
			hiddenpower: ["2M"],
			hydropump: ["2L50", "1L47"],
			icebeam: ["2T", "1M"],
			icywind: ["2M"],
			lightscreen: ["2L43", "1L42"],
			mimic: ["1M"],
			minimize: ["2L37", "1L37"],
			protect: ["2M"],
			psychic: ["2M", "1M"],
			psychup: ["2M"],
			psywave: ["1M"],
			rage: ["1M"],
			raindance: ["2M"],
			rapidspin: ["2L13"],
			recover: ["2L19", "1L27"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			substitute: ["1M"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			swift: ["2M", "2L25", "1M", "1L32"],
			tackle: ["2L1", "2S0", "1L1"],
			takedown: ["1M"],
			teleport: ["1M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			thunderwave: ["1M"],
			toxic: ["2M", "1M"],
			triattack: ["1M"],
			twister: ["2S0"],
			waterfall: ["2M"],
			watergun: ["2L7", "1M", "1L17"],
			whirlpool: ["2M"],
			zapcannon: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "harden", "twister"]},
		],
		encounters: [
			{generation: 1, level: 5},
		],
	},
	starmie: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bubblebeam: ["2L1", "1M"],
			confuseray: ["2L37"],
			curse: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dreameater: ["2M"],
			endure: ["2M"],
			flash: ["2M", "1M"],
			frustration: ["2M"],
			harden: ["1L1"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			icebeam: ["2T", "1M"],
			icywind: ["2M"],
			mimic: ["1M"],
			nightmare: ["2M"],
			protect: ["2M"],
			psychic: ["2M", "1M"],
			psychup: ["2M"],
			psywave: ["1M"],
			rage: ["1M"],
			raindance: ["2M"],
			rapidspin: ["2L1"],
			recover: ["2L1"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			substitute: ["1M"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			tackle: ["2L1", "1L1"],
			takedown: ["1M"],
			teleport: ["1M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			thunderwave: ["1M"],
			toxic: ["2M", "1M"],
			triattack: ["1M"],
			waterfall: ["2M"],
			watergun: ["1M", "1L1"],
			whirlpool: ["2M"],
			zapcannon: ["2M"],
		},
		encounters: [
			{generation: 1, level: 6},
		],
	},
	mrmime: {
		learnset: {
			attract: ["2M"],
			barrier: ["2L1", "2S0", "1L1"],
			batonpass: ["2L41"],
			bide: ["1M"],
			bodyslam: ["1M"],
			confusion: ["2L6", "1L15", "1L1"],
			counter: ["1M"],
			curse: ["2M"],
			doubleedge: ["1M"],
			doubleslap: ["2L21", "1L31"],
			doubleteam: ["2M", "1M"],
			dreameater: ["2M"],
			dynamicpunch: ["2M"],
			encore: ["2L31"],
			endure: ["2M"],
			firepunch: ["2M"],
			flash: ["2M", "1M"],
			frustration: ["2M"],
			futuresight: ["2E"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			hypnosis: ["2E"],
			icepunch: ["2M"],
			lightscreen: ["2L26", "1L23"],
			meditate: ["2L16", "1L39"],
			megakick: ["1M"],
			megapunch: ["1M"],
			metronome: ["1M"],
			mimic: ["2E", "1M"],
			mindreader: ["2S0"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			protect: ["2M"],
			psybeam: ["2L36"],
			psychic: ["2M", "1M"],
			psychup: ["2M"],
			psywave: ["1M"],
			rage: ["1M"],
			reflect: ["2L26", "1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			safeguard: ["2L46"],
			seismictoss: ["1M"],
			shadowball: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["2L11", "1M", "1L47"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			takedown: ["1M"],
			teleport: ["1M"],
			thief: ["2M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			thunderpunch: ["2M"],
			thunderwave: ["1M"],
			toxic: ["2M", "1M"],
			zapcannon: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["barrier", "mindreader"]},
		],
	},
	scyther: {
		learnset: {
			agility: ["2L24", "1L42"],
			attract: ["2M"],
			batonpass: ["2E"],
			bide: ["1M"],
			counter: ["2E"],
			curse: ["2M"],
			cut: ["2M", "1M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "2L48", "1M", "1L24"],
			endure: ["2M"],
			falseswipe: ["2L18"],
			focusenergy: ["2L6", "1L20"],
			frustration: ["2M"],
			furycutter: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			leer: ["2L1", "2S0", "1L17"],
			lightscreen: ["2E"],
			mimic: ["1M"],
			protect: ["2M"],
			pursuit: ["2L12"],
			quickattack: ["2L1", "2S0", "1L1"],
			rage: ["1M"],
			razorwind: ["2E"],
			rest: ["2M", "1M"],
			return: ["2M"],
			reversal: ["2E"],
			rocksmash: ["2M"],
			safeguard: ["2E"],
			skullbash: ["1M"],
			slash: ["2L36", "1L29"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			sonicboom: ["2S0"],
			steelwing: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			swordsdance: ["2L42", "1M", "1L35"],
			takedown: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
			wingattack: ["2L30", "1L50"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["quickattack", "leer", "sonicboom"]},
		],
		encounters: [
			{generation: 1, level: 15},
			{generation: 1, level: 25},
		],
	},
	scizor: {
		learnset: {
			agility: ["2L24"],
			attract: ["2M"],
			curse: ["2M"],
			cut: ["2M"],
			detect: ["2M"],
			doubleteam: ["2M", "2L48"],
			endure: ["2M"],
			falseswipe: ["2L18"],
			focusenergy: ["2L6"],
			frustration: ["2M"],
			furycutter: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			leer: ["2L1"],
			metalclaw: ["2L30"],
			protect: ["2M"],
			pursuit: ["2L12"],
			quickattack: ["2L1"],
			rest: ["2M"],
			return: ["2M"],
			rocksmash: ["2M"],
			sandstorm: ["2M"],
			slash: ["2L36"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			steelwing: ["2M"],
			strength: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M"],
			swordsdance: ["2L42"],
			thief: ["2M"],
			toxic: ["2M"],
		},
	},
	smoochum: {
		learnset: {
			attract: ["2M"],
			blizzard: ["2M", "2L49"],
			confusion: ["2L21"],
			curse: ["2M"],
			dizzypunch: ["2S2"],
			doubleteam: ["2M"],
			dreameater: ["2M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			frustration: ["2M"],
			hiddenpower: ["2M"],
			icebeam: ["2T"],
			icepunch: ["2M"],
			icywind: ["2M"],
			lick: ["2L1", "2S2", "2S1", "2S0"],
			meanlook: ["2L33"],
			meditate: ["2E"],
			metronome: ["2S0"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			perishsong: ["2L45"],
			petaldance: ["2S1"],
			pound: ["2L1", "2S2", "2S1", "2S0"],
			powdersnow: ["2L13"],
			protect: ["2M"],
			psychic: ["2M", "2L37"],
			psychup: ["2M"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			shadowball: ["2M"],
			sing: ["2L25"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			swagger: ["2M"],
			sweetkiss: ["2L9"],
			sweetscent: ["2M"],
			thief: ["2M"],
			toxic: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["pound", "lick", "metronome"]},
			{generation: 2, level: 5, shiny: 1, moves: ["pound", "lick", "petaldance"]},
			{generation: 2, level: 5, shiny: 1, moves: ["pound", "lick", "dizzypunch"]},
		],
	},
	jynx: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			blizzard: ["2M", "2L57", "1M", "1L58"],
			bodyslam: ["2L41", "1M", "1L39"],
			bubblebeam: ["1M"],
			counter: ["1M"],
			curse: ["2M"],
			doubleedge: ["1M"],
			doubleslap: ["2L21", "1L23"],
			doubleteam: ["2M", "1M"],
			dreameater: ["2M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			icebeam: ["2T", "1M"],
			icepunch: ["2M", "2L25", "1L31"],
			icywind: ["2M"],
			lick: ["2L1", "1L18"],
			lovelykiss: ["2L9", "2L1", "1L1"],
			meanlook: ["2L35"],
			megakick: ["1M"],
			megapunch: ["1M"],
			metronome: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			perishsong: ["2L51"],
			pound: ["2L1", "1L1"],
			powdersnow: ["2L13", "2L1"],
			protect: ["2M"],
			psychic: ["2M", "1M"],
			psychup: ["2M"],
			psywave: ["1M"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			seismictoss: ["1M"],
			shadowball: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			submission: ["1M"],
			substitute: ["1M"],
			swagger: ["2M"],
			sweetscent: ["2M"],
			takedown: ["1M"],
			teleport: ["1M"],
			thief: ["2M"],
			thrash: ["1L47"],
			toxic: ["2M", "1M"],
			watergun: ["1M"],
		},
		encounters: [
			{generation: 1, level: 15},
			{generation: 2, level: 10},
		],
	},
	elekid: {
		learnset: {
			attract: ["2M"],
			barrier: ["2E"],
			crosschop: ["2E"],
			curse: ["2M"],
			detect: ["2M"],
			dizzypunch: ["2S0"],
			doubleteam: ["2M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			firepunch: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			icepunch: ["2M"],
			karatechop: ["2E"],
			leer: ["2L1", "2S1", "2S0"],
			lightscreen: ["2L17"],
			meditate: ["2E"],
			mudslap: ["2M"],
			protect: ["2M"],
			psychic: ["2M"],
			pursuit: ["2S1"],
			quickattack: ["2L1", "2S1", "2S0"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			rollingkick: ["2E"],
			screech: ["2L33"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "2L25"],
			thief: ["2M"],
			thunder: ["2M", "2L49"],
			thunderbolt: ["2T", "2L41"],
			thunderpunch: ["2M", "2L9"],
			toxic: ["2M"],
			zapcannon: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["quickattack", "leer", "dizzypunch"]},
			{generation: 2, level: 5, shiny: 1, moves: ["quickattack", "leer", "pursuit"]},
		],
	},
	electabuzz: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			counter: ["1M"],
			curse: ["2M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			firepunch: ["2M"],
			flash: ["2M", "1M"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			icepunch: ["2M"],
			irontail: ["2M"],
			leer: ["2L1", "1L1"],
			lightscreen: ["2L17", "1L49"],
			megakick: ["1M"],
			megapunch: ["1M"],
			metronome: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			protect: ["2M"],
			psychic: ["2M", "1M"],
			psywave: ["1M"],
			quickattack: ["2L1", "1L1"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rocksmash: ["2M"],
			screech: ["2L36", "1L37"],
			seismictoss: ["1M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			swagger: ["2M"],
			swift: ["2M", "2L25", "1M"],
			takedown: ["1M"],
			teleport: ["1M"],
			thief: ["2M"],
			thunder: ["2M", "2L58", "1M", "1L54"],
			thunderbolt: ["2T", "2L47", "1M"],
			thunderpunch: ["2M", "2L9", "2L1", "1L42"],
			thundershock: ["1L34"],
			thunderwave: ["1M"],
			toxic: ["2M", "1M"],
			zapcannon: ["2M"],
		},
		encounters: [
			{generation: 1, level: 33},
			{generation: 2, level: 15},
		],
	},
	magby: {
		learnset: {
			attract: ["2M"],
			barrier: ["2E"],
			confuseray: ["2L43"],
			crosschop: ["2E"],
			curse: ["2M"],
			detect: ["2M"],
			dizzypunch: ["2S1"],
			doubleteam: ["2M"],
			dynamicpunch: ["2M"],
			ember: ["2L1", "2S1", "2S0"],
			endure: ["2M"],
			feintattack: ["2S0"],
			fireblast: ["2M", "2L49"],
			firepunch: ["2M", "2L19"],
			flamethrower: ["2T", "2L37"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			irontail: ["2M"],
			karatechop: ["2E"],
			leer: ["2L7"],
			megapunch: ["2E"],
			mudslap: ["2M"],
			protect: ["2M"],
			psychic: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			screech: ["2E"],
			sleeptalk: ["2M"],
			smog: ["2L13"],
			smokescreen: ["2L25"],
			snore: ["2M"],
			sunnyday: ["2M", "2L31"],
			swagger: ["2M"],
			thief: ["2M"],
			thunderpunch: ["2M"],
			toxic: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["ember", "feintattack"]},
			{generation: 2, level: 5, shiny: 1, moves: ["ember", "dizzypunch"]},
		],
	},
	magmar: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			confuseray: ["2L49", "1L39"],
			counter: ["1M"],
			curse: ["2M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dynamicpunch: ["2M"],
			ember: ["2L1", "1L1"],
			endure: ["2M"],
			fireblast: ["2M", "2L57", "1M"],
			firepunch: ["2M", "2L19", "2L1", "1L43"],
			flamethrower: ["2T", "2L41", "1L55"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			irontail: ["2M"],
			leer: ["2L7", "2L1", "1L36"],
			megakick: ["1M"],
			megapunch: ["1M"],
			metronome: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			protect: ["2M"],
			psychic: ["2M", "1M"],
			psywave: ["1M"],
			rage: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rocksmash: ["2M"],
			seismictoss: ["1M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			smog: ["2L13", "2L1", "1L52"],
			smokescreen: ["2L25", "1L48"],
			snore: ["2M"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M", "2L33"],
			swagger: ["2M"],
			takedown: ["1M"],
			teleport: ["1M"],
			thief: ["2M"],
			thunderpunch: ["2M"],
			toxic: ["2M", "1M"],
		},
		encounters: [
			{generation: 1, level: 34},
			{generation: 2, level: 14},
		],
	},
	pinsir: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bind: ["2L13", "1L21"],
			bodyslam: ["1M"],
			curse: ["2M"],
			cut: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			flail: ["2E"],
			focusenergy: ["2L7", "1L36"],
			frustration: ["2M"],
			furyattack: ["2E"],
			furycutter: ["2M"],
			guillotine: ["2L31", "1L30"],
			harden: ["2L25", "1L43"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			mimic: ["1M"],
			protect: ["2M"],
			rage: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rocksmash: ["2M"],
			rockthrow: ["2S0"],
			seismictoss: ["2L19", "1M", "1L25"],
			slash: ["1L49"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M", "1M"],
			submission: ["2L37", "1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swordsdance: ["2L43", "1M", "1L54"],
			takedown: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
			visegrip: ["2L1", "2S0", "1L1"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["visegrip", "rockthrow"]},
		],
		encounters: [
			{generation: 1, level: 15},
			{generation: 1, level: 20},
		],
	},
	tauros: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			curse: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			earthquake: ["2M", "1M"],
			endure: ["2M"],
			fireblast: ["2M", "1M"],
			fissure: ["1M"],
			flamethrower: ["2T"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hornattack: ["2L13"],
			horndrill: ["1M"],
			hyperbeam: ["2M", "1M"],
			icebeam: ["2T", "1M"],
			icywind: ["2M"],
			irontail: ["2M"],
			leer: ["1L35"],
			mimic: ["1M"],
			protect: ["2M"],
			pursuit: ["2L26"],
			quickattack: ["2S0"],
			rage: ["2L8", "1M", "1L44"],
			rest: ["2M", "2L34", "1M"],
			return: ["2M"],
			rocksmash: ["2M"],
			scaryface: ["2L19"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			stomp: ["1L21"],
			strength: ["2M", "1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			surf: ["2M"],
			swagger: ["2M"],
			tackle: ["2L1", "2S0", "1L1"],
			tailwhip: ["2L4", "2S0", "1L28"],
			takedown: ["2L53", "1M", "1L51"],
			thrash: ["2L43"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			toxic: ["2M", "1M"],
			zapcannon: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "tailwhip", "quickattack"]},
		],
		encounters: [
			{generation: 1, level: 21},
		],
	},
	magikarp: {
		learnset: {
			bubble: ["2S1"],
			dragonrage: ["1S0"],
			flail: ["2L30"],
			reversal: ["2S2"],
			splash: ["2L1", "2S2", "2S1", "1L1", "1S0"],
			tackle: ["2L15", "1L15"],
		},
		eventData: [
			{generation: 1, level: 15, moves: ["splash", "dragonrage"], japan: true},
			{generation: 2, level: 5, shiny: 1, moves: ["splash", "bubble"]},
			{generation: 2, level: 5, shiny: 1, moves: ["splash", "reversal"]},
		],
		encounters: [
			{generation: 1, level: 5},
		],
	},
	gyarados: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bite: ["2L20", "1L20", "1L1"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubblebeam: ["1M"],
			curse: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dragonbreath: ["2M"],
			dragonrage: ["2L25", "1M", "1L25", "1L1"],
			endure: ["2M"],
			fireblast: ["2M", "1M"],
			flamethrower: ["2T"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hydropump: ["2L40", "1L41", "1L1"],
			hyperbeam: ["2M", "2L50", "1M", "1L52"],
			icebeam: ["2T", "1M"],
			icywind: ["2M"],
			leer: ["2L30", "1L32", "1L1"],
			mimic: ["1M"],
			protect: ["2M"],
			rage: ["1M"],
			raindance: ["2M", "2L45"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			roar: ["2M"],
			rocksmash: ["2M"],
			sandstorm: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M", "1M"],
			substitute: ["1M"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			tackle: ["1L1"],
			takedown: ["1M"],
			thrash: ["2L1"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			toxic: ["2M", "1M"],
			twister: ["2L35"],
			waterfall: ["2M"],
			watergun: ["1M"],
			whirlpool: ["2M"],
			zapcannon: ["2M"],
		},
		encounters: [
			{generation: 1, level: 15},
			{generation: 2, level: 15},
		],
	},
	lapras: {
		learnset: {
			attract: ["2M"],
			aurorabeam: ["2E"],
			bide: ["1M"],
			bite: ["2S0"],
			blizzard: ["2M", "1M"],
			bodyslam: ["2L15", "1M", "1L25"],
			bubblebeam: ["1M"],
			confuseray: ["2L22", "1L31"],
			curse: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dragonbreath: ["2M"],
			dragonrage: ["1M"],
			dreameater: ["2M"],
			endure: ["2M"],
			foresight: ["2E"],
			frustration: ["2M"],
			futuresight: ["2S1"],
			growl: ["2L1", "2S1", "2S0", "1L1"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			horndrill: ["1M"],
			hydropump: ["2L57", "1L46"],
			hyperbeam: ["2M", "1M"],
			icebeam: ["2T", "2L36", "1M", "1L38"],
			icywind: ["2M"],
			irontail: ["2M"],
			mimic: ["1M"],
			mist: ["2L8", "1L20"],
			nightmare: ["2M"],
			perishsong: ["2L29"],
			protect: ["2M"],
			psychic: ["2M", "1M"],
			psywave: ["1M"],
			rage: ["1M"],
			raindance: ["2M", "2L43"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rocksmash: ["2M"],
			safeguard: ["2L50"],
			sing: ["2L1", "2S1", "2S0", "1L16"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["1M"],
			strength: ["2M", "1M"],
			substitute: ["1M"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			takedown: ["1M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			toxic: ["2M", "1M"],
			watergun: ["2L1", "2S1", "2S0", "1M", "1L1"],
			whirlpool: ["2M"],
			zapcannon: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["watergun", "growl", "sing", "bite"]},
			{generation: 2, level: 5, shiny: 1, moves: ["watergun", "growl", "sing", "futuresight"]},
		],
		encounters: [
			{generation: 1, level: 15},
		],
	},
	ditto: {
		learnset: {
			transform: ["2L1", "1L1"],
		},
		encounters: [
			{generation: 1, level: 12},
			{generation: 2, level: 10},
		],
	},
	eevee: {
		learnset: {
			attract: ["2M"],
			batonpass: ["2L36"],
			bide: ["1M"],
			bite: ["2L30", "1L30", "1L37"],
			bodyslam: ["1M"],
			charm: ["2E"],
			curse: ["2M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			flail: ["2E"],
			focusenergy: ["2L36", "1L36"],
			frustration: ["2M"],
			growl: ["2L16", "1L16"],
			growth: ["2S0"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			irontail: ["2M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			protect: ["2M"],
			quickattack: ["2L23", "1L23", "1L27"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			sandattack: ["2L8", "1L8", "1L1"],
			shadowball: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			tackle: ["2L1", "2S0", "1L1"],
			tailwhip: ["2L1", "2S0", "1L1", "1L31"],
			takedown: ["2L42", "1M", "1L42", "1L45"],
			toxic: ["2M", "1M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "tailwhip", "growth"]},
		],
		encounters: [
			{generation: 1, level: 25},
		],

	},
	vaporeon: {
		learnset: {
			acidarmor: ["2L47", "1L47", "1L42"],
			attract: ["2M"],
			aurorabeam: ["2L36", "1L36"],
			bide: ["1M"],
			bite: ["2L30", "1L30", "1L40"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubblebeam: ["1M"],
			curse: ["2M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			frustration: ["2M"],
			haze: ["2L42", "1L42", "1L44"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hydropump: ["2L52", "1L52", "1L54"],
			hyperbeam: ["2M", "1M"],
			icebeam: ["2T", "1M"],
			icywind: ["2M"],
			irontail: ["2M"],
			mimic: ["1M"],
			mist: ["1L42", "1L48"],
			mudslap: ["2M"],
			protect: ["2M"],
			quickattack: ["2L23", "1L23", "1L27", "1L1"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			roar: ["2M"],
			sandattack: ["2L8", "1L8", "1L1"],
			shadowball: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			tackle: ["2L1", "1L1"],
			tailwhip: ["2L1", "1L1", "1L37"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
			waterfall: ["2M"],
			watergun: ["2L16", "1M", "1L16", "1L31", "1L1"],
			whirlpool: ["2M"],
		},
	},
	jolteon: {
		learnset: {
			agility: ["2L47", "1L47", "1L44"],
			attract: ["2M"],
			bide: ["1M"],
			bodyslam: ["1M"],
			curse: ["2M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doublekick: ["2L30", "1L30", "1L42"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			flash: ["2M", "1M"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			irontail: ["2M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			pinmissile: ["2L36", "1L36", "1L48"],
			protect: ["2M"],
			quickattack: ["2L23", "1L23", "1L27", "1L1"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			roar: ["2M"],
			sandattack: ["2L8", "1L8", "1L1"],
			shadowball: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			tackle: ["2L1", "1L1"],
			tailwhip: ["2L1", "1L1", "1L37"],
			takedown: ["1M"],
			thunder: ["2M", "2L52", "1M", "1L52", "1L54"],
			thunderbolt: ["2T", "1M"],
			thundershock: ["2L16", "1L16", "1L31", "1L1"],
			thunderwave: ["2L42", "1M", "1L42", "1L40"],
			toxic: ["2M", "1M"],
			zapcannon: ["2M"],
		},
	},
	flareon: {
		learnset: {
			attract: ["2M"],
			bide: ["1M"],
			bite: ["2L30", "1L30", "1L40"],
			bodyslam: ["1M"],
			curse: ["2M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			ember: ["2L16", "1L16", "1L31", "1L1"],
			endure: ["2M"],
			fireblast: ["2M", "1M"],
			firespin: ["2L36", "1L36", "1L44"],
			flamethrower: ["2T", "2L52", "1L52", "1L54"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			irontail: ["2M"],
			leer: ["2L47", "1L47", "1L42"],
			mimic: ["1M"],
			mudslap: ["2M"],
			protect: ["2M"],
			quickattack: ["2L23", "1L23", "1L27", "1L1"],
			rage: ["1M", "1L48"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			roar: ["2M"],
			sandattack: ["2L8", "1L8", "1L1"],
			shadowball: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			smog: ["2L42", "1L42"],
			snore: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			tackle: ["2L1", "1L1"],
			tailwhip: ["2L1", "1L1", "1L37"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
			zapcannon: ["2M"],
		},
	},
	espeon: {
		learnset: {
			attract: ["2M"],
			confusion: ["2L16"],
			curse: ["2M"],
			cut: ["2M"],
			detect: ["2M"],
			doubleteam: ["2M"],
			dreameater: ["2M"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			irontail: ["2M"],
			morningsun: ["2L52"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			protect: ["2M"],
			psybeam: ["2L36"],
			psychic: ["2M", "2L47"],
			psychup: ["2M", "2L42"],
			quickattack: ["2L23"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			sandattack: ["2L8"],
			shadowball: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "2L30"],
			tackle: ["2L1"],
			tailwhip: ["2L1"],
			toxic: ["2M"],
			zapcannon: ["2M"],
		},
	},
	umbreon: {
		learnset: {
			attract: ["2M"],
			confuseray: ["2L30"],
			curse: ["2M"],
			cut: ["2M"],
			detect: ["2M"],
			doubleteam: ["2M"],
			dreameater: ["2M"],
			endure: ["2M"],
			feintattack: ["2L36"],
			flash: ["2M"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			irontail: ["2M"],
			meanlook: ["2L42"],
			moonlight: ["2L52"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			protect: ["2M"],
			psychic: ["2M"],
			psychup: ["2M"],
			pursuit: ["2L16"],
			quickattack: ["2L23"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			sandattack: ["2L8"],
			screech: ["2L47"],
			shadowball: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M"],
			tackle: ["2L1"],
			tailwhip: ["2L1"],
			toxic: ["2M"],
			zapcannon: ["2M"],
		},
	},
	porygon: {
		learnset: {
			agility: ["2L9", "1L35"],
			barrier: ["2S0"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			conversion: ["2L1", "2S0", "1L1"],
			curse: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dreameater: ["2M"],
			endure: ["2M"],
			flash: ["2M", "1M"],
			frustration: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			icebeam: ["2T", "1M"],
			icywind: ["2M"],
			irontail: ["2M"],
			lockon: ["2L32"],
			mimic: ["1M"],
			nightmare: ["2M"],
			protect: ["2M"],
			psybeam: ["2L12", "1L23"],
			psychic: ["2M", "1M"],
			psychup: ["2M"],
			psywave: ["1M"],
			rage: ["1M"],
			raindance: ["2M"],
			recover: ["2L20", "1L28"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			sharpen: ["2L24", "1L1"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			tackle: ["2L1", "2S0", "1L1"],
			takedown: ["1M"],
			teleport: ["1M"],
			thief: ["2M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			thunderwave: ["1M"],
			toxic: ["2M", "1M"],
			triattack: ["2L36", "1M", "1L42"],
			zapcannon: ["2M", "2L44"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "conversion", "barrier"]},
		],
		encounters: [
			{generation: 1, level: 18},
		],
	},
	porygon2: {
		learnset: {
			agility: ["2L9"],
			blizzard: ["2M"],
			conversion: ["2L1"],
			conversion2: ["2L1"],
			curse: ["2M"],
			defensecurl: ["2M", "2L24"],
			doubleteam: ["2M"],
			dreameater: ["2M"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			icebeam: ["2T"],
			icywind: ["2M"],
			irontail: ["2M"],
			lockon: ["2L32"],
			nightmare: ["2M"],
			protect: ["2M"],
			psybeam: ["2L12"],
			psychic: ["2M"],
			psychup: ["2M"],
			raindance: ["2M"],
			recover: ["2L20"],
			rest: ["2M"],
			return: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M"],
			thief: ["2M"],
			thunder: ["2M"],
			thunderbolt: ["2T"],
			toxic: ["2M"],
			triattack: ["2L36"],
			zapcannon: ["2M", "2L44"],
		},
	},
	omanyte: {
		learnset: {
			ancientpower: ["2L49"],
			attract: ["2M"],
			aurorabeam: ["2E"],
			bide: ["1M"],
			bite: ["2L13"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubblebeam: ["2E", "1M"],
			constrict: ["2L1", "2S0"],
			curse: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			frustration: ["2M"],
			haze: ["2E"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hornattack: ["1L34"],
			hydropump: ["2L55", "1L53"],
			icebeam: ["2T", "1M"],
			icywind: ["2M"],
			leer: ["2L31", "1L39"],
			mimic: ["1M"],
			protect: ["2M", "2L37"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rocksmash: ["2M"],
			rockthrow: ["2S0"],
			rollout: ["2M"],
			sandstorm: ["2M"],
			slam: ["2E"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			spikecannon: ["1L46"],
			substitute: ["1M"],
			supersonic: ["2E"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			takedown: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
			watergun: ["2L19", "1M", "1L1", "1S1"],
			whirlpool: ["2M"],
			withdraw: ["2L1", "2S0", "1L1", "1S1"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["constrict", "withdraw", "rockthrow"]},
			{generation: 1, level: 20, moves: ["watergun", "withdraw"]},
		],
		encounters: [
			{generation: 1, level: 30},
		],
	},
	omastar: {
		learnset: {
			ancientpower: ["2L54"],
			attract: ["2M"],
			bide: ["1M"],
			bite: ["2L13", "2L1"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubblebeam: ["1M"],
			constrict: ["2L1"],
			curse: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hornattack: ["1L34", "1L1"],
			horndrill: ["1M"],
			hydropump: ["2L65", "1L49"],
			hyperbeam: ["2M", "1M"],
			icebeam: ["2T", "1M"],
			icywind: ["2M"],
			leer: ["2L31", "1L39"],
			mimic: ["1M"],
			protect: ["2M", "2L37"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rocksmash: ["2M"],
			rollout: ["2M"],
			sandstorm: ["2M"],
			seismictoss: ["1M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			spikecannon: ["2L40", "1L44"],
			submission: ["1M"],
			substitute: ["1M"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			takedown: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
			watergun: ["2L19", "1M", "1L1"],
			whirlpool: ["2M"],
			withdraw: ["2L1", "1L1"],
		},
	},
	kabuto: {
		learnset: {
			absorb: ["2L10", "1L34"],
			ancientpower: ["2L55"],
			attract: ["2M"],
			aurorabeam: ["2E"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubblebeam: ["2E", "1M"],
			curse: ["2M"],
			dig: ["2E"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M", "2L37"],
			flail: ["2E"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			harden: ["2L1", "2S0", "1L1", "1S1"],
			hiddenpower: ["2M"],
			hydropump: ["1L49"],
			icebeam: ["2T", "1M"],
			icywind: ["2M"],
			leer: ["2L19", "1L44"],
			megadrain: ["2L46"],
			mimic: ["1M"],
			protect: ["2M"],
			rage: ["1M"],
			raindance: ["2M"],
			rapidspin: ["2E"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rocksmash: ["2M"],
			rockthrow: ["2S0"],
			rollout: ["2M"],
			sandattack: ["2L28"],
			sandstorm: ["2M"],
			scratch: ["2L1", "2S0", "1L1", "1S1"],
			slash: ["1L39"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			substitute: ["1M"],
			surf: ["1M"],
			swagger: ["2M"],
			takedown: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
			watergun: ["1M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["scratch", "harden", "rockthrow"]},
			{generation: 1, level: 20, moves: ["scratch", "harden"]},
		],
		encounters: [
			{generation: 1, level: 30},
		],
	},
	kabutops: {
		learnset: {
			absorb: ["2L10", "2L1", "1L34", "1L1"],
			ancientpower: ["2L65"],
			attract: ["2M"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubblebeam: ["1M"],
			curse: ["2M"],
			cut: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M", "2L37"],
			frustration: ["2M"],
			furycutter: ["2M"],
			gigadrain: ["2M"],
			harden: ["2L1", "1L1"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hydropump: ["1L53"],
			hyperbeam: ["2M", "1M"],
			icebeam: ["2T", "1M"],
			icywind: ["2M"],
			leer: ["2L19", "1L46"],
			megadrain: ["2L51"],
			megakick: ["1M"],
			mimic: ["1M"],
			protect: ["2M"],
			rage: ["1M"],
			raindance: ["2M"],
			razorwind: ["1M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rocksmash: ["2M"],
			rollout: ["2M"],
			sandattack: ["2L28"],
			sandstorm: ["2M"],
			scratch: ["2L1", "1L1"],
			seismictoss: ["1M"],
			skullbash: ["1M"],
			slash: ["2L40", "1L39"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			submission: ["1M"],
			substitute: ["1M"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			swordsdance: ["1M"],
			takedown: ["1M"],
			thief: ["2M"],
			toxic: ["2M", "1M"],
			watergun: ["1M"],
			whirlpool: ["2M"],
		},
	},
	aerodactyl: {
		learnset: {
			agility: ["2L8", "1L1"],
			ancientpower: ["2L29"],
			attract: ["2M"],
			bide: ["1M"],
			bite: ["2L15", "1L38"],
			curse: ["2M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dragonbreath: ["2M"],
			dragonrage: ["1M"],
			earthquake: ["2M"],
			endure: ["2M"],
			fireblast: ["2M", "1M"],
			flamethrower: ["2T"],
			fly: ["2M", "1M"],
			foresight: ["2E"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "2L50", "1M", "1L54"],
			irontail: ["2M"],
			mimic: ["1M"],
			protect: ["2M"],
			pursuit: ["2E"],
			rage: ["1M"],
			raindance: ["2M"],
			razorwind: ["1M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			roar: ["2M"],
			rocksmash: ["2M"],
			rockthrow: ["2S0"],
			sandstorm: ["2M"],
			scaryface: ["2L36"],
			skyattack: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			steelwing: ["2M", "2E"],
			substitute: ["1M"],
			supersonic: ["2L22", "1L33"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			takedown: ["2L43", "1M", "1L45"],
			toxic: ["2M", "1M"],
			whirlwind: ["2E", "1M"],
			wingattack: ["2L1", "2S0", "1L1"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["wingattack", "rockthrow"]},
		],
		encounters: [
			{generation: 1, level: 30},
		],
	},
	snorlax: {
		learnset: {
			amnesia: ["2L8", "1L1"],
			attract: ["2M"],
			bellydrum: ["2L22"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["2L43", "1M", "1L35"],
			bubblebeam: ["1M"],
			counter: ["1M"],
			curse: ["2M"],
			defensecurl: ["2M", "2L15"],
			doubleedge: ["1M", "1L48"],
			doubleteam: ["2M", "1M"],
			dynamicpunch: ["2M"],
			earthquake: ["2M", "1M"],
			endure: ["2M"],
			fireblast: ["2M", "1M"],
			firepunch: ["2M"],
			fissure: ["1M"],
			flamethrower: ["2T"],
			frustration: ["2M"],
			harden: ["1L41"],
			headbutt: ["2M", "2L29", "1L1"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "2L57", "1M", "1L56"],
			icebeam: ["2T", "1M"],
			icepunch: ["2M"],
			icywind: ["2M"],
			lick: ["2E"],
			lovelykiss: ["2S0"],
			megakick: ["1M"],
			megapunch: ["1M"],
			metronome: ["1M"],
			mimic: ["1M"],
			mudslap: ["2M"],
			payday: ["1M"],
			protect: ["2M"],
			psychic: ["2M", "1M"],
			psychup: ["2M"],
			psywave: ["1M"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "2L36", "1M", "1L1"],
			return: ["2M"],
			rockslide: ["1M"],
			rocksmash: ["2M"],
			rollout: ["2M", "2L50"],
			sandstorm: ["2M"],
			seismictoss: ["1M"],
			selfdestruct: ["1M"],
			shadowball: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M", "2L36"],
			solarbeam: ["2M", "1M"],
			splash: ["2S1"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			sweetkiss: ["2S2"],
			tackle: ["2L1", "2S2", "2S1", "2S0"],
			takedown: ["1M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			thunderpunch: ["2M"],
			toxic: ["2M", "1M"],
			watergun: ["1M"],
			zapcannon: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "lovelykiss"]},
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "splash"]},
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "sweetkiss"]},
		],
		encounters: [
			{generation: 1, level: 30},
		],
	},
	articuno: {
		learnset: {
			agility: ["2L25", "2S0", "1L55"],
			bide: ["1M"],
			blizzard: ["2M", "2L73", "1M", "1L51"],
			bubblebeam: ["1M"],
			curse: ["2M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			endure: ["2M"],
			fly: ["2M", "1M"],
			frustration: ["2M"],
			gust: ["2L1"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			icebeam: ["2T", "2L49", "2S0", "1M", "1L1"],
			icywind: ["2M"],
			mimic: ["1M"],
			mindreader: ["2L37", "2S0"],
			mist: ["2L13", "2S0", "1L60"],
			mudslap: ["2M"],
			peck: ["1L1"],
			powdersnow: ["2L1"],
			protect: ["2M"],
			rage: ["1M"],
			raindance: ["2M"],
			razorwind: ["1M"],
			reflect: ["2L61", "1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			roar: ["2M"],
			rocksmash: ["2M"],
			sandstorm: ["2M"],
			skyattack: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			steelwing: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
			watergun: ["1M"],
			whirlwind: ["1M"],
		},
		eventData: [
			{generation: 2, level: 50, shiny: true, moves: ["mist", "agility", "mindreader", "icebeam"]},
		],
		encounters: [
			{generation: 1, level: 50},
		],
	},
	zapdos: {
		learnset: {
			agility: ["2L25", "2S0", "1L55"],
			bide: ["1M"],
			curse: ["2M"],
			detect: ["2M", "2L37", "2S0"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			drillpeck: ["2L49", "2S0", "1L1"],
			endure: ["2M"],
			flash: ["2M", "1M"],
			fly: ["2M", "1M"],
			frustration: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			lightscreen: ["2L61", "1L60"],
			mimic: ["1M"],
			mudslap: ["2M"],
			peck: ["2L1"],
			protect: ["2M"],
			rage: ["1M"],
			raindance: ["2M"],
			razorwind: ["1M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			roar: ["2M"],
			rocksmash: ["2M"],
			sandstorm: ["2M"],
			skyattack: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			steelwing: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			takedown: ["1M"],
			thunder: ["2M", "2L73", "1M", "1L51"],
			thunderbolt: ["2T", "1M"],
			thundershock: ["2L1", "1L1"],
			thunderwave: ["2L13", "2S0", "1M"],
			toxic: ["2M", "1M"],
			whirlwind: ["1M"],
			zapcannon: ["2M"],
		},
		eventData: [
			{generation: 2, level: 50, shiny: true, moves: ["thunderwave", "agility", "detect", "drillpeck"]},
		],
		encounters: [
			{generation: 1, level: 50},
		],
	},
	moltres: {
		learnset: {
			agility: ["2L25", "2S0", "1L55"],
			bide: ["1M"],
			curse: ["2M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			ember: ["2L1"],
			endure: ["2M", "2L37", "2S0"],
			fireblast: ["2M", "1M"],
			firespin: ["2L13", "2S0", "1L1"],
			flamethrower: ["2T", "2L49", "2S0"],
			fly: ["2M", "1M"],
			frustration: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			leer: ["1L51"],
			mimic: ["1M"],
			mudslap: ["2M"],
			peck: ["1L1"],
			protect: ["2M"],
			rage: ["1M"],
			raindance: ["2M"],
			razorwind: ["1M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			roar: ["2M"],
			rocksmash: ["2M"],
			safeguard: ["2L61"],
			sandstorm: ["2M"],
			skyattack: ["2L73", "1M", "1L60"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			steelwing: ["2M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			takedown: ["1M"],
			toxic: ["2M", "1M"],
			whirlwind: ["1M"],
			wingattack: ["2L1"],
		},
		eventData: [
			{generation: 2, level: 50, shiny: true, moves: ["firespin", "agility", "endure", "flamethrower"]},
		],
		encounters: [
			{generation: 1, level: 50},
		],
	},
	dratini: {
		learnset: {
			agility: ["2L36", "1L20"],
			attract: ["2M"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubblebeam: ["1M"],
			curse: ["2M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dragonbreath: ["2M"],
			dragonrage: ["2L22", "1M", "1L40"],
			endure: ["2M"],
			extremespeed: ["2S1"],
			fireblast: ["2M", "1M"],
			flamethrower: ["2T"],
			frustration: ["2M"],
			haze: ["2E"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hydropump: ["2S0"],
			hyperbeam: ["2L57", "1L50"],
			icebeam: ["2T", "1M"],
			icywind: ["2M"],
			irontail: ["2M"],
			leer: ["2L1", "2S0", "1L1"],
			lightscreen: ["2E"],
			mimic: ["1M"],
			mist: ["2E"],
			outrage: ["2L50"],
			protect: ["2M"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			safeguard: ["2L43"],
			skullbash: ["1M"],
			slam: ["2L29", "1L30"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			substitute: ["1M"],
			supersonic: ["2E"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			takedown: ["1M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			thunderwave: ["2L8", "2S1", "1M", "1L10"],
			toxic: ["2M", "1M"],
			twister: ["2L15", "2S1"],
			waterfall: ["2M"],
			watergun: ["1M"],
			wrap: ["2L1", "2S1", "2S0", "1L1"],
			zapcannon: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["wrap", "leer", "hydropump"]},
			{generation: 2, level: 15, shiny: 1, moves: ["wrap", "thunderwave", "twister", "extremespeed"]},
		],
		encounters: [
			{generation: 1, level: 10},
		],
	},
	dragonair: {
		learnset: {
			agility: ["2L38", "1L20"],
			attract: ["2M"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubblebeam: ["1M"],
			curse: ["2M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dragonbreath: ["2M"],
			dragonrage: ["2L22", "1M", "1L45"],
			endure: ["2M"],
			fireblast: ["2M", "1M"],
			flamethrower: ["2T"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			horndrill: ["1M"],
			hyperbeam: ["2L65", "1L55"],
			icebeam: ["2T", "1M"],
			icywind: ["2M"],
			irontail: ["2M"],
			leer: ["2L1", "1L1"],
			mimic: ["1M"],
			outrage: ["2L56"],
			protect: ["2M"],
			rage: ["1M"],
			raindance: ["2M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			safeguard: ["2L47"],
			skullbash: ["1M"],
			slam: ["2L29", "1L35"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			substitute: ["1M"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			takedown: ["1M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			thunderwave: ["2L8", "2L1", "1M", "1L10", "1L1"],
			toxic: ["2M", "1M"],
			twister: ["2L15", "2L1"],
			waterfall: ["2M"],
			watergun: ["1M"],
			wrap: ["2L1", "1L1"],
			zapcannon: ["2M"],
		},
		encounters: [
			{generation: 1, level: 15},
			{generation: 2, level: 10},
		],
	},
	dragonite: {
		learnset: {
			agility: ["2L38", "1L20", "1L1"],
			attract: ["2M"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubblebeam: ["1M"],
			curse: ["2M"],
			detect: ["2M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dragonbreath: ["2M"],
			dragonrage: ["2L22", "1M", "1L45"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			fireblast: ["2M", "1M"],
			firepunch: ["2M"],
			flamethrower: ["2T"],
			fly: ["2M"],
			frustration: ["2M"],
			furycutter: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			horndrill: ["1M"],
			hyperbeam: ["2M", "2L75", "1M", "1L60"],
			icebeam: ["2T", "1M"],
			icepunch: ["2M"],
			icywind: ["2M"],
			irontail: ["2M"],
			leer: ["2L1", "1L1"],
			mimic: ["1M"],
			mudslap: ["2M"],
			outrage: ["2L61"],
			protect: ["2M"],
			rage: ["1M"],
			raindance: ["2M"],
			razorwind: ["1M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rocksmash: ["2M"],
			safeguard: ["2L47"],
			sandstorm: ["2M"],
			skullbash: ["1M"],
			slam: ["2L29", "1L35"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			steelwing: ["2M"],
			strength: ["2M", "1M"],
			substitute: ["1M"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			swift: ["2M", "1M"],
			takedown: ["1M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			thunderpunch: ["2M"],
			thunderwave: ["2L8", "2L1", "1M", "1L10", "1L1"],
			toxic: ["2M", "1M"],
			twister: ["2L15", "2L1"],
			waterfall: ["2M"],
			watergun: ["1M"],
			whirlpool: ["2M"],
			wingattack: ["2L55"],
			wrap: ["2L1", "1L1"],
			zapcannon: ["2M"],
		},
	},
	mewtwo: {
		learnset: {
			amnesia: ["2L77", "1L81"],
			barrier: ["2L11", "1L63"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubblebeam: ["1M"],
			confusion: ["2L1"],
			counter: ["1M"],
			curse: ["2M"],
			detect: ["2M"],
			disable: ["2L1"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dreameater: ["2M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			fireblast: ["2M", "1M"],
			firepunch: ["2M"],
			flamethrower: ["2T"],
			flash: ["2M", "1M"],
			frustration: ["2M"],
			futuresight: ["2L44", "2S0"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "1M"],
			icebeam: ["2T", "1M"],
			icepunch: ["2M"],
			icywind: ["2M"],
			irontail: ["2M"],
			megakick: ["1M"],
			megapunch: ["1M"],
			metronome: ["1M"],
			mimic: ["1M"],
			mist: ["2L55", "2S0", "1L75"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			payday: ["1M"],
			protect: ["2M"],
			psychic: ["2M", "2L66", "2S0", "1M", "1L66", "1L1"],
			psychup: ["2M", "2L33", "2S0"],
			psywave: ["1M"],
			rage: ["1M"],
			raindance: ["2M"],
			recover: ["2L88", "1L70"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			rocksmash: ["2M"],
			safeguard: ["2L99"],
			seismictoss: ["1M"],
			selfdestruct: ["1M"],
			shadowball: ["2M"],
			skullbash: ["1M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M", "1M"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "2L22", "1L1"],
			takedown: ["1M"],
			teleport: ["1M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			thunderpunch: ["2M"],
			thunderwave: ["1M"],
			toxic: ["2M", "1M"],
			triattack: ["1M"],
			watergun: ["1M"],
			zapcannon: ["2M"],
		},
		eventData: [
			{generation: 2, level: 70, shiny: true, moves: ["psychup", "futuresight", "mist", "psychic"]},
		],
		encounters: [
			{generation: 1, level: 70},
		],
	},
	mew: {
		learnset: {
			ancientpower: ["2L50"],
			attract: ["2M"],
			bide: ["1M"],
			blizzard: ["2M", "1M"],
			bodyslam: ["1M"],
			bubblebeam: ["1M"],
			counter: ["1M"],
			curse: ["2M"],
			cut: ["2M", "1M"],
			defensecurl: ["2M"],
			detect: ["2M"],
			dig: ["2M", "1M"],
			doubleedge: ["1M"],
			doubleteam: ["2M", "1M"],
			dragonbreath: ["2M"],
			dragonrage: ["1M"],
			dreameater: ["2M", "1M"],
			dynamicpunch: ["2M"],
			earthquake: ["2M", "1M"],
			eggbomb: ["1M"],
			endure: ["2M"],
			explosion: ["1M"],
			fireblast: ["2M", "1M"],
			firepunch: ["2M"],
			fissure: ["1M"],
			flamethrower: ["2T"],
			flash: ["2M", "1M"],
			fly: ["2M", "1M"],
			frustration: ["2M"],
			furycutter: ["2M"],
			gigadrain: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			horndrill: ["1M"],
			hyperbeam: ["2M", "1M"],
			icebeam: ["2T", "1M"],
			icepunch: ["2M"],
			icywind: ["2M"],
			irontail: ["2M"],
			megadrain: ["1M"],
			megakick: ["1M"],
			megapunch: ["2L20", "1M", "1L20"],
			metronome: ["2L30", "1M", "1L30"],
			mimic: ["1M"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			payday: ["1M"],
			pound: ["2L1", "2S1", "1L1", "1S0"],
			protect: ["2M"],
			psychic: ["2M", "2L40", "1M", "1L40"],
			psychup: ["2M"],
			psywave: ["1M"],
			rage: ["1M"],
			raindance: ["2M"],
			razorwind: ["1M"],
			reflect: ["1M"],
			rest: ["2M", "1M"],
			return: ["2M"],
			roar: ["2M"],
			rockslide: ["1M"],
			rocksmash: ["2M"],
			rollout: ["2M"],
			sandstorm: ["2M"],
			seismictoss: ["1M"],
			selfdestruct: ["1M"],
			shadowball: ["2M"],
			skullbash: ["1M"],
			skyattack: ["1M"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			snore: ["2M"],
			softboiled: ["1M"],
			solarbeam: ["2M", "1M"],
			steelwing: ["2M"],
			strength: ["2M", "1M"],
			submission: ["1M"],
			substitute: ["1M"],
			sunnyday: ["2M"],
			surf: ["2M", "1M"],
			swagger: ["2M"],
			sweetscent: ["2M"],
			swift: ["2M", "1M"],
			swordsdance: ["1M"],
			takedown: ["1M"],
			teleport: ["1M"],
			thief: ["2M"],
			thunder: ["2M", "1M"],
			thunderbolt: ["2T", "1M"],
			thunderpunch: ["2M"],
			thunderwave: ["1M"],
			toxic: ["2M", "1M"],
			transform: ["2L10", "1L10"],
			triattack: ["1M"],
			waterfall: ["2M"],
			watergun: ["1M"],
			whirlpool: ["2M"],
			whirlwind: ["1M"],
			zapcannon: ["2M"],
		},
		eventData: [
			{generation: 1, level: 5, moves: ["pound"]},
			{generation: 2, level: 5, moves: ["pound"]},
		],
		eventOnly: true,
	},
	chikorita: {
		learnset: {
			ancientpower: ["2E"],
			attract: ["2M"],
			bodyslam: ["2L29"],
			counter: ["2E"],
			curse: ["2M"],
			cut: ["2M"],
			detect: ["2M"],
			doubleteam: ["2M"],
			endure: ["2M"],
			flail: ["2E"],
			flash: ["2M"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			growl: ["2L1", "2S0"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			irontail: ["2M"],
			leechseed: ["2E"],
			lightscreen: ["2L36"],
			mudslap: ["2M"],
			petaldance: ["2S0"],
			poisonpowder: ["2L15"],
			protect: ["2M"],
			razorleaf: ["2L8"],
			reflect: ["2L12"],
			rest: ["2M"],
			return: ["2M"],
			safeguard: ["2L43"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M", "2L50"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			sweetscent: ["2M"],
			swordsdance: ["2E"],
			synthesis: ["2L22"],
			tackle: ["2L1", "2S0"],
			toxic: ["2M"],
			vinewhip: ["2E"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "growl", "petaldance"]},
		],
	},
	bayleef: {
		learnset: {
			attract: ["2M"],
			bodyslam: ["2L31"],
			curse: ["2M"],
			cut: ["2M"],
			detect: ["2M"],
			doubleteam: ["2M"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			furycutter: ["2M"],
			gigadrain: ["2M"],
			growl: ["2L1"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			irontail: ["2M"],
			lightscreen: ["2L39"],
			mudslap: ["2M"],
			poisonpowder: ["2L15"],
			protect: ["2M"],
			razorleaf: ["2L8", "2L1"],
			reflect: ["2L12", "2L1"],
			rest: ["2M"],
			return: ["2M"],
			rocksmash: ["2M"],
			safeguard: ["2L47"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M", "2L55"],
			strength: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			sweetscent: ["2M"],
			synthesis: ["2L23"],
			tackle: ["2L1"],
			toxic: ["2M"],
		},
	},
	meganium: {
		learnset: {
			attract: ["2M"],
			bodyslam: ["2L31", "2S0"],
			curse: ["2M"],
			cut: ["2M"],
			detect: ["2M"],
			doubleteam: ["2M"],
			earthquake: ["2M"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			furycutter: ["2M"],
			gigadrain: ["2M"],
			growl: ["2L1"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			irontail: ["2M"],
			lightscreen: ["2L41"],
			mudslap: ["2M"],
			poisonpowder: ["2L15", "2S0"],
			protect: ["2M"],
			razorleaf: ["2L8", "2L1"],
			reflect: ["2L12", "2L1", "2S0"],
			rest: ["2M"],
			return: ["2M"],
			rocksmash: ["2M"],
			safeguard: ["2L51"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M", "2L61"],
			strength: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			sweetscent: ["2M"],
			synthesis: ["2L23", "2S0"],
			tackle: ["2L1"],
			toxic: ["2M"],
		},
		eventData: [
			{generation: 2, level: 40, shiny: true, moves: ["reflect", "poisonpowder", "synthesis", "bodyslam"]},
		],
	},
	cyndaquil: {
		learnset: {
			attract: ["2M"],
			curse: ["2M"],
			cut: ["2M"],
			defensecurl: ["2M"],
			detect: ["2M"],
			dig: ["2M"],
			doubleedge: ["2S0"],
			doubleteam: ["2M"],
			ember: ["2L12"],
			endure: ["2M"],
			fireblast: ["2M"],
			flamethrower: ["2T", "2L46"],
			flamewheel: ["2L27"],
			foresight: ["2E"],
			frustration: ["2M"],
			furyswipes: ["2E"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			irontail: ["2M"],
			leer: ["2L1", "2S0"],
			mudslap: ["2M"],
			protect: ["2M"],
			quickattack: ["2L19", "2E"],
			rest: ["2M"],
			return: ["2M"],
			reversal: ["2E"],
			rollout: ["2M"],
			sleeptalk: ["2M"],
			smokescreen: ["2L6"],
			snore: ["2M"],
			submission: ["2E"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "2L36"],
			tackle: ["2L1", "2S0"],
			thrash: ["2E"],
			toxic: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "leer", "doubleedge"]},
		],
	},
	quilava: {
		learnset: {
			attract: ["2M"],
			curse: ["2M"],
			cut: ["2M"],
			defensecurl: ["2M"],
			detect: ["2M"],
			dig: ["2M"],
			doubleteam: ["2M"],
			ember: ["2L12"],
			endure: ["2M"],
			fireblast: ["2M"],
			flamethrower: ["2T", "2L54"],
			flamewheel: ["2L31"],
			frustration: ["2M"],
			furycutter: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			irontail: ["2M"],
			leer: ["2L1"],
			mudslap: ["2M"],
			protect: ["2M"],
			quickattack: ["2L21"],
			rest: ["2M"],
			return: ["2M"],
			roar: ["2M"],
			rocksmash: ["2M"],
			rollout: ["2M"],
			sleeptalk: ["2M"],
			smokescreen: ["2L6", "2L1"],
			snore: ["2M"],
			strength: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "2L42"],
			tackle: ["2L1"],
			toxic: ["2M"],
		},
	},
	typhlosion: {
		learnset: {
			attract: ["2M"],
			curse: ["2M"],
			cut: ["2M"],
			defensecurl: ["2M"],
			detect: ["2M"],
			dig: ["2M"],
			doubleteam: ["2M"],
			dynamicpunch: ["2M"],
			earthquake: ["2M"],
			ember: ["2L12", "2L1", "2S0"],
			endure: ["2M"],
			fireblast: ["2M"],
			firepunch: ["2M"],
			flamethrower: ["2T", "2L60"],
			flamewheel: ["2L31", "2S0"],
			frustration: ["2M"],
			furycutter: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			irontail: ["2M"],
			leer: ["2L1"],
			mudslap: ["2M"],
			protect: ["2M"],
			quickattack: ["2L21", "2S0"],
			rest: ["2M"],
			return: ["2M"],
			roar: ["2M"],
			rocksmash: ["2M"],
			rollout: ["2M"],
			sleeptalk: ["2M"],
			smokescreen: ["2L6", "2L1", "2S0"],
			snore: ["2M"],
			strength: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "2L45"],
			tackle: ["2L1"],
			thunderpunch: ["2M"],
			toxic: ["2M"],
		},
		eventData: [
			{generation: 2, level: 40, shiny: true, moves: ["smokescreen", "ember", "quickattack", "flamewheel"]},
		],
	},
	totodile: {
		learnset: {
			ancientpower: ["2E"],
			attract: ["2M"],
			bite: ["2L20"],
			blizzard: ["2M"],
			crunch: ["2E"],
			curse: ["2M"],
			cut: ["2M"],
			detect: ["2M"],
			dig: ["2M"],
			doubleteam: ["2M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hydropump: ["2L52", "2E"],
			icebeam: ["2T"],
			icepunch: ["2M"],
			icywind: ["2M"],
			irontail: ["2M"],
			leer: ["2L1", "2S0"],
			mudslap: ["2M"],
			protect: ["2M"],
			rage: ["2L7"],
			raindance: ["2M"],
			razorwind: ["2E"],
			rest: ["2M"],
			return: ["2M"],
			rockslide: ["2E"],
			scaryface: ["2L27"],
			scratch: ["2L1", "2S0"],
			screech: ["2L43"],
			slash: ["2L35"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			submission: ["2S0"],
			surf: ["2M"],
			swagger: ["2M"],
			thrash: ["2E"],
			toxic: ["2M"],
			watergun: ["2L13"],
			whirlpool: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["scratch", "leer", "submission"]},
		],
	},
	croconaw: {
		learnset: {
			attract: ["2M"],
			bite: ["2L21"],
			blizzard: ["2M"],
			curse: ["2M"],
			cut: ["2M"],
			detect: ["2M"],
			dig: ["2M"],
			doubleteam: ["2M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			frustration: ["2M"],
			furycutter: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hydropump: ["2L55"],
			icebeam: ["2T"],
			icepunch: ["2M"],
			icywind: ["2M"],
			irontail: ["2M"],
			leer: ["2L1"],
			mudslap: ["2M"],
			protect: ["2M"],
			rage: ["2L7", "2L1"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			roar: ["2M"],
			rocksmash: ["2M"],
			scaryface: ["2L28"],
			scratch: ["2L1"],
			screech: ["2L45"],
			slash: ["2L37"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M"],
			surf: ["2M"],
			swagger: ["2M"],
			toxic: ["2M"],
			watergun: ["2L13"],
			whirlpool: ["2M"],
		},
	},
	feraligatr: {
		learnset: {
			attract: ["2M"],
			bite: ["2L21", "2S0"],
			blizzard: ["2M"],
			curse: ["2M"],
			cut: ["2M"],
			detect: ["2M"],
			dig: ["2M"],
			doubleteam: ["2M"],
			dynamicpunch: ["2M"],
			earthquake: ["2M"],
			endure: ["2M"],
			frustration: ["2M"],
			furycutter: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hydropump: ["2L58"],
			hyperbeam: ["2M"],
			icebeam: ["2T"],
			icepunch: ["2M"],
			icywind: ["2M"],
			irontail: ["2M"],
			leer: ["2L1"],
			mudslap: ["2M"],
			protect: ["2M"],
			rage: ["2L7", "2L1"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			roar: ["2M"],
			rocksmash: ["2M"],
			scaryface: ["2L28", "2S0"],
			scratch: ["2L1"],
			screech: ["2L47"],
			slash: ["2L38", "2S0"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M"],
			surf: ["2M"],
			swagger: ["2M"],
			toxic: ["2M"],
			watergun: ["2L13", "2L1", "2S0"],
			whirlpool: ["2M"],
		},
		eventData: [
			{generation: 2, level: 40, shiny: true, moves: ["watergun", "bite", "scaryface", "slash"]},
		],
	},
	sentret: {
		learnset: {
			amnesia: ["2L41"],
			attract: ["2M"],
			curse: ["2M"],
			cut: ["2M"],
			defensecurl: ["2M", "2L5", "2S0"],
			detect: ["2M"],
			dig: ["2M"],
			dizzypunch: ["2S0"],
			doubleedge: ["2E"],
			doubleteam: ["2M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			firepunch: ["2M"],
			focusenergy: ["2E"],
			frustration: ["2M"],
			furycutter: ["2M"],
			furyswipes: ["2L17"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			icepunch: ["2M"],
			irontail: ["2M"],
			mudslap: ["2M"],
			protect: ["2M"],
			pursuit: ["2E"],
			quickattack: ["2L11"],
			rest: ["2M", "2L33"],
			return: ["2M"],
			reversal: ["2E"],
			rollout: ["2M"],
			shadowball: ["2M"],
			slam: ["2L25"],
			slash: ["2E"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			sunnyday: ["2M"],
			surf: ["2M"],
			swagger: ["2M"],
			swift: ["2M"],
			tackle: ["2L1", "2S0"],
			thief: ["2M"],
			thunderpunch: ["2M"],
			toxic: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "defensecurl", "dizzypunch"]},
		],
		encounters: [
			{generation: 2, level: 2},
		],
	},
	furret: {
		learnset: {
			amnesia: ["2L48"],
			attract: ["2M"],
			curse: ["2M"],
			cut: ["2M"],
			defensecurl: ["2M", "2L5", "2L1"],
			detect: ["2M"],
			dig: ["2M"],
			doubleteam: ["2M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			firepunch: ["2M"],
			frustration: ["2M"],
			furycutter: ["2M"],
			furyswipes: ["2L18"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			icepunch: ["2M"],
			irontail: ["2M"],
			mudslap: ["2M"],
			protect: ["2M"],
			quickattack: ["2L11", "2L1"],
			rest: ["2M", "2L38"],
			return: ["2M"],
			rollout: ["2M"],
			scratch: ["2L1"],
			shadowball: ["2M"],
			slam: ["2L28"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M"],
			sunnyday: ["2M"],
			surf: ["2M"],
			swagger: ["2M"],
			swift: ["2M"],
			thief: ["2M"],
			thunderpunch: ["2M"],
			toxic: ["2M"],
		},
		encounters: [
			{generation: 2, level: 6},
		],
	},
	hoothoot: {
		learnset: {
			attract: ["2M"],
			confusion: ["2L34"],
			curse: ["2M"],
			detect: ["2M"],
			doubleteam: ["2M"],
			dreameater: ["2M", "2L48"],
			endure: ["2M"],
			feintattack: ["2E"],
			flash: ["2M"],
			fly: ["2M"],
			foresight: ["2L6"],
			frustration: ["2M"],
			growl: ["2L1", "2S0"],
			hiddenpower: ["2M"],
			hypnosis: ["2L16"],
			mirrormove: ["2E"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			nightshade: ["2S0"],
			peck: ["2L11"],
			protect: ["2M"],
			reflect: ["2L22"],
			rest: ["2M"],
			return: ["2M"],
			skyattack: ["2E"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			steelwing: ["2M"],
			sunnyday: ["2M"],
			supersonic: ["2E"],
			swagger: ["2M"],
			swift: ["2M"],
			tackle: ["2L1", "2S0"],
			takedown: ["2L28"],
			thief: ["2M"],
			toxic: ["2M"],
			whirlwind: ["2E"],
			wingattack: ["2E"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "growl", "nightshade"]},
		],
		encounters: [
			{generation: 2, level: 2},
		],
	},
	noctowl: {
		learnset: {
			attract: ["2M"],
			confusion: ["2L41"],
			curse: ["2M"],
			detect: ["2M"],
			doubleteam: ["2M"],
			dreameater: ["2M", "2L57"],
			endure: ["2M"],
			flash: ["2M"],
			fly: ["2M"],
			foresight: ["2L6", "2L1"],
			frustration: ["2M"],
			growl: ["2L1"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			hypnosis: ["2L16"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			peck: ["2L11", "2L1"],
			protect: ["2M"],
			reflect: ["2L25"],
			rest: ["2M"],
			return: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			steelwing: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M"],
			tackle: ["2L1"],
			takedown: ["2L33"],
			thief: ["2M"],
			toxic: ["2M"],
		},
		encounters: [
			{generation: 2, level: 7},
		],
	},
	ledyba: {
		learnset: {
			agility: ["2L43"],
			attract: ["2M"],
			barrier: ["2S0"],
			batonpass: ["2L29"],
			bide: ["2E"],
			cometpunch: ["2L15"],
			curse: ["2M"],
			dig: ["2M"],
			doubleedge: ["2L50"],
			doubleteam: ["2M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			icepunch: ["2M"],
			lightscreen: ["2L22", "2E"],
			protect: ["2M"],
			psybeam: ["2E"],
			reflect: ["2L22"],
			rest: ["2M"],
			return: ["2M"],
			rollout: ["2M"],
			safeguard: ["2L22"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M"],
			sunnyday: ["2M"],
			supersonic: ["2L8"],
			swagger: ["2M"],
			sweetscent: ["2M"],
			swift: ["2M", "2L36"],
			tackle: ["2L1", "2S0"],
			thief: ["2M"],
			thunderpunch: ["2M"],
			toxic: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "barrier"]},
		],
		encounters: [
			{generation: 2, level: 3},
		],
	},
	ledian: {
		learnset: {
			agility: ["2L51"],
			attract: ["2M"],
			batonpass: ["2L33"],
			cometpunch: ["2L15"],
			curse: ["2M"],
			dig: ["2M"],
			doubleedge: ["2L60"],
			doubleteam: ["2M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			icepunch: ["2M"],
			lightscreen: ["2L24"],
			protect: ["2M"],
			reflect: ["2L24"],
			rest: ["2M"],
			return: ["2M"],
			rollout: ["2M"],
			safeguard: ["2L24"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M"],
			sunnyday: ["2M"],
			supersonic: ["2L8", "2L1"],
			swagger: ["2M"],
			sweetscent: ["2M"],
			swift: ["2M", "2L42"],
			tackle: ["2L1"],
			thief: ["2M"],
			thunderpunch: ["2M"],
			toxic: ["2M"],
		},
		encounters: [
			{generation: 2, level: 7},
		],
	},
	spinarak: {
		learnset: {
			agility: ["2L45"],
			attract: ["2M"],
			batonpass: ["2E"],
			constrict: ["2L11"],
			curse: ["2M"],
			dig: ["2M"],
			disable: ["2E"],
			doubleteam: ["2M"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			furyswipes: ["2L30"],
			gigadrain: ["2M"],
			growth: ["2S0"],
			hiddenpower: ["2M"],
			leechlife: ["2L23"],
			nightshade: ["2L17"],
			poisonsting: ["2L1", "2S0"],
			protect: ["2M"],
			psybeam: ["2E"],
			psychic: ["2M", "2L53"],
			pursuit: ["2E"],
			rest: ["2M"],
			return: ["2M"],
			scaryface: ["2L6"],
			screech: ["2L45"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M"],
			sonicboom: ["2E"],
			spiderweb: ["2L37"],
			stringshot: ["2L1", "2S0"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			thief: ["2M"],
			toxic: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["poisonsting", "stringshot", "growth"]},
		],
		encounters: [
			{generation: 2, level: 3},
		],
	},
	ariados: {
		learnset: {
			agility: ["2L53"],
			attract: ["2M"],
			constrict: ["2L11", "2L1"],
			curse: ["2M"],
			dig: ["2M"],
			doubleteam: ["2M"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			furyswipes: ["2L34"],
			gigadrain: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			leechlife: ["2L25"],
			nightshade: ["2L17"],
			poisonsting: ["2L1"],
			protect: ["2M"],
			psychic: ["2M", "2L63"],
			rest: ["2M"],
			return: ["2M"],
			scaryface: ["2L6", "2L1"],
			screech: ["2L53"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M"],
			spiderweb: ["2L43"],
			stringshot: ["2L1"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			thief: ["2M"],
			toxic: ["2M"],
		},
		encounters: [
			{generation: 2, level: 7},
		],
	},
	chinchou: {
		learnset: {
			attract: ["2M"],
			bubble: ["2L1", "2S0"],
			confuseray: ["2L29"],
			curse: ["2M"],
			doubleteam: ["2M"],
			endure: ["2M"],
			flail: ["2L13", "2E"],
			flash: ["2M"],
			frustration: ["2M"],
			hiddenpower: ["2M"],
			hydropump: ["2L41"],
			icebeam: ["2T"],
			lightscreen: ["2S0"],
			protect: ["2M"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			screech: ["2E"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			spark: ["2L25"],
			supersonic: ["2L5", "2E", "2S0"],
			surf: ["2M"],
			swagger: ["2M"],
			takedown: ["2L37"],
			thunder: ["2M"],
			thunderbolt: ["2T"],
			thunderwave: ["2L1", "2S0"],
			toxic: ["2M"],
			waterfall: ["2M"],
			watergun: ["2L17"],
			whirlpool: ["2M"],
			zapcannon: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["bubble", "thunderwave", "supersonic", "lightscreen"]},
		],
	},
	lanturn: {
		learnset: {
			attract: ["2M"],
			bubble: ["2L1"],
			confuseray: ["2L33"],
			curse: ["2M"],
			doubleteam: ["2M"],
			endure: ["2M"],
			flail: ["2L13"],
			flash: ["2M"],
			frustration: ["2M"],
			hiddenpower: ["2M"],
			hydropump: ["2L53"],
			hyperbeam: ["2M"],
			icebeam: ["2T"],
			protect: ["2M"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			spark: ["2L25"],
			supersonic: ["2L5", "2L1"],
			surf: ["2M"],
			swagger: ["2M"],
			takedown: ["2L45"],
			thunder: ["2M"],
			thunderbolt: ["2T"],
			thunderwave: ["2L1"],
			toxic: ["2M"],
			waterfall: ["2M"],
			watergun: ["2L17"],
			whirlpool: ["2M"],
			zapcannon: ["2M"],
		},
	},
	togepi: {
		learnset: {
			attract: ["2M"],
			charm: ["2L1"],
			curse: ["2M"],
			defensecurl: ["2M"],
			detect: ["2M"],
			doubleedge: ["2L38"],
			doubleteam: ["2M"],
			dreameater: ["2M"],
			encore: ["2L25"],
			endure: ["2M"],
			fireblast: ["2M"],
			flamethrower: ["2T"],
			flash: ["2M"],
			foresight: ["2E"],
			frustration: ["2M"],
			futuresight: ["2E"],
			growl: ["2L1"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			metronome: ["2L7"],
			mirrormove: ["2E"],
			mudslap: ["2M"],
			peck: ["2E"],
			present: ["2E"],
			protect: ["2M"],
			psychic: ["2M"],
			psychup: ["2M"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			rocksmash: ["2M"],
			rollout: ["2M"],
			safeguard: ["2L31"],
			shadowball: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			sweetkiss: ["2L18"],
			swift: ["2M"],
			toxic: ["2M"],
			zapcannon: ["2M"],
		},
	},
	togetic: {
		learnset: {
			attract: ["2M"],
			charm: ["2L1"],
			curse: ["2M"],
			defensecurl: ["2M"],
			detect: ["2M"],
			doubleedge: ["2L38"],
			doubleteam: ["2M"],
			dreameater: ["2M"],
			encore: ["2L25"],
			endure: ["2M"],
			fireblast: ["2M"],
			flamethrower: ["2T"],
			flash: ["2M"],
			fly: ["2M"],
			frustration: ["2M"],
			growl: ["2L1"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			metronome: ["2L7"],
			mudslap: ["2M"],
			protect: ["2M"],
			psychic: ["2M"],
			psychup: ["2M"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			rocksmash: ["2M"],
			rollout: ["2M"],
			safeguard: ["2L31"],
			shadowball: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M"],
			steelwing: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			sweetkiss: ["2L18"],
			swift: ["2M"],
			toxic: ["2M"],
			zapcannon: ["2M"],
		},
	},
	natu: {
		learnset: {
			attract: ["2M"],
			confuseray: ["2L40"],
			curse: ["2M"],
			detect: ["2M"],
			doubleteam: ["2M"],
			dreameater: ["2M"],
			drillpeck: ["2E"],
			endure: ["2M"],
			feintattack: ["2E"],
			flash: ["2M"],
			frustration: ["2M"],
			futuresight: ["2L30"],
			gigadrain: ["2M"],
			haze: ["2E"],
			hiddenpower: ["2M"],
			leer: ["2L1", "2S0"],
			nightmare: ["2M"],
			nightshade: ["2L10"],
			peck: ["2L1", "2S0"],
			protect: ["2M"],
			psychic: ["2M", "2L50"],
			psychup: ["2M"],
			quickattack: ["2E"],
			rest: ["2M"],
			return: ["2M"],
			safeguard: ["2S0"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M"],
			steelwing: ["2E"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M"],
			teleport: ["2L20"],
			thief: ["2M"],
			toxic: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["peck", "leer", "safeguard"]},
		],
	},
	xatu: {
		learnset: {
			attract: ["2M"],
			confuseray: ["2L50"],
			curse: ["2M"],
			detect: ["2M"],
			doubleteam: ["2M"],
			dreameater: ["2M"],
			endure: ["2M"],
			flash: ["2M"],
			fly: ["2M"],
			frustration: ["2M"],
			futuresight: ["2L35"],
			gigadrain: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			leer: ["2L1"],
			nightmare: ["2M"],
			nightshade: ["2L10", "2L1"],
			peck: ["2L1"],
			protect: ["2M"],
			psychic: ["2M", "2L65"],
			psychup: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M"],
			teleport: ["2L20"],
			thief: ["2M"],
			toxic: ["2M"],
		},
		encounters: [
			{generation: 2, level: 15},
		],
	},
	mareep: {
		learnset: {
			attract: ["2M"],
			bodyslam: ["2E"],
			cottonspore: ["2L23"],
			curse: ["2M"],
			defensecurl: ["2M"],
			doubleteam: ["2M"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			growl: ["2L1"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			irontail: ["2M"],
			lightscreen: ["2L30"],
			protect: ["2M"],
			raindance: ["2M"],
			reflect: ["2E"],
			rest: ["2M"],
			return: ["2M"],
			safeguard: ["2E"],
			screech: ["2E"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			swagger: ["2M"],
			swift: ["2M"],
			tackle: ["2L1"],
			takedown: ["2E"],
			thunder: ["2M", "2L37"],
			thunderbolt: ["2T", "2E"],
			thundershock: ["2L9"],
			thunderwave: ["2L16"],
			toxic: ["2M"],
			zapcannon: ["2M"],
		},
	},
	flaaffy: {
		learnset: {
			attract: ["2M"],
			cottonspore: ["2L27"],
			curse: ["2M"],
			defensecurl: ["2M"],
			doubleteam: ["2M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			firepunch: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			growl: ["2L1"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			irontail: ["2M"],
			lightscreen: ["2L36"],
			protect: ["2M"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			rocksmash: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M"],
			swagger: ["2M"],
			swift: ["2M"],
			tackle: ["2L1"],
			thunder: ["2M", "2L45"],
			thunderbolt: ["2T"],
			thunderpunch: ["2M"],
			thundershock: ["2L9", "2L1"],
			thunderwave: ["2L18"],
			toxic: ["2M"],
			zapcannon: ["2M"],
		},
	},
	ampharos: {
		learnset: {
			attract: ["2M"],
			cottonspore: ["2L27"],
			curse: ["2M"],
			defensecurl: ["2M"],
			doubleteam: ["2M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			firepunch: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			growl: ["2L1"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			irontail: ["2M"],
			lightscreen: ["2L42"],
			protect: ["2M"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			rocksmash: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M"],
			swagger: ["2M"],
			swift: ["2M"],
			tackle: ["2L1"],
			thunder: ["2M", "2L57"],
			thunderbolt: ["2T"],
			thunderpunch: ["2M", "2L30"],
			thundershock: ["2L9", "2L1"],
			thunderwave: ["2L18", "2L1"],
			toxic: ["2M"],
			zapcannon: ["2M"],
		},
	},
	bellossom: {
		learnset: {
			absorb: ["2L1"],
			attract: ["2M"],
			curse: ["2M"],
			cut: ["2M"],
			doubleteam: ["2M"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			petaldance: ["2L1"],
			protect: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M", "2L55"],
			stunspore: ["2L1"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			sweetscent: ["2M", "2L1"],
			toxic: ["2M"],
		},
	},
	marill: {
		learnset: {
			amnesia: ["2E"],
			attract: ["2M"],
			bellydrum: ["2E"],
			blizzard: ["2M"],
			bubblebeam: ["2L21"],
			curse: ["2M"],
			defensecurl: ["2M", "2L3", "2S2", "2S1", "2S0"],
			dizzypunch: ["2S0"],
			doubleedge: ["2L28"],
			doubleteam: ["2M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			foresight: ["2E"],
			frustration: ["2M"],
			futuresight: ["2E"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hydropump: ["2S1"],
			icebeam: ["2T"],
			icepunch: ["2M"],
			icywind: ["2M"],
			irontail: ["2M"],
			lightscreen: ["2E"],
			mudslap: ["2M"],
			perishsong: ["2E"],
			present: ["2E"],
			protect: ["2M"],
			raindance: ["2M", "2L36"],
			rest: ["2M"],
			return: ["2M"],
			rollout: ["2M", "2L15"],
			scaryface: ["2S2"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			supersonic: ["2E"],
			surf: ["2M"],
			swagger: ["2M"],
			swift: ["2M"],
			tackle: ["2L1", "2S2", "2S1", "2S0"],
			tailwhip: ["2L6"],
			toxic: ["2M"],
			waterfall: ["2M"],
			watergun: ["2L10"],
			whirlpool: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "defensecurl", "dizzypunch"]},
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "defensecurl", "hydropump"]},
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "defensecurl", "scaryface"]},
		],
	},
	azumarill: {
		learnset: {
			attract: ["2M"],
			blizzard: ["2M"],
			bubblebeam: ["2L25"],
			curse: ["2M"],
			defensecurl: ["2M", "2L3", "2L1"],
			doubleedge: ["2L36"],
			doubleteam: ["2M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			icebeam: ["2T"],
			icepunch: ["2M"],
			icywind: ["2M"],
			irontail: ["2M"],
			mudslap: ["2M"],
			protect: ["2M"],
			raindance: ["2M", "2L48"],
			rest: ["2M"],
			return: ["2M"],
			rocksmash: ["2M"],
			rollout: ["2M", "2L15"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M"],
			surf: ["2M"],
			swagger: ["2M"],
			swift: ["2M"],
			tackle: ["2L1"],
			tailwhip: ["2L6", "2L1"],
			toxic: ["2M"],
			waterfall: ["2M"],
			watergun: ["2L10", "2L1"],
			whirlpool: ["2M"],
		},
	},
	sudowoodo: {
		learnset: {
			attract: ["2M"],
			curse: ["2M"],
			defensecurl: ["2M"],
			dig: ["2M"],
			doubleteam: ["2M"],
			dynamicpunch: ["2M"],
			earthquake: ["2M"],
			endure: ["2M"],
			feintattack: ["2L37"],
			firepunch: ["2M"],
			flail: ["2L10"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			icepunch: ["2M"],
			lowkick: ["2L19"],
			mimic: ["2L1", "2S0"],
			mudslap: ["2M"],
			protect: ["2M"],
			psychup: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			rockslide: ["2L28"],
			rocksmash: ["2M"],
			rockthrow: ["2L1", "2S0"],
			rollout: ["2M"],
			sandstorm: ["2M"],
			selfdestruct: ["2E"],
			slam: ["2L46"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M"],
			substitute: ["2S0"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			thief: ["2M"],
			thunderpunch: ["2M"],
			toxic: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["rockthrow", "mimic", "substitute"]},
		],
	},
	politoed: {
		learnset: {
			attract: ["2M"],
			blizzard: ["2M"],
			curse: ["2M"],
			defensecurl: ["2M"],
			detect: ["2M"],
			doubleslap: ["2L1"],
			doubleteam: ["2M"],
			dynamicpunch: ["2M"],
			earthquake: ["2M"],
			endure: ["2M"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			hypnosis: ["2L1"],
			icebeam: ["2T"],
			icepunch: ["2M"],
			icywind: ["2M"],
			mudslap: ["2M"],
			perishsong: ["2L35", "2L1"],
			protect: ["2M"],
			psychic: ["2M"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			rocksmash: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M"],
			surf: ["2M"],
			swagger: ["2M", "2L51"],
			thief: ["2M"],
			toxic: ["2M"],
			waterfall: ["2M"],
			watergun: ["2L1"],
			whirlpool: ["2M"],
		},
	},
	hoppip: {
		learnset: {
			agility: ["2S0"],
			amnesia: ["2E"],
			attract: ["2M"],
			confusion: ["2E"],
			cottonspore: ["2L25"],
			curse: ["2M"],
			defensecurl: ["2M"],
			doubleedge: ["2E"],
			doubleteam: ["2M"],
			encore: ["2E"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			growl: ["2E"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			leechseed: ["2L20"],
			megadrain: ["2L30"],
			payday: ["2E"],
			poisonpowder: ["2L13"],
			protect: ["2M"],
			reflect: ["2E"],
			rest: ["2M"],
			return: ["2M"],
			sleeppowder: ["2L17"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M"],
			splash: ["2L1", "2S0"],
			stunspore: ["2L15"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			sweetscent: ["2M"],
			synthesis: ["2L5", "2L1", "2S0"],
			tackle: ["2L10"],
			tailwhip: ["2L5", "2S0"],
			toxic: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["splash", "synthesis", "tailwhip", "agility"]},
		],
		encounters: [
			{generation: 2, level: 3},
		],
	},
	skiploom: {
		learnset: {
			attract: ["2M"],
			cottonspore: ["2L29"],
			curse: ["2M"],
			defensecurl: ["2M"],
			doubleteam: ["2M"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			leechseed: ["2L22"],
			megadrain: ["2L36"],
			poisonpowder: ["2L13"],
			protect: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			sleeppowder: ["2L17"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M"],
			splash: ["2L1"],
			stunspore: ["2L15"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			sweetscent: ["2M"],
			synthesis: ["2L5", "2L1"],
			tackle: ["2L10", "2L1"],
			tailwhip: ["2L5", "2L1"],
			toxic: ["2M"],
		},
	},
	jumpluff: {
		learnset: {
			attract: ["2M"],
			cottonspore: ["2L33"],
			curse: ["2M"],
			defensecurl: ["2M"],
			doubleteam: ["2M"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			leechseed: ["2L22"],
			megadrain: ["2L44"],
			poisonpowder: ["2L13"],
			protect: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			sleeppowder: ["2L17"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M"],
			splash: ["2L1"],
			stunspore: ["2L15"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			sweetscent: ["2M"],
			synthesis: ["2L5", "2L1"],
			tackle: ["2L10", "2L1"],
			tailwhip: ["2L5", "2L1"],
			toxic: ["2M"],
		},
	},
	aipom: {
		learnset: {
			agility: ["2L46", "2E"],
			attract: ["2M"],
			batonpass: ["2L12"],
			beatup: ["2E"],
			counter: ["2E"],
			curse: ["2M"],
			cut: ["2M"],
			defensecurl: ["2M"],
			detect: ["2M"],
			doubleslap: ["2E"],
			doubleteam: ["2M"],
			dreameater: ["2M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			firepunch: ["2M"],
			frustration: ["2M"],
			furycutter: ["2M"],
			furyswipes: ["2L19"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			icepunch: ["2M"],
			irontail: ["2M"],
			mimic: ["2S0"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			protect: ["2M"],
			pursuit: ["2E"],
			rest: ["2M"],
			return: ["2M"],
			rocksmash: ["2M"],
			sandattack: ["2L6"],
			scratch: ["2L1", "2S0"],
			screech: ["2L36", "2E"],
			shadowball: ["2M"],
			slam: ["2E"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			spite: ["2E"],
			strength: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "2L27"],
			tailwhip: ["2L1", "2S0"],
			thief: ["2M"],
			thunder: ["2M"],
			thunderbolt: ["2T"],
			thunderpunch: ["2M"],
			toxic: ["2M"],
			zapcannon: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["scratch", "tailwhip", "mimic"]},
		],
	},
	sunkern: {
		learnset: {
			absorb: ["2L1", "2S0"],
			attract: ["2M"],
			curse: ["2M"],
			cut: ["2M"],
			doubleteam: ["2M"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			gigadrain: ["2M", "2L46"],
			growth: ["2L4", "2S0"],
			hiddenpower: ["2M"],
			megadrain: ["2L10"],
			protect: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M"],
			splash: ["2S0"],
			sunnyday: ["2M", "2L19"],
			swagger: ["2M"],
			sweetscent: ["2M"],
			synthesis: ["2L31"],
			toxic: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["absorb", "growth", "splash"]},
		],
	},
	sunflora: {
		learnset: {
			absorb: ["2L1"],
			attract: ["2M"],
			curse: ["2M"],
			cut: ["2M"],
			doubleteam: ["2M"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			growth: ["2L4"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			petaldance: ["2L31"],
			pound: ["2L1"],
			protect: ["2M"],
			razorleaf: ["2L10"],
			rest: ["2M"],
			return: ["2M"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M", "2L46"],
			sunnyday: ["2M", "2L19"],
			swagger: ["2M"],
			sweetscent: ["2M"],
			toxic: ["2M"],
		},
	},
	yanma: {
		learnset: {
			attract: ["2M"],
			curse: ["2M"],
			detect: ["2M", "2L25"],
			doubleteam: ["2M", "2L13"],
			endure: ["2M"],
			flash: ["2M"],
			foresight: ["2L1", "2S1", "2S0"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			leechlife: ["2E"],
			protect: ["2M"],
			quickattack: ["2L7"],
			rest: ["2M"],
			return: ["2M"],
			reversal: ["2E"],
			screech: ["2L43"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M"],
			sonicboom: ["2L19"],
			steelwing: ["2S0"],
			sunnyday: ["2M"],
			supersonic: ["2L31"],
			swagger: ["2M"],
			sweetkiss: ["2S1"],
			swift: ["2M", "2L37"],
			tackle: ["2L1", "2S1", "2S0"],
			thief: ["2M"],
			toxic: ["2M"],
			whirlwind: ["2E"],
			wingattack: ["2L37"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "foresight", "steelwing"]},
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "foresight", "sweetkiss"]},
		],
	},
	wooper: {
		learnset: {
			amnesia: ["2L21"],
			ancientpower: ["2E"],
			attract: ["2M"],
			bellydrum: ["2S0"],
			bodyslam: ["2E"],
			curse: ["2M"],
			defensecurl: ["2M"],
			dig: ["2M"],
			doubleteam: ["2M"],
			dynamicpunch: ["2M"],
			earthquake: ["2M", "2L31"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			haze: ["2L51"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			icebeam: ["2T"],
			icepunch: ["2M"],
			irontail: ["2M"],
			mist: ["2L51"],
			mudslap: ["2M"],
			protect: ["2M"],
			raindance: ["2M", "2L41"],
			rest: ["2M"],
			return: ["2M"],
			rocksmash: ["2M"],
			rollout: ["2M"],
			safeguard: ["2E"],
			sandstorm: ["2M"],
			scaryface: ["2S1"],
			slam: ["2L11"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			snore: ["2M"],
			surf: ["2M"],
			swagger: ["2M"],
			tailwhip: ["2L1", "2S1", "2S0"],
			toxic: ["2M"],
			watergun: ["2L1", "2S1", "2S0"],
			whirlpool: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["watergun", "tailwhip", "bellydrum"]},
			{generation: 2, level: 5, shiny: 1, moves: ["watergun", "tailwhip", "scaryface"]},
		],
		encounters: [
			{generation: 2, level: 4},
		],
	},
	quagsire: {
		learnset: {
			amnesia: ["2L23"],
			attract: ["2M"],
			curse: ["2M"],
			defensecurl: ["2M"],
			dig: ["2M"],
			doubleteam: ["2M"],
			dynamicpunch: ["2M"],
			earthquake: ["2M", "2L35"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			haze: ["2L59"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			icebeam: ["2T"],
			icepunch: ["2M"],
			irontail: ["2M"],
			mist: ["2L59"],
			mudslap: ["2M"],
			protect: ["2M"],
			raindance: ["2M", "2L47"],
			rest: ["2M"],
			return: ["2M"],
			rocksmash: ["2M"],
			rollout: ["2M"],
			sandstorm: ["2M"],
			slam: ["2L11"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			snore: ["2M"],
			strength: ["2M"],
			surf: ["2M"],
			swagger: ["2M"],
			tailwhip: ["2L1"],
			toxic: ["2M"],
			watergun: ["2L1"],
			whirlpool: ["2M"],
		},
		encounters: [
			{generation: 2, level: 15},
		],
	},
	murkrow: {
		learnset: {
			attract: ["2M"],
			beatup: ["2S0"],
			curse: ["2M"],
			detect: ["2M"],
			doubleteam: ["2M"],
			dreameater: ["2M"],
			drillpeck: ["2E"],
			endure: ["2M"],
			feintattack: ["2L31"],
			fly: ["2M"],
			frustration: ["2M"],
			haze: ["2L16"],
			hiddenpower: ["2M"],
			icywind: ["2M"],
			meanlook: ["2L41"],
			mirrormove: ["2E"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			nightshade: ["2L26"],
			peck: ["2L1", "2S0"],
			protect: ["2M"],
			psychup: ["2M"],
			pursuit: ["2L11"],
			quickattack: ["2E"],
			rest: ["2M"],
			return: ["2M"],
			shadowball: ["2M"],
			skyattack: ["2E"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			steelwing: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M"],
			thief: ["2M"],
			toxic: ["2M"],
			whirlwind: ["2E"],
			wingattack: ["2E"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["peck", "beatup"]},
		],
	},
	slowking: {
		learnset: {
			attract: ["2M"],
			blizzard: ["2M"],
			confusion: ["2L20"],
			curse: ["2M", "2L1"],
			dig: ["2M"],
			disable: ["2L29"],
			doubleteam: ["2M"],
			dreameater: ["2M"],
			dynamicpunch: ["2M"],
			earthquake: ["2M"],
			endure: ["2M"],
			fireblast: ["2M"],
			flamethrower: ["2T"],
			flash: ["2M"],
			frustration: ["2M"],
			furycutter: ["2M"],
			growl: ["2L6"],
			headbutt: ["2M", "2L34"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			icebeam: ["2T"],
			icepunch: ["2M"],
			icywind: ["2M"],
			irontail: ["2M"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			protect: ["2M"],
			psychic: ["2M", "2L48"],
			psychup: ["2M"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			rocksmash: ["2M"],
			shadowball: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M"],
			sunnyday: ["2M"],
			surf: ["2M"],
			swagger: ["2M", "2L43"],
			swift: ["2M"],
			tackle: ["2L1"],
			toxic: ["2M"],
			watergun: ["2L15"],
			whirlpool: ["2M"],
			zapcannon: ["2M"],
		},
	},
	misdreavus: {
		learnset: {
			attract: ["2M"],
			confuseray: ["2L12"],
			curse: ["2M"],
			defensecurl: ["2M"],
			destinybond: ["2E"],
			doubleteam: ["2M"],
			dreameater: ["2M"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			growl: ["2L1", "2S0"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hypnosis: ["2S0"],
			meanlook: ["2L19"],
			nightmare: ["2M"],
			painsplit: ["2L36"],
			perishsong: ["2L46"],
			protect: ["2M"],
			psybeam: ["2L27"],
			psychic: ["2M"],
			psychup: ["2M"],
			psywave: ["2L1"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			screech: ["2E"],
			shadowball: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			spite: ["2L6"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M"],
			thief: ["2M"],
			thunder: ["2M"],
			thunderbolt: ["2T"],
			toxic: ["2M"],
			zapcannon: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["growl", "hypnosis"]},
		],
	},
	unown: {
		learnset: {
			hiddenpower: ["2L1"],
		},
		encounters: [
			{generation: 2, level: 5},
		],
	},
	wobbuffet: {
		learnset: {
			counter: ["2L1"],
			destinybond: ["2L1", "2S0"],
			mimic: ["2S0"],
			mirrorcoat: ["2L1", "2S0"],
			safeguard: ["2L1", "2S0"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["mirrorcoat", "safeguard", "destinybond", "mimic"]},
		],
		encounters: [
			{generation: 2, level: 5},
		],
	},
	girafarig: {
		learnset: {
			agility: ["2L20"],
			amnesia: ["2E"],
			attract: ["2M"],
			batonpass: ["2L30"],
			beatup: ["2E"],
			confusion: ["2L7", "2L1"],
			crunch: ["2L54"],
			curse: ["2M"],
			doubleteam: ["2M"],
			dreameater: ["2M"],
			earthquake: ["2M"],
			endure: ["2M"],
			foresight: ["2E"],
			frustration: ["2M"],
			futuresight: ["2E"],
			growl: ["2L1"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			irontail: ["2M"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			protect: ["2M"],
			psybeam: ["2L41"],
			psychic: ["2M"],
			psychup: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			rocksmash: ["2M"],
			shadowball: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			stomp: ["2L13", "2L1"],
			strength: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M"],
			tackle: ["2L1"],
			takedown: ["2E"],
			thief: ["2M"],
			thunder: ["2M"],
			thunderbolt: ["2T"],
			toxic: ["2M"],
			zapcannon: ["2M"],
		},
	},
	pineco: {
		learnset: {
			attract: ["2M"],
			bide: ["2L29"],
			curse: ["2M"],
			defensecurl: ["2M"],
			doubleedge: ["2L50"],
			doubleteam: ["2M"],
			endure: ["2M"],
			explosion: ["2L36"],
			flail: ["2E"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			pinmissile: ["2E"],
			protect: ["2M", "2L1", "2S0"],
			rapidspin: ["2L22"],
			reflect: ["2E"],
			rest: ["2M"],
			return: ["2M"],
			rocksmash: ["2M"],
			rollout: ["2M"],
			selfdestruct: ["2L8"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M"],
			spikes: ["2L43"],
			strength: ["2M"],
			substitute: ["2S0"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			sweetscent: ["2M"],
			swift: ["2E"],
			tackle: ["2L1", "2S0"],
			takedown: ["2L15"],
			toxic: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "protect", "substitute"]},
		],
	},
	forretress: {
		learnset: {
			attract: ["2M"],
			bide: ["2L29"],
			curse: ["2M"],
			defensecurl: ["2M"],
			doubleedge: ["2L59"],
			doubleteam: ["2M"],
			endure: ["2M"],
			explosion: ["2L39"],
			frustration: ["2M"],
			gigadrain: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			protect: ["2M", "2L1"],
			rapidspin: ["2L22"],
			rest: ["2M"],
			return: ["2M"],
			rocksmash: ["2M"],
			rollout: ["2M"],
			sandstorm: ["2M"],
			selfdestruct: ["2L8", "2L1"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M"],
			spikes: ["2L49"],
			strength: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			sweetscent: ["2M"],
			tackle: ["2L1"],
			takedown: ["2L15"],
			toxic: ["2M"],
		},
	},
	dunsparce: {
		learnset: {
			ancientpower: ["2E"],
			attract: ["2M"],
			bide: ["2E"],
			bite: ["2E"],
			curse: ["2M"],
			defensecurl: ["2M", "2L5", "2S1", "2S0"],
			dig: ["2M"],
			doubleteam: ["2M"],
			dreameater: ["2M"],
			endure: ["2M"],
			flamethrower: ["2T"],
			frustration: ["2M"],
			furyattack: ["2S0"],
			glare: ["2L13"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			horndrill: ["2S1"],
			irontail: ["2M"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			protect: ["2M"],
			psychup: ["2M"],
			pursuit: ["2L26"],
			rage: ["2L1", "2E", "2S1", "2S0"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			rockslide: ["2E"],
			rocksmash: ["2M"],
			rollout: ["2M"],
			screech: ["2L30"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M"],
			spite: ["2L18"],
			strength: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			takedown: ["2L38"],
			thief: ["2M"],
			thunder: ["2M"],
			thunderbolt: ["2T"],
			toxic: ["2M"],
			zapcannon: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["rage", "defensecurl", "furyattack"]},
			{generation: 2, level: 5, shiny: 1, moves: ["rage", "defensecurl", "horndrill"]},
		],
	},
	gligar: {
		learnset: {
			attract: ["2M"],
			counter: ["2E", "2S0"],
			curse: ["2M"],
			cut: ["2M"],
			detect: ["2M"],
			doubleteam: ["2M"],
			earthquake: ["2S0"],
			endure: ["2M"],
			feintattack: ["2L28"],
			frustration: ["2M"],
			furycutter: ["2M"],
			guillotine: ["2L52"],
			harden: ["2L13"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			irontail: ["2M"],
			metalclaw: ["2E"],
			poisonsting: ["2L1", "2S0"],
			protect: ["2M"],
			quickattack: ["2L20"],
			razorwind: ["2E"],
			rest: ["2M"],
			return: ["2M"],
			rocksmash: ["2M"],
			sandattack: ["2L6"],
			sandstorm: ["2M"],
			screech: ["2L44"],
			slash: ["2L36"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			snore: ["2M"],
			strength: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M"],
			thief: ["2M"],
			toxic: ["2M"],
			wingattack: ["2E", "2S0"],
		},
		eventData: [
			{generation: 2, level: 5, moves: ["earthquake", "poisonsting", "counter", "wingattack"]},
		],
	},
	steelix: {
		learnset: {
			attract: ["2M"],
			bind: ["2L10"],
			crunch: ["2L49"],
			curse: ["2M"],
			cut: ["2M"],
			defensecurl: ["2M"],
			dig: ["2M"],
			doubleteam: ["2M"],
			dragonbreath: ["2M"],
			earthquake: ["2M"],
			endure: ["2M"],
			frustration: ["2M"],
			harden: ["2L23"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			irontail: ["2M"],
			mudslap: ["2M"],
			protect: ["2M"],
			rage: ["2L27"],
			rest: ["2M"],
			return: ["2M"],
			roar: ["2M"],
			rocksmash: ["2M"],
			rockthrow: ["2L14"],
			rollout: ["2M"],
			sandstorm: ["2M", "2L36"],
			screech: ["2L1"],
			slam: ["2L40"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			tackle: ["2L1"],
			toxic: ["2M"],
		},
	},
	snubbull: {
		learnset: {
			attract: ["2M"],
			bite: ["2L13"],
			charm: ["2L8"],
			crunch: ["2E"],
			curse: ["2M"],
			defensecurl: ["2M"],
			detect: ["2M"],
			doubleteam: ["2M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			feintattack: ["2E"],
			firepunch: ["2M"],
			frustration: ["2M"],
			headbutt: ["2M"],
			healbell: ["2E"],
			hiddenpower: ["2M"],
			icepunch: ["2M"],
			leer: ["2E"],
			lick: ["2L19", "2E"],
			lovelykiss: ["2S0"],
			metronome: ["2E"],
			mudslap: ["2M"],
			present: ["2E"],
			protect: ["2M"],
			rage: ["2L34"],
			raindance: ["2M"],
			reflect: ["2E"],
			rest: ["2M"],
			return: ["2M"],
			roar: ["2M", "2L26"],
			rocksmash: ["2M"],
			scaryface: ["2L1", "2S0"],
			shadowball: ["2M"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			snore: ["2M"],
			strength: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			tackle: ["2L1", "2S0"],
			tailwhip: ["2L4", "2S0"],
			takedown: ["2L43"],
			thief: ["2M"],
			thunder: ["2M"],
			thunderbolt: ["2T"],
			thunderpunch: ["2M"],
			toxic: ["2M"],
			zapcannon: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "scaryface", "tailwhip", "lovelykiss"]},
		],
	},
	granbull: {
		learnset: {
			attract: ["2M"],
			bite: ["2L13"],
			charm: ["2L8"],
			curse: ["2M"],
			defensecurl: ["2M"],
			detect: ["2M"],
			doubleteam: ["2M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			firepunch: ["2M"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			icepunch: ["2M"],
			lick: ["2L19"],
			mudslap: ["2M"],
			protect: ["2M"],
			rage: ["2L38"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			roar: ["2M", "2L28"],
			rocksmash: ["2M"],
			scaryface: ["2L1"],
			shadowball: ["2M"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			snore: ["2M"],
			strength: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			tackle: ["2L1"],
			tailwhip: ["2L4"],
			takedown: ["2L51"],
			thief: ["2M"],
			thunder: ["2M"],
			thunderbolt: ["2T"],
			thunderpunch: ["2M"],
			toxic: ["2M"],
			zapcannon: ["2M"],
		},
		encounters: [
			{generation: 2, level: 15},
		],
	},
	qwilfish: {
		learnset: {
			attract: ["2M"],
			blizzard: ["2M"],
			bubblebeam: ["2E"],
			curse: ["2M"],
			defensecurl: ["2M"],
			doubleedge: ["2S0"],
			doubleteam: ["2M"],
			endure: ["2M"],
			flail: ["2E"],
			frustration: ["2M"],
			harden: ["2L10"],
			haze: ["2E"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hydropump: ["2L46"],
			icebeam: ["2T"],
			icywind: ["2M"],
			minimize: ["2L10"],
			pinmissile: ["2L28"],
			poisonsting: ["2L1", "2S0"],
			protect: ["2M"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			rollout: ["2M"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			snore: ["2M"],
			spikes: ["2L1"],
			supersonic: ["2E"],
			surf: ["2M"],
			swagger: ["2M"],
			swift: ["2M"],
			tackle: ["2L1", "2S0"],
			takedown: ["2L37"],
			toxic: ["2M"],
			waterfall: ["2M"],
			watergun: ["2L19"],
			whirlpool: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "poisonsting", "doubleedge"]},
		],
	},
	shuckle: {
		learnset: {
			attract: ["2M"],
			bide: ["2L28"],
			constrict: ["2L1"],
			curse: ["2M"],
			defensecurl: ["2M"],
			dig: ["2M"],
			doubleteam: ["2M"],
			earthquake: ["2M"],
			encore: ["2L14"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			mudslap: ["2M"],
			protect: ["2M"],
			rest: ["2M", "2L37"],
			return: ["2M"],
			rocksmash: ["2M"],
			rollout: ["2M"],
			safeguard: ["2L23"],
			sandstorm: ["2M"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			snore: ["2M"],
			strength: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			sweetscent: ["2E"],
			toxic: ["2M"],
			withdraw: ["2L1"],
			wrap: ["2L9"],
		},
	},
	heracross: {
		learnset: {
			attract: ["2M"],
			bide: ["2E"],
			counter: ["2L27"],
			curse: ["2M"],
			cut: ["2M"],
			detect: ["2M"],
			doubleteam: ["2M"],
			earthquake: ["2M"],
			endure: ["2M", "2L12"],
			flail: ["2E"],
			frustration: ["2M"],
			furyattack: ["2L19"],
			furycutter: ["2M"],
			harden: ["2E"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hornattack: ["2L6"],
			leer: ["2L1", "2S0"],
			megahorn: ["2L54"],
			protect: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			reversal: ["2L44"],
			rocksmash: ["2M"],
			seismictoss: ["2S0"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			tackle: ["2L1", "2S0"],
			takedown: ["2L35"],
			thief: ["2M"],
			toxic: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "leer", "seismictoss"]},
		],
	},
	sneasel: {
		learnset: {
			agility: ["2L41"],
			attract: ["2M"],
			beatup: ["2L57"],
			bite: ["2E"],
			blizzard: ["2M"],
			counter: ["2E"],
			curse: ["2M"],
			cut: ["2M"],
			defensecurl: ["2M"],
			detect: ["2M"],
			dig: ["2M"],
			doubleteam: ["2M"],
			dreameater: ["2M"],
			dynamicpunch: ["2M"],
			endure: ["2M"],
			feintattack: ["2L25"],
			foresight: ["2E"],
			frustration: ["2M"],
			furycutter: ["2M"],
			furyswipes: ["2L33"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			icebeam: ["2T"],
			icepunch: ["2M"],
			icywind: ["2M"],
			irontail: ["2M"],
			leer: ["2L1", "2S0"],
			metalclaw: ["2L65"],
			moonlight: ["2S0"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			protect: ["2M"],
			psychup: ["2M"],
			quickattack: ["2L9"],
			raindance: ["2M"],
			reflect: ["2E"],
			rest: ["2M"],
			return: ["2M"],
			rocksmash: ["2M"],
			scratch: ["2L1", "2S0"],
			screech: ["2L17"],
			shadowball: ["2M"],
			slash: ["2L49"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			spite: ["2E"],
			strength: ["2M"],
			surf: ["2M"],
			swagger: ["2M"],
			swift: ["2M"],
			thief: ["2M"],
			toxic: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["scratch", "leer", "moonlight"]},
		],
	},
	teddiursa: {
		learnset: {
			attract: ["2M"],
			counter: ["2E"],
			crunch: ["2E"],
			curse: ["2M"],
			cut: ["2M"],
			defensecurl: ["2M"],
			dig: ["2M"],
			doubleteam: ["2M"],
			dynamicpunch: ["2M"],
			earthquake: ["2M"],
			endure: ["2M"],
			feintattack: ["2L22"],
			firepunch: ["2M"],
			focusenergy: ["2E"],
			frustration: ["2M"],
			furycutter: ["2M"],
			furyswipes: ["2L15"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			icepunch: ["2M"],
			leer: ["2L1", "2S0"],
			lick: ["2L8"],
			metalclaw: ["2E"],
			mudslap: ["2M"],
			protect: ["2M"],
			rest: ["2M", "2L29"],
			return: ["2M"],
			roar: ["2M"],
			rocksmash: ["2M"],
			rollout: ["2M"],
			scratch: ["2L1", "2S0"],
			seismictoss: ["2E"],
			slash: ["2L36"],
			sleeptalk: ["2M"],
			snore: ["2M", "2L43"],
			strength: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			sweetscent: ["2S0"],
			swift: ["2M"],
			takedown: ["2E"],
			thief: ["2M"],
			thrash: ["2L50"],
			thunderpunch: ["2M"],
			toxic: ["2M"],
			zapcannon: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["scratch", "leer", "sweetscent"]},
		],
		encounters: [
			{generation: 2, level: 2},
		],
	},
	ursaring: {
		learnset: {
			attract: ["2M"],
			curse: ["2M"],
			cut: ["2M"],
			defensecurl: ["2M"],
			dig: ["2M"],
			doubleteam: ["2M"],
			dynamicpunch: ["2M"],
			earthquake: ["2M"],
			endure: ["2M"],
			feintattack: ["2L22"],
			firepunch: ["2M"],
			frustration: ["2M"],
			furycutter: ["2M"],
			furyswipes: ["2L15", "2L1"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			icepunch: ["2M"],
			leer: ["2L1"],
			lick: ["2L8", "2L1"],
			mudslap: ["2M"],
			protect: ["2M"],
			rest: ["2M", "2L29"],
			return: ["2M"],
			roar: ["2M"],
			rocksmash: ["2M"],
			rollout: ["2M"],
			scratch: ["2L1"],
			slash: ["2L39"],
			sleeptalk: ["2M"],
			snore: ["2M", "2L49"],
			strength: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M"],
			thief: ["2M"],
			thrash: ["2L59"],
			thunderpunch: ["2M"],
			toxic: ["2M"],
			zapcannon: ["2M"],
		},
		encounters: [
			{generation: 2, level: 25},
		],
	},
	slugma: {
		learnset: {
			acidarmor: ["2E"],
			amnesia: ["2L29"],
			attract: ["2M"],
			bodyslam: ["2L50"],
			curse: ["2M"],
			defensecurl: ["2M"],
			doubleteam: ["2M"],
			ember: ["2L8"],
			endure: ["2M"],
			fireblast: ["2M"],
			flamethrower: ["2T", "2L36"],
			frustration: ["2M"],
			harden: ["2L22"],
			hiddenpower: ["2M"],
			mudslap: ["2M"],
			protect: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			rockslide: ["2L43"],
			rocksmash: ["2M"],
			rockthrow: ["2L15"],
			rollout: ["2M"],
			sleeptalk: ["2M"],
			smog: ["2L1"],
			snore: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			toxic: ["2M"],
		},
	},
	magcargo: {
		learnset: {
			amnesia: ["2L29"],
			attract: ["2M"],
			bodyslam: ["2L60"],
			curse: ["2M"],
			defensecurl: ["2M"],
			doubleteam: ["2M"],
			earthquake: ["2M"],
			ember: ["2L8", "2L1"],
			endure: ["2M"],
			fireblast: ["2M"],
			flamethrower: ["2T", "2L36"],
			frustration: ["2M"],
			harden: ["2L22"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			mudslap: ["2M"],
			protect: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			rockslide: ["2L48"],
			rocksmash: ["2M"],
			rockthrow: ["2L15", "2L1"],
			rollout: ["2M"],
			sleeptalk: ["2M"],
			smog: ["2L1"],
			snore: ["2M"],
			strength: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			toxic: ["2M"],
		},
	},
	swinub: {
		learnset: {
			amnesia: ["2L55"],
			ancientpower: ["2E"],
			attract: ["2M"],
			bite: ["2E"],
			blizzard: ["2M", "2L46"],
			bodyslam: ["2E"],
			curse: ["2M"],
			defensecurl: ["2M"],
			detect: ["2M"],
			doubleteam: ["2M"],
			earthquake: ["2M"],
			endure: ["2M", "2L19"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			icebeam: ["2T"],
			icywind: ["2M"],
			mist: ["2L37"],
			mudslap: ["2M"],
			powdersnow: ["2L10"],
			protect: ["2M"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			roar: ["2M"],
			rockslide: ["2E"],
			rocksmash: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M"],
			swagger: ["2M"],
			tackle: ["2L1", "2S0"],
			takedown: ["2L28", "2E"],
			toxic: ["2M"],
			whirlwind: ["2S0"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "whirlwind"]},
		],
	},
	piloswine: {
		learnset: {
			amnesia: ["2L70"],
			attract: ["2M"],
			blizzard: ["2M", "2L56"],
			curse: ["2M"],
			defensecurl: ["2M"],
			detect: ["2M"],
			doubleteam: ["2M"],
			earthquake: ["2M"],
			endure: ["2M", "2L19", "2L1"],
			frustration: ["2M"],
			furyattack: ["2L33"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hornattack: ["2L1"],
			hyperbeam: ["2M"],
			icebeam: ["2T"],
			icywind: ["2M"],
			mist: ["2L42"],
			mudslap: ["2M"],
			powdersnow: ["2L10", "2L1"],
			protect: ["2M"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			roar: ["2M"],
			rocksmash: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M"],
			swagger: ["2M"],
			takedown: ["2L28"],
			toxic: ["2M"],
		},
	},
	corsola: {
		learnset: {
			amnesia: ["2E"],
			ancientpower: ["2L43"],
			attract: ["2M"],
			bubble: ["2L13"],
			bubblebeam: ["2L25"],
			curse: ["2M"],
			defensecurl: ["2M"],
			doubleteam: ["2M"],
			earthquake: ["2M"],
			endure: ["2M"],
			frustration: ["2M"],
			harden: ["2L7"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			icebeam: ["2T"],
			mirrorcoat: ["2L37"],
			mist: ["2E"],
			mudslap: ["2M"],
			protect: ["2M"],
			psychic: ["2M"],
			raindance: ["2M"],
			recover: ["2L19"],
			rest: ["2M"],
			return: ["2M"],
			rockslide: ["2E"],
			rocksmash: ["2M"],
			rollout: ["2M"],
			safeguard: ["2E"],
			sandstorm: ["2M"],
			screech: ["2E"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			spikecannon: ["2L31"],
			strength: ["2M"],
			sunnyday: ["2M"],
			surf: ["2M"],
			swagger: ["2M"],
			tackle: ["2L1"],
			toxic: ["2M"],
			whirlpool: ["2M"],
		},
	},
	remoraid: {
		learnset: {
			amnesia: ["2S0"],
			attract: ["2M"],
			aurorabeam: ["2L22", "2E"],
			bubblebeam: ["2L22"],
			curse: ["2M"],
			defensecurl: ["2M"],
			doubleteam: ["2M"],
			endure: ["2M"],
			flamethrower: ["2T"],
			focusenergy: ["2L33"],
			frustration: ["2M"],
			haze: ["2E"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "2L55"],
			icebeam: ["2T", "2L44"],
			lockon: ["2L11"],
			mist: ["2S1"],
			mudslap: ["2M"],
			octazooka: ["2E"],
			protect: ["2M"],
			psybeam: ["2L22"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			screech: ["2E"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			supersonic: ["2E"],
			surf: ["2M"],
			swagger: ["2M"],
			swift: ["2M"],
			thief: ["2M"],
			toxic: ["2M"],
			watergun: ["2L1", "2S1", "2S0"],
			whirlpool: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["watergun", "amnesia"]},
			{generation: 2, level: 5, shiny: 1, moves: ["watergun", "mist"]},
		],
	},
	octillery: {
		learnset: {
			attract: ["2M"],
			aurorabeam: ["2L22"],
			bubblebeam: ["2L22"],
			constrict: ["2L11"],
			curse: ["2M"],
			defensecurl: ["2M"],
			doubleteam: ["2M"],
			endure: ["2M"],
			flamethrower: ["2T"],
			focusenergy: ["2L38"],
			frustration: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "2L70"],
			icebeam: ["2T", "2L54"],
			mudslap: ["2M"],
			octazooka: ["2L25"],
			protect: ["2M"],
			psybeam: ["2L22"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			surf: ["2M"],
			swagger: ["2M"],
			swift: ["2M"],
			thief: ["2M"],
			toxic: ["2M"],
			watergun: ["2L1"],
			whirlpool: ["2M"],
		},
	},
	delibird: {
		learnset: {
			attract: ["2M"],
			aurorabeam: ["2E"],
			blizzard: ["2M"],
			curse: ["2M"],
			detect: ["2M"],
			doubleteam: ["2M"],
			endure: ["2M"],
			fly: ["2M"],
			frustration: ["2M"],
			futuresight: ["2E"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			icebeam: ["2T"],
			icywind: ["2M"],
			mudslap: ["2M"],
			payday: ["2S0"],
			present: ["2L1", "2S1", "2S0"],
			protect: ["2M"],
			quickattack: ["2E"],
			raindance: ["2M"],
			rapidspin: ["2E"],
			rest: ["2M"],
			return: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			spikes: ["2S1"],
			splash: ["2E"],
			swagger: ["2M"],
			swift: ["2M"],
			thief: ["2M"],
			toxic: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["present", "payday"]},
			{generation: 2, level: 5, shiny: 1, moves: ["present", "spikes"]},
		],
	},
	mantine: {
		learnset: {
			agility: ["2L32"],
			attract: ["2M"],
			blizzard: ["2M"],
			bubble: ["2L1", "2S0"],
			bubblebeam: ["2L18"],
			confuseray: ["2L49"],
			curse: ["2M"],
			doubleteam: ["2M"],
			endure: ["2M"],
			frustration: ["2M"],
			gust: ["2S0"],
			haze: ["2E"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hydropump: ["2E"],
			icebeam: ["2T"],
			icywind: ["2M"],
			mudslap: ["2M"],
			protect: ["2M"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			slam: ["2E"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			supersonic: ["2L10"],
			surf: ["2M"],
			swagger: ["2M"],
			swift: ["2M"],
			tackle: ["2L1", "2S0"],
			takedown: ["2L25"],
			toxic: ["2M"],
			twister: ["2E"],
			waterfall: ["2M"],
			whirlpool: ["2M"],
			wingattack: ["2L40"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "bubble", "gust"]},
		],
	},
	skarmory: {
		learnset: {
			agility: ["2L25"],
			attract: ["2M"],
			curse: ["2M"],
			cut: ["2M"],
			detect: ["2M"],
			doubleteam: ["2M"],
			drillpeck: ["2E"],
			endure: ["2M"],
			fly: ["2M"],
			frustration: ["2M"],
			furyattack: ["2L37"],
			furycutter: ["2S0"],
			hiddenpower: ["2M"],
			leer: ["2L1", "2S0"],
			mudslap: ["2M"],
			peck: ["2L1", "2S0"],
			protect: ["2M"],
			pursuit: ["2E"],
			rest: ["2M"],
			return: ["2M"],
			sandattack: ["2L13"],
			sandstorm: ["2M"],
			skyattack: ["2E"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			steelwing: ["2M", "2L49"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "2L19"],
			thief: ["2M"],
			toxic: ["2M"],
			whirlwind: ["2E"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["leer", "peck", "furycutter"]},
		],
	},
	houndour: {
		learnset: {
			attract: ["2M"],
			beatup: ["2E"],
			bite: ["2L20"],
			counter: ["2E"],
			crunch: ["2L43"],
			curse: ["2M"],
			detect: ["2M"],
			doubleteam: ["2M"],
			dreameater: ["2M"],
			ember: ["2L1"],
			endure: ["2M"],
			feintattack: ["2L27"],
			fireblast: ["2M"],
			firespin: ["2E"],
			flamethrower: ["2T", "2L35"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			irontail: ["2M"],
			leer: ["2L1"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			protect: ["2M"],
			pursuit: ["2E"],
			rage: ["2E"],
			rest: ["2M"],
			return: ["2M"],
			reversal: ["2E"],
			roar: ["2M", "2L7"],
			rocksmash: ["2M"],
			shadowball: ["2M"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			smog: ["2L13"],
			snore: ["2M"],
			solarbeam: ["2M"],
			spite: ["2E"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M"],
			thief: ["2M"],
			toxic: ["2M"],
		},
	},
	houndoom: {
		learnset: {
			attract: ["2M"],
			bite: ["2L20"],
			crunch: ["2L52"],
			curse: ["2M"],
			detect: ["2M"],
			doubleteam: ["2M"],
			dreameater: ["2M"],
			ember: ["2L1"],
			endure: ["2M"],
			feintattack: ["2L30"],
			fireblast: ["2M"],
			flamethrower: ["2T", "2L41"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			irontail: ["2M"],
			leer: ["2L1"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			protect: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			roar: ["2M", "2L7"],
			rocksmash: ["2M"],
			shadowball: ["2M"],
			sleeptalk: ["2M"],
			sludgebomb: ["2M"],
			smog: ["2L13"],
			snore: ["2M"],
			solarbeam: ["2M"],
			strength: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M"],
			thief: ["2M"],
			toxic: ["2M"],
		},
	},
	phanpy: {
		learnset: {
			absorb: ["2S0"],
			ancientpower: ["2E"],
			attract: ["2M"],
			bodyslam: ["2E"],
			curse: ["2M"],
			defensecurl: ["2M", "2L9"],
			doubleedge: ["2L49"],
			doubleteam: ["2M"],
			earthquake: ["2M"],
			encore: ["2S1"],
			endure: ["2M", "2L41"],
			flail: ["2L17"],
			focusenergy: ["2E"],
			frustration: ["2M"],
			growl: ["2L1", "2S1", "2S0"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			mudslap: ["2M"],
			protect: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			roar: ["2M"],
			rocksmash: ["2M"],
			rollout: ["2M", "2L33"],
			sandstorm: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			tackle: ["2L1", "2S1", "2S0"],
			takedown: ["2L25"],
			toxic: ["2M"],
			watergun: ["2E"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "growl", "absorb"]},
			{generation: 2, level: 5, moves: ["tackle", "growl", "encore"], japan: true},
		],
		encounters: [
			{generation: 2, level: 2},
		],
	},
	donphan: {
		learnset: {
			attract: ["2M"],
			curse: ["2M"],
			defensecurl: ["2M", "2L9"],
			doubleteam: ["2M"],
			earthquake: ["2M", "2L49"],
			endure: ["2M"],
			flail: ["2L17"],
			frustration: ["2M"],
			furyattack: ["2L25"],
			growl: ["2L1"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hornattack: ["2L1"],
			hyperbeam: ["2M"],
			mudslap: ["2M"],
			protect: ["2M"],
			rapidspin: ["2L41"],
			rest: ["2M"],
			return: ["2M"],
			roar: ["2M"],
			rocksmash: ["2M"],
			rollout: ["2M", "2L33"],
			sandstorm: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			toxic: ["2M"],
		},
	},
	stantler: {
		learnset: {
			attract: ["2M"],
			bite: ["2E"],
			confuseray: ["2L49"],
			curse: ["2M"],
			detect: ["2M"],
			disable: ["2E"],
			doubleteam: ["2M"],
			dreameater: ["2M"],
			earthquake: ["2M"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hypnosis: ["2L15"],
			leer: ["2L8"],
			lightscreen: ["2E"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			protect: ["2M"],
			psychic: ["2M"],
			psychup: ["2M"],
			raindance: ["2M"],
			reflect: ["2E"],
			rest: ["2M"],
			return: ["2M"],
			roar: ["2M"],
			safeguard: ["2S0"],
			sandattack: ["2L31"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			spite: ["2E"],
			stomp: ["2L23"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M"],
			tackle: ["2L1", "2S0"],
			takedown: ["2L40"],
			thief: ["2M"],
			toxic: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "safeguard"]},
		],
	},
	smeargle: {
		learnset: {
			sketch: ["2L91", "2L81", "2L71", "2L61", "2L51", "2L41", "2L31", "2L21", "2L11", "2L1"],
		},
	},
	miltank: {
		learnset: {
			attract: ["2M"],
			bide: ["2L26"],
			blizzard: ["2M"],
			bodyslam: ["2L43"],
			curse: ["2M"],
			defensecurl: ["2M", "2L8"],
			doubleteam: ["2M"],
			dynamicpunch: ["2M"],
			earthquake: ["2M"],
			endure: ["2M"],
			firepunch: ["2M"],
			frustration: ["2M"],
			growl: ["2L4", "2S0"],
			headbutt: ["2M"],
			healbell: ["2L53"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			icebeam: ["2T"],
			icepunch: ["2M"],
			icywind: ["2M"],
			irontail: ["2M"],
			megakick: ["2S0"],
			milkdrink: ["2L19"],
			mudslap: ["2M"],
			present: ["2E"],
			protect: ["2M"],
			psychup: ["2M"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			reversal: ["2E"],
			rocksmash: ["2M"],
			rollout: ["2M", "2L34"],
			sandstorm: ["2M"],
			seismictoss: ["2E"],
			shadowball: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			stomp: ["2L13"],
			strength: ["2M"],
			sunnyday: ["2M"],
			surf: ["2M"],
			swagger: ["2M"],
			sweetscent: ["2M"],
			tackle: ["2L1", "2S0"],
			thunder: ["2M"],
			thunderbolt: ["2T"],
			thunderpunch: ["2M"],
			toxic: ["2M"],
			zapcannon: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["tackle", "growl", "megakick"]},
		],
	},
	raikou: {
		learnset: {
			bite: ["2L1"],
			crunch: ["2L61"],
			curse: ["2M"],
			cut: ["2M"],
			detect: ["2M"],
			dig: ["2M"],
			doubleteam: ["2M"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			irontail: ["2M"],
			leer: ["2L1", "2S0"],
			mudslap: ["2M"],
			protect: ["2M"],
			psychup: ["2M"],
			quickattack: ["2L31", "2S0"],
			raindance: ["2M"],
			reflect: ["2L51"],
			rest: ["2M"],
			return: ["2M"],
			roar: ["2M", "2L21", "2S0"],
			rocksmash: ["2M"],
			sandstorm: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			spark: ["2L41"],
			strength: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			swift: ["2M"],
			thunder: ["2M", "2L71"],
			thunderbolt: ["2T"],
			thundershock: ["2L11", "2S0"],
			toxic: ["2M"],
			zapcannon: ["2M"],
		},
		eventData: [
			{generation: 2, level: 40, shiny: true, moves: ["leer", "thundershock", "roar", "quickattack"]},
		],
		encounters: [
			{generation: 2, level: 40},
		],
	},
	entei: {
		learnset: {
			bite: ["2L1"],
			curse: ["2M"],
			cut: ["2M"],
			detect: ["2M"],
			dig: ["2M"],
			doubleteam: ["2M"],
			ember: ["2L11", "2S0"],
			endure: ["2M"],
			fireblast: ["2M", "2L71"],
			firespin: ["2L31", "2S0"],
			flamethrower: ["2T", "2L51"],
			flash: ["2M"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			irontail: ["2M"],
			leer: ["2L1", "2S0"],
			mudslap: ["2M"],
			protect: ["2M"],
			psychup: ["2M"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			roar: ["2M", "2L21", "2S0"],
			rocksmash: ["2M"],
			sandstorm: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M"],
			stomp: ["2L41"],
			strength: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M", "2L61"],
			swift: ["2M"],
			toxic: ["2M"],
		},
		eventData: [
			{generation: 2, level: 40, shiny: true, moves: ["leer", "ember", "roar", "firespin"]},
		],
		encounters: [
			{generation: 2, level: 40},
		],
	},
	suicune: {
		learnset: {
			aurorabeam: ["2L41"],
			bite: ["2L1"],
			blizzard: ["2M"],
			bubblebeam: ["2L11", "2L41"],
			curse: ["2M"],
			cut: ["2M"],
			detect: ["2M"],
			dig: ["2M"],
			doubleteam: ["2M"],
			endure: ["2M"],
			frustration: ["2M"],
			gust: ["2L31", "2S0"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hydropump: ["2L71"],
			hyperbeam: ["2M"],
			icebeam: ["2T"],
			icywind: ["2M"],
			irontail: ["2M"],
			leer: ["2L1", "2S0"],
			mirrorcoat: ["2L61"],
			mist: ["2L51"],
			mudslap: ["2M"],
			protect: ["2M"],
			psychup: ["2M"],
			raindance: ["2M", "2L21"],
			rest: ["2M"],
			return: ["2M"],
			roar: ["2M", "2L21", "2S0"],
			rocksmash: ["2M"],
			sandstorm: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			sunnyday: ["2M"],
			surf: ["2M"],
			swagger: ["2M"],
			swift: ["2M"],
			toxic: ["2M"],
			waterfall: ["2M"],
			watergun: ["2L11", "2S0"],
			whirlpool: ["2M"],
		},
		eventData: [
			{generation: 2, level: 40, shiny: true, moves: ["leer", "watergun", "roar", "gust"]},
		],
		encounters: [
			{generation: 2, level: 40},
		],
	},
	larvitar: {
		learnset: {
			ancientpower: ["2E"],
			attract: ["2M"],
			bite: ["2L1", "2S0"],
			crunch: ["2L43"],
			curse: ["2M"],
			detect: ["2M"],
			dig: ["2M"],
			doubleteam: ["2M"],
			earthquake: ["2M", "2L50"],
			endure: ["2M"],
			focusenergy: ["2E"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "2L57"],
			leer: ["2L1", "2S0"],
			mudslap: ["2M"],
			outrage: ["2E"],
			protect: ["2M"],
			pursuit: ["2E"],
			rage: ["2S0"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			rockslide: ["2L22"],
			sandstorm: ["2M", "2L8"],
			scaryface: ["2L36"],
			screech: ["2L15"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			stomp: ["2E"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			thrash: ["2L29"],
			toxic: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["bite", "leer", "rage"]},
		],
	},
	pupitar: {
		learnset: {
			attract: ["2M"],
			bite: ["2L1"],
			crunch: ["2L47"],
			curse: ["2M"],
			detect: ["2M"],
			dig: ["2M"],
			doubleteam: ["2M"],
			earthquake: ["2M", "2L56"],
			endure: ["2M"],
			frustration: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "2L65"],
			leer: ["2L1"],
			mudslap: ["2M"],
			protect: ["2M"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			rockslide: ["2L22"],
			sandstorm: ["2M", "2L8", "2L1"],
			scaryface: ["2L38"],
			screech: ["2L15", "2L1"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			thrash: ["2L29"],
			toxic: ["2M"],
		},
	},
	tyranitar: {
		learnset: {
			attract: ["2M"],
			bite: ["2L1"],
			crunch: ["2L47"],
			curse: ["2M"],
			cut: ["2M"],
			detect: ["2M"],
			dig: ["2M"],
			doubleteam: ["2M"],
			dragonbreath: ["2M"],
			dynamicpunch: ["2M"],
			earthquake: ["2M", "2L61"],
			endure: ["2M"],
			fireblast: ["2M"],
			firepunch: ["2M"],
			flamethrower: ["2T"],
			frustration: ["2M"],
			furycutter: ["2M"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M", "2L75"],
			icebeam: ["2T"],
			irontail: ["2M"],
			leer: ["2L1"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			protect: ["2M"],
			raindance: ["2M"],
			rest: ["2M"],
			return: ["2M"],
			roar: ["2M"],
			rockslide: ["2L22"],
			rocksmash: ["2M"],
			sandstorm: ["2M", "2L8", "2L1"],
			scaryface: ["2L38"],
			screech: ["2L15", "2L1"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			strength: ["2M"],
			sunnyday: ["2M"],
			surf: ["2M"],
			swagger: ["2M"],
			thrash: ["2L29"],
			thunderbolt: ["2T"],
			toxic: ["2M"],
		},
	},
	lugia: {
		learnset: {
			aeroblast: ["2L1", "2S0"],
			ancientpower: ["2L88"],
			blizzard: ["2M"],
			curse: ["2M"],
			detect: ["2M"],
			doubleteam: ["2M"],
			dragonbreath: ["2M"],
			dreameater: ["2M"],
			earthquake: ["2M"],
			endure: ["2M"],
			fly: ["2M"],
			frustration: ["2M"],
			futuresight: ["2L99"],
			gigadrain: ["2M"],
			gust: ["2L22", "2S0"],
			headbutt: ["2M"],
			hiddenpower: ["2M"],
			hydropump: ["2L44"],
			hyperbeam: ["2M"],
			icebeam: ["2T"],
			icywind: ["2M"],
			irontail: ["2M"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			protect: ["2M"],
			psychic: ["2M"],
			psychup: ["2M"],
			raindance: ["2M", "2L55"],
			recover: ["2L33", "2S0"],
			rest: ["2M"],
			return: ["2M"],
			roar: ["2M"],
			rocksmash: ["2M"],
			safeguard: ["2L11", "2S0"],
			sandstorm: ["2M"],
			shadowball: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			steelwing: ["2M"],
			strength: ["2M"],
			sunnyday: ["2M"],
			surf: ["2M"],
			swagger: ["2M"],
			swift: ["2M", "2L66"],
			thunder: ["2M"],
			thunderbolt: ["2T"],
			toxic: ["2M"],
			waterfall: ["2M"],
			whirlpool: ["2M"],
			whirlwind: ["2L77"],
			zapcannon: ["2M"],
		},
		eventData: [
			{generation: 2, level: 40, shiny: true, moves: ["aeroblast", "safeguard", "gust", "recover"]},
		],
		encounters: [
			{generation: 2, level: 40},
		],
	},
	hooh: {
		learnset: {
			ancientpower: ["2L88"],
			curse: ["2M"],
			detect: ["2M"],
			doubleteam: ["2M"],
			dragonbreath: ["2M"],
			dreameater: ["2M"],
			earthquake: ["2M"],
			endure: ["2M"],
			fireblast: ["2M", "2L44"],
			flamethrower: ["2T"],
			flash: ["2M"],
			fly: ["2M"],
			frustration: ["2M"],
			futuresight: ["2L99"],
			gigadrain: ["2M"],
			gust: ["2L22", "2S0"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			protect: ["2M"],
			psychic: ["2M"],
			psychup: ["2M"],
			raindance: ["2M"],
			recover: ["2L33", "2S0"],
			rest: ["2M"],
			return: ["2M"],
			roar: ["2M"],
			rocksmash: ["2M"],
			sacredfire: ["2L1", "2S0"],
			safeguard: ["2L11", "2S0"],
			sandstorm: ["2M"],
			shadowball: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M"],
			steelwing: ["2M"],
			strength: ["2M"],
			sunnyday: ["2M", "2L55"],
			swagger: ["2M"],
			swift: ["2M", "2L66"],
			thunder: ["2M"],
			thunderbolt: ["2T"],
			toxic: ["2M"],
			whirlwind: ["2L77"],
			zapcannon: ["2M"],
		},
		eventData: [
			{generation: 2, level: 40, shiny: true, moves: ["sacredfire", "safeguard", "gust", "recover"]},
		],
		encounters: [
			{generation: 2, level: 40},
		],
	},
	celebi: {
		learnset: {
			ancientpower: ["2L20"],
			batonpass: ["2L40"],
			confusion: ["2L1", "2S0"],
			curse: ["2M"],
			defensecurl: ["2M"],
			detect: ["2M"],
			doubleteam: ["2M"],
			dreameater: ["2M"],
			endure: ["2M"],
			flash: ["2M"],
			frustration: ["2M"],
			futuresight: ["2L30"],
			gigadrain: ["2M"],
			healbell: ["2L1", "2S0"],
			hiddenpower: ["2M"],
			hyperbeam: ["2M"],
			leechseed: ["2L1", "2S0"],
			mudslap: ["2M"],
			nightmare: ["2M"],
			perishsong: ["2L50"],
			protect: ["2M"],
			psychic: ["2M"],
			psychup: ["2M"],
			raindance: ["2M"],
			recover: ["2L1", "2S0"],
			rest: ["2M"],
			return: ["2M"],
			safeguard: ["2L10"],
			sandstorm: ["2M"],
			shadowball: ["2M"],
			sleeptalk: ["2M"],
			snore: ["2M"],
			solarbeam: ["2M"],
			sunnyday: ["2M"],
			swagger: ["2M"],
			sweetscent: ["2M"],
			swift: ["2M"],
			toxic: ["2M"],
		},
		eventData: [
			{generation: 2, level: 5, shiny: 1, moves: ["leechseed", "confusion", "healbell", "recover"]},
		],
		encounters: [
			{generation: 2, level: 40},
		],
		eventOnly: true,
	},
};
