package com.mixsmart.utils;

/**
 * SQL语句工具类
 * @author lmq
 * @version 1.0
 * @since JDK版本大于等于1.6
 * 2016年1月17日
 */
public class SQLUtils {

	private SQLUtils() {
		throw new UnsupportedOperationException("SQLUtils类无法实例化"); 
	}
	
	/**
	 * 判断语句是否为查询语句
	 * @param statement 语句
	 * @return 如果是查询语句；返回:true；否则返回:false
	 */
	public static boolean isSelect(String statement) {
		boolean is = StringUtils.isNotEmpty(statement)?(statement.trim().startsWith("select ")?true:false):false;
		//为HQL语句时
		is = is || StringUtils.isNotEmpty(statement)?(statement.trim().startsWith("from ")?true:false):false;
		return is;
	}
	
	/**
	 * 判断语句是否为插入语句
	 * @param statement 语句
	 * @return 如果是插入语句；返回:true；否则返回:false
	 */
	public static boolean isInsert(String statement) {
		return StringUtils.isNotEmpty(statement)?(statement.trim().startsWith("insert ")?true:false):false;
	}
	
	/**
	 * 判断语句是否为更新语句
	 * @param statement 语句
	 * @return 如果是更新语句；返回:true；否则返回:false
	 */
	public static boolean isUpdate(String statement) {
		return StringUtils.isNotEmpty(statement)?(statement.trim().startsWith("update ")?true:false):false;
	}
	
	/**
	 * 判断语句是否为删除语句
	 * @param statement 语句
	 * @return 如果是删除语句；返回:true；否则返回:false
	 */
	public static boolean isDelete(String statement) {
		return StringUtils.isNotEmpty(statement)?(statement.trim().startsWith("delete ")?true:false):false;
	}
	
}
