package com.mixsmart.utils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

/**
 * 简单对象工具类
 * @author lmq
 * @version 1.0
 * @since 1.0
 * 2015年8月22日
 */
public class ObjectUtils {

	/**
	 * 根据内容进行数据类型转换
	 * <p>如:字符串“5”转换之后变成整型5</p>
	 * @param value
	 * @return 转换后的值
	 */
	public static Object covertDataType(Object value) {
		Object obj = null;
		String valueStr = value.toString();
		if(StringUtils.isNotEmpty(valueStr)) {
			if(StringUtils.isInteger(valueStr)) {
				obj = Integer.parseInt(valueStr);
			} else if(StringUtils.isDecimal(valueStr)) {
				obj = Double.parseDouble(valueStr);
			} else {
				obj = value;
			}
		} else {
			obj = value;
		}
		return obj;
	}
	
	/**
	 * boolean型转化为整型 <br />
	 * 转换依据是:true--1;false--0
	 * @param value
	 * @return 返回1或0
	 */
	public static int boolean2Int(boolean value) {
		return value?1:0;
	}
	
	
	/**
	 * boolean型转化为String <br />
	 * 转换依据是:true--"1";false--"0"
	 * @param value
	 * @return 返回“1”或“0”
	 */
	public static String boolean2String(boolean value) {
		return value?"1":"0";
	}
	
	
	/**
	 * int型转化为boolean <br />
	 * 转换依据是:1--true;非1--false
	 * @param value
	 * @return 返回true或false
	 */
	public static boolean int2Boolean(int value) {
		return value == 1;
	}
	
	
	/**
	 * Strng型转化为boolean <br />
	 * 转换依据是:"1"--true；非"1"--false
	 * @param value
	 * @return 返回true或false
	 */
	public static boolean string2Boolean(String value) {
		return "1".equals(value);
	}
	
	/**
	 * 简单Bean对象转换为Map对象；
	 * <p>转换规则是：实例属性作为Map的key，实例属性对应的值作为Map对象的value.</p>
	 * <p>注：当属性对应的值为空（null或""）时，实例对应的属性不会放到Map对象中；既：属性对应的值为空时不转换.</p>
	 * @param objBean 简单对象实例
	 * @return 返回转换后的Map对象
	 */
	public static Map<String, Object> simpleBean2Map(Object objBean) {
	    if(null == objBean) {
	        return null;
	    }
	    Class<?> clazz = objBean.getClass();
	    Map<String, Object> maps = new HashMap<String, Object>();
	    convert2Map(objBean, clazz, maps);
	    return (maps.isEmpty() ? null : maps);
	}
	
	/**
	 * 对象转换为Map
	 * @param objBean 对象实例
	 * @param clazz 对象类
	 * @param maps 转换后的Map对象
	 */
	private static void convert2Map(Object objBean, Class<?> clazz, Map<String, Object> maps) {
	    Field[] fields = clazz.getDeclaredFields();
        if(null == fields || fields.length == 0) {
            return;
        }
        try {
            for(Field field : fields) {
                if(Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers())) {
                    continue;
                }
                String fieldName = field.getName();
                PropertyDescriptor propertyDesc = new PropertyDescriptor(fieldName, clazz);
                Method method = propertyDesc.getReadMethod();
                if(null != method) {
                    Object value = method.invoke(objBean);
                    if(null != value && StringUtils.isNotEmpty(value.toString())) {
                        if(null != value && value instanceof String &&  value.toString().startsWith("%")) {
                            maps.put(fieldName, URLDecoder.decode(value.toString(), "UTF-8"));
                        } else if(value.getClass().isArray()){
                            Object[] values = (Object[])value;
                            if(values.length > 0 ) {
                                maps.put(fieldName, value);
                            }
                        } else {
                            maps.put(fieldName, value);
                        }
                    }
                }
                method = null;
            }
        } catch (SecurityException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
        Class<?> superClazz = clazz.getSuperclass();
        if (null != superClazz) {
            convert2Map(objBean, superClazz, maps);
        }
	}
	
	/**
	 * 处理Boolean类型数据；对象转Boolean类型
	 * @param value 值
	 * @return 返回true或false
	 */
	public static boolean handleBoolean(Object value) {
        if(null == value) {
            return false;
        }
        try {
            return Boolean.parseBoolean(value.toString());
        } catch (Exception e) {
            return false;
        }
    }
}
