package com.mixsmart.utils;

import org.slf4j.Logger;

/**
 * 日志工具类
 * @author lmq
 *
 */
public class LoggerUtils {

	/**
	 * 记录INFO日志；如果 <code>msg</code> 参数需要拼接字符串，请使用{@link #info(Logger, String, Object...)} 方法
	 * @param logger log4j实现类
	 * @param msg 日志内容
	 */
	public static void info(Logger logger, String msg) {
		if(logger.isInfoEnabled() && StringUtils.isNotEmpty(msg)) {
			logger.info(msg);
		}
	}
	
	/**
	 * 记录INFO日志；拼接例子，如：info("你好啊,{}","张三")
	 * @param logger log4j实现类
	 * @param msg 日志内容
	 * @param args 日志参数
	 */
	public static void info(Logger logger, String msg, Object...args ) {
		if(logger.isInfoEnabled() && StringUtils.isNotEmpty(msg)) {
			logger.info(msg, args);
		}
	}
	
	/**
	 * 记录DEBUG日志；如果 <code>msg</code> 参数需要拼接字符串，请使用{@link #debug(Logger, String, Object...)} 方法
	 * @param logger log4j实现类
	 * @param msg 日志内容
	 */
	public static void debug(Logger logger, String msg) {
		if(logger.isDebugEnabled() && StringUtils.isNotEmpty(msg)) {
			logger.debug(msg);
		}
	}
	
	/**
	 * 记录DEBUG日志；拼接例子，如：info("你好啊,{}",new String[]{"张三"})
	 * @param logger log4j实现类
	 * @param msg 日志内容
	 * @param args 日志参数
	 */
	public static void debug(Logger logger, String msg, Object...args ) {
		if(logger.isDebugEnabled() && StringUtils.isNotEmpty(msg)) {
			logger.debug(msg, args);
		}
	}
	
	/**
	 * 记录ERROR日志
	 * @param logger log4j实现类
	 * @param msg 日志内容
	 */
	public static void error(Logger logger, String msg) {
		if(logger.isErrorEnabled() && StringUtils.isNotEmpty(msg)) {
			logger.error(msg);
		}
	}
	
	/**
	 * 记录ERROR日志
	 * @param logger log4j实现类
	 * @param msg 日志内容
	 * @param args 日志参数
	 */
	public static void error(Logger logger, String msg, Object...args ) {
		if(logger.isErrorEnabled() && StringUtils.isNotEmpty(msg)) {
			logger.error(msg, args);
		}
	}
	
	/**
     * 记录ERROR日志
     * @param logger log4j实现类
     * @param msg 日志内容
     * @param t 异常对象
     */
    public static void error(Logger logger, String msg, Throwable t) {
        if(logger.isErrorEnabled() && StringUtils.isNotEmpty(msg)) {
            logger.error(msg, t);
        }
    }
    
    /**
     * 记录ERROR日志
     * @param logger log4j实现类
     * @param t 异常对象
     */
    public static void error(Logger logger, Throwable t) {
        if(logger.isErrorEnabled()) {
            logger.error("异常信息", t);
        }
    }
	
	/**
	 * 记录WARN日志
	 * @param logger log4j实现类
	 * @param msg 日志内容
	 */
	public static void warn(Logger logger, String msg) {
		if(logger.isWarnEnabled() && StringUtils.isNotEmpty(msg)) {
			logger.warn(msg);
		}
	}
	
	/**
	 * 记录WARN日志
	 * @param logger log4j实现类
	 * @param msg 日志内容
	 * @param args 日志参数
	 */
	public static void warn(Logger logger, String msg, Object...args ) {
		if(logger.isWarnEnabled() && StringUtils.isNotEmpty(msg)) {
			logger.warn(msg, args);
		}
	}
	
	/**
	 * 记录TRACE日志
	 * @param logger log4j实现类
	 * @param msg 日志内容
	 */
	public static void trace(Logger logger, String msg) {
		if(logger.isTraceEnabled() && StringUtils.isNotEmpty(msg)) {
			logger.trace(msg);
		}
	}
	
	/**
	 * 记录TRACE日志
	 * @param logger log4j实现类
	 * @param msg 日志内容
	 * @param args 日志参数
	 */
	public static void trace(Logger logger, String msg, Object...args ) {
		if(logger.isTraceEnabled() && StringUtils.isNotEmpty(msg)) {
			logger.trace(msg, args);
		}
	}
}
