package com.mixsmart.utils;

import com.mixsmart.config.SystemConfig;
import com.mixsmart.constant.IMixConstant;

/**
 * 文件分类工具类
 * @author lmq
 * @version 1.0
 * @since JDK1.6以上  2016年7月22日
 */
public class FileClassifyUtils {

    /**
     * 获取目录 
     * @param typeProp 配置类型属性名称
     * @param dirProp 配置类型所在目录名称
     * @param ext 文件扩展名
     * @return 返回扩展名所在目录；
     * 如果没有配置该扩展名对应的目录，则返回null
     */
    private static String getDir(String typeProp, String dirProp, String ext) {
        if(StringUtils.isNotEmpty(typeProp) && StringUtils.isNotEmpty(dirProp)) {
            String dirStr = null;
            String configExt = SystemConfig.getInstance().getValue(typeProp);
            String[] configExts = configExt.split(IMixConstant.MULTI_VALUE_SPLIT);
            if(ArrayUtils.isArrayContainsIgnoreCase(configExts, ext)) {
                dirStr = SystemConfig.getInstance().getValue(dirProp);
            }
            return dirStr;
        } else {
            return null;
        }
    }
    
    /**
     * 获取图片存放路径
     * @param ext 文件扩展名
     * @return 返回该扩展名所在目录；
     */
    private static String getImagesDir(String ext) {
        return getDir("upload.image.type", "upload.images.dir", ext);
    }
    
    /**
     * 获取图片存放路径
     * @param ext 文件扩展名
     * @return 返回该扩展名所在目录；
     */
    private static String getVideoDir(String ext) {
        return getDir("upload.video.type", "upload.video.dir", ext);
    }
    
    /**
     * 获取图片存放路径
     * @param ext 文件扩展名
     * @return 返回该扩展名所在目录；
     */
    private static String getDocDir(String ext) {
        return getDir("upload.doc.dir", "upload.doc.type", ext);
    }
    
    /**
     * 获取图片存放路径
     * @param ext 文件扩展名
     * @return 返回该扩展名所在目录；
     */
    private static String getAudioDir(String ext) {
        return getDir("upload.audio.type", "upload.audio.dir", ext);
    }
    
    /**
     * 获取图片存放路径
     * @param ext 文件扩展名
     * @return 返回该扩展名所在目录；
     */
    private static String getOtherDir(String ext) {
        return SystemConfig.getInstance().getValue("upload.other.dir");
    }
    
    /**
     * 获取归类目录
     * @param ext 文件扩展名
     * @return 返回该扩展名所在目录；
     */
    public static String getClassifyDir(String ext) {
        String dir = getImagesDir(ext);
        if(StringUtils.isEmpty(dir)) {
            dir = getDocDir(ext);
        }
        if(StringUtils.isEmpty(dir)) {
            dir = getVideoDir(ext);
        }
        if(StringUtils.isEmpty(dir)) {
            dir = getAudioDir(ext);
        }
        if(StringUtils.isEmpty(dir)) {
            dir = getOtherDir(ext);
        }
        return dir;
    }
    
    /**
     * 获取归类目录（返回的是相对路径；如：images,video,other等）
     * @param ext 文件扩展名
     * @return 返回该扩展名所在目录；
     */
    public static String getClassifyRelativeDir(String ext) {
        String dir = getClassifyDir(ext);
        if(StringUtils.isNotEmpty(dir)) {
            dir = dir.substring(dir.lastIndexOf("/") + 1, dir.length());
        }
        return dir;
    }
	
	
}
