package com.mixsmart.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import com.mixsmart.utils.StringUtils;

/**
 * 日期工具类
 * @author lmq
 * @version 1.0
 * @since JDK1.6
 * 2015年8月22日
 */
public class DateUtils {

	/**
	 * 时间转为日期格式
	 * <p>如：formatter参数为空时，默认格式为“yyyy-MM-dd HH:mm:ss”</p>
	 * @param date
	 * @param formatter 
	 * @return 日期转换后的字符串 
	 */
	public static String dateToStr(Date date,String formatter) {
		String value = null;
		if(null != date) {
			if(StringUtils.isEmpty(formatter)) {
				formatter = "yyyy-MM-dd HH:mm:ss";
			}
			SimpleDateFormat dateFormat = new SimpleDateFormat(formatter);
			value = dateFormat.format(date);
			dateFormat = null;
		}
		return value;
	}
	
	/**
     * 日期转为日期时间字符串格式
     * @param date 日期对象
     * @return 日期转换后的字符串 
     */
    public static String dateTimeToStr(Date date) {
        return dateToStr(date, "yyyy-MM-dd HH:mm:ss");
    }
    
    /**
     * 日期转为日期字符串格式
     * @param date 日期对象
     * @return 返回日期字符串 
     */
    public static String dateToStr(Date date) {
        return dateToStr(date, "yyyy-MM-dd");
    }
	
	/**
	 * 解析成日期时间
	 * @param dateTimeStr 日期时间字符串；格式为“yyyy-MM-dd HH:mm:ss”
	 * @return 返回 {@link Date} 对象
	 */
	public static Date parseDateTime(String dateTimeStr) {
	    if(StringUtils.isEmpty(dateTimeStr)) {
	        return null;
	    }
	    Date datetime = null;
	    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	    try {
            datetime = dateFormat.parse(dateTimeStr);
        } catch (ParseException e) {
            e.printStackTrace();
        }
	    return datetime;
	}
	
	/**
     * 解析成日期
     * @param dateTimeStr 日期字符串；格式为“yyyy-MM-dd”
     * @return 返回 {@link Date} 对象
     */
    public static Date parseDate(String dateStr) {
        if(StringUtils.isEmpty(dateStr)) {
            return null;
        }
        Date datetime = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            datetime = dateFormat.parse(dateStr);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return datetime;
    }
    
    /**
     * 获取当前日期的字符串形式
     * @param formatter 日期格式；如果为空，则使用默认格式：“yyyy-MM-dd HH:mm:ss”
     * @return 返回当前日期格式化后的日期字符串
     */
    public static String getCurrentDateStr(String formatter) {
        if(StringUtils.isEmpty(formatter)) {
            formatter = "yyyy-MM-dd HH:mm:ss";
        }
        return DateUtils.dateToStr(new Date(), formatter);
    }
}
