package com.mixsmart.numconvert;

/**
 * 数字转换类接口
 * @author lmq
 * @version 1.0
 * @since JDK版本大于等于1.6
 * <p>2016年5月17日</p>
 */
public interface INumConvert {

	/**
	 * 整型数字转换
	 * @param num 整型数字
	 * @return 返回转换后的值
	 */
	public String convert(Integer num);
	
	/**
	 * 长整型数字转换
	 * @param num 长整型数字
	 * @return 返回转换后的值
	 */
	public String convert(Long num);
	
	/**
	 * 单精度浮点型小数（Float）转换
	 * @param num 单精度浮点型小数（Float）
	 * @return 返回转换后的值
	 */
	public String convert(Float num);
	
	/**
	 * 双精度浮点型小数(Double)转换
	 * @param num 双精度浮点型小数(Double)
	 * @return 返回转换后的值
	 */
	public String convert(Double num);
	
}
