package com.mixsmart.numconvert;

/**
 * 数字转换抽象类；实现了INumConvert接口
 * @author lmq
 * @version 1.0
 * @since JDK版本大于等于1.6
 * <p>2016年5月17日</p>
 */
public abstract class AbstractNumConvert implements INumConvert {

	@Override
	public String convert(Integer num) {
		return this.convert((long)num);
	}

	@Override
	public abstract String convert(Long num);

	@Override
	public String convert(Float num) {
		return this.convert((double)num);
	}

	@Override
	public abstract String convert(Double num);

}
