package com.mixsmart.enums;

import com.mixsmart.utils.StringUtils;

/**
 * 是否类型
 * @version 1.0
 * @since JDK1.6以上
 * @author lmq 
 * 2016年2月1日
 */
public enum YesNoType {
    
    /**
     * 0 -- 否
     */
    NO(0, false, "0", "否"),
    /**
     * 1 -- 是
     */
    YES(1, true, "1", "是");
    
    private int index;
    private Boolean value;
    private String strValue;
    private String text;
    
    private YesNoType(int index,boolean value, String strValue,String text) {
        this.index = index;
        this.value = value;
        this.strValue = strValue;
        this.text = text;
    }
    
    /**
     * 通过INDEX值获取是否类型对象
     * @param index 值
     * @return 返回index对应的类型对象
     */
    public static YesNoType getObj(int index) {
        YesNoType yesNoType = null;
        for (YesNoType yesNo : YesNoType.values()) {
            if(yesNo.getIndex() == index) {
                yesNoType = yesNo;
                break;
            }
        }
        return yesNoType;
    }
    
    /**
     * 通过value值获取是否类型对象；如果没有获取对象，则返回默认对象；
     * 默认值为： {@link #NO}
     * @param value 值
     * @return 返回value对应的类型对象
     */
    public static YesNoType getSupportDefaultObj(int index) {
        YesNoType yesNoType = getObj(index);
        if(null == yesNoType) {
            yesNoType = NO;
        }
        return yesNoType;
    }
    
    /**
     * 通过value值获取是否类型对象
     * @param value 值
     * @return 返回value对应的类型对象
     */
    public static YesNoType getObj(boolean value) {
        YesNoType yesNoType = null;
        for (YesNoType yesNo : YesNoType.values()) {
            if(yesNo.getValue() == value) {
                yesNoType = yesNo;
                break;
            }
        }
        return yesNoType;
    }
    
    /**
     * 通过value值获取是否类型对象；如果没有获取对象，则返回默认对象；
     * 默认值为： {@link #NO}
     * @param value 值
     * @return 返回value对应的类型对象
     */
    public static YesNoType getSupportDefaultObj(boolean value) {
        YesNoType yesNoType = getObj(value);
        if(null == yesNoType) {
            yesNoType = NO;
        }
        return yesNoType;
    }
    
    /**
     * 通过value值获取是否类型对象
     * @param strValue 字符串值
     * @return 返回value对应的类型对象
     */
    public static YesNoType getObjByStrValue(String strValue) {
        YesNoType yesNoType = null;
        if(StringUtils.isEmpty(strValue)) {
            return yesNoType;
        }
        for (YesNoType yesNo : YesNoType.values()) {
            if(yesNo.getStrValue().equals(strValue)) {
                yesNoType = yesNo;
                break;
            }
        }
        return yesNoType;
    }
    
    /**
     * 通过 <code>value</code> 值获取是否类型对象；如果没有获取对象，则返回默认对象；
     * 默认值为： {@link #NO}
     * @param strValue 字符串值
     * @return 返回是否类型对象
     */
    public static YesNoType getSupportDefaultObj(String strValue) {
        YesNoType yesNoType = getObjByStrValue(strValue);
        if(null == yesNoType) {
            yesNoType = NO;
        }
        return yesNoType;
    }
    
    /**
     * 通过text值获取是否类型对象
     * @param text 显示内容
     * @return 返回是否类型对象
     */
    public static YesNoType getObj(String text) {
        YesNoType yesNoType = null;
        if(StringUtils.isEmpty(text)) {
            return yesNoType;
        }
        for (YesNoType yesNo : YesNoType.values()) {
            if(yesNo.getText().equals(text)) {
                yesNoType = yesNo;
                break;
            }
        }
        return yesNoType;
    }
    
    public int getIndex() {
        return index;
    }
    
    public void setIndex(int index) {
        this.index = index;
    }
    
    public boolean getValue() {
        return value;
    }
    
    public void setValue(boolean value) {
        this.value = value;
    }
    
    public String getText() {
        return text;
    }
    
    public void setText(String text) {
        this.text = text;
    }

    public String getStrValue() {
        return strValue;
    }
    
}
