/*
 * Decompiled with CFR 0.152.
 */
package com.mixsmart.utils;

import com.mixsmart.exception.NullArgumentException;
import com.mixsmart.sort.ChinaNumSort;
import com.mixsmart.utils.ArrayUtils;
import com.mixsmart.utils.CollectionUtils;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private StringUtils() {
        throw new UnsupportedOperationException("StringUtils\u7c7b\u65e0\u6cd5\u5b9e\u4f8b\u5316");
    }

    public static boolean isEmpty(String value) {
        return null == value || value.trim().length() == 0;
    }

    public static boolean isNotEmpty(String value) {
        return !StringUtils.isEmpty(value);
    }

    public static void isAssert(Object value, String msg) {
        String string = msg = StringUtils.isEmpty(msg) ? "\u63d0\u4f9b\u7684\u53c2\u6570\u4e3a\u7a7a" : msg;
        if (null == value) {
            throw new NullArgumentException(msg);
        }
        if (value instanceof String ? StringUtils.isEmpty(value.toString()) : (value instanceof Collection ? CollectionUtils.isEmpty((Collection)value) : value.getClass().isArray() && ArrayUtils.isEmpty((Object[])value))) {
            throw new NullArgumentException(msg);
        }
    }

    public static boolean isEquals(Object value1, Object value2) {
        boolean is = false;
        if (null != value1 && null != value1) {
            is = value1.toString().equals(value2.toString());
        } else if (null == value1 && null == value1) {
            is = true;
        }
        return is;
    }

    public static boolean isNotEquals(Object value1, Object value2) {
        return !StringUtils.isEquals(value1, value2);
    }

    public static boolean isEqualsIgnoreCase(Object value1, Object value2) {
        boolean is = false;
        if (null != value1 && null != value1) {
            is = value1.toString().equalsIgnoreCase(value2.toString());
        } else if (null == value1 && null == value1) {
            is = true;
        }
        return is;
    }

    public static boolean isNotEqualsIgnoreCase(Object value1, Object value2) {
        return !StringUtils.isEqualsIgnoreCase(value1, value2);
    }

    @Deprecated
    public static String handNull(Object obj) {
        return StringUtils.handleNull(obj);
    }

    public static String handleNull(Object obj) {
        if (null == obj) {
            return "";
        }
        return obj.toString().trim();
    }

    public static String nullToStr(Object obj) {
        if (null == obj) {
            return "null";
        }
        return obj.toString().trim();
    }

    public static Integer handObj2Integer(Object obj) {
        return StringUtils.handleObj2Integer(obj);
    }

    public static Integer handleObj2Integer(Object obj) {
        if (null == obj) {
            return 0;
        }
        Integer value = 0;
        try {
            value = Integer.parseInt(obj.toString());
        }
        catch (Exception ex) {
            value = 0;
        }
        return value;
    }

    @Deprecated
    public static String handNumNull(Object obj) {
        return StringUtils.handleNumNull(obj);
    }

    public static String handleNumNull(Object obj) {
        if (null == obj) {
            return "0";
        }
        return obj.toString().trim();
    }

    public static boolean isNum(String value) {
        boolean is = false;
        Pattern pattern = Pattern.compile("\\d+|\\d+\\.\\d+");
        Matcher matcher = pattern.matcher(value);
        is = matcher.matches();
        return is;
    }

    public static boolean isInteger(String value) {
        Matcher matcher;
        boolean is = false;
        Pattern pattern = Pattern.compile("\\d+");
        if (null != value && value.length() > 1) {
            pattern = Pattern.compile("^[1-9]\\d+");
        }
        is = (matcher = pattern.matcher(value)).matches();
        return is;
    }

    public static boolean isDecimal(String value) {
        boolean is = false;
        Pattern pattern = Pattern.compile("\\d+\\.\\d+");
        Matcher matcher = pattern.matcher(value);
        is = matcher.matches();
        return is;
    }

    public static String randomNum(int num) {
        Random random = new Random();
        String numStr = "";
        for (int i = 0; i < num; ++i) {
            numStr = numStr + random.nextInt(10);
        }
        return numStr;
    }

    public static String createSerialNum(String dateFormaterStr) {
        String serialNum = null;
        if (!StringUtils.isEmpty(dateFormaterStr)) {
            SimpleDateFormat dateFormatter = new SimpleDateFormat(dateFormaterStr);
            serialNum = dateFormatter.format(new Date());
            Object var2_2 = null;
        }
        return serialNum;
    }

    public static String createSerialNum() {
        return StringUtils.uuid();
    }

    public static String uuid() {
        String value = UUID.randomUUID().toString();
        value = value.replaceAll("-", "");
        return value;
    }

    public static String getFileSuffix(String fileName) {
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    public static String trimFileSuffix(String fileName) {
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    public static String upperSeparateUnderline(String value) {
        StringBuilder strBuilder = null;
        if (!StringUtils.isEmpty(value)) {
            strBuilder = new StringBuilder();
            byte[] values = value.getBytes();
            for (int i = 0; i < values.length; ++i) {
                if (values[i] >= 65 && values[i] <= 90) {
                    if (i > 0 && i < values.length - 1) {
                        strBuilder.append("_" + (char)(values[i] + 32));
                        continue;
                    }
                    strBuilder.append(String.valueOf((char)(values[i] + 32)));
                    continue;
                }
                strBuilder.append(String.valueOf((char)values[i]));
            }
            Object var2_2 = null;
        }
        return strBuilder != null ? strBuilder.toString() : null;
    }

    public static String firstToUppercase(String value) {
        if (!StringUtils.isEmpty(value)) {
            String firstChar = value.substring(0, 1);
            String otherChar = value.substring(1);
            firstChar = firstChar.toUpperCase();
            value = firstChar + otherChar;
        }
        return value;
    }

    public static String html2Text(String htmlContent) {
        if (StringUtils.isEmpty(htmlContent)) {
            return htmlContent;
        }
        String regExScript = "<[\\s]*?script[^>]*?>[\\s\\S]*?<[\\s]*?\\/[\\s]*?script[\\s]*?>";
        String regExStyle = "<[\\s]*?style[^>]*?>[\\s\\S]*?<[\\s]*?\\/[\\s]*?style[\\s]*?>";
        String regExHtml = "<[^>]+>";
        Pattern pScript = Pattern.compile(regExScript, 2);
        Matcher mScript = pScript.matcher(htmlContent);
        htmlContent = mScript.replaceAll("");
        Pattern pStyle = Pattern.compile(regExStyle, 2);
        Matcher mStyle = pStyle.matcher(htmlContent);
        htmlContent = mStyle.replaceAll("");
        Pattern pHtml = Pattern.compile(regExHtml, 2);
        Matcher mHtml = pHtml.matcher(htmlContent);
        htmlContent = mHtml.replaceAll("");
        return htmlContent;
    }

    public static boolean isPhoneNO(String phoneNo) {
        Pattern p = Pattern.compile("^((13[0-9])|(15[^4,\\D])|(18[0,5-9]))\\d{8}$");
        Matcher m = p.matcher(phoneNo);
        return m.matches();
    }

    public static boolean isFixedTelephone(String tel) {
        Pattern p = Pattern.compile("^[0][0-9]{2,3}-[2-9][0-9]{6,7}(-[0-9]{1,4})?");
        Matcher m = p.matcher(tel);
        return m.matches();
    }

    public static boolean isAnonymous(String anonymous) {
        Pattern p = Pattern.compile("^[\\u4e00-\\u9fa5|A-Za-z]([\\w|\\u4e00-\\u9fa5]){1,7}$");
        Matcher m = p.matcher(anonymous);
        return m.matches();
    }

    public static boolean isChinese(String value) {
        Pattern p = Pattern.compile("^[\\u4E00-\\u9FFF]+$");
        Matcher m = p.matcher(value);
        boolean is = m.matches();
        return is;
    }

    public static boolean isCheckRegex(String value, String regex) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(value);
        boolean is = m.matches();
        return is;
    }

    public static boolean isQQ(String value) {
        Pattern p = Pattern.compile("^[1-9]\\d{6,11}$");
        Matcher m = p.matcher(value);
        return m.matches();
    }

    public static boolean isEmail(String email) {
        Pattern p = Pattern.compile("^([a-zA-Z0-9]+[_|\\_|\\.]?)*[a-zA-Z0-9]+@([a-zA-Z0-9]+[_|\\_|\\.]?)*[a-zA-Z0-9]+\\.[a-zA-Z]{2,3}$");
        Matcher m = p.matcher(email);
        return m.matches();
    }

    public static String secondToHHMMSS(long second) {
        long h = 0L;
        long m = 0L;
        long s = 0L;
        long tmp = 0L;
        if (second >= 3600L) {
            h = second / 3600L;
            tmp = second % 36000L;
            if (tmp >= 60L) {
                m = tmp / 60L;
                s = tmp % 60L;
            } else {
                s = tmp;
            }
        } else if (second >= 60L) {
            m = second / 60L;
            s = second % 60L;
        } else {
            s = second;
        }
        return (h > 9L ? Long.valueOf(h) : "0" + h) + ":" + (m > 9L ? Long.valueOf(m) : "0" + m) + ":" + (s > 9L ? Long.valueOf(s) : "0" + s);
    }

    public static String filterSQLParams(String params) {
        if (!StringUtils.isEmpty(params)) {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append("'|\"|update|delete|select|drop|insert|=|;|0x|\\(|\\)|\\s|\\*|\\?|\\%|\\$");
            strBuilder.append("|and|exec|execute|chr|mid|master|truncate|char|declare|sitename|net user|xp_cmdshell|or");
            strBuilder.append("|\\+|,|like'|table|from|grant|use|group_concat|column_name|information_schema.columns");
            strBuilder.append("|table_schema|union|where|order|by|count");
            strBuilder.append("|--|,|like|//|/|#");
            String params1 = params.toLowerCase();
            params1 = params1.replaceAll(strBuilder.toString(), "");
            if ("".equals(params1) && !"''".equals(params)) {
                params = params1;
            }
            params = params.replaceAll("&", "&amp");
            params = params.replaceAll("<", "&lt");
            params = params.replaceAll(">", "&gt");
        }
        return params;
    }

    public static String splitIds(String ids, String regex) {
        String newIds = "";
        if (null != ids && !StringUtils.isEmpty(ids.toString())) {
            String[] idsArr = ids.split(regex);
            for (int i = 0; i < idsArr.length; ++i) {
                newIds = i != idsArr.length - 1 ? newIds + "'" + idsArr[i] + "'," : newIds + "'" + idsArr[i] + "'";
            }
        }
        return newIds;
    }

    public static String fileSize(long size) {
        DecimalFormat df = new DecimalFormat("0.0#");
        long KB = 1024L;
        long MB = KB * 1024L;
        long GB = MB * 1024L;
        String valueStr = null;
        if (size < 0L) {
            valueStr = "0 KB";
        } else if (size < KB * 1024L) {
            double value = (double)size / (double)KB;
            valueStr = df.format(value) + " KB";
        } else if (size < MB * 1024L) {
            double value = (double)size / (double)MB;
            valueStr = df.format(value) + " M";
        } else {
            double value = (double)size / (double)GB;
            valueStr = df.format(value) + " G";
        }
        df = null;
        return valueStr;
    }

    public static String filterFilePath(String value) {
        if (!StringUtils.isEmpty(value)) {
            value.replaceAll("\\.|/|\\\\\\\\|\\\\|:|%2F|%2E|25%|20%|%5C|60%|27%|%3A|%2A", "");
        }
        return value;
    }

    public static boolean isContains(String value, String contain) {
        boolean is = false;
        if (!StringUtils.isEmpty(value) && null != contain) {
            is = value.indexOf(contain) > -1;
        }
        return is;
    }

    public static String[] list2Array(Collection<String> values) {
        String[] valueArray = null;
        if (null != values && values.size() > 0) {
            valueArray = new String[values.size()];
            values.toArray(valueArray);
        }
        return valueArray;
    }

    public static boolean checkIp(String ip) {
        boolean is = false;
        String regex = "^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(ip);
        if (matcher.matches()) {
            is = true;
        }
        return is;
    }

    public static String collection2String(Collection<String> values, String separater) {
        StringBuilder strBuilder = null;
        if (null != values && values.size() > 0) {
            strBuilder = new StringBuilder();
            if (StringUtils.isEmpty(separater)) {
                separater = "";
            }
            for (String value : values) {
                strBuilder.append(value + separater);
            }
            if (!StringUtils.isEmpty(separater)) {
                strBuilder.delete(strBuilder.length() - 1, strBuilder.length());
            }
        }
        return strBuilder != null ? strBuilder.toString() : null;
    }

    public static String removeMultiSpace(String value) {
        if (StringUtils.isNotEmpty(value)) {
            value = value.replaceAll("\\s+|\n|\r|\n|\t", " ");
        }
        return value;
    }

    public static String repaceSpecialChar(String value) {
        if (StringUtils.isNotEmpty(value)) {
            value = value.replaceAll("\r|\n|\t", "");
        }
        return value;
    }

    public static String repaceSlash(String value) {
        if (StringUtils.isNotEmpty(value)) {
            value = value.replaceAll("\\\\", "\\\\\\\\");
        }
        return value;
    }

    public static List<String> string2List(String value, String separater) {
        List<String> lists = null;
        if (StringUtils.isNotEmpty(value)) {
            separater = StringUtils.isEmpty(separater) ? "," : separater;
            String[] array = value.split(separater);
            lists = Arrays.asList(array);
        }
        return lists;
    }

    public static int chinaNumSort(String value1, String value2) {
        return ChinaNumSort.getIntance().sort(value1, value2);
    }

    public static String handleUrlParam(String url) {
        if (StringUtils.isEmpty(url)) {
            return url;
        }
        StringBuilder urlBuilder = new StringBuilder(url);
        if (url.indexOf("?") == -1) {
            urlBuilder.append("?");
        } else {
            urlBuilder.append("&");
        }
        return urlBuilder.toString();
    }

    public static String handlePath(String path) {
        if (StringUtils.isEmpty(path)) {
            return path;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    public static String empty2Null(String value) {
        return StringUtils.isEmpty(value) ? null : value;
    }

    public static String removeMultiValue(String value) {
        if (StringUtils.isEmpty(value)) {
            return value;
        }
        int p = value.indexOf(",");
        if (p >= 0) {
            value = value.substring(0, p);
        }
        return value;
    }
}

