/*
 * Decompiled with CFR 0.152.
 */
package com.mixsmart.utils;

import java.text.SimpleDateFormat;
import java.util.Date;

public class ShortTimeFormat {
    private Date pDate;
    private Date currentDate;
    private String dateFormatter = "yyyy-MM-dd HH:mm:ss";
    private static final long SECONDS = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOURS = 3600000L;
    private static final long DAY = 86400000L;
    private static final long MONTH = 2592000000L;
    private static final long YEAR = 31104000000L;

    public ShortTimeFormat(Date pDate) {
        this.pDate = pDate;
        this.currentDate = new Date();
    }

    public ShortTimeFormat(String dateStr) throws Exception {
        SimpleDateFormat dateFormate = new SimpleDateFormat(this.dateFormatter);
        try {
            this.pDate = dateFormate.parse(dateStr);
            this.currentDate = new Date();
        }
        catch (Exception e) {
            throw new Exception("\u4f20\u5165\u7684\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
    }

    public String toShortTime() {
        long pTime = this.pDate.getTime();
        long cTime = this.currentDate.getTime();
        long intervalTime = cTime - pTime;
        String value = this.toShortHMS(intervalTime);
        return value;
    }

    protected String toShortHMS(long intervalTime) {
        String value = null;
        if (intervalTime < 86400000L) {
            int tNum = 0;
            String unit = null;
            if (intervalTime < 60000L) {
                tNum = (int)(intervalTime / 1000L);
                unit = "\u79d2";
            } else if (intervalTime < 3600000L) {
                tNum = (int)(intervalTime / 60000L);
                unit = "\u5206\u949f";
            } else {
                tNum = (int)(intervalTime / 3600000L);
                unit = "\u5c0f\u65f6";
            }
            if (tNum == 0) {
                tNum = 1;
            }
            value = tNum + unit + "\u524d";
        } else {
            value = this.toShortDay(intervalTime);
        }
        return value;
    }

    protected String toShortDay(long intervalTime) {
        String value = null;
        if (intervalTime < 2592000000L) {
            int tNum = (int)(intervalTime / 86400000L);
            if (tNum == 0) {
                tNum = 1;
            }
            value = tNum + "\u5929\u524d";
        } else {
            value = this.toShortMonth(intervalTime);
        }
        return value;
    }

    protected String toShortMonth(long intervalTime) {
        String value = null;
        if (intervalTime < 31104000000L) {
            int tNum = (int)(intervalTime / 2592000000L);
            if (tNum == 0) {
                tNum = 1;
            }
            value = tNum + "\u6708\u524d";
        } else {
            value = this.toShortYear(intervalTime);
        }
        return value;
    }

    protected String toShortYear(long intervalTime) {
        String value = null;
        int tNum = (int)(intervalTime / 31104000000L);
        if (tNum == 0) {
            tNum = 1;
        }
        value = tNum + "\u5e74\u524d";
        return value;
    }
}

