/*
 * Decompiled with CFR 0.152.
 */
package com.mixsmart.utils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    public static final Logger log = LoggerFactory.getLogger(ReflectionUtils.class);

    private ReflectionUtils() {
        throw new UnsupportedOperationException("ReflectionUtils\u7c7b\u65e0\u6cd5\u5b9e\u4f8b\u5316");
    }

    public static <T> Class<T> getSuperClassGenricType(Class<?> clazz) {
        return ReflectionUtils.getSuperClassGenricType(clazz, 0);
    }

    public static Class<?> getSuperClassGenricType(Class<?> clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            log.warn(clazz.getSimpleName() + " \u7236\u7c7b\u4e0d\u662fParameterizedType\u7c7b\u578b");
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            log.warn(clazz.getSimpleName() + " \u4e0d\u662f\u4e00\u4e2a\u5b9e\u9645\u7684\u7236\u7c7b\u6cdb\u578b\u53c2\u6570");
            return Object.class;
        }
        return (Class)params[index];
    }

    public static Class<?> getRealType(Class<?> clazz) {
        ParameterizedType pt = (ParameterizedType)clazz.getGenericSuperclass();
        return (Class)pt.getActualTypeArguments()[0];
    }
}

