/*
 * Decompiled with CFR 0.152.
 */
package com.mixsmart.utils;

import com.mixsmart.utils.StringUtils;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class NetUtils {
    private NetUtils() {
        throw new UnsupportedOperationException("NetUtils\u7c7b\u65e0\u6cd5\u5b9e\u4f8b\u5316");
    }

    public static String getLocalIPv4() {
        String ip = null;
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return ip;
    }

    public static String[] getLocalAllIPv4() {
        String[] ipArray = null;
        ArrayList<String> ips = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            while (nets.hasMoreElements()) {
                NetworkInterface net = nets.nextElement();
                if (!net.isUp() || net.isLoopback() || net.isVirtual()) continue;
                List<InterfaceAddress> list = net.getInterfaceAddresses();
                for (InterfaceAddress interfaceAddr : list) {
                    String ip = interfaceAddr.getAddress().getHostAddress();
                    if (!StringUtils.isNotEmpty(ip) || ip.split("\\.").length != 4) continue;
                    ips.add(ip);
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        if (ips.size() > 0) {
            ipArray = new String[ips.size()];
            ips.toArray(ipArray);
        }
        return ipArray;
    }

    public static String[] getLocalAllMac() {
        String[] macArray = null;
        ArrayList<String> macList = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            while (nets.hasMoreElements()) {
                NetworkInterface net = nets.nextElement();
                if (!net.isUp() || net.isLoopback() || net.isVirtual()) continue;
                byte[] macBytes = net.getHardwareAddress();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < macBytes.length; ++i) {
                    int temp;
                    String str;
                    if (i != 0) {
                        sb.append("-");
                    }
                    if ((str = Integer.toHexString(temp = macBytes[i] & 0xFF)).length() == 1) {
                        sb.append("0" + str);
                        continue;
                    }
                    sb.append(str);
                }
                macList.add(sb.toString().toUpperCase());
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        if (macList.size() > 0) {
            macArray = new String[macList.size()];
            macList.toArray(macArray);
        }
        return macArray;
    }
}

