/*
 * Decompiled with CFR 0.152.
 */
package com.mixsmart.utils;

import com.mixsmart.utils.StringUtils;
import org.slf4j.Logger;

public class LoggerUtils {
    public static void info(Logger logger, String msg) {
        if (logger.isInfoEnabled() && StringUtils.isNotEmpty(msg)) {
            logger.info(msg);
        }
    }

    public static void info(Logger logger, String msg, Object ... args) {
        if (logger.isInfoEnabled() && StringUtils.isNotEmpty(msg)) {
            logger.info(msg, args);
        }
    }

    public static void debug(Logger logger, String msg) {
        if (logger.isDebugEnabled() && StringUtils.isNotEmpty(msg)) {
            logger.debug(msg);
        }
    }

    public static void debug(Logger logger, String msg, Object ... args) {
        if (logger.isDebugEnabled() && StringUtils.isNotEmpty(msg)) {
            logger.debug(msg, args);
        }
    }

    public static void error(Logger logger, String msg) {
        if (logger.isErrorEnabled() && StringUtils.isNotEmpty(msg)) {
            logger.error(msg);
        }
    }

    public static void error(Logger logger, String msg, Object ... args) {
        if (logger.isErrorEnabled() && StringUtils.isNotEmpty(msg)) {
            logger.error(msg, args);
        }
    }

    public static void error(Logger logger, String msg, Throwable t) {
        if (logger.isErrorEnabled() && StringUtils.isNotEmpty(msg)) {
            logger.error(msg, t);
        }
    }

    public static void error(Logger logger, Throwable t) {
        if (logger.isErrorEnabled()) {
            logger.error("\u5f02\u5e38\u4fe1\u606f", t);
        }
    }

    public static void warn(Logger logger, String msg) {
        if (logger.isWarnEnabled() && StringUtils.isNotEmpty(msg)) {
            logger.warn(msg);
        }
    }

    public static void warn(Logger logger, String msg, Object ... args) {
        if (logger.isWarnEnabled() && StringUtils.isNotEmpty(msg)) {
            logger.warn(msg, args);
        }
    }

    public static void trace(Logger logger, String msg) {
        if (logger.isTraceEnabled() && StringUtils.isNotEmpty(msg)) {
            logger.trace(msg);
        }
    }

    public static void trace(Logger logger, String msg, Object ... args) {
        if (logger.isTraceEnabled() && StringUtils.isNotEmpty(msg)) {
            logger.trace(msg, args);
        }
    }
}

