/*
 * Decompiled with CFR 0.152.
 */
package com.mixsmart.utils;

import com.mixsmart.utils.IdCardValidator;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class IdCardInfoExtractor {
    private String province;
    private String city;
    private String region;
    private int year;
    private int month;
    private int day;
    private String gender;
    private Date birthday;
    private Map<String, String> cityCodeMap = new HashMap<String, String>(){
        {
            this.put("11", "\u5317\u4eac");
            this.put("12", "\u5929\u6d25");
            this.put("13", "\u6cb3\u5317");
            this.put("14", "\u5c71\u897f");
            this.put("15", "\u5185\u8499\u53e4");
            this.put("21", "\u8fbd\u5b81");
            this.put("22", "\u5409\u6797");
            this.put("23", "\u9ed1\u9f99\u6c5f");
            this.put("31", "\u4e0a\u6d77");
            this.put("32", "\u6c5f\u82cf");
            this.put("33", "\u6d59\u6c5f");
            this.put("34", "\u5b89\u5fbd");
            this.put("35", "\u798f\u5efa");
            this.put("36", "\u6c5f\u897f");
            this.put("37", "\u5c71\u4e1c");
            this.put("41", "\u6cb3\u5357");
            this.put("42", "\u6e56\u5317");
            this.put("43", "\u6e56\u5357");
            this.put("44", "\u5e7f\u4e1c");
            this.put("45", "\u5e7f\u897f");
            this.put("46", "\u6d77\u5357");
            this.put("50", "\u91cd\u5e86");
            this.put("51", "\u56db\u5ddd");
            this.put("52", "\u8d35\u5dde");
            this.put("53", "\u4e91\u5357");
            this.put("54", "\u897f\u85cf");
            this.put("61", "\u9655\u897f");
            this.put("62", "\u7518\u8083");
            this.put("63", "\u9752\u6d77");
            this.put("64", "\u5b81\u590f");
            this.put("65", "\u65b0\u7586");
            this.put("71", "\u53f0\u6e7e");
            this.put("81", "\u9999\u6e2f");
            this.put("82", "\u6fb3\u95e8");
            this.put("91", "\u56fd\u5916");
        }
    };
    private IdCardValidator validator = null;

    public IdCardInfoExtractor(String idcard) {
        try {
            this.validator = new IdCardValidator();
            if (this.validator.isValidatedAllIdcard(idcard)) {
                Date birthdate;
                String id17;
                if (idcard.length() == 15) {
                    idcard = this.validator.convertIdcarBy15bit(idcard);
                }
                String provinceId = idcard.substring(0, 2);
                Set<String> key = this.cityCodeMap.keySet();
                for (String id : key) {
                    if (!id.equals(provinceId)) continue;
                    this.province = this.cityCodeMap.get(id);
                    break;
                }
                this.gender = Integer.parseInt(id17 = idcard.substring(16, 17)) % 2 != 0 ? "\u7537" : "\u5973";
                String birthday = idcard.substring(6, 14);
                this.birthday = birthdate = new SimpleDateFormat("yyyyMMdd").parse(birthday);
                GregorianCalendar currentDay = new GregorianCalendar();
                currentDay.setTime(birthdate);
                this.year = currentDay.get(1);
                this.month = currentDay.get(2) + 1;
                this.day = currentDay.get(5);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return "\u7701\u4efd\uff1a" + this.province + ",\u6027\u522b\uff1a" + this.gender + ",\u51fa\u751f\u65e5\u671f\uff1a" + this.birthday;
    }

    public static void main(String[] args) {
        String idcard = "";
        IdCardInfoExtractor ie = new IdCardInfoExtractor(idcard);
        System.out.println(ie.toString());
    }

    public String getProvince() {
        return this.province;
    }

    public String getCity() {
        return this.city;
    }

    public String getRegion() {
        return this.region;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public String getGender() {
        return this.gender;
    }

    public Date getBirthday() {
        return this.birthday;
    }

    public Map<String, String> getCityCodeMap() {
        return this.cityCodeMap;
    }

    public IdCardValidator getValidator() {
        return this.validator;
    }
}

