/*
 * Decompiled with CFR 0.152.
 */
package com.mixsmart.utils;

import com.mixsmart.utils.LoggerUtils;
import com.mixsmart.utils.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);

    public static String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public static boolean deleteFile(String filePath) {
        boolean is = false;
        LoggerUtils.info(log, "\u5220\u9664\u6587\u4ef6...");
        if (StringUtils.isNotEmpty(filePath)) {
            File file = new File(filePath);
            if (file.exists()) {
                is = file.delete();
                if (is) {
                    LoggerUtils.info(log, "[" + filePath + "]\u6587\u4ef6\u5220\u9664[\u6210\u529f]..");
                } else {
                    LoggerUtils.error(log, "[" + filePath + "]\u6587\u4ef6\u5220\u9664[\u5931\u8d25]..");
                }
            } else {
                LoggerUtils.error(log, "\u6587\u4ef6\u4e0d\u5b58\u5728[" + filePath + "]");
            }
        } else {
            LoggerUtils.error(log, "\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        }
        return is;
    }

    public static String readFile(String filePath, boolean isLine) {
        StringBuilder content = null;
        if (StringUtils.isNotEmpty(filePath)) {
            File file = new File(filePath);
            if (!file.exists()) {
                LoggerUtils.error(log, "\u6587\u4ef6\u4e0d\u5b58\u5728[" + filePath + "]");
            } else {
                try {
                    BufferedReader buffReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                    String line = null;
                    content = new StringBuilder();
                    while ((line = buffReader.readLine()) != null) {
                        if (isLine) {
                            line = line + "\n";
                        }
                        content.append(line);
                    }
                    buffReader.close();
                    buffReader = null;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            LoggerUtils.error(log, "\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        }
        return null == content ? null : content.toString();
    }

    public static boolean writeFile(String contents, String filePath, boolean cover) {
        boolean is = false;
        if (StringUtils.isNotEmpty(filePath) && StringUtils.isNotEmpty(contents)) {
            File dir;
            File file = new File(filePath);
            if (file.exists()) {
                LoggerUtils.error(log, "\u6587\u4ef6\u5df2\u5b58\u5728[" + filePath + "]");
                if (cover) {
                    file.delete();
                } else {
                    return is;
                }
            }
            if (!(dir = file.getParentFile()).exists()) {
                dir.mkdirs();
            }
            try {
                BufferedWriter buffWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "UTF-8"));
                buffWriter.write(contents);
                buffWriter.flush();
                buffWriter.close();
                is = true;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            LoggerUtils.error(log, "\u6587\u4ef6\u8def\u5f84\u6216\u5185\u5bb9\u4e3a\u7a7a");
        }
        return is;
    }

    public static boolean writeFile(String filePath, String contents) {
        boolean is = false;
        if (StringUtils.isNotEmpty(filePath)) {
            File file = new File(filePath);
            if (null != file && file.exists()) {
                try {
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                    writer.write(contents);
                    writer.flush();
                    writer.close();
                    is = true;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                LoggerUtils.error(log, "\u6587\u4ef6\u4e0d\u5b58\u5728[" + file.getAbsolutePath() + "]");
            }
        }
        return is;
    }

    public static boolean writeFile(File file, String contents) {
        boolean is = false;
        if (null != file && file.exists()) {
            try {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                writer.write(contents);
                writer.flush();
                writer.close();
                is = true;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            LoggerUtils.error(log, "\u6587\u4ef6\u4e0d\u5b58\u5728[" + file.getAbsolutePath() + "]");
        }
        return is;
    }
}

