/*
 * Decompiled with CFR 0.152.
 */
package com.mixsmart.utils;

import com.mixsmart.config.SystemConfig;
import com.mixsmart.utils.ArrayUtils;
import com.mixsmart.utils.StringUtils;

public class FileClassifyUtils {
    private static String getDir(String typeProp, String dirProp, String ext) {
        if (StringUtils.isNotEmpty(typeProp) && StringUtils.isNotEmpty(dirProp)) {
            String dirStr = null;
            String configExt = SystemConfig.getInstance().getValue(typeProp);
            String[] configExts = configExt.split(",");
            if (ArrayUtils.isArrayContainsIgnoreCase(configExts, ext)) {
                dirStr = SystemConfig.getInstance().getValue(dirProp);
            }
            return dirStr;
        }
        return null;
    }

    private static String getImagesDir(String ext) {
        return FileClassifyUtils.getDir("upload.image.type", "upload.images.dir", ext);
    }

    private static String getVideoDir(String ext) {
        return FileClassifyUtils.getDir("upload.video.type", "upload.video.dir", ext);
    }

    private static String getDocDir(String ext) {
        return FileClassifyUtils.getDir("upload.doc.dir", "upload.doc.type", ext);
    }

    private static String getAudioDir(String ext) {
        return FileClassifyUtils.getDir("upload.audio.type", "upload.audio.dir", ext);
    }

    private static String getOtherDir(String ext) {
        return SystemConfig.getInstance().getValue("upload.other.dir");
    }

    public static String getClassifyDir(String ext) {
        String dir = FileClassifyUtils.getImagesDir(ext);
        if (StringUtils.isEmpty(dir)) {
            dir = FileClassifyUtils.getDocDir(ext);
        }
        if (StringUtils.isEmpty(dir)) {
            dir = FileClassifyUtils.getVideoDir(ext);
        }
        if (StringUtils.isEmpty(dir)) {
            dir = FileClassifyUtils.getAudioDir(ext);
        }
        if (StringUtils.isEmpty(dir)) {
            dir = FileClassifyUtils.getOtherDir(ext);
        }
        return dir;
    }

    public static String getClassifyRelativeDir(String ext) {
        String dir = FileClassifyUtils.getClassifyDir(ext);
        if (StringUtils.isNotEmpty(dir)) {
            dir = dir.substring(dir.lastIndexOf("/") + 1, dir.length());
        }
        return dir;
    }
}

