/*
 * Decompiled with CFR 0.152.
 */
package com.mixsmart.utils;

import com.mixsmart.exception.NullArgumentException;
import com.mixsmart.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CollectionUtils {
    private CollectionUtils() {
        throw new UnsupportedOperationException("CollectionUtils\u7c7b\u65e0\u6cd5\u5b9e\u4f8b\u5316");
    }

    public static boolean isContain(Collection<?> objs, Object obj) {
        boolean is = false;
        if (CollectionUtils.isEmpty(objs)) {
            return obj == null;
        }
        if (null == obj) {
            return is;
        }
        for (Object value : objs) {
            if (!obj.getClass().isAssignableFrom(value.getClass())) {
                is = false;
                break;
            }
            if (!value.toString().equals(obj.toString())) continue;
            is = true;
            break;
        }
        return is;
    }

    public static boolean isEmpty(Collection<?> objs) {
        return null == objs || objs.isEmpty();
    }

    public static <E> List<E> handleNull(List<E> objs) {
        return CollectionUtils.isEmpty(objs) ? null : objs;
    }

    public static boolean isNotEmpty(Collection<?> objs) {
        return !CollectionUtils.isEmpty(objs);
    }

    public static List<String> toString(Collection<?> objs) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object obj : objs) {
            list.add(obj.toString());
        }
        return list.size() > 0 ? list : null;
    }

    public static void isAssert(Collection<?> objs, String msg) {
        String string = msg = StringUtils.isEmpty(msg) ? "\u53c2\u6570\u4e3a\u7a7a" : msg;
        if (CollectionUtils.isEmpty(objs)) {
            throw new NullArgumentException(msg);
        }
    }
}

