/*
 * Decompiled with CFR 0.152.
 */
package com.mixsmart.utils;

import com.mixsmart.utils.StringUtils;

public class ArrayUtils {
    private ArrayUtils() {
        throw new UnsupportedOperationException("ArrayUtils\u7c7b\u65e0\u6cd5\u5b9e\u4f8b\u5316");
    }

    public static String arrayToString(Object[] objs, String separate) {
        StringBuilder strBuff = null;
        if (null == objs || objs.length == 0) {
            return null;
        }
        if (StringUtils.isEmpty(separate)) {
            separate = ",";
        }
        strBuff = new StringBuilder();
        for (int i = 0; i < objs.length; ++i) {
            if (i < objs.length - 1) {
                strBuff.append(String.valueOf(objs[i]) + separate);
                continue;
            }
            strBuff.append(String.valueOf(objs[i]));
        }
        objs = null;
        return null != strBuff ? strBuff.toString() : null;
    }

    public static String[] stringToArray(String value, String separate) {
        String[] array = null;
        if (StringUtils.isEmpty(separate)) {
            separate = ",";
        }
        if (StringUtils.isNotEmpty(value)) {
            array = value.split(separate);
        }
        value = null;
        return array;
    }

    public static boolean isArrayContains(String str, String subStr, String separate) {
        if (StringUtils.isEmpty(str)) {
            return StringUtils.isEmpty(subStr);
        }
        if (null == subStr) {
            return true;
        }
        boolean is = false;
        if (StringUtils.isEmpty(separate)) {
            separate = ",";
        }
        String[] strArray = str.split(separate);
        for (int i = 0; i < strArray.length; ++i) {
            if (!subStr.equals(strArray[i].trim())) continue;
            is = true;
            break;
        }
        return is;
    }

    public static <E> boolean isArrayContains(E[] objs, E subObj) {
        if (null == subObj) {
            return true;
        }
        if (ArrayUtils.isEmpty(objs)) {
            return subObj == null;
        }
        boolean is = false;
        for (E obj : objs) {
            if (!subObj.toString().equals(obj.toString())) continue;
            is = true;
            break;
        }
        return is;
    }

    public static <E> boolean isArrayContainsIgnoreCase(E[] objs, E subObj) {
        if (null == subObj) {
            return true;
        }
        if (ArrayUtils.isEmpty(objs)) {
            return subObj == null;
        }
        boolean is = false;
        for (E obj : objs) {
            if (!subObj.toString().toLowerCase().equals(obj.toString().toLowerCase())) continue;
            is = true;
            break;
        }
        return is;
    }

    public static boolean isArrayContainsIgnoreCase(String str, String subStr, String separate) {
        if (StringUtils.isEmpty(str)) {
            return StringUtils.isEmpty(subStr);
        }
        if (StringUtils.isEmpty(subStr)) {
            return true;
        }
        if (StringUtils.isEmpty(separate)) {
            separate = ",";
        }
        boolean is = false;
        String[] strArray = str.split(separate);
        for (int i = 0; i < strArray.length; ++i) {
            if (!subStr.equalsIgnoreCase(strArray[i].trim())) continue;
            is = true;
            break;
        }
        return is;
    }

    public static <T> boolean isEmpty(T[] array) {
        return null == array || array.length == 0;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return !ArrayUtils.isEmpty(array);
    }
}

