/*
 * Decompiled with CFR 0.152.
 */
package com.mixsmart.sort;

import com.mixsmart.utils.StringUtils;

public class ChinaNumSort {
    private final String[] CHINA_NUM = new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341"};
    private static ChinaNumSort instance = new ChinaNumSort();

    private ChinaNumSort() {
    }

    public static ChinaNumSort getIntance() {
        return instance;
    }

    public int sort(String value, String otherValue) {
        int result = 1;
        if (StringUtils.isEmpty(value) || StringUtils.isEmpty(otherValue)) {
            return result;
        }
        int[] posArray = this.getPosition(value);
        if (posArray[0] == -1) {
            return value.compareTo(otherValue);
        }
        int[] otherPosArray = this.getPosition(otherValue);
        if (otherPosArray[0] == -1) {
            return value.compareTo(otherValue);
        }
        if (posArray[0] == otherPosArray[0]) {
            value = value.replace(this.CHINA_NUM[posArray[1]], String.valueOf(posArray[1] + 1));
            otherValue = otherValue.replace(this.CHINA_NUM[otherPosArray[1]], String.valueOf(otherPosArray[1] + 1));
            result = value.compareTo(otherValue);
        } else {
            result = value.compareTo(otherValue);
        }
        return result;
    }

    private int[] getPosition(String value) {
        int[] posArray = new int[]{-1, -1};
        for (int i = 0; i < this.CHINA_NUM.length; ++i) {
            int pos = value.indexOf(this.CHINA_NUM[i]);
            if (pos <= -1) continue;
            posArray[0] = pos;
            posArray[1] = i;
            break;
        }
        return posArray;
    }
}

