/*
 * Decompiled with CFR 0.152.
 */
package com.mixsmart.security;

import com.mixsmart.security.Coder;
import com.mixsmart.security.DESCoder;
import com.mixsmart.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;

public class SecurityUtils {
    public static String md5(String value) {
        if (StringUtils.isNotEmpty(value)) {
            try {
                byte[] bytes = value.getBytes("UTF-8");
                bytes = Coder.encryptMD5(bytes);
                StringBuffer md5StrBuff = new StringBuffer();
                for (int i = 0; i < bytes.length; ++i) {
                    if (Integer.toHexString(0xFF & bytes[i]).length() == 1) {
                        md5StrBuff.append("0").append(Integer.toHexString(0xFF & bytes[i]));
                        continue;
                    }
                    md5StrBuff.append(Integer.toHexString(0xFF & bytes[i]));
                }
                value = md5StrBuff.toString();
            }
            catch (UnsupportedEncodingException e) {
                value = null;
                e.printStackTrace();
            }
            catch (Exception e) {
                value = null;
                e.printStackTrace();
            }
        }
        return value;
    }

    public static String sha(String value) {
        if (StringUtils.isNotEmpty(value)) {
            try {
                byte[] bytes = value.getBytes("UTF-8");
                bytes = Coder.encryptSHA(bytes);
                value = SecurityUtils.byteArrayToHex(bytes);
            }
            catch (UnsupportedEncodingException e) {
                value = null;
                e.printStackTrace();
            }
            catch (Exception e) {
                value = null;
                e.printStackTrace();
            }
        }
        return value;
    }

    private static String byteArrayToHex(byte[] byteArray) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] resultCharArray = new char[byteArray.length * 2];
        int index = 0;
        for (byte b : byteArray) {
            resultCharArray[index++] = hexDigits[b >>> 4 & 0xF];
            resultCharArray[index++] = hexDigits[b & 0xF];
        }
        return new String(resultCharArray);
    }

    public static String desEncode(String value, String key) {
        if (StringUtils.isNotEmpty(value) && StringUtils.isNotEmpty(key)) {
            try {
                byte[] bytes = value.getBytes("UTF-8");
                bytes = DESCoder.encrypt(bytes, key);
                value = Base64.encodeBase64URLSafeString((byte[])bytes);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    public static String desDecode(String value, String key) {
        try {
            byte[] bytes = Base64.decodeBase64((String)value);
            bytes = DESCoder.decrypt(bytes, key);
            value = new String(bytes, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            value = null;
            e.printStackTrace();
        }
        catch (Exception e) {
            value = null;
            e.printStackTrace();
        }
        return value;
    }
}

