/*
 * Decompiled with CFR 0.152.
 */
package com.mixsmart.security;

import com.mixsmart.security.Coder;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public abstract class DESCoder
extends Coder {
    public static final String ALGORITHM = "DES";

    private static Key toKey(byte[] key) throws Exception {
        DESKeySpec dks = new DESKeySpec(key);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ALGORITHM);
        SecretKey secretKey = keyFactory.generateSecret(dks);
        return secretKey;
    }

    public static byte[] decrypt(byte[] data, String key) throws Exception {
        Key k = DESCoder.toKey(DESCoder.encryptBASE64(key.getBytes()).getBytes());
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, k);
        return cipher.doFinal(data);
    }

    public static byte[] encrypt(byte[] data, String key) throws Exception {
        Key k = DESCoder.toKey(DESCoder.encryptBASE64(key.getBytes()).getBytes());
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, k);
        return cipher.doFinal(data);
    }

    public static String initKey() throws Exception {
        return DESCoder.initKey(null);
    }

    public static String initKey(String seed) throws Exception {
        SecureRandom secureRandom = null;
        secureRandom = seed != null ? new SecureRandom(DESCoder.decryptBASE64(seed)) : new SecureRandom();
        KeyGenerator kg = KeyGenerator.getInstance(ALGORITHM);
        kg.init(secureRandom);
        SecretKey secretKey = kg.generateKey();
        return DESCoder.encryptBASE64(secretKey.getEncoded());
    }

    private static SecretKey generateKey(String secretKey) throws NoSuchAlgorithmException {
        SecureRandom secureRandom = new SecureRandom(secretKey.getBytes());
        KeyGenerator kg = null;
        try {
            kg = KeyGenerator.getInstance(ALGORITHM);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        kg.init(secureRandom);
        return kg.generateKey();
    }
}

