/*
 * Decompiled with CFR 0.152.
 */
package com.mixsmart.numconvert;

import com.mixsmart.numconvert.AbstractNumConvert;

public class ChinaNumConvert
extends AbstractNumConvert {
    private static final String[] CHINA_NUMS = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    private static final String[] CHINA_UNITS = new String[]{"", "\u5341", "\u767e", "\u5343", "\u4e07", "\u5341\u4e07", "\u767e\u4e07", "\u5343\u4e07", "\u4ebf", "\u5341\u4ebf", "\u767e\u4ebf", "\u5343\u4ebf", "\u4e07\u4ebf"};
    private static final String DECIMAL_FLAG = ".";
    private static final String DECIMAL_CONVERT_FLAG = "\u70b9";

    @Override
    public String convert(Long num) {
        if (num < 10L) {
            int numInt = Integer.parseInt(num.toString());
            return CHINA_NUMS[numInt];
        }
        if (num == 10L) {
            return CHINA_UNITS[1];
        }
        char[] charArray = String.valueOf(num).toCharArray();
        StringBuilder resultBuilder = new StringBuilder();
        int len = charArray.length;
        for (int i = 0; i < len; ++i) {
            int n = Integer.parseInt(String.valueOf(charArray[i]));
            if (resultBuilder.lastIndexOf(CHINA_NUMS[0]) > -1) {
                if (!CHINA_NUMS[0].equals(CHINA_NUMS[n])) {
                    resultBuilder.append(CHINA_NUMS[n]);
                }
            } else {
                resultBuilder.append(CHINA_NUMS[n]);
            }
            if (!CHINA_NUMS[0].equals(CHINA_NUMS[n])) {
                resultBuilder.append(CHINA_UNITS[len - i - 1]);
            }
            if (this.isAfterZero(charArray, len - (i + 1))) break;
        }
        charArray = null;
        return resultBuilder.toString();
    }

    protected boolean isAfterZero(char[] chars, int afterLen) {
        boolean is = true;
        for (int i = chars.length - afterLen; i < chars.length; ++i) {
            if ('0' == chars[i]) continue;
            if (is) {
                // empty if block
            }
            is = false;
            break;
        }
        return is;
    }

    @Override
    public String convert(Double num) {
        char[] charArray = String.valueOf(num).toCharArray();
        StringBuilder resultBuilder = new StringBuilder();
        int len = charArray.length;
        for (int i = 0; i < len; ++i) {
            String value = String.valueOf(charArray[i]);
            if (DECIMAL_FLAG.equals(value)) {
                resultBuilder.append(DECIMAL_CONVERT_FLAG);
                continue;
            }
            int n = Integer.parseInt(value);
            resultBuilder.append(CHINA_NUMS[n]);
            resultBuilder.append(CHINA_UNITS[len - i - 1]);
        }
        charArray = null;
        return resultBuilder.toString();
    }
}

