/*
 * Decompiled with CFR 0.152.
 */
package com.mixsmart.config;

import com.mixsmart.config.AbstractConfig;
import com.mixsmart.config.bean.ProjectInfo;
import com.mixsmart.utils.LoggerUtils;
import com.mixsmart.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class SystemConfig
extends AbstractConfig {
    public static final String SYS_CONFIG_FILE = "/sysconfig.properties";
    private static SystemConfig instance;
    private String sysConfigPath;
    private long lastModifyTime = 0L;
    private Properties prop = null;

    private SystemConfig(String sysConfigPath) {
        this.sysConfigPath = StringUtils.isNotEmpty(sysConfigPath) ? sysConfigPath : SYS_CONFIG_FILE;
        this.init();
    }

    private SystemConfig() {
        this.sysConfigPath = SYS_CONFIG_FILE;
        this.init();
    }

    private void reloadConfig() {
        String devModel = instance.getValue("project.devModel");
        if (StringUtils.isNotEmpty(devModel) && "1".equals(devModel)) {
            URL path = this.getClass().getResource(this.sysConfigPath);
            File file = new File(path.getFile());
            path = null;
            if (file.exists() && file.lastModified() > this.lastModifyTime) {
                this.reInit();
            }
            Object var3_3 = null;
        }
    }

    public static synchronized SystemConfig getInstance() {
        if (null == instance) {
            instance = new SystemConfig();
        }
        instance.reloadConfig();
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        LoggerUtils.info(this.logger, "\u521d\u59cb\u5316\u914d\u7f6e\u6587\u4ef6-------");
        InputStream in = null;
        try {
            URL url = this.getClass().getResource(this.sysConfigPath);
            in = url.openStream();
            if (null != in) {
                this.prop = new Properties();
                this.prop.load(in);
            }
            File file = new File(url.getFile());
            this.lastModifyTime = file.lastModified();
            file = null;
            LoggerUtils.info(this.logger, "\u521d\u59cb\u5316\u914d\u7f6e\u6587\u4ef6[\u7ed3\u675f]-------");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public String getValue(String key) {
        String value = null;
        if (null != this.prop && StringUtils.isNotEmpty(key)) {
            try {
                value = StringUtils.handleNull(this.prop.get(key));
                value = this.handleSysVar(value);
                value = this.handleVar(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    public ProjectInfo getProjectInfo() {
        ProjectInfo projectInfo = null;
        if (null != this.prop) {
            projectInfo = new ProjectInfo();
            projectInfo.initParam("project", this);
        }
        return projectInfo;
    }

    public void reInit() {
        this.init();
    }

    @Override
    public String getValue(String key, String defaultValue) {
        String value = this.getValue(key);
        if (StringUtils.isEmpty(value)) {
            value = defaultValue;
        }
        return value;
    }
}

