/*
 * Decompiled with CFR 0.152.
 */
package com.mixsmart.config;

import com.mixsmart.utils.LoggerUtils;
import com.mixsmart.utils.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfig {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected String handleVar(String value) {
        if (StringUtils.isNotEmpty(value)) {
            String regex = "(?<=\\$\\{)[^\\{\\}]+(?=\\})";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(value);
            while (matcher.find()) {
                String varName = matcher.group();
                if (!StringUtils.isNotEmpty(varName)) continue;
                String val = null;
                try {
                    val = this.getValue(varName);
                }
                catch (Exception e) {
                    LoggerUtils.info(this.logger, "\u53d8\u91cf\u3010" + val + "\u3011\u6ca1\u5b9a\u4e49");
                    e.printStackTrace();
                    val = null;
                }
                if (StringUtils.isEmpty(val)) {
                    LoggerUtils.info(this.logger, "\u53d8\u91cf\u3010" + val + "\u3011\u6ca1\u5b9a\u4e49");
                }
                value = value.replace("${" + varName + "}", StringUtils.handleNull(val));
            }
            matcher = pattern.matcher(value);
            if (matcher.find()) {
                this.handleVar(value);
            }
            pattern = null;
            matcher = null;
            return value;
        }
        return value;
    }

    protected String handleSysVar(String value) {
        String regex = "(?<=#\\{)[^\\{\\}]+(?=\\})";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(value);
        while (matcher.find()) {
            String varName = matcher.group();
            if (!StringUtils.isNotEmpty(varName)) continue;
            String val = null;
            try {
                val = System.getProperty(varName);
            }
            catch (Exception e) {
                LoggerUtils.info(this.logger, "\u7cfb\u7edf\u5c5e\u6027\u3010" + val + "\u3011\u6ca1\u6709\u627e\u5230");
                e.printStackTrace();
                val = null;
            }
            value = value.replace("#{" + varName + "}", StringUtils.handleNull(val));
        }
        matcher = pattern.matcher(value);
        if (matcher.find()) {
            this.handleSysVar(value);
        }
        pattern = null;
        matcher = null;
        return value;
    }

    public abstract String getValue(String var1);

    public abstract String getValue(String var1, String var2);
}

