/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.spring;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snaker.engine.DBAccess;
import org.snaker.engine.access.AbstractDBAccess;
import org.snaker.engine.entity.Process;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.core.support.AbstractLobCreatingPreparedStatementCallback;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobHandler;

public class SpringJdbcAccess
extends AbstractDBAccess
implements DBAccess {
    private static final Logger log = LoggerFactory.getLogger(SpringJdbcAccess.class);
    private LobHandler lobHandler;
    private JdbcTemplate template;

    @Override
    public void saveProcess(final Process process) {
        super.saveProcess(process);
        if (process.getBytes() != null) {
            this.template.execute("update t_wf_process set content=? where id=?", (PreparedStatementCallback)new AbstractLobCreatingPreparedStatementCallback(this.lobHandler){

                protected void setValues(PreparedStatement ps, LobCreator lobCreator) throws SQLException, DataAccessException {
                    try {
                        lobCreator.setBlobAsBytes(ps, 1, process.getBytes());
                        StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)2, (int)12, (Object)process.getId());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    @Override
    public void updateProcess(final Process process) {
        super.updateProcess(process);
        if (process.getBytes() != null) {
            this.template.execute("update t_wf_process set content=? where id=?", (PreparedStatementCallback)new AbstractLobCreatingPreparedStatementCallback(this.lobHandler){

                protected void setValues(PreparedStatement ps, LobCreator lobCreator) throws SQLException, DataAccessException {
                    try {
                        lobCreator.setBlobAsBytes(ps, 1, process.getBytes());
                        StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)2, (int)12, (Object)process.getId());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    @Override
    public boolean isORM() {
        return false;
    }

    @Override
    public void saveOrUpdate(Map<String, Object> map) {
        String sql = (String)map.get("SQL");
        Object[] args = (Object[])map.get("ARGS");
        int[] type = (int[])map.get("TYPE");
        if (log.isDebugEnabled()) {
            log.debug("\u589e\u5220\u6539\u6570\u636e(Spring\u6258\u7ba1\u4e8b\u52a1)=\n" + sql);
        }
        this.template.update(sql, args, type);
    }

    @Override
    public Integer getLatestProcessVersion(String name) {
        String where = " where name = ?";
        Number number = (Number)this.template.queryForObject("select max(version) from t_wf_process " + where, new Object[]{name}, Integer.class);
        return number != null ? number.intValue() : -1;
    }

    @Override
    public <T> T queryObject(Class<T> clazz, String sql, Object ... args) {
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u5355\u6761\u6570\u636e=\n" + sql);
        }
        try {
            return (T)this.template.queryForObject(sql, args, (RowMapper)new BeanPropertyRowMapper(clazz));
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5355\u6761\u6570\u636e=\n" + e.getMessage());
            return null;
        }
    }

    @Override
    public <T> List<T> queryList(Class<T> clazz, String sql, Object ... args) {
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u591a\u6761\u6570\u636e=\n" + sql);
        }
        return this.template.query(sql, args, (RowMapper)new BeanPropertyRowMapper(clazz));
    }

    @Override
    public Object queryCount(String sql, Object ... args) {
        return this.template.queryForLong(sql, args);
    }

    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    public DataSource getDataSource() {
        return this.template != null ? this.template.getDataSource() : null;
    }

    public void setDataSource(DataSource dataSource) {
        if (this.template == null || dataSource != this.template.getDataSource()) {
            this.template = new JdbcTemplate(dataSource);
        }
    }

    @Override
    protected Connection getConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }
}

