/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.parser;

import java.util.List;
import org.snaker.engine.helper.XmlHelper;
import org.snaker.engine.model.NodeModel;
import org.snaker.engine.model.TransitionModel;
import org.snaker.engine.parser.NodeParser;
import org.w3c.dom.Element;

public abstract class AbstractNodeParser
implements NodeParser {
    protected NodeModel model;

    @Override
    public void parse(Element element) {
        this.model = this.newModel();
        this.model.setName(element.getAttribute("name"));
        this.model.setDisplayName(element.getAttribute("displayName"));
        this.model.setLayout(element.getAttribute("layout"));
        this.model.setPreInterceptors(element.getAttribute("preInterceptors"));
        this.model.setPostInterceptors(element.getAttribute("postInterceptors"));
        List<Element> transitions = XmlHelper.elements(element, "transition");
        for (Element te : transitions) {
            TransitionModel transition = new TransitionModel();
            transition.setName(te.getAttribute("name"));
            transition.setDisplayName(te.getAttribute("displayName"));
            transition.setTo(te.getAttribute("to"));
            transition.setExpr(te.getAttribute("expr"));
            transition.setG(te.getAttribute("g"));
            transition.setOffset(te.getAttribute("offset"));
            transition.setType(te.getAttribute("type"));
            int num = 0;
            int isCheckForm = 1;
            try {
                num = Integer.parseInt(te.getAttribute("sortNum"));
                isCheckForm = Integer.parseInt(te.getAttribute("isCheckForm"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            transition.setSortNum(num);
            transition.setIsCheckForm(isCheckForm);
            transition.setSource(this.model);
            this.model.getOutputs().add(transition);
        }
        this.parseNode(this.model, element);
    }

    protected void parseNode(NodeModel model, Element element) {
    }

    protected abstract NodeModel newModel();

    @Override
    public NodeModel getModel() {
        return this.model;
    }
}

