/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.helper;

import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.snaker.engine.helper.StringHelper;

public class DateHelper {
    private static final String DATE_FORMAT_DEFAULT = "yyyy-MM-dd HH:mm:ss";

    public static String getTime() {
        return new DateTime().toString(DATE_FORMAT_DEFAULT);
    }

    public static String parseTime(Object date) {
        if (date == null) {
            return null;
        }
        if (date instanceof Date) {
            return new DateTime((Object)((Date)date)).toString(DATE_FORMAT_DEFAULT);
        }
        if (date instanceof String) {
            return String.valueOf(date);
        }
        return "";
    }

    public static String parseTime(Map<String, Object> args, Object date) {
        String timeStr = null;
        if (date != null && date instanceof String && StringUtils.isNotEmpty((String)date.toString()) && StringHelper.isNum(date.toString())) {
            float hours = Float.parseFloat(date.toString());
            if (hours > 0.0f) {
                long currentTime = System.currentTimeMillis();
                long millis = (long)(hours * 60.0f * 60.0f * 1000.0f);
                long time = currentTime + millis;
                timeStr = DateHelper.parseTime(new Date(time));
            }
        } else {
            timeStr = DateHelper.parseTime(args.get(date));
        }
        return timeStr;
    }

    public static Date processTime(Map<String, Object> args, String parameter) {
        if (StringHelper.isEmpty(parameter)) {
            return null;
        }
        Object data = args.get(parameter);
        if (data == null) {
            data = parameter;
        }
        Date result = null;
        if (data instanceof Date) {
            return (Date)data;
        }
        if (data instanceof Long) {
            return new Date((Long)data);
        }
        boolean cfr_ignored_0 = data instanceof String;
        return result;
    }

    public static Date handleTime(Map<String, Object> args, String hoursStr) {
        Date date = null;
        if (StringUtils.isNotEmpty((String)hoursStr) && StringHelper.isNum(hoursStr)) {
            float hours = Float.parseFloat(hoursStr);
            if (hours > 0.0f) {
                long currentTime = System.currentTimeMillis();
                long millis = (long)(hours * 60.0f * 60.0f * 1000.0f);
                long expireTime = currentTime + millis;
                date = new Date(expireTime);
            }
        } else {
            date = DateHelper.processTime(args, hoursStr);
        }
        return date;
    }
}

