/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.helper;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigHelper {
    private static final transient Logger log = LoggerFactory.getLogger(ConfigHelper.class);
    private static final String PROPERTIES_FILENAME = "snaker.properties";
    private static Properties properties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Properties getProperties() {
        if (properties != null) return properties;
        Class<ConfigHelper> clazz = ConfigHelper.class;
        synchronized (ConfigHelper.class) {
            if (properties != null) return properties;
            ConfigHelper.loadProperties(PROPERTIES_FILENAME);
            // ** MonitorExit[var0] (shouldn't be in output)
            return properties;
        }
    }

    public static String getProperty(String key) {
        if (key == null) {
            return null;
        }
        return ConfigHelper.getProperties().getProperty(key);
    }

    public static int getNumerProperty(String key) {
        String value = ConfigHelper.getProperties().getProperty(key);
        if (NumberUtils.isNumber((String)value)) {
            return Integer.parseInt(value);
        }
        return 0;
    }

    public static void loadProperties(Properties props) {
        properties = props;
    }

    public static void loadProperties(String filename) {
        InputStream in = null;
        ClassLoader threadContextClassLoader = Thread.currentThread().getContextClassLoader();
        properties = new Properties();
        if (threadContextClassLoader != null) {
            in = threadContextClassLoader.getResourceAsStream(filename);
        }
        if (in == null) {
            in = ConfigHelper.class.getResourceAsStream(filename);
            if (in == null) {
                log.warn("No properties file found in the classpath by filename " + filename);
            }
        } else {
            try {
                try {
                    properties.load(in);
                    log.info("Properties read " + properties);
                }
                catch (Exception e) {
                    log.error("Error reading from " + filename, (Throwable)e);
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        log.warn("IOException while closing InputStream: " + e2.getMessage());
                    }
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.warn("IOException while closing InputStream: " + e.getMessage());
                }
            }
        }
    }
}

