/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.handlers.impl;

import java.util.List;
import org.snaker.engine.SnakerEngine;
import org.snaker.engine.SnakerException;
import org.snaker.engine.access.QueryFilter;
import org.snaker.engine.core.Execution;
import org.snaker.engine.entity.Order;
import org.snaker.engine.entity.Process;
import org.snaker.engine.entity.Task;
import org.snaker.engine.handlers.IHandler;
import org.snaker.engine.helper.StringHelper;
import org.snaker.engine.model.ProcessModel;
import org.snaker.engine.model.SubProcessModel;

public class EndProcessHandler
implements IHandler {
    @Override
    public void handle(Execution execution) {
        SnakerEngine engine = execution.getEngine();
        Order order = execution.getOrder();
        List<Task> tasks = engine.query().getActiveTasks(new QueryFilter().setOrderId(order.getId()));
        for (Task task : tasks) {
            if (task.isMajor()) {
                throw new SnakerException("\u5b58\u5728\u672a\u5b8c\u6210\u7684\u4e3b\u529e\u4efb\u52a1,\u8bf7\u786e\u8ba4.");
            }
            engine.task().complete(task.getId(), "snaker.auto");
        }
        engine.order().complete(order.getId());
        if (StringHelper.isNotEmpty(order.getParentId())) {
            Order parentOrder = engine.query().getOrder(order.getParentId());
            if (parentOrder == null) {
                return;
            }
            Process process = engine.process().getProcessById(parentOrder.getProcessId());
            ProcessModel pm = process.getModel();
            if (pm == null) {
                return;
            }
            SubProcessModel spm = (SubProcessModel)pm.getNode(order.getParentNodeName());
            Execution newExecution = new Execution(engine, process, parentOrder, execution.getArgs());
            newExecution.setChildOrderId(order.getId());
            newExecution.setTask(execution.getTask());
            spm.execute(newExecution);
            execution.addTasks(newExecution.getTasks());
        }
    }
}

