/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.handlers.impl;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snaker.engine.SnakerException;
import org.snaker.engine.SnakerInterceptor;
import org.snaker.engine.core.Execution;
import org.snaker.engine.core.ServiceContext;
import org.snaker.engine.entity.Task;
import org.snaker.engine.handlers.IHandler;
import org.snaker.engine.model.TaskModel;

public class CreateTaskHandler
implements IHandler {
    private static final Logger log = LoggerFactory.getLogger(CreateTaskHandler.class);
    private TaskModel model;

    public CreateTaskHandler(TaskModel model) {
        this.model = model;
    }

    @Override
    public void handle(Execution execution) {
        List<Task> tasks = execution.getEngine().task().createTask(this.model, execution);
        execution.addTasks(tasks);
        List<SnakerInterceptor> interceptors = ServiceContext.getContext().findList(SnakerInterceptor.class);
        try {
            for (SnakerInterceptor interceptor : interceptors) {
                interceptor.intercept(execution);
            }
        }
        catch (Exception e) {
            log.error("\u62e6\u622a\u5668\u6267\u884c\u5931\u8d25=" + e.getMessage());
            throw new SnakerException(e);
        }
    }
}

