/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.entity;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.snaker.engine.helper.JsonHelper;
import org.snaker.engine.model.TaskModel;

public class Task
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -189094546633914087L;
    public static final String KEY_ACTOR = "S-ACTOR";
    private String id;
    private Integer version = 0;
    private String orderId;
    private String taskName;
    private String displayName;
    private Integer performType;
    private Integer taskType;
    private String operator;
    private String createTime;
    private String takeTime;
    private String finishTime;
    private String expireTime;
    private Date expireDate;
    private Date remindDate;
    private String actionUrl;
    private String[] actorIds;
    private String parentTaskId;
    private String variable;
    private TaskModel model;

    public Task() {
    }

    public Task(String id) {
        this.id = id;
    }

    public boolean isMajor() {
        return this.taskType.intValue() == TaskModel.TaskType.Major.ordinal();
    }

    public String getParentTaskId() {
        return this.parentTaskId;
    }

    public void setParentTaskId(String parentTaskId) {
        this.parentTaskId = parentTaskId;
    }

    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public Integer getTaskType() {
        return this.taskType;
    }

    public void setTaskType(Integer taskType) {
        this.taskType = taskType;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getFinishTime() {
        return this.finishTime;
    }

    public void setFinishTime(String finishTime) {
        this.finishTime = finishTime;
    }

    public String getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(String expireTime) {
        this.expireTime = expireTime;
    }

    public String getActionUrl() {
        return this.actionUrl;
    }

    public void setActionUrl(String actionUrl) {
        this.actionUrl = actionUrl;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String[] getActorIds() {
        String actorStr;
        if (this.actorIds == null && (actorStr = (String)this.getVariableMap().get(KEY_ACTOR)) != null) {
            this.actorIds = actorStr.split(",");
        }
        return this.actorIds;
    }

    public void setActorIds(String[] actorIds) {
        this.actorIds = actorIds;
    }

    public Integer getPerformType() {
        return this.performType;
    }

    public void setPerformType(Integer performType) {
        this.performType = performType;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Date getExpireDate() {
        return this.expireDate;
    }

    public void setExpireDate(Date expireDate) {
        this.expireDate = expireDate;
    }

    public Date getRemindDate() {
        return this.remindDate;
    }

    public void setRemindDate(Date remindDate) {
        this.remindDate = remindDate;
    }

    public TaskModel getModel() {
        return this.model;
    }

    public void setModel(TaskModel model) {
        this.model = model;
    }

    public Map<String, Object> getVariableMap() {
        Map map = JsonHelper.fromJson(this.variable, Map.class);
        if (map == null) {
            return Collections.emptyMap();
        }
        return map;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Task(id=").append(this.id);
        sb.append(",orderId=").append(this.orderId);
        sb.append(",taskName=").append(this.taskName);
        sb.append(",displayName").append(this.displayName);
        sb.append(",taskType=").append(this.taskType);
        sb.append(",createTime=").append(this.createTime);
        sb.append(",performType=").append(this.performType).append(")");
        return sb.toString();
    }

    public String getTakeTime() {
        return this.takeTime;
    }

    public void setTakeTime(String takeTime) {
        this.takeTime = takeTime;
    }
}

