/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.entity;

import java.io.InputStream;
import java.io.Serializable;
import java.sql.Blob;
import org.snaker.engine.SnakerException;
import org.snaker.engine.helper.StreamHelper;
import org.snaker.engine.model.ProcessModel;

public class Process
implements Serializable {
    private static final long serialVersionUID = 6541688543201014542L;
    private String id;
    private Integer version;
    private String name;
    private String displayName;
    private String type;
    private String instanceUrl;
    private Integer state;
    private String createTime;
    private String creator;
    private ProcessModel model;
    private Blob content;
    private byte[] bytes;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getState() {
        return this.state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ProcessModel getModel() {
        return this.model;
    }

    public void setModel(ProcessModel processModel) {
        this.model = processModel;
        this.name = processModel.getName();
        this.displayName = processModel.getDisplayName();
        this.instanceUrl = processModel.getInstanceUrl();
    }

    public String getInstanceUrl() {
        return this.instanceUrl;
    }

    public void setInstanceUrl(String instanceUrl) {
        this.instanceUrl = instanceUrl;
    }

    public byte[] getDBContent() {
        if (this.content != null) {
            try {
                return this.content.getBytes(1L, Long.valueOf(this.content.length()).intValue());
            }
            catch (Exception e) {
                try {
                    InputStream is = this.content.getBinaryStream();
                    return StreamHelper.readBytes(is);
                }
                catch (Exception e1) {
                    throw new SnakerException("couldn't extract stream out of blob", e1);
                }
            }
        }
        return this.bytes;
    }

    public Blob getContent() {
        return this.content;
    }

    public void setContent(Blob content) {
        this.content = content;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Process(id=").append(this.id);
        sb.append(",name=").append(this.name);
        sb.append(",displayName=").append(this.displayName);
        sb.append(",version=").append(this.version);
        sb.append(",state=").append(this.state).append(")");
        return sb.toString();
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }
}

