/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.entity;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.snaker.engine.SnakerEngine;
import org.snaker.engine.core.ServiceContext;
import org.snaker.engine.entity.Order;
import org.snaker.engine.entity.Process;
import org.snaker.engine.helper.JsonHelper;

public class HistoryOrder
implements Serializable {
    private static final long serialVersionUID = 5853727929104539328L;
    private String id;
    private String processId;
    private Integer orderState;
    private String creator;
    private String createTime;
    private String endTime;
    private String parentId;
    private String expireTime;
    private Integer priority;
    private String orderNo;
    private String variable;

    public HistoryOrder() {
    }

    public HistoryOrder(Order order) {
        this.id = order.getId();
        this.processId = order.getProcessId();
        this.createTime = order.getCreateTime();
        this.expireTime = order.getExpireTime();
        this.creator = order.getCreator();
        this.parentId = order.getParentId();
        this.priority = order.getPriority();
        this.orderNo = order.getOrderNo();
        this.variable = order.getVariable();
    }

    public Order undo() {
        Order order = new Order();
        order.setId(this.id);
        order.setProcessId(this.processId);
        order.setParentId(this.parentId);
        order.setCreator(this.creator);
        order.setCreateTime(this.createTime);
        order.setLastUpdator(this.creator);
        order.setLastUpdateTime(this.endTime);
        order.setExpireTime(this.expireTime);
        order.setOrderNo(this.orderNo);
        order.setPriority(this.priority);
        order.setVariable(this.variable);
        order.setVersion(0);
        return order;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public Integer getOrderState() {
        return this.orderState;
    }

    public void setOrderState(Integer orderState) {
        this.orderState = orderState;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(String expireTime) {
        this.expireTime = expireTime;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public Map<String, Object> getVariableMap() {
        Map map = JsonHelper.fromJson(this.variable, Map.class);
        if (map == null) {
            return Collections.emptyMap();
        }
        return map;
    }

    public String getProcessName() {
        SnakerEngine engine = ServiceContext.getEngine();
        Process process = engine.process().getProcessById(this.processId);
        if (process == null) {
            return this.processId;
        }
        return process.getDisplayName();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HistoryOrder(id=").append(this.id);
        sb.append(",processId=").append(this.processId);
        sb.append(",creator=").append(this.creator);
        sb.append(",createTime").append(this.createTime);
        sb.append(",orderNo=").append(this.orderNo).append(")");
        return sb.toString();
    }
}

